/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.handlers.BlockHandler;
import org.wordpress.aztec.handlers.HeadingHandler;
import org.wordpress.aztec.handlers.ListItemHandler;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecPreformatSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.spans.ParagraphSpan;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u00002\u00020\u0001:\u0004YZ[\\B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\"\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J \u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0002J&\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001aJ\"\u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\b\b\u0002\u0010.\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u001aJ\"\u00100\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\b\b\u0002\u0010.\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u001aJ*\u00101\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001a2\b\b\u0002\u0010.\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u001aJ\"\u00102\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\b\b\u0002\u0010.\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u001aJ\u000e\u00103\u001a\u00020&2\u0006\u0010(\u001a\u00020\u001aJ\u001a\u00103\u001a\u00020&2\b\b\u0002\u0010.\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u001aJ\u001a\u00104\u001a\u00020&2\b\b\u0002\u0010.\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u001aJ\u001e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u001aJ\u0016\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180;2\u0006\u0010'\u001a\u00020\u001eJ \u0010<\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J(\u0010=\u001a\u00020\u00162\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0;2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J&\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180?2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001a2\b\b\u0002\u0010@\u001a\u00020AJ?\u0010B\u001a\u00020\u0018\"\u0010\b\u0000\u0010C*\n\u0012\u0006\b\u0001\u0012\u00020\u00180;2\u0006\u0010D\u001a\u0002HC2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001a2\b\b\u0002\u0010@\u001a\u00020A\u00a2\u0006\u0002\u0010EJ \u0010B\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001a2\b\b\u0002\u0010@\u001a\u00020AJ\u000e\u0010F\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u001eJ>\u0010F\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\u001a2\u0014\b\u0002\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180;0?2\b\b\u0002\u0010J\u001a\u00020&J\u000e\u0010K\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u0018J\"\u0010M\u001a\u00020\u00162\u0006\u0010N\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u001a\u0010O\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\"\u0010P\u001a\u00020\u00162\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\"\u0010R\u001a\u00020\u00162\u0006\u0010S\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010T\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u001eJ\u0006\u0010U\u001a\u00020\u0016J\u0006\u0010V\u001a\u00020\u0016J\u0006\u0010W\u001a\u00020\u0016J\u0006\u0010X\u001a\u00020&R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006]"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "headerStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "preformatStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;)V", "getHeaderStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "getPreformatStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "applyBlock", "", "blockSpan", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "start", "", "end", "applyBlockStyle", "blockElementType", "Lorg/wordpress/aztec/ITextFormat;", "applyHeadingBlock", "headingSpan", "Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "applyListBlock", "listSpan", "Lorg/wordpress/aztec/spans/AztecListSpan;", "containHeadingType", "", "textFormat", "index", "containsBlockElement", "text", "Landroid/text/Editable;", "nestingLevel", "containsHeading", "selStart", "selEnd", "containsHeadingOnly", "containsList", "containsOtherHeadings", "containsPreformat", "containsQuote", "getBoundsOfText", "Lkotlin/ranges/IntRange;", "editable", "selectionStart", "selectionEnd", "getOuterBlockSpanType", "Ljava/lang/Class;", "liftBlock", "liftListBlock", "makeBlock", "", "attrs", "Lorg/wordpress/aztec/AztecAttributes;", "makeBlockSpan", "T", "type", "(Ljava/lang/Class;Lorg/wordpress/aztec/ITextFormat;ILorg/wordpress/aztec/AztecAttributes;)Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "removeBlockStyle", "originalStart", "originalEnd", "spanTypes", "ignoreLineBounds", "setBlockStyle", "blockElement", "switchHeaderType", "headerTypeToSwitchTo", "switchHeadingToPreformat", "switchListType", "listTypeToSwitchTo", "switchPreformatToHeading", "headingTextFormat", "toggleHeading", "toggleOrderedList", "toggleQuote", "toggleUnorderedList", "tryRemoveBlockStyleFromFirstLine", "HeaderStyle", "ListStyle", "PreformatStyle", "QuoteStyle", "aztec_release"})
public final class BlockFormatter
extends AztecFormatter {
    @NotNull
    private final ListStyle listStyle;
    @NotNull
    private final QuoteStyle quoteStyle;
    @NotNull
    private final HeaderStyle headerStyle;
    @NotNull
    private final PreformatStyle preformatStyle;

    public final void toggleOrderedList() {
        if (!BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
            if (BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
                BlockFormatter.switchListType$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(AztecTextFormat.FORMAT_ORDERED_LIST);
        }
    }

    public final void toggleUnorderedList() {
        if (!BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
            if (BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
                BlockFormatter.switchListType$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(AztecTextFormat.FORMAT_UNORDERED_LIST);
        }
    }

    public final void toggleQuote() {
        if (!BlockFormatter.containsQuote$default(this, 0, 0, 3, null)) {
            BlockFormatter.applyBlockStyle$default(this, AztecTextFormat.FORMAT_QUOTE, 0, 0, 6, null);
        } else {
            this.removeBlockStyle(AztecTextFormat.FORMAT_QUOTE);
        }
    }

    public final void toggleHeading(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
            if (!BlockFormatter.containsHeadingOnly$default(this, textFormat, 0, 0, 6, null)) {
                if (BlockFormatter.containsPreformat$default(this, 0, 0, 3, null)) {
                    BlockFormatter.switchPreformatToHeading$default(this, textFormat, 0, 0, 6, null);
                } else if (BlockFormatter.containsOtherHeadings$default(this, textFormat, 0, 0, 6, null)) {
                    BlockFormatter.switchHeaderType$default(this, textFormat, 0, 0, 6, null);
                } else {
                    BlockFormatter.applyBlockStyle$default(this, textFormat, 0, 0, 6, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_PARAGRAPH)) {
            Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecHeadingSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(se\u2026cHeadingSpan::class.java)");
            AztecHeadingSpan span = (AztecHeadingSpan)ArraysKt.firstOrNull((Object[])objectArray);
            if (span != null) {
                this.removeBlockStyle(span.getTextFormat());
            }
            this.removeBlockStyle(AztecTextFormat.FORMAT_PREFORMAT);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_PREFORMAT) && !BlockFormatter.containsPreformat$default(this, 0, 0, 3, null)) {
            if (BlockFormatter.containsOtherHeadings$default(this, AztecTextFormat.FORMAT_PREFORMAT, 0, 0, 6, null)) {
                BlockFormatter.switchHeadingToPreformat$default(this, 0, 0, 3, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, textFormat, 0, 0, 6, null);
            }
        }
    }

    public final boolean tryRemoveBlockStyleFromFirstLine() {
        int selectionStart = this.getEditor().getSelectionStart();
        if (selectionStart != 0) {
            return false;
        }
        boolean changed = false;
        Object[] objectArray = this.getEditableText().getSpans(0, 0, IAztecBlockSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(0,\u2026tecBlockSpan::class.java)");
        Object[] $receiver$iv = objectArray;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            int indexOfNewline;
            Object element$iv = $receiver$iv[i];
            IAztecBlockSpan it = (IAztecBlockSpan)element$iv;
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            int n = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)'\n', (int)0, (boolean)false, (int)6, null);
            int it2 = n;
            int n2 = indexOfNewline = it2 != -1 ? it2 : this.getEditableText().length();
            if (spanEnd <= indexOfNewline + 1) {
                this.getEditableText().removeSpan((Object)it);
                changed = true;
                continue;
            }
            this.getEditableText().setSpan((Object)it, indexOfNewline + 1, spanEnd, this.getEditableText().getSpanFlags((Object)it));
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(@NotNull ITextFormat textFormat) {
        Collection<Class<?>> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Iterable iterable = BlockFormatter.makeBlock$default(this, textFormat, 0, null, 4, null);
        int n = this.getSelectionEnd();
        int n2 = this.getSelectionStart();
        ITextFormat iTextFormat = textFormat;
        BlockFormatter blockFormatter = this;
        void var3_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IAztecBlockSpan iAztecBlockSpan = (IAztecBlockSpan)item$iv$iv;
            collection = destination$iv$iv;
            Class<?> clazz = it.getClass();
            collection.add(clazz);
        }
        collection = (List)destination$iv$iv;
        BlockFormatter.removeBlockStyle$default(blockFormatter, iTextFormat, n2, n, (List)collection, false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(@NotNull ITextFormat textFormat, int originalStart, int originalEnd, @NotNull List<Class<IAztecBlockSpan>> spanTypes, boolean ignoreLineBounds) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull(spanTypes, (String)"spanTypes");
        int start = originalStart;
        int end = originalEnd;
        IntRange boundsOfSelectedText = ignoreLineBounds ? new IntRange(start, end) : this.getBoundsOfText(this.getEditableText(), start, end);
        int startOfBounds = boundsOfSelectedText.getStart();
        int endOfBounds = boundsOfSelectedText.getEndInclusive();
        if (ignoreLineBounds) {
            boolean hasExtendingBeyondSpans;
            block20: {
                boolean bl;
                Iterable $receiver$iv;
                boolean hasPrecedingSpans;
                block18: {
                    boolean bl2;
                    Iterable $receiver$iv2 = spanTypes;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            boolean bl3;
                            block17: {
                                void $receiver$iv3;
                                Class spanType = (Class)element$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.getEditableText().getSpans(start, end, spanType), (String)"editableText.getSpans(start, end, spanType)");
                                for (int i = 0; i < ((void)$receiver$iv3).length; ++i) {
                                    void element$iv2 = $receiver$iv3[i];
                                    IAztecBlockSpan span = (IAztecBlockSpan)element$iv2;
                                    if (!(this.getEditableText().getSpanStart((Object)span) < startOfBounds)) continue;
                                    bl3 = true;
                                    break block17;
                                }
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block18;
                        }
                        bl2 = hasPrecedingSpans = false;
                    }
                }
                if (hasPrecedingSpans && this.getEditableText().charAt(startOfBounds - 1) != Constants.INSTANCE.getNEWLINE()) {
                    this.getEditableText().insert(startOfBounds, (CharSequence)("" + Constants.INSTANCE.getNEWLINE()));
                    int $receiver$iv2 = start;
                    start = $receiver$iv2 + 1;
                    $receiver$iv2 = end;
                    end = $receiver$iv2 + 1;
                    $receiver$iv2 = startOfBounds;
                    startOfBounds = $receiver$iv2 + 1;
                    $receiver$iv2 = endOfBounds;
                    endOfBounds = $receiver$iv2 + 1;
                }
                if (($receiver$iv = (Iterable)spanTypes) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        boolean bl4;
                        block19: {
                            void $receiver$iv4;
                            Class spanType = (Class)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)this.getEditableText().getSpans(start, end, spanType), (String)"editableText.getSpans(start, end, spanType)");
                            for (int element$iv2 = 0; element$iv2 < ((void)$receiver$iv4).length; ++element$iv2) {
                                void element$iv3 = $receiver$iv4[element$iv2];
                                IAztecBlockSpan span = (IAztecBlockSpan)element$iv3;
                                if (!(endOfBounds < this.getEditableText().getSpanEnd((Object)span))) continue;
                                bl4 = true;
                                break block19;
                            }
                            bl4 = false;
                        }
                        if (!bl4) continue;
                        bl = true;
                        break block20;
                    }
                    bl = hasExtendingBeyondSpans = false;
                }
            }
            if (hasExtendingBeyondSpans && this.getEditableText().charAt(endOfBounds) != Constants.INSTANCE.getNEWLINE()) {
                this.getEditableText().insert(endOfBounds, (CharSequence)("" + Constants.INSTANCE.getNEWLINE()));
                int $receiver$iv = end;
                end = $receiver$iv + 1;
                $receiver$iv = endOfBounds;
                endOfBounds = $receiver$iv + 1;
                if (this.getSelectionEnd() == endOfBounds) {
                    this.getEditor().setSelection(this.getSelectionStart() != this.getSelectionEnd() ? this.getSelectionStart() : this.getSelectionEnd() - 1, this.getSelectionEnd() - 1);
                }
            }
        }
        Iterable $receiver$iv = spanTypes;
        for (Object element$iv : $receiver$iv) {
            Class spanType = (Class)element$iv;
            boolean hasLingeringEmptyListItem = spanType.isAssignableFrom(AztecListItemSpan.class) && this.getEditableText().length() > end && (this.getEditableText().charAt(end) == '\n' || this.getEditableText().charAt(end) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER());
            int endModifier = hasLingeringEmptyListItem ? 1 : 0;
            IAztecBlockSpan[] spans = (IAztecBlockSpan[])this.getEditableText().getSpans(start, end + endModifier, spanType);
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            Object[] $receiver$iv5 = spans;
            for (int i = 0; i < $receiver$iv5.length; ++i) {
                boolean spanExtendsBeyondLine;
                Object element$iv4 = $receiver$iv5[i];
                IAztecBlockSpan span = (IAztecBlockSpan)element$iv4;
                int spanStart = this.getEditableText().getSpanStart((Object)span);
                int spanEnd = this.getEditableText().getSpanEnd((Object)span);
                boolean spanPrecedesLine = spanStart < startOfBounds;
                boolean bl = spanExtendsBeyondLine = endOfBounds < spanEnd;
                if (spanPrecedesLine && !spanExtendsBeyondLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    IAztecBlockSpan iAztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, iAztecBlockSpan, spanStart, startOfBounds);
                    continue;
                }
                if (spanExtendsBeyondLine && !spanPrecedesLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    IAztecBlockSpan iAztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, iAztecBlockSpan, endOfBounds, spanEnd);
                    continue;
                }
                if (spanPrecedesLine && spanExtendsBeyondLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    IAztecBlockSpan iAztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, iAztecBlockSpan, spanStart, startOfBounds);
                    BlockHandler.Companion.set((Spannable)this.getEditableText(), this.makeBlockSpan(span.getClass(), textFormat, span.getNestingLevel(), span.getAttributes()), endOfBounds, spanEnd);
                    continue;
                }
                this.getEditableText().removeSpan((Object)span);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void removeBlockStyle$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, List list, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            List<Class<IAztecBlockSpan>> list2 = Arrays.asList(IAztecBlockSpan.class);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(IAztecBlockSpan::class.java)");
            list = list2;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        blockFormatter.removeBlockStyle(iTextFormat, n, n2, list, bl);
    }

    @NotNull
    public final Class<? extends IAztecBlockSpan> getOuterBlockSpanType(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) {
            return AztecOrderedListSpan.class;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
            return AztecUnorderedListSpan.class;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_QUOTE)) {
            return AztecQuoteSpan.class;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
            return AztecHeadingSpan.class;
        }
        return ParagraphSpan.class;
    }

    @NotNull
    public final List<IAztecBlockSpan> makeBlock(@NotNull ITextFormat textFormat, int nestingLevel, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecOrderedListSpan(nestingLevel, attrs, this.listStyle), new AztecListItemSpan(nestingLevel + 1, null, 2, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecOrder\u2026emSpan(nestingLevel + 1))");
            return list;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecUnorderedListSpan(nestingLevel, attrs, this.listStyle), new AztecListItemSpan(nestingLevel + 1, null, 2, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecUnord\u2026emSpan(nestingLevel + 1))");
            return list;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_QUOTE)) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecQuoteSpan(nestingLevel, attrs, this.quoteStyle));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecQuote\u2026evel, attrs, quoteStyle))");
            return list;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecHeadingSpan(nestingLevel, textFormat, attrs, this.headerStyle));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecHeadi\u2026mat, attrs, headerStyle))");
            return list;
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_PREFORMAT)) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecPreformatSpan(nestingLevel, attrs, this.preformatStyle));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecPrefo\u2026, attrs, preformatStyle))");
            return list;
        }
        List<IAztecBlockSpan> list = Arrays.asList(new ParagraphSpan(nestingLevel, attrs));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(ParagraphSpan(nestingLevel, attrs))");
        return list;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List makeBlock$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, AztecAttributes aztecAttributes, int n2, Object object) {
        if ((n2 & 4) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return blockFormatter.makeBlock(iTextFormat, n, aztecAttributes);
    }

    @NotNull
    public final IAztecBlockSpan makeBlockSpan(@NotNull ITextFormat textFormat, int nestingLevel, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        ITextFormat iTextFormat = textFormat;
        return Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST) ? this.makeBlockSpan(AztecOrderedListSpan.class, textFormat, nestingLevel, attrs) : (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST) ? this.makeBlockSpan(AztecUnorderedListSpan.class, textFormat, nestingLevel, attrs) : (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_QUOTE) ? this.makeBlockSpan(AztecQuoteSpan.class, textFormat, nestingLevel, attrs) : (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5) || Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6) ? this.makeBlockSpan(AztecHeadingSpan.class, textFormat, nestingLevel, attrs) : (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_PREFORMAT) ? this.makeBlockSpan(AztecPreformatSpan.class, textFormat, nestingLevel, attrs) : (IAztecBlockSpan)new ParagraphSpan(nestingLevel, attrs)))));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IAztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, AztecAttributes aztecAttributes, int n2, Object object) {
        if ((n2 & 4) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return blockFormatter.makeBlockSpan(iTextFormat, n, aztecAttributes);
    }

    @NotNull
    public final <T extends Class<? extends IAztecBlockSpan>> IAztecBlockSpan makeBlockSpan(@NotNull T type, @NotNull ITextFormat textFormat, int nestingLevel, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        T t = type;
        return Intrinsics.areEqual(t, AztecOrderedListSpan.class) ? (IAztecBlockSpan)new AztecOrderedListSpan(nestingLevel, attrs, this.listStyle) : (Intrinsics.areEqual(t, AztecUnorderedListSpan.class) ? (IAztecBlockSpan)new AztecUnorderedListSpan(nestingLevel, attrs, this.listStyle) : (Intrinsics.areEqual(t, AztecListItemSpan.class) ? (IAztecBlockSpan)new AztecListItemSpan(nestingLevel, attrs) : (Intrinsics.areEqual(t, AztecQuoteSpan.class) ? (IAztecBlockSpan)new AztecQuoteSpan(nestingLevel, attrs, this.quoteStyle) : (Intrinsics.areEqual(t, AztecHeadingSpan.class) ? (IAztecBlockSpan)new AztecHeadingSpan(nestingLevel, textFormat, attrs, this.headerStyle) : (Intrinsics.areEqual(t, AztecPreformatSpan.class) ? (IAztecBlockSpan)new AztecPreformatSpan(nestingLevel, attrs, this.preformatStyle) : (IAztecBlockSpan)new ParagraphSpan(nestingLevel, attrs))))));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IAztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, Class clazz, ITextFormat iTextFormat, int n, AztecAttributes aztecAttributes, int n2, Object object) {
        if ((n2 & 8) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return blockFormatter.makeBlockSpan(clazz, iTextFormat, n, aztecAttributes);
    }

    public final void setBlockStyle(@NotNull IAztecBlockSpan blockElement) {
        Intrinsics.checkParameterIsNotNull((Object)blockElement, (String)"blockElement");
        IAztecBlockSpan iAztecBlockSpan = blockElement;
        if (iAztecBlockSpan instanceof AztecOrderedListSpan) {
            ((AztecOrderedListSpan)blockElement).setListStyle(this.listStyle);
        } else if (iAztecBlockSpan instanceof AztecUnorderedListSpan) {
            ((AztecUnorderedListSpan)blockElement).setListStyle(this.listStyle);
        } else if (iAztecBlockSpan instanceof AztecQuoteSpan) {
            ((AztecQuoteSpan)blockElement).setQuoteStyle(this.quoteStyle);
        } else if (iAztecBlockSpan instanceof AztecPreformatSpan) {
            ((AztecPreformatSpan)blockElement).setPreformatStyle(this.preformatStyle);
        } else if (iAztecBlockSpan instanceof AztecHeadingSpan) {
            ((AztecHeadingSpan)blockElement).setHeaderStyle(this.headerStyle);
        }
    }

    @NotNull
    public final IntRange getBoundsOfText(@NotNull Editable editable, int selectionStart, int selectionEnd) {
        int indexOfFirstLineBreak;
        Intrinsics.checkParameterIsNotNull((Object)editable, (String)"editable");
        boolean selectionStartIsOnTheNewLine = selectionStart != selectionEnd && selectionStart > 0 && selectionStart < this.getEditableText().length() && editable.charAt(selectionStart) == '\n';
        boolean selectionStartIsBetweenNewlines = selectionStartIsOnTheNewLine && selectionStart > 0 && selectionStart < this.getEditableText().length() && editable.charAt(selectionStart - 1) == '\n';
        boolean isTrailingNewlineAtTheEndOfSelection = selectionStart != selectionEnd && selectionEnd > 0 && this.getEditableText().length() > selectionEnd && this.getEditableText().charAt(selectionEnd) != Constants.INSTANCE.getEND_OF_BUFFER_MARKER() && this.getEditableText().charAt(selectionEnd) != '\n' && this.getEditableText().charAt(selectionEnd - 1) == '\n';
        int indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionEnd, (boolean)false, (int)4, null);
        if (selectionStartIsBetweenNewlines) {
            indexOfFirstLineBreak = selectionStart;
        } else if (selectionStartIsOnTheNewLine) {
            boolean isSingleCharacterLine = selectionStart > 1 && this.getEditableText().charAt(selectionStart - 1) != '\n' && this.getEditableText().charAt(selectionStart - 2) == '\n' || selectionStart == 1;
            indexOfFirstLineBreak = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - (isSingleCharacterLine ? 0 : 1)), (boolean)false, (int)4, null) - (isSingleCharacterLine ? 1 : 0);
            if (isTrailingNewlineAtTheEndOfSelection) {
                indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionEnd - 1), (boolean)false, (int)4, null);
            }
        } else if (isTrailingNewlineAtTheEndOfSelection) {
            indexOfFirstLineBreak = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1;
            indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionEnd - 1), (boolean)false, (int)4, null);
        } else {
            indexOfFirstLineBreak = indexOfLastLineBreak > 0 ? StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1 : (indexOfLastLineBreak == -1 ? (selectionStart == 0 ? 0 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null) + 1) : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null));
        }
        int startOfBlock = indexOfFirstLineBreak != -1 ? indexOfFirstLineBreak : 0;
        int endOfBlock = indexOfLastLineBreak != -1 ? indexOfLastLineBreak + 1 : editable.length();
        return new IntRange(startOfBlock, endOfBlock);
    }

    public final void applyBlockStyle(@NotNull ITextFormat blockElementType, int start, int end) {
        block11: {
            int endOfBlock;
            int startOfBlock;
            IAztecBlockSpan spanToApply;
            block14: {
                IAztecBlockSpan spanOnNextLine;
                block15: {
                    int nestingLevel;
                    int endOfLine;
                    block12: {
                        IAztecBlockSpan spansOnPreviousLine;
                        block13: {
                            block10: {
                                int nestingLevelAtTheEndOfSelection;
                                Intrinsics.checkParameterIsNotNull((Object)blockElementType, (String)"blockElementType");
                                CharSequence charSequence = (CharSequence)this.getEditableText();
                                if (charSequence.length() == 0) {
                                    this.getEditableText().append((CharSequence)("" + Constants.INSTANCE.getEND_OF_BUFFER_MARKER()));
                                }
                                if (start == end) break block10;
                                int nestingLevelAtTheStartOfSelection = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), start, 0, 4, null);
                                if (nestingLevelAtTheStartOfSelection != (nestingLevelAtTheEndOfSelection = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), end, 0, 4, null)) && (nestingLevelAtTheStartOfSelection != 0 || nestingLevelAtTheEndOfSelection != 1)) {
                                    return;
                                }
                                IntRange boundsOfSelectedText = this.getBoundsOfText(this.getEditableText(), start, end);
                                int startOfBlock2 = boundsOfSelectedText.getStart();
                                int endOfBlock2 = boundsOfSelectedText.getEndInclusive();
                                this.applyBlock(BlockFormatter.makeBlockSpan$default(this, blockElementType, nestingLevelAtTheStartOfSelection, null, 4, null), startOfBlock2, endOfBlock2 == this.getEditableText().length() ? endOfBlock2 : endOfBlock2);
                                break block11;
                            }
                            IntRange boundsOfSelectedText = this.getBoundsOfText(this.getEditableText(), start, end);
                            int startOfLine = boundsOfSelectedText.getStart();
                            endOfLine = boundsOfSelectedText.getEndInclusive();
                            nestingLevel = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), start, 0, 4, null) + 1;
                            spanToApply = BlockFormatter.makeBlockSpan$default(this, blockElementType, nestingLevel, null, 4, null);
                            startOfBlock = startOfLine;
                            endOfBlock = endOfLine;
                            if (startOfLine == 0) break block12;
                            Object[] objectArray = this.getEditableText().getSpans(startOfLine - 1, startOfLine - 1, spanToApply.getClass());
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u20261, spanToApply.javaClass)");
                            spansOnPreviousLine = (IAztecBlockSpan)ArraysKt.firstOrNull((Object[])objectArray);
                            if (spansOnPreviousLine == null || spansOnPreviousLine.getNestingLevel() != nestingLevel) break block12;
                            if (!(spansOnPreviousLine instanceof AztecHeadingSpan)) break block13;
                            IAztecBlockSpan iAztecBlockSpan = spanToApply;
                            if (iAztecBlockSpan == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecHeadingSpan");
                            }
                            if (Intrinsics.areEqual((Object)((Object)((AztecHeadingSpan)spansOnPreviousLine).getHeading()), (Object)((Object)((AztecHeadingSpan)iAztecBlockSpan).getHeading())) ^ true) break block12;
                        }
                        startOfBlock = this.getEditableText().getSpanStart((Object)spansOnPreviousLine);
                        this.liftBlock(blockElementType, startOfBlock, endOfBlock);
                    }
                    if (endOfLine == this.getEditableText().length()) break block14;
                    Object[] objectArray = this.getEditableText().getSpans(endOfLine + 1, endOfLine + 1, spanToApply.getClass());
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(en\u20261, spanToApply.javaClass)");
                    spanOnNextLine = (IAztecBlockSpan)ArraysKt.firstOrNull((Object[])objectArray);
                    if (spanOnNextLine == null || spanOnNextLine.getNestingLevel() != nestingLevel) break block14;
                    if (!(spanOnNextLine instanceof AztecHeadingSpan)) break block15;
                    IAztecBlockSpan iAztecBlockSpan = spanToApply;
                    if (iAztecBlockSpan == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecHeadingSpan");
                    }
                    if (Intrinsics.areEqual((Object)((Object)((AztecHeadingSpan)spanOnNextLine).getHeading()), (Object)((Object)((AztecHeadingSpan)iAztecBlockSpan).getHeading())) ^ true) break block14;
                }
                endOfBlock = this.getEditableText().getSpanEnd((Object)spanOnNextLine);
                this.liftBlock(blockElementType, startOfBlock, endOfBlock);
            }
            this.applyBlock(spanToApply, startOfBlock, endOfBlock);
            this.getEditor().onSelectionChanged(this.getEditor().getSelectionStart(), this.getEditor().getSelectionEnd());
        }
    }

    public static /* bridge */ /* synthetic */ void applyBlockStyle$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.applyBlockStyle(iTextFormat, n, n2);
    }

    private final void applyBlock(IAztecBlockSpan blockSpan, int start, int end) {
        IAztecBlockSpan iAztecBlockSpan = blockSpan;
        if (iAztecBlockSpan instanceof AztecOrderedListSpan) {
            this.applyListBlock((AztecListSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecUnorderedListSpan) {
            this.applyListBlock((AztecListSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecQuoteSpan) {
            BlockHandler.Companion.set((Spannable)this.getEditableText(), blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecHeadingSpan) {
            this.applyHeadingBlock((AztecHeadingSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecPreformatSpan) {
            BlockHandler.Companion.set((Spannable)this.getEditableText(), blockSpan, start, end);
        } else {
            this.getEditableText().setSpan((Object)blockSpan, start, end, 51);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyListBlock(AztecListSpan listSpan, int start, int end) {
        BlockHandler.Companion.set((Spannable)this.getEditableText(), listSpan, start, end);
        if (end - start == 1 && (this.getEditableText().charAt(end - 1) == '\n' || this.getEditableText().charAt(end - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER())) {
            ListItemHandler.Companion.newListItem((Spannable)this.getEditableText(), start, end, listSpan.getNestingLevel() + 1);
        } else {
            CharSequence charSequence = (CharSequence)this.getEditableText();
            int n = end - 1;
            String listContent = ((Object)charSequence.subSequence(start, n)).toString();
            String[] lines = TextUtils.split((String)listContent, (String)"\n");
            n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int lineLength = lines[i].length();
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int n7 = lineStart + lineLength;
                int it = n7;
                int lineEnd = start + it != this.getEditableText().length() ? it + 1 : it;
                ListItemHandler.Companion.newListItem((Spannable)this.getEditableText(), start + lineStart, start + lineEnd, listSpan.getNestingLevel() + 1);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyHeadingBlock(AztecHeadingSpan headingSpan, int start, int end) {
        CharSequence charSequence = (CharSequence)this.getEditableText();
        String[] lines = TextUtils.split((String)((Object)charSequence.subSequence(start, end)).toString(), (String)"\n");
        int n = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
        int n2 = lines.length;
        while (n < n2) {
            int n3;
            void $receiver$iv;
            void i;
            int splitLength = lines[i].length();
            int n4 = 0;
            Iterable iterable = (Iterable)new IntRange(n4, (int)(i - true));
            int n5 = start;
            int sum$iv = 0;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int element$iv;
                int n6 = element$iv = ((IntIterator)iterator).nextInt();
                n3 = sum$iv;
                int n7 = lines[it].length() + 1;
                sum$iv = n3 + n7;
            }
            n3 = sum$iv;
            int lineStart = n5 + n3;
            int lineEnd = Math.min(lineStart + splitLength + 1, end);
            int lineLength = lineEnd - lineStart;
            if (lineLength != 0) {
                HeadingHandler.Companion.cloneHeading((Spannable)this.getEditableText(), headingSpan, lineStart, lineEnd);
            }
            ++i;
        }
    }

    private final void liftBlock(ITextFormat textFormat, int start, int end) {
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) {
            this.liftListBlock(AztecOrderedListSpan.class, start, end);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
            this.liftListBlock(AztecUnorderedListSpan.class, start, end);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_QUOTE)) {
            Object[] objectArray = this.getEditableText().getSpans(start, end, AztecQuoteSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026tecQuoteSpan::class.java)");
            Object[] $receiver$iv = objectArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                AztecQuoteSpan it = (AztecQuoteSpan)element$iv;
                this.getEditableText().removeSpan((Object)it);
            }
        } else {
            Object[] objectArray = this.getEditableText().getSpans(start, end, ParagraphSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026aragraphSpan::class.java)");
            Object[] $receiver$iv = objectArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                ParagraphSpan it = (ParagraphSpan)element$iv;
                this.getEditableText().removeSpan((Object)it);
            }
        }
    }

    private final void liftListBlock(Class<? extends AztecListSpan> listSpan, int start, int end) {
        IAztecBlockSpan it;
        Object element$iv;
        int n;
        Object[] objectArray = this.getEditableText().getSpans(start, end, listSpan);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(start, end, listSpan)");
        Object[] $receiver$iv = objectArray;
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (AztecListSpan)element$iv;
            this.getEditableText().removeSpan((Object)it);
        }
        Object[] objectArray2 = this.getEditableText().getSpans(start, end, AztecListItemSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"editableText.getSpans(st\u2026ListItemSpan::class.java)");
        $receiver$iv = objectArray2;
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (AztecListItemSpan)element$iv;
            this.getEditableText().removeSpan((Object)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsList(@NotNull ITextFormat textFormat, int nestingLevel, int selStart, int selEnd) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart <= lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containsBlockElement(textFormat, it, this.getEditableText(), nestingLevel)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containsList$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = blockFormatter.getSelectionStart();
        }
        if ((n4 & 8) != 0) {
            n3 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsList(iTextFormat, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsBlockElement(@NotNull ITextFormat textFormat, int index, @NotNull Editable text, int nestingLevel) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String[] lines = TextUtils.split((String)text.toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)objectArray).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start > end) {
            return false;
        }
        IAztecBlockSpan[] spans = (IAztecBlockSpan[])this.getEditableText().getSpans(start, end, BlockFormatter.makeBlockSpan$default(this, textFormat, nestingLevel, null, 4, null).getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        Object[] objectArray2 = objectArray = (Object[])spans;
        return !(objectArray2.length == 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsQuote(int selStart, int selEnd) {
        if (selStart < 0) return false;
        if (selEnd < 0) {
            return false;
        }
        Object[] objectArray = this.getEditableText().getSpans(selStart, selEnd, AztecQuoteSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(se\u2026tecQuoteSpan::class.java)");
        Object[] $receiver$iv = objectArray;
        int n = 0;
        while (n < $receiver$iv.length) {
            boolean bl;
            Object element$iv = $receiver$iv[n];
            AztecQuoteSpan it = (AztecQuoteSpan)element$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)it);
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            if (selStart == selEnd) {
                if (this.getEditableText().length() == selStart) {
                    int n2 = selStart;
                    if (spanStart <= n2 && spanEnd >= n2) {
                        return true;
                    }
                    bl = false;
                } else {
                    if (spanEnd != selStart) {
                        int n3 = selStart;
                        if (spanStart <= n3 && spanEnd >= n3) {
                            return true;
                        }
                    }
                    bl = false;
                }
            } else {
                int n4 = selStart;
                if (spanStart <= n4) {
                    if (spanEnd >= n4) return true;
                }
                int n5 = selEnd;
                if (spanStart <= n5) {
                    if (spanEnd >= n5) return true;
                }
                int n6 = spanStart;
                if (selStart <= n6) {
                    if (selEnd >= n6) return true;
                }
                int n7 = spanEnd;
                if (spanStart <= n7 && spanEnd >= n7) {
                    return true;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean containsQuote$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsQuote(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containHeadingType(textFormat, it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containsHeading$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsHeading(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containHeadingType(ITextFormat textFormat, int index) {
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)iterator).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        int n5 = 0;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        if (n5 < spans.length) {
            AztecHeadingSpan span = spans[n5];
            ITextFormat iTextFormat = textFormat;
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1)) {
                return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H1));
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2)) {
                return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H2));
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3)) {
                return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H3));
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4)) {
                return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H4));
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5)) {
                return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H5));
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
                return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H6));
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsOtherHeadings(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        AztecTextFormat[] aztecTextFormatArray = new AztecTextFormat[]{AztecTextFormat.FORMAT_HEADING_1, AztecTextFormat.FORMAT_HEADING_2, AztecTextFormat.FORMAT_HEADING_3, AztecTextFormat.FORMAT_HEADING_4, AztecTextFormat.FORMAT_HEADING_5, AztecTextFormat.FORMAT_HEADING_6, AztecTextFormat.FORMAT_PREFORMAT};
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            void it = element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it, (Object)textFormat) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            AztecTextFormat it = (AztecTextFormat)element$iv;
            if (!this.containsHeading(it, selStart, selEnd)) continue;
            return true;
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean containsOtherHeadings$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsOtherHeadings(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsHeadingOnly(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        Object element$iv;
        AztecTextFormat it;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        AztecTextFormat[] aztecTextFormatArray = new AztecTextFormat[]{AztecTextFormat.FORMAT_HEADING_1, AztecTextFormat.FORMAT_HEADING_2, AztecTextFormat.FORMAT_HEADING_3, AztecTextFormat.FORMAT_HEADING_4, AztecTextFormat.FORMAT_HEADING_5, AztecTextFormat.FORMAT_HEADING_6, AztecTextFormat.FORMAT_PREFORMAT};
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            void it2 = element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it2, (Object)textFormat) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherHeadings = (List)destination$iv$iv;
        if (!this.containsHeading(textFormat, selStart, selEnd)) return false;
        $receiver$iv = otherHeadings;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (!this.containsHeading(it = (AztecTextFormat)(element$iv = iterator.next()), selStart, selEnd));
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean containsHeadingOnly$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsHeadingOnly(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsPreformat(int selStart, int selEnd) {
        boolean bl;
        block7: {
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containsPreformat(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containsPreformat$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsPreformat(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsPreformat(int index) {
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)objectArray).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        AztecPreformatSpan[] spans = (AztecPreformatSpan[])this.getEditableText().getSpans(start, end, AztecPreformatSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        Object[] objectArray2 = objectArray = (Object[])spans;
        return !(objectArray2.length == 0);
    }

    public final void switchListType(@NotNull ITextFormat listTypeToSwitchTo, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)listTypeToSwitchTo, (String)"listTypeToSwitchTo");
        Object[] objectArray = this.getEditableText().getSpans(start, end, AztecListSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026ztecListSpan::class.java)");
        AztecListSpan existingListSpan = (AztecListSpan)ArraysKt.firstOrNull((Object[])objectArray);
        if (existingListSpan != null) {
            int spanStart = this.getEditableText().getSpanStart((Object)existingListSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingListSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingListSpan);
            this.getEditableText().removeSpan((Object)existingListSpan);
            this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, listTypeToSwitchTo, existingListSpan.getNestingLevel(), null, 4, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchListType$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchListType(iTextFormat, n, n2);
    }

    public final void switchHeaderType(@NotNull ITextFormat headerTypeToSwitchTo, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)headerTypeToSwitchTo, (String)"headerTypeToSwitchTo");
        Object[] objectArray = this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026cHeadingSpan::class.java)");
        AztecHeadingSpan existingHeaderSpan = (AztecHeadingSpan)ArraysKt.firstOrNull((Object[])objectArray);
        if (existingHeaderSpan != null) {
            int spanStart = this.getEditableText().getSpanStart((Object)existingHeaderSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingHeaderSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingHeaderSpan);
            existingHeaderSpan.setTextFormat(headerTypeToSwitchTo);
            this.getEditableText().setSpan((Object)existingHeaderSpan, spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchHeaderType$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchHeaderType(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void switchHeadingToPreformat(int start, int end) {
        Object[] objectArray = this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026cHeadingSpan::class.java)");
        AztecHeadingSpan heading = (AztecHeadingSpan)ArraysKt.firstOrNull((Object[])objectArray);
        if (heading != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)heading);
            int spanEnd = this.getEditableText().getSpanEnd((Object)heading);
            int spanFlags = this.getEditableText().getSpanFlags((Object)heading);
            Iterable iterable = $receiver$iv = (Iterable)BlockFormatter.makeBlock$default(this, heading.getTextFormat(), 0, null, 4, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IAztecBlockSpan iAztecBlockSpan = (IAztecBlockSpan)item$iv$iv;
                Collection collection = destination$iv$iv;
                Class<?> clazz = it.getClass();
                collection.add(clazz);
            }
            List spanType = (List)destination$iv$iv;
            BlockFormatter.removeBlockStyle$default(this, heading.getTextFormat(), spanStart, spanEnd, spanType, false, 16, null);
            this.getEditableText().setSpan((Object)new AztecPreformatSpan(heading.getNestingLevel(), heading.getAttributes(), this.preformatStyle), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchHeadingToPreformat$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchHeadingToPreformat(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void switchPreformatToHeading(@NotNull ITextFormat headingTextFormat, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)headingTextFormat, (String)"headingTextFormat");
        Object[] objectArray = this.getEditableText().getSpans(start, end, AztecPreformatSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026reformatSpan::class.java)");
        AztecPreformatSpan preformat = (AztecPreformatSpan)ArraysKt.firstOrNull((Object[])objectArray);
        if (preformat != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)preformat);
            int spanEnd = this.getEditableText().getSpanEnd((Object)preformat);
            int spanFlags = this.getEditableText().getSpanFlags((Object)preformat);
            Iterable iterable = $receiver$iv = (Iterable)BlockFormatter.makeBlock$default(this, AztecTextFormat.FORMAT_PREFORMAT, 0, null, 4, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IAztecBlockSpan iAztecBlockSpan = (IAztecBlockSpan)item$iv$iv;
                Collection collection = destination$iv$iv;
                Class<?> clazz = it.getClass();
                collection.add(clazz);
            }
            List spanType = (List)destination$iv$iv;
            BlockFormatter.removeBlockStyle$default(this, AztecTextFormat.FORMAT_PREFORMAT, spanStart, spanEnd, spanType, false, 16, null);
            this.getEditableText().setSpan((Object)new AztecHeadingSpan(preformat.getNestingLevel(), headingTextFormat, preformat.getAttributes(), null, 8, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchPreformatToHeading$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchPreformatToHeading(iTextFormat, n, n2);
    }

    @NotNull
    public final ListStyle getListStyle() {
        return this.listStyle;
    }

    @NotNull
    public final QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    @NotNull
    public final HeaderStyle getHeaderStyle() {
        return this.headerStyle;
    }

    @NotNull
    public final PreformatStyle getPreformatStyle() {
        return this.preformatStyle;
    }

    public BlockFormatter(@NotNull AztecText editor, @NotNull ListStyle listStyle, @NotNull QuoteStyle quoteStyle, @NotNull HeaderStyle headerStyle, @NotNull PreformatStyle preformatStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"headerStyle");
        Intrinsics.checkParameterIsNotNull((Object)preformatStyle, (String)"preformatStyle");
        super(editor);
        this.listStyle = listStyle;
        this.quoteStyle = quoteStyle;
        this.headerStyle = headerStyle;
        this.preformatStyle = preformatStyle;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "", "indicatorColor", "", "indicatorMargin", "indicatorPadding", "indicatorWidth", "verticalPadding", "(IIIII)V", "getIndicatorColor", "()I", "getIndicatorMargin", "getIndicatorPadding", "getIndicatorWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class ListStyle {
        private final int indicatorColor;
        private final int indicatorMargin;
        private final int indicatorPadding;
        private final int indicatorWidth;
        private final int verticalPadding;

        public final int getIndicatorColor() {
            return this.indicatorColor;
        }

        public final int getIndicatorMargin() {
            return this.indicatorMargin;
        }

        public final int getIndicatorPadding() {
            return this.indicatorPadding;
        }

        public final int getIndicatorWidth() {
            return this.indicatorWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public ListStyle(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            this.indicatorColor = indicatorColor;
            this.indicatorMargin = indicatorMargin;
            this.indicatorPadding = indicatorPadding;
            this.indicatorWidth = indicatorWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.indicatorColor;
        }

        public final int component2() {
            return this.indicatorMargin;
        }

        public final int component3() {
            return this.indicatorPadding;
        }

        public final int component4() {
            return this.indicatorWidth;
        }

        public final int component5() {
            return this.verticalPadding;
        }

        @NotNull
        public final ListStyle copy(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            return new ListStyle(indicatorColor, indicatorMargin, indicatorPadding, indicatorWidth, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ListStyle copy$default(ListStyle listStyle, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = listStyle.indicatorColor;
            }
            if ((n6 & 2) != 0) {
                n2 = listStyle.indicatorMargin;
            }
            if ((n6 & 4) != 0) {
                n3 = listStyle.indicatorPadding;
            }
            if ((n6 & 8) != 0) {
                n4 = listStyle.indicatorWidth;
            }
            if ((n6 & 0x10) != 0) {
                n5 = listStyle.verticalPadding;
            }
            return listStyle.copy(n, n2, n3, n4, n5);
        }

        public String toString() {
            return "ListStyle(indicatorColor=" + this.indicatorColor + ", indicatorMargin=" + this.indicatorMargin + ", indicatorPadding=" + this.indicatorPadding + ", indicatorWidth=" + this.indicatorWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((this.indicatorColor * 31 + this.indicatorMargin) * 31 + this.indicatorPadding) * 31 + this.indicatorWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListStyle)) break block3;
                    ListStyle listStyle = (ListStyle)object;
                    if (!(this.indicatorColor == listStyle.indicatorColor) || !(this.indicatorMargin == listStyle.indicatorMargin) || !(this.indicatorPadding == listStyle.indicatorPadding) || !(this.indicatorWidth == listStyle.indicatorWidth) || !(this.verticalPadding == listStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006#"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "", "quoteBackground", "", "quoteColor", "quoteBackgroundAlpha", "", "quoteMargin", "quotePadding", "quoteWidth", "verticalPadding", "(IIFIIII)V", "getQuoteBackground", "()I", "getQuoteBackgroundAlpha", "()F", "getQuoteColor", "getQuoteMargin", "getQuotePadding", "getQuoteWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class QuoteStyle {
        private final int quoteBackground;
        private final int quoteColor;
        private final float quoteBackgroundAlpha;
        private final int quoteMargin;
        private final int quotePadding;
        private final int quoteWidth;
        private final int verticalPadding;

        public final int getQuoteBackground() {
            return this.quoteBackground;
        }

        public final int getQuoteColor() {
            return this.quoteColor;
        }

        public final float getQuoteBackgroundAlpha() {
            return this.quoteBackgroundAlpha;
        }

        public final int getQuoteMargin() {
            return this.quoteMargin;
        }

        public final int getQuotePadding() {
            return this.quotePadding;
        }

        public final int getQuoteWidth() {
            return this.quoteWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public QuoteStyle(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            this.quoteBackground = quoteBackground;
            this.quoteColor = quoteColor;
            this.quoteBackgroundAlpha = quoteBackgroundAlpha;
            this.quoteMargin = quoteMargin;
            this.quotePadding = quotePadding;
            this.quoteWidth = quoteWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.quoteBackground;
        }

        public final int component2() {
            return this.quoteColor;
        }

        public final float component3() {
            return this.quoteBackgroundAlpha;
        }

        public final int component4() {
            return this.quoteMargin;
        }

        public final int component5() {
            return this.quotePadding;
        }

        public final int component6() {
            return this.quoteWidth;
        }

        public final int component7() {
            return this.verticalPadding;
        }

        @NotNull
        public final QuoteStyle copy(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            return new QuoteStyle(quoteBackground, quoteColor, quoteBackgroundAlpha, quoteMargin, quotePadding, quoteWidth, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QuoteStyle copy$default(QuoteStyle quoteStyle, int n, int n2, float f, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = quoteStyle.quoteBackground;
            }
            if ((n7 & 2) != 0) {
                n2 = quoteStyle.quoteColor;
            }
            if ((n7 & 4) != 0) {
                f = quoteStyle.quoteBackgroundAlpha;
            }
            if ((n7 & 8) != 0) {
                n3 = quoteStyle.quoteMargin;
            }
            if ((n7 & 0x10) != 0) {
                n4 = quoteStyle.quotePadding;
            }
            if ((n7 & 0x20) != 0) {
                n5 = quoteStyle.quoteWidth;
            }
            if ((n7 & 0x40) != 0) {
                n6 = quoteStyle.verticalPadding;
            }
            return quoteStyle.copy(n, n2, f, n3, n4, n5, n6);
        }

        public String toString() {
            return "QuoteStyle(quoteBackground=" + this.quoteBackground + ", quoteColor=" + this.quoteColor + ", quoteBackgroundAlpha=" + this.quoteBackgroundAlpha + ", quoteMargin=" + this.quoteMargin + ", quotePadding=" + this.quotePadding + ", quoteWidth=" + this.quoteWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((((this.quoteBackground * 31 + this.quoteColor) * 31 + Float.floatToIntBits(this.quoteBackgroundAlpha)) * 31 + this.quoteMargin) * 31 + this.quotePadding) * 31 + this.quoteWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QuoteStyle)) break block3;
                    QuoteStyle quoteStyle = (QuoteStyle)object;
                    if (!(this.quoteBackground == quoteStyle.quoteBackground) || !(this.quoteColor == quoteStyle.quoteColor) || Float.compare(this.quoteBackgroundAlpha, quoteStyle.quoteBackgroundAlpha) != 0 || !(this.quoteMargin == quoteStyle.quoteMargin) || !(this.quotePadding == quoteStyle.quotePadding) || !(this.quoteWidth == quoteStyle.quoteWidth) || !(this.verticalPadding == quoteStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "", "preformatBackground", "", "preformatBackgroundAlpha", "", "preformatColor", "verticalPadding", "(IFII)V", "getPreformatBackground", "()I", "getPreformatBackgroundAlpha", "()F", "getPreformatColor", "getVerticalPadding", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class PreformatStyle {
        private final int preformatBackground;
        private final float preformatBackgroundAlpha;
        private final int preformatColor;
        private final int verticalPadding;

        public final int getPreformatBackground() {
            return this.preformatBackground;
        }

        public final float getPreformatBackgroundAlpha() {
            return this.preformatBackgroundAlpha;
        }

        public final int getPreformatColor() {
            return this.preformatColor;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public PreformatStyle(int preformatBackground, float preformatBackgroundAlpha, int preformatColor, int verticalPadding) {
            this.preformatBackground = preformatBackground;
            this.preformatBackgroundAlpha = preformatBackgroundAlpha;
            this.preformatColor = preformatColor;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.preformatBackground;
        }

        public final float component2() {
            return this.preformatBackgroundAlpha;
        }

        public final int component3() {
            return this.preformatColor;
        }

        public final int component4() {
            return this.verticalPadding;
        }

        @NotNull
        public final PreformatStyle copy(int preformatBackground, float preformatBackgroundAlpha, int preformatColor, int verticalPadding) {
            return new PreformatStyle(preformatBackground, preformatBackgroundAlpha, preformatColor, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PreformatStyle copy$default(PreformatStyle preformatStyle, int n, float f, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = preformatStyle.preformatBackground;
            }
            if ((n4 & 2) != 0) {
                f = preformatStyle.preformatBackgroundAlpha;
            }
            if ((n4 & 4) != 0) {
                n2 = preformatStyle.preformatColor;
            }
            if ((n4 & 8) != 0) {
                n3 = preformatStyle.verticalPadding;
            }
            return preformatStyle.copy(n, f, n2, n3);
        }

        public String toString() {
            return "PreformatStyle(preformatBackground=" + this.preformatBackground + ", preformatBackgroundAlpha=" + this.preformatBackgroundAlpha + ", preformatColor=" + this.preformatColor + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return ((this.preformatBackground * 31 + Float.floatToIntBits(this.preformatBackgroundAlpha)) * 31 + this.preformatColor) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PreformatStyle)) break block3;
                    PreformatStyle preformatStyle = (PreformatStyle)object;
                    if (!(this.preformatBackground == preformatStyle.preformatBackground) || Float.compare(this.preformatBackgroundAlpha, preformatStyle.preformatBackgroundAlpha) != 0 || !(this.preformatColor == preformatStyle.preformatColor) || !(this.verticalPadding == preformatStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "", "verticalPadding", "", "(I)V", "getVerticalPadding", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class HeaderStyle {
        private final int verticalPadding;

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public HeaderStyle(int verticalPadding) {
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.verticalPadding;
        }

        @NotNull
        public final HeaderStyle copy(int verticalPadding) {
            return new HeaderStyle(verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ HeaderStyle copy$default(HeaderStyle headerStyle, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = headerStyle.verticalPadding;
            }
            return headerStyle.copy(n);
        }

        public String toString() {
            return "HeaderStyle(verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HeaderStyle)) break block3;
                    HeaderStyle headerStyle = (HeaderStyle)object;
                    if (!(this.verticalPadding == headerStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

