/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers.event.sequence;

import android.os.Build;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.watchers.event.IEventInjector;
import org.wordpress.aztec.watchers.event.buckets.API26Bucket;
import org.wordpress.aztec.watchers.event.buckets.Bucket;
import org.wordpress.aztec.watchers.event.sequence.EventSequence;
import org.wordpress.aztec.watchers.event.sequence.UserOperationEvent;
import org.wordpress.aztec.watchers.event.text.TextWatcherEvent;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/ObservationQueue;", "Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;", "Lorg/wordpress/aztec/watchers/event/text/TextWatcherEvent;", "injector", "Lorg/wordpress/aztec/watchers/event/IEventInjector;", "(Lorg/wordpress/aztec/watchers/event/IEventInjector;)V", "buckets", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/watchers/event/buckets/Bucket;", "Lkotlin/collections/ArrayList;", "getBuckets", "()Ljava/util/ArrayList;", "getInjector", "()Lorg/wordpress/aztec/watchers/event/IEventInjector;", "add", "", "element", "processQueue", "", "aztec_release"})
public final class ObservationQueue
extends EventSequence<TextWatcherEvent> {
    @NotNull
    private final ArrayList<Bucket> buckets;
    @NotNull
    private final IEventInjector injector;

    @NotNull
    public final ArrayList<Bucket> getBuckets() {
        return this.buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean add(@NotNull TextWatcherEvent element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObservationQueue observationQueue = this;
        synchronized (observationQueue) {
            void var3_3;
            boolean added;
            block5: {
                added = super.add(element);
                if (this.buckets.size() != 0) break block5;
                boolean bl = added;
                return bl;
            }
            if (added) {
                this.processQueue();
            }
            void var5_5 = var3_3;
            return (boolean)var5_5;
        }
    }

    private final void processQueue() {
        boolean foundOnePartialMatch = false;
        for (Bucket bucket : this.buckets) {
            for (UserOperationEvent operation : bucket.getUserOperations()) {
                if (this.size() < operation.getSequence().size()) {
                    if (!operation.isUserOperationPartiallyObservedInSequence(this)) continue;
                    foundOnePartialMatch = true;
                    continue;
                }
                if (!operation.isUserOperationObservedInSequence(this)) continue;
                TextWatcherEvent replacementEvent = operation.buildReplacementEventWithSequenceData(this);
                this.injector.executeEvent(replacementEvent);
                this.clear();
            }
        }
        if (this.size() > 0 && !foundOnePartialMatch) {
            this.clear();
        }
    }

    @NotNull
    public final IEventInjector getInjector() {
        return this.injector;
    }

    public ObservationQueue(@NotNull IEventInjector injector) {
        Intrinsics.checkParameterIsNotNull((Object)injector, (String)"injector");
        this.injector = injector;
        this.buckets = new ArrayList();
        if (Build.VERSION.SDK_INT >= 26) {
            this.buckets.add(new API26Bucket());
        }
    }
}

