/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.ArrowKeyMovementMethod;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.UnknownClickableSpan;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/wordpress/aztec/EnhancedMovementMethod;", "Landroid/text/method/ArrowKeyMovementMethod;", "()V", "onTouchEvent", "", "widget", "Landroid/widget/TextView;", "text", "Landroid/text/Spannable;", "event", "Landroid/view/MotionEvent;", "aztec_release"})
public final class EnhancedMovementMethod
extends ArrowKeyMovementMethod {
    public static final EnhancedMovementMethod INSTANCE;

    public boolean onTouchEvent(@NotNull TextView widget, @NotNull Spannable text, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getAction();
        if (action == 1) {
            Object[] objectArray;
            Object[] objectArray2;
            boolean clickedOnSpan;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            y += widget.getScrollY();
            if ((x += widget.getScrollX()) < 0) {
                return true;
            }
            Layout layout2 = widget.getLayout();
            int line = layout2.getLineForVertical(y);
            int off = layout2.getOffsetForHorizontal(line, (float)x);
            float charX = layout2.getPrimaryHorizontal(off);
            float charPrevX = off > 0 ? layout2.getPrimaryHorizontal(off - 1) : charX;
            float charNextX = off < text.length() ? layout2.getPrimaryHorizontal(off + 1) : charX;
            Rect lineRect = new Rect();
            layout2.getLineBounds(line, lineRect);
            boolean clickedWithinLineHeight = y >= lineRect.top && y <= lineRect.bottom;
            boolean clickedOnSpanToTheLeftOfCursor = RangesKt.floatRangeContains((ClosedRange)((ClosedRange)RangesKt.rangeTo((float)charPrevX, (float)charX)), (int)x);
            boolean clickedOnSpanToTheRightOfCursor = RangesKt.floatRangeContains((ClosedRange)((ClosedRange)RangesKt.rangeTo((float)charX, (float)charNextX)), (int)x);
            boolean bl = clickedOnSpan = clickedWithinLineHeight && (clickedOnSpanToTheLeftOfCursor || clickedOnSpanToTheRightOfCursor);
            boolean clickedSpanBordersAnotherOne = text.getSpans(off, off, ClickableSpan.class).length == 1 && !((objectArray2 = (objectArray = text.getSpans(off + 1, off + 1, ClickableSpan.class))).length == 0);
            boolean isClickedSpanAmbiguous = text.getSpans(off, off, ClickableSpan.class).length > 1;
            boolean failedToPinpointClickedSpan = (isClickedSpanAmbiguous || clickedSpanBordersAnotherOne) && !clickedOnSpanToTheLeftOfCursor && !clickedOnSpanToTheRightOfCursor;
            ClickableSpan link = null;
            if (clickedOnSpan) {
                if (isClickedSpanAmbiguous) {
                    if (clickedOnSpanToTheLeftOfCursor) {
                        link = ((ClickableSpan[])text.getSpans(off, off, ClickableSpan.class))[0];
                    } else if (clickedOnSpanToTheRightOfCursor) {
                        link = ((ClickableSpan[])text.getSpans(off, off, ClickableSpan.class))[1];
                    }
                } else {
                    link = (ClickableSpan)ArraysKt.firstOrNull((Object[])text.getSpans(off, off, ClickableSpan.class));
                }
            } else if (failedToPinpointClickedSpan) {
                Object object;
                block13: {
                    Object[] $receiver$iv = text.getSpans(off, off, ClickableSpan.class);
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object element$iv = $receiver$iv[i];
                        ClickableSpan it = (ClickableSpan)element$iv;
                        if (!(text.getSpanStart((Object)it) == off)) continue;
                        object = element$iv;
                        break block13;
                    }
                    object = null;
                }
                link = (ClickableSpan)object;
            }
            if (link != null && (link instanceof AztecMediaClickableSpan || link instanceof UnknownClickableSpan)) {
                if (action == 1) {
                    link.onClick((View)widget);
                }
                return true;
            }
        }
        return super.onTouchEvent(widget, text, event);
    }

    private EnhancedMovementMethod() {
        INSTANCE = this;
    }

    static {
        new EnhancedMovementMethod();
    }
}

