/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecTagHandler;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.plugins.IAztecPlugin;
import org.wordpress.aztec.plugins.visual2html.IHtmlPostprocessor;
import org.wordpress.aztec.plugins.visual2html.IInlineSpanHandler;
import org.wordpress.aztec.spans.AztecCursorSpan;
import org.wordpress.aztec.spans.AztecHorizontalRuleSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecVisualLinebreak;
import org.wordpress.aztec.spans.CommentSpan;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecFullWidthImageSpan;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.spans.IAztecSurroundedWithNewlines;
import org.wordpress.aztec.spans.UnknownHtmlSpan;
import org.wordpress.aztec.util.SpanWrapper;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020!H\u0002J$\u0010$\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020(2\u0006\u0010)\u001a\u00020\bH\u0002J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u00020\u001f2\u0006\u0010#\u001a\u0002012\u0006\u00102\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010#\u001a\u000201H\u0002J,\u00104\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\b2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u00105\u001a\u00020\t2\u0006\u0010#\u001a\u00020+H\u0002J\u0010\u00106\u001a\u00020-2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00107\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020+H\u0002J\u000e\u00108\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020-H\u0002J\u0018\u0010;\u001a\u00020-2\u0006\u0010#\u001a\u00020+2\b\b\u0002\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020+H\u0002JL\u0010?\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020+2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020C2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010E2\u0006\u0010G\u001a\u00020\bH\u0002J<\u0010H\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020+2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010EH\u0002J\u001c\u0010I\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020+H\u0002JD\u0010I\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020+2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u000e\u0010J\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010E2\u0006\u0010G\u001a\u00020\bH\u0002JD\u0010K\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020+2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010EH\u0002J4\u0010M\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020(2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010L\u001a\u00020\bH\u0002J4\u0010N\u001a\u00020\u001f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010#\u001a\u00020+2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010O\u001a\u00020PH\u0002R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006Q"}, d2={"Lorg/wordpress/aztec/AztecParser;", "", "plugins", "", "Lorg/wordpress/aztec/plugins/IAztecPlugin;", "(Ljava/util/List;)V", "closeMap", "Ljava/util/TreeMap;", "", "Lorg/wordpress/aztec/spans/HiddenHtmlSpan;", "getCloseMap$aztec_release", "()Ljava/util/TreeMap;", "setCloseMap$aztec_release", "(Ljava/util/TreeMap;)V", "hiddenIndex", "getHiddenIndex$aztec_release", "()I", "setHiddenIndex$aztec_release", "(I)V", "hiddenSpans", "", "getHiddenSpans$aztec_release", "()[I", "setHiddenSpans$aztec_release", "([I)V", "openMap", "getOpenMap$aztec_release", "setOpenMap$aztec_release", "getPlugins", "()Ljava/util/List;", "addVisualNewlinesToBlockElements", "", "spanned", "Landroid/text/Editable;", "cleanupZWJ", "text", "consumeCursorIfInInput", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "position", "fromHtml", "Landroid/text/Spanned;", "source", "", "context", "Landroid/content/Context;", "markBlockElementLineBreak", "Landroid/text/Spannable;", "startPos", "markBlockElementsAsParagraphs", "parseHiddenSpans", "span", "postprocessHtml", "resetHiddenTagParser", "syncVisualNewlinesOfBlockElements", "tidy", "html", "toHtml", "withCursor", "", "unbiasNestingLevel", "withinBlock", "start", "end", "blockSpan", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "parents", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/spans/IAztecNestable;", "nestingLevel", "withinContent", "withinHtml", "grandParents", "withinParagraph", "nl", "withinStyle", "withinUnknown", "unknownHtmlSpan", "Lorg/wordpress/aztec/spans/UnknownHtmlSpan;", "aztec_release"})
public final class AztecParser {
    private int hiddenIndex;
    @NotNull
    private TreeMap<Integer, HiddenHtmlSpan> closeMap;
    @NotNull
    private TreeMap<Integer, HiddenHtmlSpan> openMap;
    @NotNull
    private int[] hiddenSpans;
    @NotNull
    private final List<IAztecPlugin> plugins;

    public final int getHiddenIndex$aztec_release() {
        return this.hiddenIndex;
    }

    public final void setHiddenIndex$aztec_release(int n) {
        this.hiddenIndex = n;
    }

    @NotNull
    public final TreeMap<Integer, HiddenHtmlSpan> getCloseMap$aztec_release() {
        return this.closeMap;
    }

    public final void setCloseMap$aztec_release(@NotNull TreeMap<Integer, HiddenHtmlSpan> treeMap) {
        Intrinsics.checkParameterIsNotNull(treeMap, (String)"<set-?>");
        this.closeMap = treeMap;
    }

    @NotNull
    public final TreeMap<Integer, HiddenHtmlSpan> getOpenMap$aztec_release() {
        return this.openMap;
    }

    public final void setOpenMap$aztec_release(@NotNull TreeMap<Integer, HiddenHtmlSpan> treeMap) {
        Intrinsics.checkParameterIsNotNull(treeMap, (String)"<set-?>");
        this.openMap = treeMap;
    }

    @NotNull
    public final int[] getHiddenSpans$aztec_release() {
        return this.hiddenSpans;
    }

    public final void setHiddenSpans$aztec_release(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.hiddenSpans = nArray;
    }

    @NotNull
    public final Spanned fromHtml(@NotNull String source, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String tidySource = this.tidy(source);
        SpannableStringBuilder spanned = new SpannableStringBuilder((CharSequence)Html.fromHtml(tidySource, new AztecTagHandler(this.plugins), context, this.plugins));
        this.addVisualNewlinesToBlockElements((Editable)spanned);
        this.markBlockElementsAsParagraphs((Spannable)spanned);
        this.cleanupZWJ((Editable)spanned);
        this.unbiasNestingLevel((Spanned)spanned);
        return (Spanned)spanned;
    }

    @NotNull
    public final String toHtml(@NotNull Spanned text, boolean withCursor) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StringBuilder out = new StringBuilder();
        SpannableStringBuilder data = new SpannableStringBuilder((CharSequence)text).append(Constants.INSTANCE.getZWJ_CHAR());
        Object[] objectArray = data.getSpans(data.length() - 1, data.length(), HiddenHtmlSpan.class);
        if (objectArray.length == 0 && (objectArray = data.getSpans(data.length() - 1, data.length(), AztecListSpan.class)).length == 0) {
            data.delete(data.length() - 1, data.length());
        }
        SpannableStringBuilder spannableStringBuilder = data;
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder, (String)"data");
        this.resetHiddenTagParser((Spanned)spannableStringBuilder);
        HiddenHtmlSpan[] hidden = (HiddenHtmlSpan[])data.getSpans(0, data.length(), HiddenHtmlSpan.class);
        this.hiddenSpans = new int[((Object[])hidden).length * 2];
        Object[] $receiver$iv = (Object[])hidden;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            int end;
            Object element$iv = $receiver$iv[i];
            HiddenHtmlSpan it = (HiddenHtmlSpan)((Object)element$iv);
            int n = this.hiddenIndex;
            this.hiddenIndex = n + 1;
            this.hiddenSpans[n] = it.getStartOrder();
            n = this.hiddenIndex;
            this.hiddenIndex = n + 1;
            this.hiddenSpans[n] = it.getEndOrder();
            int start = data.getSpanStart((Object)it);
            if (start != (end = data.getSpanEnd((Object)it)) || data.charAt(start) != '\n') continue;
            data.insert(start, (CharSequence)("" + Constants.INSTANCE.getMAGIC_CHAR()));
        }
        this.hiddenIndex = 0;
        Arrays.sort(this.hiddenSpans);
        if (!withCursor) {
            AztecCursorSpan cursorSpan;
            AztecCursorSpan aztecCursorSpan = cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])data.getSpans(0, data.length(), AztecCursorSpan.class));
            if (aztecCursorSpan != null) {
                AztecCursorSpan aztecCursorSpan2;
                AztecCursorSpan it = aztecCursorSpan2 = aztecCursorSpan;
                data.removeSpan((Object)cursorSpan);
            }
        }
        this.withinHtml(out, (Spanned)data);
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        String html = this.postprocessHtml(this.tidy(string));
        return html;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String toHtml$default(AztecParser aztecParser, Spanned spanned, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return aztecParser.toHtml(spanned, bl);
    }

    private final String postprocessHtml(String source) {
        IAztecPlugin it;
        Iterable $receiver$iv$iv;
        String html = source;
        Iterable $receiver$iv = this.plugins;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)element$iv$iv;
            if (!(it instanceof IHtmlPostprocessor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            IAztecPlugin iAztecPlugin = it;
            if (iAztecPlugin == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.IHtmlPostprocessor");
            }
            IHtmlPostprocessor iHtmlPostprocessor = (IHtmlPostprocessor)iAztecPlugin;
            collection.add(iHtmlPostprocessor);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            IHtmlPostprocessor it2 = (IHtmlPostprocessor)element$iv;
            html = it2.processHtmlAfterSerialization(html);
        }
        return html;
    }

    private final void markBlockElementLineBreak(Spannable text, int startPos) {
        text.setSpan((Object)new AztecVisualLinebreak(), startPos, startPos, 17);
    }

    /*
     * Unable to fully structure code
     */
    public final void addVisualNewlinesToBlockElements(@NotNull Editable spanned) {
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        $receiver$iv = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (IAztecSurroundedWithNewlines)element$iv;
            parent = IAztecNestable.Companion.getParent((Spannable)spanned, new SpanWrapper<IAztecSurroundedWithNewlines>((Spannable)spanned, it));
            if (!(it instanceof AztecListSpan)) ** GOTO lbl-1000
            v0 = parent;
            if ((v0 != null ? v0.getSpan() : null) instanceof AztecListItemSpan) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            repelling = v1;
            spanStart = spanned.getSpanStart((Object)it);
            if (!repelling && spanStart < 1) continue;
            v2 = parent;
            v3 = parentStart = v2 != null ? v2.getStart() : 0;
            if (!repelling && spanStart == parentStart || !repelling && spanned.charAt(spanStart - 1) == '\n') continue;
            spanned.insert(spanStart, (CharSequence)"\n");
            var10_13 = SpanWrapper.Companion;
            var11_14 = (Spannable)spanned;
            var12_16 = spanStart + 1;
            end$iv = spanStart + 2;
            v4 = spannable$iv.getSpans((int)start$iv, end$iv, IAztecNestable.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"spannable.getSpans(start, end, T::class.java)");
            this_$iv = this_$iv.getSpans((Spannable)spannable$iv, v4);
            spannable$iv = $receiver$iv;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                subParent = (SpanWrapper)element$iv$iv;
                if (!(((IAztecNestable)subParent.getSpan()).getNestingLevel() < it.getNestingLevel() && subParent.getStart() == spanStart + 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (E element$iv : $receiver$iv) {
                v5 = subParent = (SpanWrapper)element$iv;
                var14_20 = v5.getStart();
                v5.setStart(var14_20 + -1);
            }
            this.markBlockElementLineBreak((Spannable)spanned, spanStart);
        }
        $receiver$iv = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (IAztecSurroundedWithNewlines)element$iv;
            spanEnd = spanned.getSpanEnd((Object)it);
            if (spanEnd == spanned.length()) continue;
            if (spanned.charAt(spanEnd) == '\n' && (var8_11 = (var7_9 = spanned.getSpans(spanEnd, spanEnd, AztecVisualLinebreak.class))).length == 0 == false) {
                if (!(it instanceof IAztecBlockSpan)) continue;
                spanned.setSpan((Object)it, spanned.getSpanStart((Object)it), spanEnd + 1, spanned.getSpanFlags((Object)it));
                continue;
            }
            spanned.insert(spanEnd, (CharSequence)"\n");
            if (it instanceof IAztecBlockSpan) {
                spanned.setSpan((Object)it, spanned.getSpanStart((Object)it), spanEnd + 1, spanned.getSpanFlags((Object)it));
            }
            this.markBlockElementLineBreak((Spannable)spanned, spanEnd);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void syncVisualNewlinesOfBlockElements(@NotNull Editable spanned) {
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        $receiver$iv = spanned.getSpans(0, spanned.length(), AztecVisualLinebreak.class);
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (AztecVisualLinebreak)element$iv;
            spanned.removeSpan(it);
        }
        $receiver$iv = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (IAztecSurroundedWithNewlines)element$iv;
            spanEnd = spanned.getSpanEnd(it);
            v0 = newlineExpected = it instanceof IAztecBlockSpan != false && spanEnd > 0 ? spanEnd - 1 : spanEnd;
            if (spanEnd == spanned.length() || spanned.charAt(newlineExpected) != '\n') continue;
            this.markBlockElementLineBreak((Spannable)spanned, newlineExpected);
        }
        $receiver$iv = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            block6: {
                element$iv = $receiver$iv[var3_3];
                it = (IAztecSurroundedWithNewlines)element$iv;
                parent = IAztecNestable.Companion.getParent((Spannable)spanned, new SpanWrapper<Object>((Spannable)spanned, it));
                if (!(it instanceof AztecListSpan)) ** GOTO lbl-1000
                v1 = parent;
                if ((v1 != null ? v1.getSpan() : null) instanceof AztecListItemSpan) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                repelling = v2;
                spanStart = spanned.getSpanStart(it);
                if (spanStart == 0 || !repelling && spanStart < 2 || spanned.charAt(spanStart - 1) != '\n') continue;
                $receiver$iv = spanned.getSpans(spanStart, spanStart, IAztecSurroundedWithNewlines.class);
                for (var10_11 = 0; var10_11 < $receiver$iv.length; ++var10_11) {
                    element$iv = $receiver$iv[var10_11];
                    before = (IAztecSurroundedWithNewlines)element$iv;
                    if (!(spanned.getSpanEnd((Object)before) == spanStart)) continue;
                    v3 = true;
                    break block6;
                }
                v3 = false;
            }
            if (v3 || spanStart > 1 && !repelling && spanned.charAt(spanStart - 2) == '\n' || (var10_12 = (var9_10 = spanned.getSpans(spanStart - 1, spanStart - 1, AztecVisualLinebreak.class))).length == 0 == false) continue;
            this.markBlockElementLineBreak((Spannable)spanned, spanStart - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markBlockElementsAsParagraphs(Spannable text) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = SpanWrapper.Companion.getSpans(text, 0, text.length(), IAztecBlockSpan.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SpanWrapper spanWrapper = (SpanWrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            it.setFlags(51);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void cleanupZWJ(Editable text) {
        int lastIndex = text.length();
        do {
            if ((lastIndex = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)text), (char)Constants.INSTANCE.getZWJ_CHAR(), (int)lastIndex, (boolean)false, (int)4, null)) == text.length() - 1) {
                return;
            }
            if (lastIndex <= -1) continue;
            text.delete(lastIndex, lastIndex + 1);
        } while (lastIndex > -1);
    }

    private final void unbiasNestingLevel(Spanned text) {
        Object[] $receiver$iv = text.getSpans(0, text.length(), IAztecNestable.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            IAztecNestable it;
            Object element$iv = $receiver$iv[i];
            IAztecNestable iAztecNestable = it = (IAztecNestable)element$iv;
            iAztecNestable.setNestingLevel(iAztecNestable.getNestingLevel() - 2);
        }
    }

    private final void resetHiddenTagParser(Spanned text) {
        this.hiddenIndex = 0;
        this.closeMap.clear();
        this.openMap.clear();
        HiddenHtmlSpan[] spans = (HiddenHtmlSpan[])text.getSpans(0, text.length(), HiddenHtmlSpan.class);
        Object[] $receiver$iv = (Object[])spans;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            HiddenHtmlSpan p1 = (HiddenHtmlSpan)((Object)element$iv);
            p1.reset();
        }
    }

    private final void withinHtml(StringBuilder out, Spanned text) {
        this.withinHtml(out, text, 0, text.length(), null, -1);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinHtml(StringBuilder out, Spanned text, int start, int end, ArrayList<IAztecNestable> grandParents, int nestingLevel) {
        int next;
        int i = start;
        do {
            ArrayList<IAztecNestable> parents;
            Object object;
            IAztecNestable iAztecNestable;
            block10: {
                IAztecNestable[] paragraphs;
                void $receiver$iv$iv;
                Collection $receiver$iv;
                Object[] objectArray = text.getSpans(i, end, IAztecNestable.class);
                iAztecNestable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                    void element$iv$iv = $receiver$iv$iv[j];
                    IAztecNestable it = (IAztecNestable)element$iv$iv;
                    if (!(!(it instanceof IAztecFullWidthImageSpan))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Collection thisCollection$iv = $receiver$iv;
                if (thisCollection$iv.toArray(new IAztecNestable[thisCollection$iv.size()]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ArraysKt.sortWith((Object[])paragraphs, (Comparator)new Comparator<IAztecNestable>(text){
                    final /* synthetic */ Spanned $text;

                    public final int compare(IAztecNestable a, IAztecNestable b) {
                        int startComparison = Intrinsics.compare((int)this.$text.getSpanStart((Object)a), (int)this.$text.getSpanStart((Object)b));
                        if (startComparison == 0) {
                            int nestingComparison = Intrinsics.compare((int)a.getNestingLevel(), (int)b.getNestingLevel());
                            if (nestingComparison == 0) {
                                return Intrinsics.compare((int)this.$text.getSpanEnd((Object)a), (int)this.$text.getSpanEnd((Object)b));
                            }
                            return nestingComparison;
                        }
                        return startComparison;
                    }
                    {
                        this.$text = spanned;
                    }
                });
                Object[] $receiver$iv2 = paragraphs;
                for (int j = 0; j < $receiver$iv2.length; ++j) {
                    Object element$iv = $receiver$iv2[j];
                    IAztecNestable it = (IAztecNestable)element$iv;
                    if (!(it.getNestingLevel() > nestingLevel)) continue;
                    object = element$iv;
                    break block10;
                }
                object = null;
            }
            IAztecNestable paragraph = (IAztecNestable)object;
            if (paragraph == null) {
                next = end;
                parents = grandParents;
            } else if (text.getSpanStart((Object)paragraph) > i) {
                next = text.getSpanStart((Object)paragraph);
                paragraph = null;
                parents = grandParents;
            } else {
                next = text.getSpanEnd((Object)paragraph);
                ArrayList<IAztecNestable> arrayList = grandParents;
                parents = new ArrayList(arrayList != null ? (Collection)arrayList : (Collection)new ArrayList());
                parents.add(paragraph);
            }
            iAztecNestable = paragraph;
            if (iAztecNestable instanceof IAztecBlockSpan) {
                this.withinBlock(out, text, i, next, (IAztecBlockSpan)paragraph, parents, paragraph.getNestingLevel());
                continue;
            }
            if (iAztecNestable instanceof UnknownHtmlSpan) {
                this.withinUnknown(out, text, i, next, (UnknownHtmlSpan)paragraph);
                continue;
            }
            this.withinContent(out, text, i, next, parents);
        } while ((i = next) < end);
        this.consumeCursorIfInInput(out, (CharSequence)text, text.length());
    }

    private final void withinUnknown(StringBuilder out, Spanned text, int start, int end, UnknownHtmlSpan unknownHtmlSpan) {
        this.consumeCursorIfInInput(out, (CharSequence)text, start);
        out.append((CharSequence)unknownHtmlSpan.getRawHtml());
        this.consumeCursorIfInInput(out, (CharSequence)text, end);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinBlock(StringBuilder out, Spanned text, int start, int end, IAztecBlockSpan blockSpan, ArrayList<IAztecNestable> parents, int nestingLevel) {
        Object object;
        out.append('<' + blockSpan.getStartTag() + '>');
        this.withinHtml(out, text, start, end, parents, nestingLevel);
        out.append("</" + blockSpan.getEndTag() + '>');
        if (end > 0 && text.charAt(end - 1) == Constants.INSTANCE.getNEWLINE() && ((Object[])(object = text.getSpans(end - 1, end, AztecVisualLinebreak.class))).length == 0) {
            boolean bl;
            block5: {
                ArrayList<IAztecNestable> arrayList = parents;
                if (arrayList != null) {
                    void $receiver$iv;
                    object = arrayList;
                    for (Object element$iv : $receiver$iv) {
                        IAztecNestable it = (IAztecNestable)element$iv;
                        if (!(Intrinsics.areEqual((Object)it, (Object)blockSpan) ^ true && text.getSpanEnd((Object)it) == end)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                out.append("<br>");
            }
        }
    }

    private final void withinContent(StringBuilder out, Spanned text, int start, int end, ArrayList<IAztecNestable> parents) {
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)((CharSequence)text), (char)'\n', (int)i, (int)end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                boolean isVisualLinebreak;
                Object[] objectArray = text.getSpans(next, next, AztecVisualLinebreak.class);
                Object[] objectArray2 = objectArray;
                boolean bl = isVisualLinebreak = !(objectArray2.length == 0);
                if (!isVisualLinebreak) {
                    ++nl;
                }
                ++next;
            }
            this.withinParagraph(out, text, i, next - nl, nl, parents);
            i = next;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void withinParagraph(StringBuilder out, Spanned text, int start, int end, int nl, ArrayList<IAztecNestable> parents) {
        next = new Ref.IntRef();
        i = start;
        while (i < end || start == end) {
            block30: {
                next.element = text.nextSpanTransition(i, end, CharacterStyle.class);
                spans = (CharacterStyle[])text.getSpans(i, next.element, CharacterStyle.class);
                var10_11 = 0;
                var11_12 = spans.length;
                while (var10_11 < var11_12) {
                    span = spans[j];
                    if (span instanceof IAztecInlineSpan) {
                        out.append('<' + ((IAztecInlineSpan)span).getStartTag() + '>');
                    }
                    if (span instanceof CommentSpan) {
                        out.append("<!--");
                    }
                    var14_17 = $receiver$iv = (Iterable)this.plugins;
                    destination$iv$iv = new ArrayList<E>();
                    var16_19 = $receiver$iv$iv.iterator();
                    while (var16_19.hasNext()) {
                        element$iv$iv = var16_19.next();
                        it = (IAztecPlugin)element$iv$iv;
                        if (!(it instanceof IInlineSpanHandler)) ** GOTO lbl-1000
                        v0 = (IInlineSpanHandler)it;
                        v1 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"span");
                        if (v0.canHandleSpan(v1)) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    var16_19 = $receiver$iv$iv.iterator();
                    while (var16_19.hasNext()) {
                        item$iv$iv = var16_19.next();
                        it = (IAztecPlugin)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        v3 = it;
                        if (v3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.IInlineSpanHandler");
                        }
                        var24_24 = (IInlineSpanHandler)v3;
                        var23_23.add(var24_24);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv /* !! */  = $receiver$iv$iv.next();
                        it = (IInlineSpanHandler)element$iv /* !! */ ;
                        v4 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"span");
                        it.handleSpanStart(out, v4);
                        if (it.shouldParseContent()) continue;
                        i = next.element;
                    }
                    if (span instanceof AztecHorizontalRuleSpan) {
                        out.append('<' + ((AztecHorizontalRuleSpan)span).getStartTag() + '>');
                        i = next.element;
                    }
                    if (span instanceof AztecMediaSpan) {
                        out.append(((AztecMediaSpan)span).getHtml());
                        i = next.element;
                    }
                    if (span instanceof HiddenHtmlSpan) {
                        this.parseHiddenSpans(i, out, (HiddenHtmlSpan)span, text);
                    }
                    ++j;
                }
                this.withinStyle(out, (CharSequence)text, i, next.element, nl);
                v5 = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])spans)));
                j = v5.getFirst();
                var11_12 = v5.getLast();
                span = v5.getStep();
                v6 = j;
                v7 = var11_12;
                if (!(span > 0 ? v6 <= v7 : v6 >= v7)) break block30;
                while (true) {
                    if ((span = spans[j]) instanceof IAztecInlineSpan) {
                        out.append("</" + ((IAztecInlineSpan)span).getEndTag() + '>');
                    }
                    if (span instanceof CommentSpan) {
                        out.append("-->");
                    }
                    element$iv /* !! */  = $receiver$iv = (Iterable)this.plugins;
                    destination$iv$iv = new ArrayList<E>();
                    $i$a$3$forEach = $receiver$iv$iv.iterator();
                    while ($i$a$3$forEach.hasNext()) {
                        element$iv$iv = $i$a$3$forEach.next();
                        it = (IAztecPlugin)element$iv$iv;
                        if (!(it instanceof IInlineSpanHandler)) ** GOTO lbl-1000
                        v8 = (IInlineSpanHandler)it;
                        v9 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"span");
                        if (v8.canHandleSpan(v9)) {
                            v10 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v10 = false;
                        }
                        if (!v10) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    $i$a$3$forEach = $receiver$iv$iv.iterator();
                    while ($i$a$3$forEach.hasNext()) {
                        item$iv$iv = $i$a$3$forEach.next();
                        it = (IAztecPlugin)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        v11 = it;
                        if (v11 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.IInlineSpanHandler");
                        }
                        var24_24 = (IInlineSpanHandler)v11;
                        var23_23.add(var24_24);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        it = (IInlineSpanHandler)element$iv;
                        v12 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"span");
                        it.handleSpanEnd(out, v12);
                    }
                    if (span instanceof HiddenHtmlSpan) {
                        this.parseHiddenSpans(next.element, out, (HiddenHtmlSpan)span, text);
                    }
                    if (j == var11_12) break;
                    j += span;
                }
            }
            if (start == end) break;
            i = next.element;
        }
        if ((spans = 0) <= (var10_11 = nl - 1)) {
            while (true) {
                block29: {
                    v13 = parents;
                    if (v13 != null) {
                        $receiver$iv = v13;
                        for (T element$iv : $receiver$iv) {
                            it = (IAztecNestable)element$iv;
                            if (!(text.getSpanEnd((Object)it) == end + 1 + z)) continue;
                            v14 = true;
                            break block29;
                        }
                        v14 = false;
                    } else {
                        v14 = parentSharesEnd = false;
                    }
                }
                if (!parentSharesEnd) {
                    out.append("<br>");
                    this.consumeCursorIfInInput(out, (CharSequence)text, end + z);
                }
                if (z == var10_11) break;
                ++z;
            }
        }
    }

    private final void parseHiddenSpans(int position, StringBuilder out, HiddenHtmlSpan span, Spanned text) {
        int last;
        this.closeMap.put(span.getEndOrder(), span);
        this.openMap.put(span.getStartOrder(), span);
        do {
            HiddenHtmlSpan nextSpan;
            Map map;
            last = this.hiddenIndex;
            if (this.hiddenIndex >= this.hiddenSpans.length) break;
            int nextSpanIndex = this.hiddenSpans[this.hiddenIndex];
            Map map2 = this.openMap;
            Integer n = nextSpanIndex;
            Map map3 = map = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map3.containsKey(n)) {
                if (this.openMap.get(nextSpanIndex) == null) {
                    Intrinsics.throwNpe();
                }
                if (!nextSpan.isOpened() && text.getSpanStart((Object)nextSpan) == position) {
                    out.append((CharSequence)nextSpan.getStartTag());
                    nextSpan.open();
                    int n2 = this.hiddenIndex;
                    this.hiddenIndex = n2 + 1;
                }
            }
            if (!this.closeMap.containsKey(nextSpanIndex)) continue;
            if (this.closeMap.get(nextSpanIndex) == null) {
                Intrinsics.throwNpe();
            }
            if (nextSpan.isParsed() || text.getSpanEnd((Object)nextSpan) != position) continue;
            out.append((CharSequence)nextSpan.getEndTag());
            nextSpan.parse();
            int n3 = this.hiddenIndex;
            this.hiddenIndex = n3 + 1;
        } while (last != this.hiddenIndex);
    }

    private final void withinStyle(StringBuilder out, CharSequence text, int start, int end, int nl) {
        int i = start;
        while (i < end) {
            char c = text.charAt(i);
            if (c == Constants.INSTANCE.getZWJ_CHAR()) {
                ++i;
                continue;
            }
            this.consumeCursorIfInInput(out, text, i);
            if (c == '<') {
                out.append("&lt;");
            } else if (c == '>') {
                out.append("&gt;");
            } else if (c == '&') {
                out.append("&amp;");
            } else if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    this.consumeCursorIfInInput(out, text, ++i);
                }
                out.append(' ');
            } else if (c != '\n') {
                out.append(c);
            }
            ++i;
        }
        if (nl == 0 && text.length() > i && text.charAt(i) == '\n') {
            this.consumeCursorIfInInput(out, text, i);
        }
    }

    private final void consumeCursorIfInInput(StringBuilder out, CharSequence text, int position) {
        AztecCursorSpan cursorSpan;
        if (text instanceof SpannableStringBuilder && (cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])((SpannableStringBuilder)text).getSpans(position, position, AztecCursorSpan.class))) != null) {
            out.append(AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG());
            ((SpannableStringBuilder)text).removeSpan((Object)cursorSpan);
        }
    }

    private final String tidy(String html) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)html, (String)Constants.INSTANCE.getZWJ_STRING(), (String)"", (boolean)false, (int)4, null), (String)Constants.INSTANCE.getMAGIC_STRING(), (String)"", (boolean)false, (int)4, null);
        String string = "(</? ?br>)*((aztec_cursor)?)</blockquote>";
        string = new Regex(string);
        String string2 = "$2</blockquote>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</li>";
        string = new Regex(string);
        string2 = "$2</li>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</p>";
        string = new Regex(string);
        string2 = "$2</p>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</pre>";
        string = new Regex(string);
        string2 = "$2</pre>";
        return string.replace(charSequence, string2);
    }

    @NotNull
    public final List<IAztecPlugin> getPlugins() {
        return this.plugins;
    }

    public AztecParser(@NotNull List<? extends IAztecPlugin> plugins) {
        Intrinsics.checkParameterIsNotNull(plugins, (String)"plugins");
        this.plugins = plugins;
        this.closeMap = new TreeMap();
        this.openMap = new TreeMap();
        this.hiddenSpans = new int[0];
    }

    public /* synthetic */ AztecParser(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        this(list);
    }

    public AztecParser() {
        this(null, 1, null);
    }
}

