/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Paint;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.UpdateLayout;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecNestable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0006J\u001e\u0010 \u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006R\u001a\u0010\t\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\r\u00a8\u0006$"}, d2={"Lorg/wordpress/aztec/spans/AztecListSpan;", "Landroid/text/style/LeadingMarginSpan$Standard;", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "nestingLevel", "", "verticalPadding", "(II)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "getVerticalPadding", "setVerticalPadding", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "getIndexOfProcessedLine", "nestingDepth", "Landroid/text/Spanned;", "index", "nextIndex", "aztec_release"})
public abstract class AztecListSpan
extends LeadingMarginSpan.Standard
implements IAztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    private int endBeforeBleed;
    private int startBeforeCollapse;
    private int nestingLevel;
    private int verticalPadding;

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.verticalPadding;
            fm.top -= this.verticalPadding;
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.verticalPadding;
            fm.bottom += this.verticalPadding;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getIndexOfProcessedLine(@NotNull CharSequence text, int end) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int spanStart = ((Spanned)text).getSpanStart((Object)this);
        int spanEnd = ((Spanned)text).getSpanEnd((Object)this);
        CharSequence charSequence = text.subSequence(spanStart, spanEnd);
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned listText = (Spanned)charSequence;
        if (this.nestingDepth(listText, end - spanStart, end - spanStart + 1) != this.getNestingLevel() + 1) {
            return -1;
        }
        CharSequence charSequence2 = listText.subSequence(0, end - spanStart);
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned textBeforeBeforeEnd = (Spanned)charSequence2;
        ArrayList<Integer> nestingDepth = new ArrayList<Integer>();
        CharSequence $receiver$iv = (CharSequence)textBeforeBeforeEnd;
        int index$iv = 0;
        CharSequence charSequence3 = $receiver$iv;
        for (int i = 0; i < charSequence3.length(); ++i) {
            void c;
            char item$iv = charSequence3.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int i2 = n;
            if (c != 10) continue;
            nestingDepth.add(this.nestingDepth(textBeforeBeforeEnd, i2, i2 + 1));
        }
        int otherLinesAtSameNestingLevel = 0;
        for (Integer maxNestingLevel : nestingDepth) {
            if (maxNestingLevel - 1 != this.getNestingLevel()) continue;
            ++otherLinesAtSameNestingLevel;
        }
        return otherLinesAtSameNestingLevel + 1;
    }

    public final int nestingDepth(@NotNull Spanned text, int index, int nextIndex) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int finalNextIndex = nextIndex > text.length() ? index : nextIndex;
        return IAztecNestable.Companion.getNestingLevelAt(text, index, finalNextIndex);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    public final int getVerticalPadding() {
        return this.verticalPadding;
    }

    public final void setVerticalPadding(int n) {
        this.verticalPadding = n;
    }

    public AztecListSpan(int nestingLevel, int verticalPadding) {
        super(0);
        this.nestingLevel = nestingLevel;
        this.verticalPadding = verticalPadding;
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
    }

    public /* synthetic */ AztecListSpan(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    @Override
    @NotNull
    public String getStartTag() {
        return IAztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return IAztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void clearStartBeforeCollapse() {
        IAztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return IAztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        IAztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return IAztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

