/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineHeightSpan;
import android.text.style.QuoteSpan;
import android.text.style.UpdateLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.IAztecBlockSpan;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ8\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u000200H\u0016Jb\u00101\u001a\u00020(2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0016Jh\u0010<\u001a\u00020(2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00072\u0006\u0010?\u001a\u00020@H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010\u0019\u00a8\u0006D"}, d2={"Lorg/wordpress/aztec/spans/AztecQuoteSpan;", "Landroid/text/style/QuoteSpan;", "Landroid/text/style/LineBackgroundSpan;", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "nestingLevel", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "(ILorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "setQuoteStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;)V", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "drawBackground", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "left", "right", "top", "baseline", "bottom", "lnum", "drawLeadingMargin", "x", "dir", "first", "", "layout", "Landroid/text/Layout;", "getLeadingMargin", "aztec_release"})
public final class AztecQuoteSpan
extends QuoteSpan
implements LineBackgroundSpan,
IAztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    private int endBeforeBleed;
    private int startBeforeCollapse;
    @NotNull
    private final Rect rect;
    @NotNull
    private final String TAG = "blockquote";
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.QuoteStyle quoteStyle;

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    @NotNull
    public final Rect getRect() {
        return this.rect;
    }

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.quoteStyle.getVerticalPadding();
            fm.top -= this.quoteStyle.getVerticalPadding();
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.quoteStyle.getVerticalPadding();
            fm.bottom += this.quoteStyle.getVerticalPadding();
        }
    }

    public int getLeadingMargin(boolean first) {
        return this.quoteStyle.getQuoteMargin() + this.quoteStyle.getQuoteWidth() + this.quoteStyle.getQuotePadding();
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout2) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        Paint.Style style2 = p.getStyle();
        int color2 = p.getColor();
        p.setStyle(Paint.Style.FILL);
        p.setColor(this.quoteStyle.getQuoteColor());
        c.drawRect((float)x + (float)this.quoteStyle.getQuoteMargin(), (float)top, (float)(x + this.quoteStyle.getQuoteMargin() + dir * this.quoteStyle.getQuoteWidth()), (float)bottom, p);
        p.setStyle(style2);
        p.setColor(color2);
    }

    public void drawBackground(@NotNull Canvas c, @NotNull Paint p, int left, int right, int top, int baseline, int bottom, @Nullable CharSequence text, int start, int end, int lnum) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        int alpha = (int)(this.quoteStyle.getQuoteBackgroundAlpha() * (float)255);
        int paintColor = p.getColor();
        p.setColor(Color.argb((int)alpha, (int)Color.red((int)this.quoteStyle.getQuoteBackground()), (int)Color.green((int)this.quoteStyle.getQuoteBackground()), (int)Color.blue((int)this.quoteStyle.getQuoteBackground())));
        this.rect.set(left + this.quoteStyle.getQuoteMargin(), top, right, bottom);
        c.drawRect(this.rect, p);
        p.setColor(paintColor);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public final void setQuoteStyle(@NotNull BlockFormatter.QuoteStyle quoteStyle) {
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"<set-?>");
        this.quoteStyle = quoteStyle;
    }

    public AztecQuoteSpan(int nestingLevel, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.QuoteStyle quoteStyle) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.quoteStyle = quoteStyle;
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
        this.rect = new Rect();
        this.TAG = "blockquote";
    }

    public /* synthetic */ AztecQuoteSpan(int n, AztecAttributes aztecAttributes, BlockFormatter.QuoteStyle quoteStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 4) != 0) {
            quoteStyle = new BlockFormatter.QuoteStyle(0, 0, 0.0f, 0, 0, 0, 0);
        }
        this(n, aztecAttributes, quoteStyle);
    }

    @Override
    @NotNull
    public String getStartTag() {
        return IAztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return IAztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void clearStartBeforeCollapse() {
        IAztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return IAztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        IAztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return IAztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

