/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.TextPaint;
import android.text.style.DynamicDrawableSpan;
import android.view.View;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0005JP\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020%2\u0006\u00100\u001a\u00020%2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020%2\u0006\u00106\u001a\u000207H\u0016J\n\u00108\u001a\u0004\u0018\u00010\u0005H\u0016J6\u00109\u001a\u00020%2\b\u00106\u001a\u0004\u0018\u0001072\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010$\u001a\u00020%2\u0006\u00100\u001a\u00020%2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006="}, d2={"Lorg/wordpress/aztec/spans/AztecDynamicImageSpan;", "Landroid/text/style/DynamicDrawableSpan;", "context", "Landroid/content/Context;", "imageDrawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;)V", "aspectRatio", "", "getAspectRatio", "()D", "setAspectRatio", "(D)V", "getContext", "()Landroid/content/Context;", "drawableRef", "Ljava/lang/ref/WeakReference;", "getDrawableRef", "()Ljava/lang/ref/WeakReference;", "setDrawableRef", "(Ljava/lang/ref/WeakReference;)V", "measuring", "", "originalBounds", "Landroid/graphics/Rect;", "getOriginalBounds", "()Landroid/graphics/Rect;", "setOriginalBounds", "(Landroid/graphics/Rect;)V", "textView", "Lorg/wordpress/aztec/AztecText;", "getTextView", "()Lorg/wordpress/aztec/AztecText;", "setTextView", "(Lorg/wordpress/aztec/AztecText;)V", "adjustBounds", "start", "", "calculateWantedWidth", "widthMeasureSpec", "computeAspectRatio", "", "drawable", "draw", "canvas", "Landroid/graphics/Canvas;", "text", "", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getDrawable", "getSize", "metrics", "Landroid/graphics/Paint$FontMetricsInt;", "Companion", "aztec_release"})
public abstract class AztecDynamicImageSpan
extends DynamicDrawableSpan {
    @Nullable
    private AztecText textView;
    @NotNull
    private Rect originalBounds;
    private double aspectRatio;
    private boolean measuring;
    @Nullable
    private WeakReference<Drawable> drawableRef;
    @NotNull
    private final Context context;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final AztecText getTextView() {
        return this.textView;
    }

    public final void setTextView(@Nullable AztecText aztecText) {
        this.textView = aztecText;
    }

    @NotNull
    public final Rect getOriginalBounds() {
        return this.originalBounds;
    }

    public final void setOriginalBounds(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
        this.originalBounds = rect;
    }

    public final double getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(double d) {
        this.aspectRatio = d;
    }

    @Nullable
    protected final WeakReference<Drawable> getDrawableRef() {
        return this.drawableRef;
    }

    protected final void setDrawableRef(@Nullable WeakReference<Drawable> weakReference) {
        this.drawableRef = weakReference;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void computeAspectRatio(@Nullable Drawable drawable2) {
        Drawable drawable3;
        Drawable drawable4;
        Drawable drawable5 = drawable2;
        if ((drawable5 != null ? drawable5.getIntrinsicWidth() : -1) > -1) {
            Drawable drawable6 = drawable2;
            if ((drawable6 != null ? drawable6.getIntrinsicHeight() : -1) > -1) {
                Drawable drawable7 = drawable2;
                Drawable drawable8 = drawable2;
                this.aspectRatio = 1.0 * (double)(drawable7 != null ? drawable7.getIntrinsicWidth() : 1) / (double)(drawable8 != null ? drawable8.getIntrinsicHeight() : 1);
                return;
            }
        }
        if ((drawable4 = drawable2) != null && (drawable4 = drawable4.getBounds()) != null ? drawable4.isEmpty() : true) {
            this.aspectRatio = 1.0;
            return;
        }
        Drawable drawable9 = drawable2;
        this.aspectRatio = 1.0 * (double)(drawable9 != null && (drawable9 = drawable9.getBounds()) != null ? drawable9.width() : 0) / (double)((drawable3 = drawable2) != null && (drawable3 = drawable3.getBounds()) != null ? drawable3.height() : 1);
    }

    public int getSize(@Nullable Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt metrics) {
        Rect sizeRect = this.adjustBounds(start);
        if (metrics != null && sizeRect.width() > 0) {
            metrics.ascent = -sizeRect.height();
            metrics.descent = 0;
            metrics.top = metrics.ascent;
            metrics.bottom = 0;
        }
        return sizeRect.width();
    }

    @NotNull
    public final Rect adjustBounds(int start) {
        Drawable drawable2;
        int height;
        int n;
        int width;
        int n2;
        Layout layout;
        Drawable drawable3;
        block17: {
            Drawable drawable4;
            block16: {
                WeakReference<Drawable> weakReference = this.drawableRef;
                Object object = drawable3 = weakReference != null ? (Drawable)weakReference.get() : null;
                if (this.textView == null) break block16;
                AztecText aztecText = this.textView;
                if (!Intrinsics.areEqual((Object)(aztecText != null ? Integer.valueOf(aztecText.getWidthMeasureSpec()) : null), (Object)0)) break block17;
            }
            if ((drawable4 = drawable3) == null || (drawable4 = drawable4.getBounds()) == null) {
                drawable4 = new Rect(0, 0, 0, 0);
            }
            return new Rect((Rect)drawable4);
        }
        AztecText aztecText = this.textView;
        Object object = layout = aztecText != null ? aztecText.getLayout() : null;
        if (this.measuring || layout == null) {
            return new Rect(0, 0, 1, 1);
        }
        AztecText aztecText2 = this.textView;
        AztecText aztecText3 = this.textView;
        AztecText aztecText4 = this.textView;
        int cfr_ignored_0 = this.calculateWantedWidth(aztecText2 != null ? aztecText2.getWidthMeasureSpec() : 0) - (aztecText3 != null ? aztecText3.getCompoundPaddingLeft() : 0) - (aztecText4 != null ? aztecText4.getCompoundPaddingRight() : 0);
        this.measuring = true;
        this.measuring = false;
        int line = layout.getLineForOffset(start);
        int maxWidth = layout.getParagraphRight(line) - layout.getParagraphLeft(line);
        if (this.originalBounds.width() > 0) {
            n2 = this.originalBounds.width();
        } else {
            Drawable drawable5 = drawable3;
            if ((drawable5 != null ? drawable5.getIntrinsicWidth() : -1) > -1) {
                Drawable drawable6 = drawable3;
                n2 = drawable6 != null ? drawable6.getIntrinsicWidth() : -1;
            } else {
                n2 = width = maxWidth;
            }
        }
        if (this.originalBounds.height() > 0) {
            n = this.originalBounds.height();
        } else {
            Drawable drawable7 = drawable3;
            if ((drawable7 != null ? drawable7.getIntrinsicHeight() : -1) > -1) {
                Drawable drawable8 = drawable3;
                n = drawable8 != null ? drawable8.getIntrinsicHeight() : -1;
            } else {
                n = height = (int)((double)width / this.aspectRatio);
            }
        }
        if (width > maxWidth) {
            width = maxWidth;
            height = (int)((double)width / this.aspectRatio);
        }
        Drawable drawable9 = drawable3;
        if (drawable9 != null) {
            drawable9.setBounds(new Rect(0, 0, width, height));
        }
        if ((drawable2 = drawable3) == null || (drawable2 = drawable2.getBounds()) == null) {
            drawable2 = new Rect(0, 0, 0, 0);
        }
        return new Rect((Rect)drawable2);
    }

    public final int calculateWantedWidth(int widthMeasureSpec) {
        int width;
        BoringLayout.Metrics UNKNOWN_BORING;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING = new BoringLayout.Metrics();
        int des = -1;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (des < 0) {
                AztecText aztecText = this.textView;
                boring = BoringLayout.isBoring((CharSequence)"", (TextPaint)(aztecText != null ? aztecText.getPaint() : null));
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    AztecText aztecText = this.textView;
                    des = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)"", (TextPaint)(aztecText != null ? aztecText.getPaint() : null)));
                }
                width = des;
            } else {
                width = boring.width;
            }
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        return width;
    }

    @Nullable
    public Drawable getDrawable() {
        WeakReference<Drawable> weakReference = this.drawableRef;
        return weakReference != null ? (Drawable)weakReference.get() : null;
    }

    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.save();
        if (this.getDrawable() != null) {
            int transY = top;
            if (this.mVerticalAlignment == 1) {
                transY -= paint.getFontMetricsInt().descent;
            }
            canvas.translate(x, (float)transY);
            Drawable drawable2 = this.getDrawable();
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            drawable2.draw(canvas);
        }
        canvas.restore();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public AztecDynamicImageSpan(@NotNull Context context, @Nullable Drawable imageDrawable) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        Drawable drawable2 = imageDrawable;
        if (drawable2 == null || (drawable2 = drawable2.getBounds()) == null) {
            drawable2 = new Rect(0, 0, 0, 0);
        }
        this.originalBounds = new Rect((Rect)drawable2);
        this.aspectRatio = 1.0;
        WeakReference<Drawable> weakReference = this.drawableRef = new WeakReference<Drawable>(imageDrawable);
        this.computeAspectRatio((Drawable)(weakReference != null ? (Drawable)weakReference.get() : null));
        WeakReference<Drawable> weakReference2 = this.drawableRef;
        Companion.setInitBounds((Drawable)(weakReference2 != null ? (Drawable)weakReference2.get() : null));
    }

    @JvmStatic
    protected static final void setInitBounds(@Nullable Drawable drawable2) {
        Companion.setInitBounds(drawable2);
    }

    @JvmStatic
    protected static final int getWidth(@Nullable Drawable drawable2) {
        return Companion.getWidth(drawable2);
    }

    @JvmStatic
    protected static final int getHeight(@Nullable Drawable drawable2) {
        return Companion.getHeight(drawable2);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0005J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0005\u00a8\u0006\n"}, d2={"Lorg/wordpress/aztec/spans/AztecDynamicImageSpan$Companion;", "", "()V", "getHeight", "", "drawable", "Landroid/graphics/drawable/Drawable;", "getWidth", "setInitBounds", "", "aztec_release"})
    public static final class Companion {
        @JvmStatic
        protected final void setInitBounds(@Nullable Drawable drawable2) {
            block0: {
                Drawable drawable3;
                Drawable it;
                Drawable drawable4 = drawable2;
                if (drawable4 == null || !(it = (drawable3 = drawable4)).getBounds().isEmpty() || it.getIntrinsicWidth() <= -1 && it.getIntrinsicHeight() <= -1) break block0;
                it.setBounds(0, 0, it.getIntrinsicWidth(), it.getIntrinsicHeight());
            }
        }

        @JvmStatic
        protected final int getWidth(@Nullable Drawable drawable2) {
            Drawable drawable3 = drawable2;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicWidth() < 0) {
                    return it.getBounds().width();
                }
                return it.getIntrinsicWidth();
            }
            return 0;
        }

        @JvmStatic
        protected final int getHeight(@Nullable Drawable drawable2) {
            Drawable drawable3 = drawable2;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicHeight() < 0) {
                    return it.getBounds().height();
                }
                return it.getIntrinsicHeight();
            }
            return 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

