/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.R;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecHorizontalRuleSpan;
import org.wordpress.aztec.spans.AztecImageSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecPreformatSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecStrikethroughSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.AztecVideoSpan;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/wordpress/aztec/AztecTagHandler;", "Lorg/wordpress/aztec/Html$TagHandler;", "()V", "order", "", "createImageSpan", "Lorg/wordpress/aztec/spans/AztecMediaSpan;", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "context", "Landroid/content/Context;", "createVideoSpan", "nestingLevel", "end", "", "output", "Landroid/text/Editable;", "kind", "Ljava/lang/Class;", "endHidden", "handleElement", "opening", "", "span", "", "handleTag", "tag", "", "Lorg/xml/sax/Attributes;", "start", "mark", "Companion", "aztec_release"})
public final class AztecTagHandler
implements Html.TagHandler {
    private int order;
    private static final String LIST_LI = "li";
    private static final String LIST_UL = "ul";
    private static final String LIST_OL = "ol";
    private static final String STRIKETHROUGH_S = "s";
    private static final String STRIKETHROUGH_STRIKE = "strike";
    private static final String STRIKETHROUGH_DEL = "del";
    private static final String DIV = "div";
    private static final String SPAN = "span";
    private static final String BLOCKQUOTE = "blockquote";
    private static final String PARAGRAPH = "p";
    private static final String PREFORMAT = "pre";
    private static final String IMAGE = "img";
    private static final String VIDEO = "video";
    private static final String LINE = "hr";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handleTag(boolean opening, @NotNull String tag, @NotNull Editable output, @NotNull Context context, @NotNull Attributes attributes, int nestingLevel) {
        AztecMediaSpan mediaSpan;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String string = tag;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getLIST_LI())) {
            this.handleElement(output, opening, new AztecListItemSpan(nestingLevel, new AztecAttributes(attributes)));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getSTRIKETHROUGH_S()) || Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getSTRIKETHROUGH_STRIKE()) || Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getSTRIKETHROUGH_DEL())) {
            this.handleElement(output, opening, new AztecStrikethroughSpan(tag, new AztecAttributes(attributes)));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getDIV()) || Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getSPAN())) {
            if (opening) {
                int n = this.order;
                this.order = n + 1;
                this.start(output, (Object)new HiddenHtmlSpan(tag, new AztecAttributes(attributes), n));
            } else {
                int n = this.order;
                this.order = n + 1;
                this.endHidden(output, n);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getLIST_UL())) {
            this.handleElement(output, opening, new AztecUnorderedListSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getLIST_OL())) {
            this.handleElement(output, opening, new AztecOrderedListSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getBLOCKQUOTE())) {
            this.handleElement(output, opening, new AztecQuoteSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getIMAGE())) {
            if (opening) {
                mediaSpan = this.createImageSpan(new AztecAttributes(attributes), context);
                this.start(output, mediaSpan);
                this.start(output, (Object)new AztecMediaClickableSpan(mediaSpan));
                output.append(Constants.INSTANCE.getIMG_CHAR());
            } else {
                this.end(output, AztecImageSpan.class);
                this.end(output, AztecMediaClickableSpan.class);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getVIDEO())) {
            if (opening) {
                mediaSpan = this.createVideoSpan(new AztecAttributes(attributes), context, nestingLevel);
                this.start(output, mediaSpan);
                this.start(output, (Object)new AztecMediaClickableSpan(mediaSpan));
                output.append(Constants.INSTANCE.getIMG_CHAR());
            } else {
                this.end(output, AztecVideoSpan.class);
                this.end(output, AztecMediaClickableSpan.class);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getPARAGRAPH())) {
            this.handleElement(output, opening, new ParagraphSpan(nestingLevel, new AztecAttributes(attributes)));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getLINE())) {
            if (opening) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.img_hr);
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026ntext, R.drawable.img_hr)");
                this.start(output, new AztecHorizontalRuleSpan(context, drawable2, nestingLevel, null, null, 24, null));
                output.append(Constants.INSTANCE.getMAGIC_CHAR());
            } else {
                this.end(output, AztecHorizontalRuleSpan.class);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AztecTagHandler.Companion.getPREFORMAT())) {
            this.handleElement(output, opening, new AztecPreformatSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            this.handleElement(output, opening, new AztecHeadingSpan(nestingLevel, tag, new AztecAttributes(attributes), null, 8, null));
            return true;
        }
        return false;
    }

    private final AztecMediaSpan createImageSpan(AztecAttributes attributes, Context context) {
        TypedArray styles = context.obtainStyledAttributes(R.styleable.AztecText);
        Drawable loadingDrawable = ContextCompat.getDrawable((Context)context, (int)styles.getResourceId(R.styleable.AztecText_drawableLoading, R.drawable.ic_image_loading));
        styles.recycle();
        return new AztecImageSpan(context, loadingDrawable, attributes, null, null, 24, null);
    }

    private final AztecMediaSpan createVideoSpan(AztecAttributes attributes, Context context, int nestingLevel) {
        TypedArray styles = context.obtainStyledAttributes(R.styleable.AztecText);
        Drawable loadingDrawable = ContextCompat.getDrawable((Context)context, (int)styles.getResourceId(R.styleable.AztecText_drawableLoading, R.drawable.ic_image_loading));
        styles.recycle();
        return new AztecVideoSpan(context, loadingDrawable, nestingLevel, attributes, null, null, 48, null);
    }

    private final void handleElement(Editable output, boolean opening, Object span) {
        if (opening) {
            this.start(output, span);
        } else {
            this.end(output, span.getClass());
        }
    }

    private final void start(Editable output, Object mark) {
        output.setSpan(mark, output.length(), output.length(), 17);
    }

    private final void endHidden(Editable output, int order) {
        HiddenHtmlSpan last = AztecTagHandler.Companion.getLastOpenHidden(output);
        if (last != null) {
            last.close(order);
            int start = output.getSpanStart((Object)last);
            int end = output.length();
            if (start != end) {
                output.setSpan((Object)last, start, end, 33);
            } else {
                output.setSpan((Object)last, start, end, 17);
            }
        }
    }

    private final void end(Editable output, Class<?> kind) {
        int end;
        Object last = AztecTagHandler.Companion.getLast(output, kind);
        int start = output.getSpanStart(last);
        if (start != (end = output.length())) {
            output.setSpan(last, start, end, 33);
        } else if (start == end && IAztecBlockSpan.class.isAssignableFrom(kind)) {
            output.append(Constants.INSTANCE.getZWJ_CHAR());
            output.setSpan(last, start, output.length(), 33);
        }
    }

    static {
        LIST_LI = LIST_LI;
        LIST_UL = LIST_UL;
        LIST_OL = LIST_OL;
        STRIKETHROUGH_S = STRIKETHROUGH_S;
        STRIKETHROUGH_STRIKE = STRIKETHROUGH_STRIKE;
        STRIKETHROUGH_DEL = STRIKETHROUGH_DEL;
        DIV = DIV;
        SPAN = SPAN;
        BLOCKQUOTE = BLOCKQUOTE;
        PARAGRAPH = PARAGRAPH;
        PREFORMAT = PREFORMAT;
        IMAGE = IMAGE;
        VIDEO = VIDEO;
        LINE = LINE;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006\u00a8\u0006("}, d2={"Lorg/wordpress/aztec/AztecTagHandler$Companion;", "", "()V", "BLOCKQUOTE", "", "getBLOCKQUOTE", "()Ljava/lang/String;", "DIV", "getDIV", "IMAGE", "getIMAGE", "LINE", "getLINE", "LIST_LI", "getLIST_LI", "LIST_OL", "getLIST_OL", "LIST_UL", "getLIST_UL", "PARAGRAPH", "getPARAGRAPH", "PREFORMAT", "getPREFORMAT", "SPAN", "getSPAN", "STRIKETHROUGH_DEL", "getSTRIKETHROUGH_DEL", "STRIKETHROUGH_S", "getSTRIKETHROUGH_S", "STRIKETHROUGH_STRIKE", "getSTRIKETHROUGH_STRIKE", "VIDEO", "getVIDEO", "getLast", "text", "Landroid/text/Editable;", "kind", "Ljava/lang/Class;", "getLastOpenHidden", "Lorg/wordpress/aztec/spans/HiddenHtmlSpan;", "aztec_release"})
    public static final class Companion {
        private final String getLIST_LI() {
            return LIST_LI;
        }

        private final String getLIST_UL() {
            return LIST_UL;
        }

        private final String getLIST_OL() {
            return LIST_OL;
        }

        private final String getSTRIKETHROUGH_S() {
            return STRIKETHROUGH_S;
        }

        private final String getSTRIKETHROUGH_STRIKE() {
            return STRIKETHROUGH_STRIKE;
        }

        private final String getSTRIKETHROUGH_DEL() {
            return STRIKETHROUGH_DEL;
        }

        private final String getDIV() {
            return DIV;
        }

        private final String getSPAN() {
            return SPAN;
        }

        private final String getBLOCKQUOTE() {
            return BLOCKQUOTE;
        }

        private final String getPARAGRAPH() {
            return PARAGRAPH;
        }

        private final String getPREFORMAT() {
            return PREFORMAT;
        }

        private final String getIMAGE() {
            return IMAGE;
        }

        private final String getVIDEO() {
            return VIDEO;
        }

        private final String getLINE() {
            return LINE;
        }

        /*
         * WARNING - void declaration
         */
        private final Object getLast(Editable text, Class<?> kind) {
            Object object;
            Object v0;
            Object object2;
            Object[] spans;
            block4: {
                void $receiver$iv;
                spans = text.getSpans(0, text.length(), kind);
                object2 = spans;
                if (((Object[])object2).length == 0) {
                    return null;
                }
                object2 = (Iterable)RangesKt.downTo((int)spans.length, (int)1);
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!(text.getSpanFlags(spans[it - 1]) == 17)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Integer n = v0;
            if (n != null) {
                object2 = n;
                int it = ((Number)object2).intValue();
                object = spans[it - 1];
            } else {
                object = null;
            }
            return object;
        }

        /*
         * Unable to fully structure code
         */
        private final HiddenHtmlSpan getLastOpenHidden(Editable text) {
            block6: {
                spans = (HiddenHtmlSpan[])text.getSpans(0, text.length(), HiddenHtmlSpan.class);
                var3_3 = (Object[])spans;
                if (var3_3.length == 0) {
                    return null;
                }
                $receiver$iv = (Object[])spans;
                if ($receiver$iv.length > 1) {
                    var4_4 = $receiver$iv;
                    var5_6 = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            HiddenHtmlSpan it = (HiddenHtmlSpan)((Object)b);
                            Comparable comparable = Integer.valueOf(it.getStartOrder());
                            it = (HiddenHtmlSpan)((Object)a);
                            Comparable comparable2 = comparable;
                            Integer n = it.getStartOrder();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    };
                    ArraysKt.sortWith((Object[])var4_4, (Comparator)var5_6);
                }
                $receiver$iv = (Object[])spans;
                for (var4_5 = 0; var4_5 < $receiver$iv.length; ++var4_5) {
                    element$iv = $receiver$iv[var4_5];
                    it = (HiddenHtmlSpan)element$iv;
                    if (text.getSpanFlags((Object)it) != 17) ** GOTO lbl-1000
                    v0 = it;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.HiddenHtmlSpan");
                    }
                    if (!v0.isClosed()) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            return (HiddenHtmlSpan)v2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

