/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecTagHandler;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecCommentSpan;
import org.wordpress.aztec.spans.AztecCursorSpan;
import org.wordpress.aztec.spans.AztecFullWidthImageSpan;
import org.wordpress.aztec.spans.AztecHorizontalRuleSpan;
import org.wordpress.aztec.spans.AztecInlineSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecNestable;
import org.wordpress.aztec.spans.AztecSurroundedWithNewlines;
import org.wordpress.aztec.spans.AztecVisualLinebreak;
import org.wordpress.aztec.spans.CommentSpan;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.UnknownHtmlSpan;
import org.wordpress.aztec.util.SpanWrapper;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001fH\u0002J$\u0010\"\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0002J4\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020\u001d2\u0006\u0010!\u001a\u0002052\u0006\u00106\u001a\u00020\u0005H\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u0010!\u001a\u000205H\u0002J,\u00108\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00052\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u00109\u001a\u00020\u00062\u0006\u0010!\u001a\u00020)H\u0002J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020)H\u0002J\u000e\u0010;\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020+H\u0002J\u0018\u0010>\u001a\u00020+2\u0006\u0010!\u001a\u00020)2\b\b\u0002\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020)H\u0002JL\u0010B\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020)2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u00020F2\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010H2\u0006\u0010J\u001a\u00020\u0005H\u0002J<\u0010K\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020)2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010HH\u0002J\u001c\u0010L\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020)H\u0002JD\u0010L\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020)2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u000e\u0010M\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010H2\u0006\u0010J\u001a\u00020\u0005H\u0002JD\u0010N\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020)2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u00052\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020I\u0018\u00010HH\u0002J4\u0010P\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020&2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u0005H\u0002J4\u0010Q\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020)2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u0006\u0010R\u001a\u00020SH\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR\u001a\u0010\u0019\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000f\u00a8\u0006T"}, d2={"Lorg/wordpress/aztec/AztecParser;", "", "()V", "closeMap", "Ljava/util/TreeMap;", "", "Lorg/wordpress/aztec/spans/HiddenHtmlSpan;", "getCloseMap$aztec_release", "()Ljava/util/TreeMap;", "setCloseMap$aztec_release", "(Ljava/util/TreeMap;)V", "hiddenIndex", "getHiddenIndex$aztec_release", "()I", "setHiddenIndex$aztec_release", "(I)V", "hiddenSpans", "", "getHiddenSpans$aztec_release", "()[I", "setHiddenSpans$aztec_release", "([I)V", "openMap", "getOpenMap$aztec_release", "setOpenMap$aztec_release", "spanCursorPosition", "getSpanCursorPosition$aztec_release", "setSpanCursorPosition$aztec_release", "addVisualNewlinesToBlockElements", "", "spanned", "Landroid/text/Editable;", "cleanupZWJ", "text", "consumeCursorIfInInput", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "position", "fromHtml", "Landroid/text/Spanned;", "source", "", "onImageTappedListener", "Lorg/wordpress/aztec/AztecText$OnImageTappedListener;", "onVideoTappedListener", "Lorg/wordpress/aztec/AztecText$OnVideoTappedListener;", "onUnknownHtmlClickListener", "Lorg/wordpress/aztec/spans/UnknownHtmlSpan$OnUnknownHtmlClickListener;", "context", "Landroid/content/Context;", "markBlockElementLineBreak", "Landroid/text/Spannable;", "startPos", "markBlockElementsAsParagraphs", "parseHiddenSpans", "span", "resetHiddenTagParser", "syncVisualNewlinesOfBlockElements", "tidy", "html", "toHtml", "withCursor", "", "unbiasNestingLevel", "withinBlock", "start", "end", "blockSpan", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "parents", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/spans/AztecNestable;", "nestingLevel", "withinContent", "withinHtml", "grandParents", "withinParagraph", "nl", "withinStyle", "withinUnknown", "unknownHtmlSpan", "Lorg/wordpress/aztec/spans/UnknownHtmlSpan;", "aztec_release"})
public final class AztecParser {
    private int hiddenIndex;
    @NotNull
    private TreeMap<Integer, HiddenHtmlSpan> closeMap = new TreeMap();
    @NotNull
    private TreeMap<Integer, HiddenHtmlSpan> openMap = new TreeMap();
    @NotNull
    private int[] hiddenSpans = new int[0];
    private int spanCursorPosition = -1;

    public final int getHiddenIndex$aztec_release() {
        return this.hiddenIndex;
    }

    public final void setHiddenIndex$aztec_release(int n) {
        this.hiddenIndex = n;
    }

    @NotNull
    public final TreeMap<Integer, HiddenHtmlSpan> getCloseMap$aztec_release() {
        return this.closeMap;
    }

    public final void setCloseMap$aztec_release(@NotNull TreeMap<Integer, HiddenHtmlSpan> treeMap) {
        Intrinsics.checkParameterIsNotNull(treeMap, (String)"<set-?>");
        this.closeMap = treeMap;
    }

    @NotNull
    public final TreeMap<Integer, HiddenHtmlSpan> getOpenMap$aztec_release() {
        return this.openMap;
    }

    public final void setOpenMap$aztec_release(@NotNull TreeMap<Integer, HiddenHtmlSpan> treeMap) {
        Intrinsics.checkParameterIsNotNull(treeMap, (String)"<set-?>");
        this.openMap = treeMap;
    }

    @NotNull
    public final int[] getHiddenSpans$aztec_release() {
        return this.hiddenSpans;
    }

    public final void setHiddenSpans$aztec_release(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.hiddenSpans = nArray;
    }

    public final int getSpanCursorPosition$aztec_release() {
        return this.spanCursorPosition;
    }

    public final void setSpanCursorPosition$aztec_release(int n) {
        this.spanCursorPosition = n;
    }

    @NotNull
    public final Spanned fromHtml(@NotNull String source, @Nullable AztecText.OnImageTappedListener onImageTappedListener, @Nullable AztecText.OnVideoTappedListener onVideoTappedListener, @Nullable UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String tidySource = this.tidy(source);
        SpannableStringBuilder spanned = new SpannableStringBuilder((CharSequence)Html.fromHtml(tidySource, new AztecTagHandler(), onUnknownHtmlClickListener, context));
        this.addVisualNewlinesToBlockElements((Editable)spanned);
        this.markBlockElementsAsParagraphs((Spannable)spanned);
        this.cleanupZWJ((Editable)spanned);
        this.unbiasNestingLevel((Spanned)spanned);
        return (Spanned)spanned;
    }

    @NotNull
    public final String toHtml(@NotNull Spanned text, boolean withCursor) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StringBuilder out = new StringBuilder();
        SpannableStringBuilder data = new SpannableStringBuilder((CharSequence)text).append(Constants.INSTANCE.getZWJ_CHAR());
        Object[] objectArray = data.getSpans(data.length() - 1, data.length(), HiddenHtmlSpan.class);
        if (objectArray.length == 0 && (objectArray = data.getSpans(data.length() - 1, data.length(), AztecListSpan.class)).length == 0) {
            data.delete(data.length() - 1, data.length());
        }
        SpannableStringBuilder spannableStringBuilder = data;
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder, (String)"data");
        this.resetHiddenTagParser((Spanned)spannableStringBuilder);
        HiddenHtmlSpan[] hidden = (HiddenHtmlSpan[])data.getSpans(0, data.length(), HiddenHtmlSpan.class);
        this.hiddenSpans = new int[((Object[])hidden).length * 2];
        Object[] $receiver$iv = (Object[])hidden;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            int end;
            Object element$iv = $receiver$iv[i];
            HiddenHtmlSpan it = (HiddenHtmlSpan)((Object)element$iv);
            int n = this.hiddenIndex;
            this.hiddenIndex = n + 1;
            this.hiddenSpans[n] = it.getStartOrder();
            n = this.hiddenIndex;
            this.hiddenIndex = n + 1;
            this.hiddenSpans[n] = it.getEndOrder();
            int start = data.getSpanStart((Object)it);
            if (start != (end = data.getSpanEnd((Object)it)) || data.charAt(start) != '\n') continue;
            data.insert(start, (CharSequence)("" + Constants.INSTANCE.getMAGIC_CHAR()));
        }
        this.hiddenIndex = 0;
        Arrays.sort(this.hiddenSpans);
        if (withCursor) {
            AztecCursorSpan cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])data.getSpans(0, data.length(), AztecCursorSpan.class));
            if (cursorSpan != null) {
                this.spanCursorPosition = data.getSpanStart((Object)cursorSpan);
            }
        } else {
            this.spanCursorPosition = -1;
        }
        SpannableStringBuilder spannableStringBuilder2 = data;
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder2, (String)"data");
        this.withinHtml(out, (Spanned)spannableStringBuilder2);
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return this.tidy(string);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String toHtml$default(AztecParser aztecParser, Spanned spanned, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return aztecParser.toHtml(spanned, bl);
    }

    private final void markBlockElementLineBreak(Spannable text, int startPos) {
        text.setSpan((Object)new AztecVisualLinebreak(), startPos, startPos, 17);
    }

    /*
     * WARNING - void declaration
     */
    public final void addVisualNewlinesToBlockElements(@NotNull Editable spanned) {
        AztecSurroundedWithNewlines it;
        Object element$iv;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        Object[] $receiver$iv = spanned.getSpans(0, spanned.length(), AztecSurroundedWithNewlines.class);
        for (n = 0; n < $receiver$iv.length; ++n) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            Iterable this_$iv;
            void start$iv;
            void spannable$iv;
            int parentStart;
            SpanWrapper<? extends AztecNestable> parent;
            element$iv = $receiver$iv[n];
            it = (AztecSurroundedWithNewlines)element$iv;
            SpanWrapper<? extends AztecNestable> spanWrapper = parent = AztecNestable.Companion.getParent((Spannable)spanned, new SpanWrapper<AztecSurroundedWithNewlines>((Spannable)spanned, it));
            boolean repelling = (spanWrapper != null ? spanWrapper.getSpan() : null) instanceof AztecListItemSpan && it instanceof AztecListSpan;
            int spanStart = spanned.getSpanStart((Object)it);
            if (!repelling && spanStart < 1) continue;
            SpanWrapper<? extends AztecNestable> spanWrapper2 = parent;
            int n2 = parentStart = spanWrapper2 != null ? spanWrapper2.getStart() : 0;
            if (!repelling && spanStart == parentStart || !repelling && spanned.charAt(spanStart - 1) == '\n') continue;
            spanned.insert(spanStart, (CharSequence)"\n");
            SpanWrapper.Companion companion = SpanWrapper.Companion;
            Spannable spannable = (Spannable)spanned;
            int n3 = spanStart + 1;
            int end$iv = spanStart + 2;
            Object[] objectArray = spannable$iv.getSpans((int)start$iv, end$iv, AztecNestable.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"spannable.getSpans(start, end, T::class.java)");
            this_$iv = ((SpanWrapper.Companion)((Object)this_$iv)).getSpans((Spannable)spannable$iv, objectArray);
            spannable$iv = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                SpanWrapper parent2 = (SpanWrapper)element$iv$iv;
                if (!(((AztecNestable)parent2.getSpan()).getNestingLevel() < it.getNestingLevel() && parent2.getStart() == spanStart + 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv;
            for (Object element$iv2 : $receiver$iv2) {
                SpanWrapper parent3;
                SpanWrapper spanWrapper3 = parent3 = (SpanWrapper)element$iv2;
                int n4 = spanWrapper3.getStart();
                spanWrapper3.setStart(n4 + -1);
            }
            this.markBlockElementLineBreak((Spannable)spanned, spanStart);
        }
        $receiver$iv = spanned.getSpans(0, spanned.length(), AztecSurroundedWithNewlines.class);
        for (n = 0; n < $receiver$iv.length; ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            element$iv = $receiver$iv[n];
            it = (AztecSurroundedWithNewlines)element$iv;
            int spanEnd = spanned.getSpanEnd((Object)it);
            if (spanEnd == spanned.length()) continue;
            if (spanned.charAt(spanEnd) == '\n' && !((objectArray2 = (objectArray = spanned.getSpans(spanEnd, spanEnd, AztecVisualLinebreak.class))).length == 0)) {
                if (!(it instanceof AztecBlockSpan)) continue;
                spanned.setSpan((Object)it, spanned.getSpanStart((Object)it), spanEnd + 1, spanned.getSpanFlags((Object)it));
                continue;
            }
            spanned.insert(spanEnd, (CharSequence)"\n");
            if (it instanceof AztecBlockSpan) {
                spanned.setSpan((Object)it, spanned.getSpanStart((Object)it), spanEnd + 1, spanned.getSpanFlags((Object)it));
            }
            this.markBlockElementLineBreak((Spannable)spanned, spanEnd);
        }
    }

    public final void syncVisualNewlinesOfBlockElements(@NotNull Editable spanned) {
        Object it;
        Object element$iv;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        Object[] $receiver$iv = spanned.getSpans(0, spanned.length(), AztecVisualLinebreak.class);
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (AztecVisualLinebreak)element$iv;
            spanned.removeSpan(it);
        }
        $receiver$iv = spanned.getSpans(0, spanned.length(), AztecSurroundedWithNewlines.class);
        for (n = 0; n < $receiver$iv.length; ++n) {
            int newlineExpected;
            element$iv = $receiver$iv[n];
            it = (AztecSurroundedWithNewlines)element$iv;
            int spanEnd = spanned.getSpanEnd(it);
            int n2 = newlineExpected = it instanceof AztecBlockSpan ? spanEnd - 1 : spanEnd;
            if (spanEnd == spanned.length() || spanned.charAt(newlineExpected) != '\n') continue;
            this.markBlockElementLineBreak((Spannable)spanned, newlineExpected);
        }
        $receiver$iv = spanned.getSpans(0, spanned.length(), AztecSurroundedWithNewlines.class);
        for (n = 0; n < $receiver$iv.length; ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            boolean bl;
            int spanStart;
            boolean repelling;
            block4: {
                SpanWrapper<? extends AztecNestable> parent;
                element$iv = $receiver$iv[n];
                it = (AztecSurroundedWithNewlines)element$iv;
                SpanWrapper<? extends AztecNestable> spanWrapper = parent = AztecNestable.Companion.getParent((Spannable)spanned, new SpanWrapper<Object>((Spannable)spanned, it));
                repelling = (spanWrapper != null ? spanWrapper.getSpan() : null) instanceof AztecListItemSpan && it instanceof AztecListSpan;
                spanStart = spanned.getSpanStart(it);
                if (!repelling && spanStart < 1 || !repelling && spanStart < 2 || spanned.charAt(spanStart - 1) != '\n') continue;
                Object[] $receiver$iv2 = spanned.getSpans(spanStart, spanStart, AztecSurroundedWithNewlines.class);
                for (int i = 0; i < $receiver$iv2.length; ++i) {
                    Object element$iv2 = $receiver$iv2[i];
                    AztecSurroundedWithNewlines before = (AztecSurroundedWithNewlines)element$iv2;
                    if (!(spanned.getSpanEnd((Object)before) == spanStart)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl || !repelling && spanned.charAt(spanStart - 2) == '\n' || !((objectArray2 = (objectArray = spanned.getSpans(spanStart - 1, spanStart - 1, AztecVisualLinebreak.class))).length == 0)) continue;
            this.markBlockElementLineBreak((Spannable)spanned, spanStart - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markBlockElementsAsParagraphs(Spannable text) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = SpanWrapper.Companion.getSpans(text, 0, text.length(), AztecBlockSpan.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SpanWrapper spanWrapper = (SpanWrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            it.setFlags(51);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void cleanupZWJ(Editable text) {
        int lastIndex = text.length();
        do {
            if ((lastIndex = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)text), (char)Constants.INSTANCE.getZWJ_CHAR(), (int)lastIndex, (boolean)false, (int)4, null)) == text.length() - 1) {
                return;
            }
            if (lastIndex <= -1) continue;
            text.delete(lastIndex, lastIndex + 1);
        } while (lastIndex > -1);
    }

    private final void unbiasNestingLevel(Spanned text) {
        Object[] $receiver$iv = text.getSpans(0, text.length(), AztecNestable.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            AztecNestable it;
            Object element$iv = $receiver$iv[i];
            AztecNestable aztecNestable = it = (AztecNestable)element$iv;
            aztecNestable.setNestingLevel(aztecNestable.getNestingLevel() - 2);
        }
    }

    private final void resetHiddenTagParser(Spanned text) {
        this.hiddenIndex = 0;
        this.closeMap.clear();
        this.openMap.clear();
        HiddenHtmlSpan[] spans = (HiddenHtmlSpan[])text.getSpans(0, text.length(), HiddenHtmlSpan.class);
        Object[] $receiver$iv = (Object[])spans;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            HiddenHtmlSpan p1 = (HiddenHtmlSpan)((Object)element$iv);
            p1.reset();
        }
    }

    private final void withinHtml(StringBuilder out, Spanned text) {
        this.withinHtml(out, text, 0, text.length(), null, -1);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinHtml(StringBuilder out, Spanned text, int start, int end, ArrayList<AztecNestable> grandParents, int nestingLevel) {
        int next;
        int i = start;
        do {
            ArrayList<AztecNestable> parents;
            Object object;
            AztecNestable aztecNestable;
            block10: {
                AztecNestable[] paragraphs;
                void $receiver$iv$iv;
                Collection $receiver$iv;
                Object[] objectArray = text.getSpans(i, end, AztecNestable.class);
                aztecNestable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                    void element$iv$iv = $receiver$iv$iv[j];
                    AztecNestable it = (AztecNestable)element$iv$iv;
                    if (!(!(it instanceof AztecFullWidthImageSpan))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Collection thisCollection$iv = $receiver$iv;
                if (thisCollection$iv.toArray(new AztecNestable[thisCollection$iv.size()]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ArraysKt.sortWith((Object[])paragraphs, (Comparator)new Comparator<AztecNestable>(text){
                    final /* synthetic */ Spanned $text;

                    public final int compare(AztecNestable a, AztecNestable b) {
                        int startComparison = Intrinsics.compare((int)this.$text.getSpanStart((Object)a), (int)this.$text.getSpanStart((Object)b));
                        if (startComparison == 0) {
                            int nestingComparison = Intrinsics.compare((int)a.getNestingLevel(), (int)b.getNestingLevel());
                            if (nestingComparison == 0) {
                                return Intrinsics.compare((int)this.$text.getSpanEnd((Object)a), (int)this.$text.getSpanEnd((Object)b));
                            }
                            return nestingComparison;
                        }
                        return startComparison;
                    }
                    {
                        this.$text = spanned;
                    }
                });
                Object[] $receiver$iv2 = paragraphs;
                for (int j = 0; j < $receiver$iv2.length; ++j) {
                    Object element$iv = $receiver$iv2[j];
                    AztecNestable it = (AztecNestable)element$iv;
                    if (!(it.getNestingLevel() > nestingLevel)) continue;
                    object = element$iv;
                    break block10;
                }
                object = null;
            }
            AztecNestable paragraph = (AztecNestable)object;
            if (paragraph == null) {
                next = end;
                parents = grandParents;
            } else if (text.getSpanStart((Object)paragraph) > i) {
                next = text.getSpanStart((Object)paragraph);
                paragraph = null;
                parents = grandParents;
            } else {
                next = text.getSpanEnd((Object)paragraph);
                ArrayList<AztecNestable> arrayList = grandParents;
                parents = new ArrayList(arrayList != null ? (Collection)arrayList : (Collection)new ArrayList());
                parents.add(paragraph);
            }
            aztecNestable = paragraph;
            if (aztecNestable instanceof AztecBlockSpan) {
                this.withinBlock(out, text, i, next, (AztecBlockSpan)paragraph, parents, paragraph.getNestingLevel());
                continue;
            }
            if (aztecNestable instanceof UnknownHtmlSpan) {
                this.withinUnknown(out, text, i, next, (UnknownHtmlSpan)paragraph);
                continue;
            }
            this.withinContent(out, text, i, next, parents);
        } while ((i = next) < end);
        this.consumeCursorIfInInput(out, (CharSequence)text, text.length());
    }

    private final void withinUnknown(StringBuilder out, Spanned text, int start, int end, UnknownHtmlSpan unknownHtmlSpan) {
        this.consumeCursorIfInInput(out, (CharSequence)text, start);
        out.append((CharSequence)unknownHtmlSpan.getRawHtml());
        this.consumeCursorIfInInput(out, (CharSequence)text, end);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinBlock(StringBuilder out, Spanned text, int start, int end, AztecBlockSpan blockSpan, ArrayList<AztecNestable> parents, int nestingLevel) {
        Object object;
        out.append("<" + blockSpan.getStartTag() + ">");
        this.withinHtml(out, text, start, end, parents, nestingLevel);
        out.append("</" + blockSpan.getEndTag() + ">");
        if (end > 0 && text.charAt(end - 1) == Constants.INSTANCE.getNEWLINE() && ((Object[])(object = text.getSpans(end - 1, end, AztecVisualLinebreak.class))).length == 0) {
            boolean bl;
            block5: {
                ArrayList<AztecNestable> arrayList = parents;
                if (arrayList != null) {
                    void $receiver$iv;
                    object = arrayList;
                    for (Object element$iv : $receiver$iv) {
                        AztecNestable it = (AztecNestable)element$iv;
                        if (!(Intrinsics.areEqual((Object)it, (Object)blockSpan) ^ true && text.getSpanEnd((Object)it) == end)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                out.append("<br>");
            }
        }
    }

    private final void withinContent(StringBuilder out, Spanned text, int start, int end, ArrayList<AztecNestable> parents) {
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)((CharSequence)text), (char)'\n', (int)i, (int)end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                boolean isVisualLinebreak;
                Object[] objectArray = text.getSpans(next, next, AztecVisualLinebreak.class);
                Object[] objectArray2 = objectArray;
                boolean bl = isVisualLinebreak = !(objectArray2.length == 0);
                if (!isVisualLinebreak) {
                    ++nl;
                }
                ++next;
            }
            this.withinParagraph(out, text, i, next - nl, nl, parents);
            i = next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void withinParagraph(StringBuilder out, Spanned text, int start, int end, int nl, ArrayList<AztecNestable> parents) {
        int spans2;
        int n;
        int i = start;
        while (i < end || start == end) {
            int j;
            n = 0;
            int next = text.nextSpanTransition(i, end, CharacterStyle.class);
            CharacterStyle[] spans2 = (CharacterStyle[])text.getSpans(i, next, CharacterStyle.class);
            int n2 = spans2.length - 1;
            if (n <= n2) {
                while (true) {
                    CharacterStyle span;
                    if ((span = spans2[j]) instanceof AztecInlineSpan) {
                        out.append("<" + ((AztecInlineSpan)span).getStartTag() + ">");
                    }
                    if (span instanceof CommentSpan) {
                        out.append("<!--");
                    }
                    if (span instanceof AztecCommentSpan) {
                        out.append("<!--");
                        out.append(((AztecCommentSpan)span).getCommentText());
                        i = next;
                    }
                    if (span instanceof AztecHorizontalRuleSpan) {
                        out.append("<" + ((AztecHorizontalRuleSpan)span).getStartTag() + ">");
                        i = next;
                    }
                    if (span instanceof AztecMediaSpan) {
                        out.append(((AztecMediaSpan)span).getHtml());
                        i = next;
                    }
                    if (span instanceof HiddenHtmlSpan) {
                        this.parseHiddenSpans(i, out, (HiddenHtmlSpan)span, text);
                    }
                    if (j == n2) break;
                    ++j;
                }
            }
            this.withinStyle(out, (CharSequence)text, i, next, nl);
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])spans2)));
            j = intProgression.getFirst();
            n2 = intProgression.getLast();
            int span = intProgression.getStep();
            int n3 = j;
            int n4 = n2;
            if (span > 0 ? n3 <= n4 : n3 >= n4) {
                while (true) {
                    CharacterStyle span2;
                    if ((span2 = spans2[j]) instanceof AztecInlineSpan) {
                        out.append("</" + ((AztecInlineSpan)span2).getEndTag() + ">");
                    }
                    if (span2 instanceof AztecCommentSpan || span2 instanceof CommentSpan) {
                        out.append("-->");
                    }
                    if (span2 instanceof HiddenHtmlSpan) {
                        this.parseHiddenSpans(next, out, (HiddenHtmlSpan)span2, text);
                    }
                    if (j == n2) break;
                    j += span;
                }
            }
            if (start == end) break;
            i = next;
        }
        if ((spans2 = 0) <= (n = nl - 1)) {
            while (true) {
                boolean parentSharesEnd;
                void z;
                block20: {
                    boolean bl;
                    ArrayList<AztecNestable> arrayList = parents;
                    if (arrayList != null) {
                        Iterable $receiver$iv = arrayList;
                        for (Object element$iv : $receiver$iv) {
                            AztecNestable it = (AztecNestable)element$iv;
                            if (!(text.getSpanEnd((Object)it) == end + 1 + z)) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    } else {
                        bl = parentSharesEnd = false;
                    }
                }
                if (!parentSharesEnd) {
                    out.append("<br>");
                    this.consumeCursorIfInInput(out, (CharSequence)text, end + z);
                }
                if (z == n) break;
                ++z;
            }
        }
    }

    private final void parseHiddenSpans(int position, StringBuilder out, HiddenHtmlSpan span, Spanned text) {
        int last;
        this.closeMap.put(span.getEndOrder(), span);
        this.openMap.put(span.getStartOrder(), span);
        do {
            HiddenHtmlSpan nextSpan;
            Map map;
            last = this.hiddenIndex;
            if (this.hiddenIndex >= this.hiddenSpans.length) break;
            int nextSpanIndex = this.hiddenSpans[this.hiddenIndex];
            Map map2 = this.openMap;
            Integer n = nextSpanIndex;
            Map map3 = map = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map3.containsKey(n)) {
                if (this.openMap.get(nextSpanIndex) == null) {
                    Intrinsics.throwNpe();
                }
                if (!nextSpan.isOpened() && text.getSpanStart((Object)nextSpan) == position) {
                    out.append((CharSequence)nextSpan.getStartTag());
                    nextSpan.open();
                    int n2 = this.hiddenIndex;
                    this.hiddenIndex = n2 + 1;
                }
            }
            if (!this.closeMap.containsKey(nextSpanIndex)) continue;
            if (this.closeMap.get(nextSpanIndex) == null) {
                Intrinsics.throwNpe();
            }
            if (nextSpan.isParsed() || text.getSpanEnd((Object)nextSpan) != position) continue;
            out.append((CharSequence)nextSpan.getEndTag());
            nextSpan.parse();
            int n3 = this.hiddenIndex;
            this.hiddenIndex = n3 + 1;
        } while (last != this.hiddenIndex);
    }

    private final void withinStyle(StringBuilder out, CharSequence text, int start, int end, int nl) {
        int i = start;
        while (i < end) {
            char c = text.charAt(i);
            if (c == Constants.INSTANCE.getZWJ_CHAR()) {
                ++i;
                continue;
            }
            this.consumeCursorIfInInput(out, text, i);
            if (c == '<') {
                out.append("&lt;");
            } else if (c == '>') {
                out.append("&gt;");
            } else if (c == '&') {
                out.append("&amp;");
            } else if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c < '\udc00' && i + 1 < end && (d = text.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    ++i;
                    int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                    out.append("&#").append(codepoint).append(";");
                }
            } else if (c > '~' || c < ' ') {
                if (c != '\n') {
                    out.append("&#").append((int)c).append(";");
                }
            } else if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    this.consumeCursorIfInInput(out, text, ++i);
                }
                out.append(' ');
            } else {
                out.append(c);
            }
            ++i;
        }
        if (nl == 0 && text.length() > i && text.charAt(i) == '\n') {
            this.consumeCursorIfInInput(out, text, i);
        }
    }

    private final void consumeCursorIfInInput(StringBuilder out, CharSequence text, int position) {
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
        }
        AztecCursorSpan cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])((SpannableStringBuilder)charSequence).getSpans(position, position, AztecCursorSpan.class));
        if (cursorSpan != null) {
            out.append(AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG());
            ((SpannableStringBuilder)text).removeSpan((Object)cursorSpan);
        }
    }

    private final String tidy(String html) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)html, (String)"&#8203;", (String)"", (boolean)false, (int)4, null), (String)"&#65279;", (String)"", (boolean)false, (int)4, null);
        String string = "(</? ?br>)*((aztec_cursor)?)</blockquote>";
        string = new Regex(string);
        String string2 = "$2</blockquote>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</li>";
        string = new Regex(string);
        string2 = "$2</li>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</p>";
        string = new Regex(string);
        string2 = "$2</p>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</pre>";
        string = new Regex(string);
        string2 = "$2</pre>";
        return string.replace(charSequence, string2);
    }
}

