/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.TextWatcher;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecPreformatSpan;
import org.wordpress.aztec.spans.EndOfParagraphMarker;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J(\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/watchers/EndOfParagraphMarkerAdder;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "verticalParagraphMargin", "", "(Lorg/wordpress/aztec/AztecText;I)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "textChangedEventDetails", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "getVerticalParagraphMargin", "()I", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "onTextChanged", "before", "paragraphMarkerCanBeApplied", "", "Companion", "aztec_release"})
public final class EndOfParagraphMarkerAdder
implements TextWatcher {
    private final WeakReference<AztecText> aztecTextRef;
    private TextChangedEvent textChangedEventDetails;
    private final int verticalParagraphMargin;
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.textChangedEventDetails = new TextChangedEvent(((Object)text).toString(), false, 0, 6, null);
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.textChangedEventDetails.setBefore(before);
        this.textChangedEventDetails.setText(text);
        this.textChangedEventDetails.setCountOfCharacters(count);
        this.textChangedEventDetails.setStart(start);
        this.textChangedEventDetails.initialize();
        if (!this.textChangedEventDetails.isNewLine()) {
            return;
        }
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null && !aztecText.isTextChangedListenerDisabled() && aztecText.isInCalypsoMode()) {
            int inputStart = this.textChangedEventDetails.getInputStart();
            int inputEnd = this.textChangedEventDetails.getInputEnd();
            Editable editable = aztecText.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"aztecText.text");
            if (this.paragraphMarkerCanBeApplied(editable)) {
                Object[] objectArray;
                aztecText.getText().setSpan((Object)new EndOfParagraphMarker(this.verticalParagraphMargin), inputStart, inputEnd, 33);
                ParagraphSpan[] paragraphs = (ParagraphSpan[])aztecText.getText().getSpans(inputStart, inputEnd, ParagraphSpan.class);
                Object[] objectArray2 = objectArray = (Object[])paragraphs;
                if (!(objectArray2.length == 0)) {
                    ParagraphSpan paragraph = (ParagraphSpan)ArraysKt.first((Object[])paragraphs);
                    int paragraphEnd = aztecText.getText().getSpanEnd((Object)paragraph);
                    if (paragraphEnd > inputEnd) {
                        int paragraphStart = aztecText.getText().getSpanStart((Object)paragraph);
                        int paragraphFlags = aztecText.getText().getSpanFlags((Object)paragraph);
                        aztecText.getText().setSpan((Object)paragraph, paragraphStart, inputEnd, paragraphFlags);
                    }
                }
            }
        }
    }

    public final boolean paragraphMarkerCanBeApplied(@NotNull Editable text) {
        boolean insideHeading;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int inputStart = this.textChangedEventDetails.getInputStart();
        int inputEnd = this.textChangedEventDetails.getInputEnd();
        Object[] objectArray2 = objectArray = text.getSpans(inputStart, inputEnd, AztecListItemSpan.class);
        boolean isInsideList = !(objectArray2.length == 0);
        Object[] objectArray3 = objectArray2 = text.getSpans(inputStart, inputEnd, AztecPreformatSpan.class);
        boolean isInsidePre = !(objectArray3.length == 0);
        Object[] objectArray4 = objectArray3 = text.getSpans(inputStart, inputEnd, AztecCodeSpan.class);
        boolean isInsideCode = !(objectArray4.length == 0);
        Object[] objectArray5 = objectArray4 = text.getSpans(inputStart, inputEnd, AztecHeadingSpan.class);
        boolean bl = insideHeading = !(objectArray5.length == 0);
        if (insideHeading && text.length() > inputEnd && text.charAt(inputEnd) == '\n') {
            insideHeading = false;
        }
        return !isInsideList && !insideHeading && !isInsidePre && !isInsideCode;
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Object[] $receiver$iv = text.getSpans(0, text.length(), EndOfParagraphMarker.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            EndOfParagraphMarker it = (EndOfParagraphMarker)element$iv;
            text.setSpan((Object)it, text.getSpanStart((Object)it), text.getSpanEnd((Object)it), 33);
        }
    }

    public final int getVerticalParagraphMargin() {
        return this.verticalParagraphMargin;
    }

    public EndOfParagraphMarkerAdder(@NotNull AztecText aztecText, int verticalParagraphMargin) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.verticalParagraphMargin = verticalParagraphMargin;
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
        this.textChangedEventDetails = new TextChangedEvent("", 0, 0, 0);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/watchers/EndOfParagraphMarkerAdder$Companion;", "", "()V", "install", "", "editText", "Lorg/wordpress/aztec/AztecText;", "verticalParagraphMargin", "", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull AztecText editText, int verticalParagraphMargin) {
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            editText.addTextChangedListener(new EndOfParagraphMarkerAdder(editText, verticalParagraphMargin));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

