/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.util;

import android.text.Spannable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.android.util.AppLog;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 (*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0006\u0010$\u001a\u00020%J-\u0010&\u001a\u00020%2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0005\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/wordpress/aztec/util/SpanWrapper;", "T", "", "spannable", "Landroid/text/Spannable;", "span", "(Landroid/text/Spannable;Ljava/lang/Object;)V", "END_MASK", "", "PARAGRAPH", "START_MASK", "START_SHIFT", "end", "getEnd", "()I", "setEnd", "(I)V", "flags", "getFlags", "setFlags", "getSpan", "()Ljava/lang/Object;", "setSpan", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getSpannable", "()Landroid/text/Spannable;", "setSpannable", "(Landroid/text/Spannable;)V", "start", "getStart", "setStart", "isInvalidParagraph", "", "index", "flag", "remove", "", "setSpanOrLogError", "(Ljava/lang/Object;III)V", "Companion", "aztec_release"})
public final class SpanWrapper<T> {
    private final int START_MASK = 240;
    private final int END_MASK = 15;
    private final int START_SHIFT = 4;
    private final int PARAGRAPH = 3;
    @NotNull
    private Spannable spannable;
    private T span;
    public static final Companion Companion = new Companion(null);

    public final void remove() {
        this.spannable.removeSpan(this.span);
    }

    public final int getStart() {
        return this.spannable.getSpanStart(this.span);
    }

    public final void setStart(int start) {
        this.setSpanOrLogError(this.span, start, this.getEnd(), this.getFlags());
    }

    public final int getEnd() {
        return this.spannable.getSpanEnd(this.span);
    }

    public final void setEnd(int end) {
        this.setSpanOrLogError(this.span, this.getStart(), end, this.getFlags());
    }

    public final int getFlags() {
        return this.spannable.getSpanFlags(this.span);
    }

    public final void setFlags(int flags) {
        this.setSpanOrLogError(this.span, this.getStart(), this.getEnd(), flags);
    }

    private final void setSpanOrLogError(T span, int start, int end, int flags) {
        int flagsStart = (flags & this.START_MASK) >> this.START_SHIFT;
        if (this.isInvalidParagraph(start, flagsStart)) {
            AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + this.spannable.charAt(start - 1) + ")"));
            return;
        }
        int flagsEnd = flags & this.END_MASK;
        if (this.isInvalidParagraph(end, flagsEnd)) {
            AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + this.spannable.charAt(end - 1) + ")"));
            return;
        }
        this.spannable.setSpan(span, start, end, flags);
    }

    private final boolean isInvalidParagraph(int index, int flag) {
        return flag == this.PARAGRAPH && index != 0 && index != this.spannable.length() && this.spannable.charAt(index - 1) != '\n';
    }

    @NotNull
    public final Spannable getSpannable() {
        return this.spannable;
    }

    public final void setSpannable(@NotNull Spannable spannable) {
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"<set-?>");
        this.spannable = spannable;
    }

    public final T getSpan() {
        return this.span;
    }

    public final void setSpan(T t) {
        this.span = t;
    }

    public SpanWrapper(@NotNull Spannable spannable, T span) {
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
        this.spannable = spannable;
        this.span = span;
        this.START_MASK = 240;
        this.END_MASK = 15;
        this.START_SHIFT = 4;
        this.PARAGRAPH = 3;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n\u00a2\u0006\u0002\u0010\u000bJ9\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\n\b\u0001\u0010\u0006\u0018\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0086\bJ>\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\u00a8\u0006\u0011"}, d2={"Lorg/wordpress/aztec/util/SpanWrapper$Companion;", "", "()V", "getSpans", "", "Lorg/wordpress/aztec/util/SpanWrapper;", "T", "spannable", "Landroid/text/Spannable;", "spanObjects", "", "(Landroid/text/Spannable;[Ljava/lang/Object;)Ljava/util/List;", "start", "", "end", "type", "Ljava/lang/Class;", "aztec_release"})
    public static final class Companion {
        private final <T> List<SpanWrapper<T>> getSpans(Spannable spannable, int start, int end) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object[] objectArray = spannable.getSpans(start, end, Object.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"spannable.getSpans(start, end, T::class.java)");
            return this.getSpans(spannable, objectArray);
        }

        @NotNull
        public final <T> List<SpanWrapper<T>> getSpans(@NotNull Spannable spannable, int start, int end, @NotNull Class<T> type) {
            Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Object[] objectArray = spannable.getSpans(start, end, type);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"spannable.getSpans(start, end, type)");
            return this.getSpans(spannable, objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T> List<SpanWrapper<T>> getSpans(@NotNull Spannable spannable, @NotNull T[] spanObjects) {
            void $receiver$iv$iv;
            T[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
            Intrinsics.checkParameterIsNotNull(spanObjects, (String)"spanObjects");
            T[] TArray = $receiver$iv = spanObjects;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv;
                void var8_8 = item$iv$iv = $receiver$iv$iv[i];
                Collection collection = destination$iv$iv;
                SpanWrapper<void> spanWrapper = new SpanWrapper<void>(spannable, it);
                collection.add(spanWrapper);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

