/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.os.Handler;
import android.os.Looper;
import android.widget.EditText;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.IHistoryListener;
import org.wordpress.aztec.source.SourceViewEditText;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0010J\u0006\u0010.\u001a\u00020,J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0010H\u0004J\u000e\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020,2\u0006\u00102\u001a\u000203J\u0006\u00105\u001a\u00020\u0003J\u000e\u00106\u001a\u00020,2\u0006\u00102\u001a\u000203J\u000e\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\u0016J\u0010\u00109\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0002J\u000e\u0010:\u001a\u00020,2\u0006\u00102\u001a\u000203J\u0006\u0010;\u001a\u00020\u0003J\u0006\u0010<\u001a\u00020,R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/wordpress/aztec/History;", "", "historyEnabled", "", "historySize", "", "(ZI)V", "historyCursor", "getHistoryCursor", "()I", "setHistoryCursor", "(I)V", "getHistoryEnabled", "()Z", "historyList", "Ljava/util/LinkedList;", "", "getHistoryList", "()Ljava/util/LinkedList;", "setHistoryList", "(Ljava/util/LinkedList;)V", "historyListener", "Lorg/wordpress/aztec/IHistoryListener;", "historyRunnable", "Lorg/wordpress/aztec/History$HistoryRunnable;", "getHistorySize", "historyThrottleTime", "", "getHistoryThrottleTime", "()J", "setHistoryThrottleTime", "(J)V", "historyWorking", "inputBefore", "inputLast", "getInputLast", "()Ljava/lang/String;", "setInputLast", "(Ljava/lang/String;)V", "inputLastTmp", "mainHandler", "Landroid/os/Handler;", "textChangedPending", "beforeTextChanged", "", "text", "clearHistory", "doHandleHistory", "inputBeforeTmp", "handleHistory", "editText", "Landroid/widget/EditText;", "redo", "redoValid", "refreshLastHistoryItem", "setHistoryListener", "listener", "setTextFromHistory", "undo", "undoValid", "updateActions", "HistoryRunnable", "aztec_release"})
public final class History {
    private int historyCursor;
    @NotNull
    private LinkedList<String> historyList;
    @NotNull
    private String inputLast;
    private IHistoryListener historyListener;
    private boolean historyWorking;
    private String inputBefore;
    private final Handler mainHandler;
    private final HistoryRunnable historyRunnable;
    private String inputLastTmp;
    private boolean textChangedPending;
    private long historyThrottleTime;
    private final boolean historyEnabled;
    private final int historySize;

    public final int getHistoryCursor() {
        return this.historyCursor;
    }

    public final void setHistoryCursor(int n) {
        this.historyCursor = n;
    }

    @NotNull
    public final LinkedList<String> getHistoryList() {
        return this.historyList;
    }

    public final void setHistoryList(@NotNull LinkedList<String> linkedList) {
        Intrinsics.checkParameterIsNotNull(linkedList, (String)"<set-?>");
        this.historyList = linkedList;
    }

    @NotNull
    public final String getInputLast() {
        return this.inputLast;
    }

    public final void setInputLast(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.inputLast = string2;
    }

    public final long getHistoryThrottleTime() {
        return this.historyThrottleTime;
    }

    public final void setHistoryThrottleTime(long l) {
        this.historyThrottleTime = l;
    }

    public final void beforeTextChanged(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (this.historyEnabled && !this.historyWorking) {
            this.mainHandler.removeCallbacks((Runnable)this.historyRunnable);
            if (!this.textChangedPending) {
                this.textChangedPending = true;
                HistoryRunnable historyRunnable = this.historyRunnable;
                if (historyRunnable != null) {
                    historyRunnable.setText(text);
                }
            }
            this.mainHandler.postDelayed((Runnable)this.historyRunnable, this.historyThrottleTime);
        }
    }

    protected final void doHandleHistory(@NotNull String inputBeforeTmp) {
        Intrinsics.checkParameterIsNotNull((Object)inputBeforeTmp, (String)"inputBeforeTmp");
        this.textChangedPending = false;
        this.inputBefore = inputBeforeTmp;
        this.inputLast = this.inputLastTmp;
        String string2 = this.inputBefore;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputBefore");
        }
        if (Intrinsics.areEqual((Object)this.inputLast, (Object)string2)) {
            return;
        }
        while (this.historyCursor != this.historyList.size() && this.historyCursor >= 0) {
            this.historyList.remove(this.historyCursor);
        }
        if (this.historyList.size() >= this.historySize) {
            this.historyList.remove(0);
            int n = this.historyCursor;
            this.historyCursor = n + -1;
        }
        String string3 = this.inputBefore;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputBefore");
        }
        this.historyList.add(string3);
        this.historyCursor = this.historyList.size();
        this.updateActions();
    }

    public final void handleHistory(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.historyEnabled || this.historyWorking) {
            return;
        }
        if (editText instanceof AztecText) {
            this.inputLastTmp = ((AztecText)editText).toFormattedHtml();
        } else if (editText instanceof SourceViewEditText) {
            this.inputLastTmp = ((SourceViewEditText)editText).getText().toString();
        }
    }

    public final void refreshLastHistoryItem(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.historyEnabled || this.historyWorking) {
            return;
        }
        if (editText instanceof AztecText) {
            this.inputLastTmp = ((AztecText)editText).toFormattedHtml();
        } else if (editText instanceof SourceViewEditText) {
            this.inputLastTmp = ((SourceViewEditText)editText).getText().toString();
        }
        this.inputLast = this.inputLastTmp;
    }

    public final void redo(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.redoValid()) {
            return;
        }
        this.historyWorking = true;
        editText.setFocusable(false);
        editText.setFocusableInTouchMode(false);
        if (this.historyCursor >= this.historyList.size() - 1) {
            this.historyCursor = this.historyList.size();
            if (editText instanceof AztecText) {
                ((AztecText)editText).fromHtml(this.inputLast);
            } else if (editText instanceof SourceViewEditText) {
                ((SourceViewEditText)editText).displayStyledHtml(this.inputLast);
            }
        } else {
            int n = this.historyCursor;
            this.historyCursor = n + 1;
            this.setTextFromHistory(editText);
        }
        this.historyWorking = false;
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        this.updateActions();
    }

    public final void undo(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.undoValid()) {
            return;
        }
        this.historyWorking = true;
        int n = this.historyCursor;
        this.historyCursor = n + -1;
        editText.setFocusable(false);
        editText.setFocusableInTouchMode(false);
        this.setTextFromHistory(editText);
        this.historyWorking = false;
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        this.updateActions();
    }

    private final void setTextFromHistory(EditText editText) {
        if (editText instanceof AztecText) {
            AztecText aztecText = (AztecText)editText;
            String string2 = this.historyList.get(this.historyCursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"historyList[historyCursor]");
            aztecText.fromHtml(string2);
        } else if (editText instanceof SourceViewEditText) {
            SourceViewEditText sourceViewEditText = (SourceViewEditText)editText;
            String string3 = this.historyList.get(this.historyCursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"historyList[historyCursor]");
            sourceViewEditText.displayStyledHtml(string3);
        }
    }

    public final boolean redoValid() {
        if (!this.historyEnabled || this.historySize <= 0 || this.historyList.size() <= 0 || this.historyWorking) {
            return false;
        }
        return this.historyCursor < this.historyList.size();
    }

    public final boolean undoValid() {
        if (!this.historyEnabled || this.historySize <= 0 || this.historyWorking) {
            return false;
        }
        return this.historyList.size() > 0 && this.historyCursor > 0;
    }

    public final void clearHistory() {
        this.inputLast = "";
        this.historyList.clear();
    }

    public final void setHistoryListener(@NotNull IHistoryListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.historyListener = listener;
    }

    public final void updateActions() {
        block1: {
            IHistoryListener iHistoryListener = this.historyListener;
            if (iHistoryListener != null) {
                iHistoryListener.onRedoEnabled();
            }
            IHistoryListener iHistoryListener2 = this.historyListener;
            if (iHistoryListener2 == null) break block1;
            iHistoryListener2.onUndoEnabled();
        }
    }

    public final boolean getHistoryEnabled() {
        return this.historyEnabled;
    }

    public final int getHistorySize() {
        return this.historySize;
    }

    public History(boolean historyEnabled, int historySize) {
        this.historyEnabled = historyEnabled;
        this.historySize = historySize;
        this.historyList = new LinkedList();
        this.inputLast = "";
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.inputLastTmp = "";
        this.historyThrottleTime = 500L;
        this.historyRunnable = this.historyEnabled ? new HistoryRunnable(this) : (HistoryRunnable)null;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/wordpress/aztec/History$HistoryRunnable;", "Ljava/lang/Runnable;", "history", "Lorg/wordpress/aztec/History;", "(Lorg/wordpress/aztec/History;Lorg/wordpress/aztec/History;)V", "getHistory", "()Lorg/wordpress/aztec/History;", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "run", "", "aztec_release"})
    public final class HistoryRunnable
    implements Runnable {
        @NotNull
        private String text;
        @NotNull
        private final History history;

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            this.text = string2;
        }

        @Override
        public void run() {
            this.history.doHandleHistory(this.text);
        }

        @NotNull
        public final History getHistory() {
            return this.history;
        }

        public HistoryRunnable(History history) {
            Intrinsics.checkParameterIsNotNull((Object)history, (String)"history");
            this.history = history;
            this.text = "";
        }
    }
}

