/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.TextWatcher;
import android.text.style.LeadingMarginSpan;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.formatting.InlineFormatter;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J(\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u001a\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dR\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/wordpress/aztec/watchers/InlineTextWatcher;", "Landroid/text/TextWatcher;", "inlineFormatter", "Lorg/wordpress/aztec/formatting/InlineFormatter;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/formatting/InlineFormatter;Lorg/wordpress/aztec/AztecText;)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "getInlineFormatter", "()Lorg/wordpress/aztec/formatting/InlineFormatter;", "setInlineFormatter", "(Lorg/wordpress/aztec/formatting/InlineFormatter;)V", "textChangedEventDetails", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "onTextChanged", "before", "removeLeadingStyle", "spanClass", "Ljava/lang/Class;", "Companion", "aztec_release"})
public final class InlineTextWatcher
implements TextWatcher {
    private final WeakReference<AztecText> aztecTextRef;
    private TextChangedEvent textChangedEventDetails;
    @NotNull
    private InlineFormatter inlineFormatter;
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null ? aztecText.isTextChangedListenerDisabled() : true) {
            return;
        }
        this.textChangedEventDetails = new TextChangedEvent(((Object)text).toString(), false, 0, 6, null);
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null ? aztecText.isTextChangedListenerDisabled() : true) {
            return;
        }
        this.textChangedEventDetails.setBefore(before);
        this.textChangedEventDetails.setText(text);
        this.textChangedEventDetails.setCountOfCharacters(count);
        this.textChangedEventDetails.setStart(start);
        this.textChangedEventDetails.initialize();
    }

    public void afterTextChanged(@NotNull Editable text) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                AztecText aztecText = (AztecText)this.aztecTextRef.get();
                if (aztecText != null ? aztecText.isTextChangedListenerDisabled() : true) {
                    return;
                }
                if (this.textChangedEventDetails.getInputStart() == 0 && this.textChangedEventDetails.getCount() == 0) {
                    this.removeLeadingStyle(text, IAztecInlineSpan.class);
                    this.removeLeadingStyle(text, LeadingMarginSpan.class);
                }
                AztecText aztecText2 = (AztecText)this.aztecTextRef.get();
                if (!(aztecText2 != null ? aztecText2.isInlineTextHandlerEnabled() : true)) break block2;
                this.inlineFormatter.handleInlineStyling(this.textChangedEventDetails);
                break block3;
            }
            AztecText aztecText = (AztecText)this.aztecTextRef.get();
            if (aztecText == null) break block3;
            aztecText.enableInlineTextHandling();
        }
    }

    public final void removeLeadingStyle(@NotNull Editable text, @NotNull Class<?> spanClass) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(spanClass, (String)"spanClass");
        Object[] $receiver$iv = text.getSpans(0, 0, spanClass);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv;
            Object it = element$iv = $receiver$iv[i];
            CharSequence charSequence = (CharSequence)text;
            if (charSequence.length() > 0) {
                text.setSpan(it, 0, text.getSpanEnd(it), text.getSpanFlags(it));
                continue;
            }
            text.removeSpan(it);
        }
    }

    @NotNull
    public final InlineFormatter getInlineFormatter() {
        return this.inlineFormatter;
    }

    public final void setInlineFormatter(@NotNull InlineFormatter inlineFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)inlineFormatter, (String)"<set-?>");
        this.inlineFormatter = inlineFormatter;
    }

    public InlineTextWatcher(@NotNull InlineFormatter inlineFormatter, @NotNull AztecText aztecText) {
        Intrinsics.checkParameterIsNotNull((Object)inlineFormatter, (String)"inlineFormatter");
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.inlineFormatter = inlineFormatter;
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
        this.textChangedEventDetails = new TextChangedEvent("", 0, 0, 0);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/watchers/InlineTextWatcher$Companion;", "", "()V", "install", "", "inlineFormatter", "Lorg/wordpress/aztec/formatting/InlineFormatter;", "text", "Lorg/wordpress/aztec/AztecText;", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull InlineFormatter inlineFormatter, @NotNull AztecText text) {
            Intrinsics.checkParameterIsNotNull((Object)inlineFormatter, (String)"inlineFormatter");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            text.addTextChangedListener(new InlineTextWatcher(inlineFormatter, text));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

