/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.UpdateLayout;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.IAztecBlockSpan;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 K2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002KLB+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB)\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J8\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u00020+H\u0016J\u0010\u0010G\u001a\u00020?2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020?2\u0006\u0010H\u001a\u00020IH\u0016R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0010\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001b\"\u0004\b8\u0010\u001dR&\u0010\u000e\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006M"}, d2={"Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "Landroid/text/style/MetricAffectingSpan;", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "nestingLevel", "", "tag", "", "attrs", "Lorg/wordpress/aztec/AztecAttributes;", "headerStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "(ILjava/lang/String;Lorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;)V", "textFormat", "Lorg/wordpress/aztec/ITextFormat;", "attributes", "(ILorg/wordpress/aztec/ITextFormat;Lorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;)V", "TAG", "getTAG", "()Ljava/lang/String;", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getHeaderStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "setHeaderStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;)V", "heading", "Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "getHeading", "()Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "setHeading", "(Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;)V", "getNestingLevel", "setNestingLevel", "previousFontMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "getPreviousFontMetrics", "()Landroid/graphics/Paint$FontMetricsInt;", "setPreviousFontMetrics", "(Landroid/graphics/Paint$FontMetricsInt;)V", "previousTextScale", "", "getPreviousTextScale", "()F", "setPreviousTextScale", "(F)V", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "value", "getTextFormat", "()Lorg/wordpress/aztec/ITextFormat;", "setTextFormat", "(Lorg/wordpress/aztec/ITextFormat;)V", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "updateDrawState", "textPaint", "Landroid/text/TextPaint;", "updateMeasureState", "Companion", "Heading", "aztec_release"})
public final class AztecHeadingSpan
extends MetricAffectingSpan
implements IAztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    private int endBeforeBleed;
    private int startBeforeCollapse;
    @NotNull
    private ITextFormat textFormat;
    @NotNull
    public Heading heading;
    @Nullable
    private Paint.FontMetricsInt previousFontMetrics;
    private float previousTextScale;
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.HeaderStyle headerStyle;
    private static final float SCALE_H1 = 1.73f;
    private static final float SCALE_H2 = 1.32f;
    private static final float SCALE_H3 = 1.02f;
    private static final float SCALE_H4 = 0.87f;
    private static final float SCALE_H5 = 0.72f;
    private static final float SCALE_H6 = 0.6f;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getTAG() {
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        return heading.getTag$aztec_release();
    }

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    @NotNull
    public final ITextFormat getTextFormat() {
        return this.textFormat;
    }

    public final void setTextFormat(@NotNull ITextFormat value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.textFormat = value;
        this.heading = Companion.textFormatToHeading(value);
    }

    @NotNull
    public final Heading getHeading() {
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        return heading;
    }

    public final void setHeading(@NotNull Heading heading) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)heading), (String)"<set-?>");
        this.heading = heading;
    }

    @Nullable
    public final Paint.FontMetricsInt getPreviousFontMetrics() {
        return this.previousFontMetrics;
    }

    public final void setPreviousFontMetrics(@Nullable Paint.FontMetricsInt fontMetricsInt) {
        this.previousFontMetrics = fontMetricsInt;
    }

    public final float getPreviousTextScale() {
        return this.previousTextScale;
    }

    public final void setPreviousTextScale(float f) {
        this.previousTextScale = f;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (this.previousFontMetrics == null) {
            this.previousFontMetrics = new Paint.FontMetricsInt();
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.top = fm.top;
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.ascent = fm.ascent;
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.bottom = fm.bottom;
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.descent = fm.descent;
        }
        boolean addedTopPadding = false;
        boolean addedBottomPadding = false;
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.headerStyle.getVerticalPadding();
            fm.top -= this.headerStyle.getVerticalPadding();
            addedTopPadding = true;
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.headerStyle.getVerticalPadding();
            fm.bottom += this.headerStyle.getVerticalPadding();
            addedBottomPadding = true;
        }
        if (!addedTopPadding) {
            Paint.FontMetricsInt fontMetricsInt = this.previousFontMetrics;
            if (fontMetricsInt == null) {
                Intrinsics.throwNpe();
            }
            fm.ascent = fontMetricsInt.ascent;
            Paint.FontMetricsInt fontMetricsInt2 = this.previousFontMetrics;
            if (fontMetricsInt2 == null) {
                Intrinsics.throwNpe();
            }
            fm.top = fontMetricsInt2.top;
        }
        if (!addedBottomPadding) {
            Paint.FontMetricsInt fontMetricsInt = this.previousFontMetrics;
            if (fontMetricsInt == null) {
                Intrinsics.throwNpe();
            }
            fm.descent = fontMetricsInt.descent;
            Paint.FontMetricsInt fontMetricsInt3 = this.previousFontMetrics;
            if (fontMetricsInt3 == null) {
                Intrinsics.throwNpe();
            }
            fm.bottom = fontMetricsInt3.bottom;
        }
    }

    public void updateDrawState(@NotNull TextPaint textPaint) {
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        TextPaint textPaint2 = textPaint;
        float f = textPaint2.getTextSize();
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        textPaint2.setTextSize(f * heading.getScale$aztec_release());
        textPaint.setFakeBoldText(true);
    }

    public void updateMeasureState(@NotNull TextPaint textPaint) {
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        if (this.previousTextScale != heading.getScale$aztec_release()) {
            this.previousFontMetrics = null;
        }
        Heading heading2 = this.heading;
        if (heading2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        this.previousTextScale = heading2.getScale$aztec_release();
        TextPaint textPaint2 = textPaint;
        float f = textPaint2.getTextSize();
        Heading heading3 = this.heading;
        if (heading3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        textPaint2.setTextSize(f * heading3.getScale$aztec_release());
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.HeaderStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public final void setHeaderStyle(@NotNull BlockFormatter.HeaderStyle headerStyle) {
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"<set-?>");
        this.headerStyle = headerStyle;
    }

    @JvmOverloads
    public AztecHeadingSpan(int nestingLevel, @NotNull ITextFormat textFormat, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.HeaderStyle headerStyle) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"headerStyle");
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.headerStyle = headerStyle;
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
        this.textFormat = AztecTextFormat.FORMAT_HEADING_1;
        this.previousTextScale = 1.0f;
        this.setTextFormat(textFormat);
    }

    @JvmOverloads
    public /* synthetic */ AztecHeadingSpan(int n, ITextFormat iTextFormat, AztecAttributes aztecAttributes, BlockFormatter.HeaderStyle headerStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            headerStyle = new BlockFormatter.HeaderStyle(0);
        }
        this(n, iTextFormat, aztecAttributes, headerStyle);
    }

    @JvmOverloads
    public AztecHeadingSpan(int nestingLevel, @NotNull ITextFormat textFormat, @NotNull AztecAttributes attributes) {
        this(nestingLevel, textFormat, attributes, null, 8, null);
    }

    public AztecHeadingSpan(int nestingLevel, @NotNull String tag, @NotNull AztecAttributes attrs, @NotNull BlockFormatter.HeaderStyle headerStyle) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"headerStyle");
        this(nestingLevel, Companion.tagToTextFormat(tag), attrs, headerStyle);
    }

    public /* synthetic */ AztecHeadingSpan(int n, String string2, AztecAttributes aztecAttributes, BlockFormatter.HeaderStyle headerStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 8) != 0) {
            headerStyle = new BlockFormatter.HeaderStyle(0);
        }
        this(n, string2, aztecAttributes, headerStyle);
    }

    static {
        SCALE_H1 = 1.73f;
        SCALE_H2 = 1.32f;
        SCALE_H3 = 1.02f;
        SCALE_H4 = 0.87f;
        SCALE_H5 = 0.72f;
        SCALE_H6 = 0.6f;
    }

    @Override
    @NotNull
    public String getStartTag() {
        return IAztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return IAztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void clearStartBeforeCollapse() {
        IAztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return IAztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        IAztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return IAztecBlockSpan.DefaultImpls.hasBled(this);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "", "scale", "", "tag", "", "(Ljava/lang/String;IFLjava/lang/String;)V", "getScale$aztec_release", "()F", "getTag$aztec_release", "()Ljava/lang/String;", "H1", "H2", "H3", "H4", "H5", "H6", "aztec_release"})
    public static final class Heading
    extends Enum<Heading> {
        public static final /* enum */ Heading H1;
        public static final /* enum */ Heading H2;
        public static final /* enum */ Heading H3;
        public static final /* enum */ Heading H4;
        public static final /* enum */ Heading H5;
        public static final /* enum */ Heading H6;
        private static final /* synthetic */ Heading[] $VALUES;
        private final float scale;
        @NotNull
        private final String tag;

        static {
            Heading[] headingArray = new Heading[6];
            Heading[] headingArray2 = headingArray;
            headingArray[0] = H1 = new Heading(Companion.getSCALE_H1(), "h1");
            headingArray[1] = H2 = new Heading(Companion.getSCALE_H2(), "h2");
            headingArray[2] = H3 = new Heading(Companion.getSCALE_H3(), "h3");
            headingArray[3] = H4 = new Heading(Companion.getSCALE_H4(), "h4");
            headingArray[4] = H5 = new Heading(Companion.getSCALE_H5(), "h5");
            headingArray[5] = H6 = new Heading(Companion.getSCALE_H6(), "h6");
            $VALUES = headingArray;
        }

        public final float getScale$aztec_release() {
            return this.scale;
        }

        @NotNull
        public final String getTag$aztec_release() {
            return this.tag;
        }

        protected Heading(float scale, String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.scale = scale;
            this.tag = tag;
        }

        public static Heading[] values() {
            return (Heading[])$VALUES.clone();
        }

        public static Heading valueOf(String string2) {
            return Enum.valueOf(Heading.class, string2);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/wordpress/aztec/spans/AztecHeadingSpan$Companion;", "", "()V", "SCALE_H1", "", "getSCALE_H1", "()F", "SCALE_H2", "getSCALE_H2", "SCALE_H3", "getSCALE_H3", "SCALE_H4", "getSCALE_H4", "SCALE_H5", "getSCALE_H5", "SCALE_H6", "getSCALE_H6", "tagToTextFormat", "Lorg/wordpress/aztec/ITextFormat;", "tag", "", "textFormatToHeading", "Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "textFormat", "aztec_release"})
    public static final class Companion {
        private final float getSCALE_H1() {
            return SCALE_H1;
        }

        private final float getSCALE_H2() {
            return SCALE_H2;
        }

        private final float getSCALE_H3() {
            return SCALE_H3;
        }

        private final float getSCALE_H4() {
            return SCALE_H4;
        }

        private final float getSCALE_H5() {
            return SCALE_H5;
        }

        private final float getSCALE_H6() {
            return SCALE_H6;
        }

        @NotNull
        public final ITextFormat tagToTextFormat(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            String string2 = tag;
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            switch (string3) {
                case "h1": {
                    return AztecTextFormat.FORMAT_HEADING_1;
                }
                case "h2": {
                    return AztecTextFormat.FORMAT_HEADING_2;
                }
                case "h3": {
                    return AztecTextFormat.FORMAT_HEADING_3;
                }
                case "h4": {
                    return AztecTextFormat.FORMAT_HEADING_4;
                }
                case "h5": {
                    return AztecTextFormat.FORMAT_HEADING_5;
                }
                case "h6": {
                    return AztecTextFormat.FORMAT_HEADING_6;
                }
            }
            return AztecTextFormat.FORMAT_HEADING_1;
        }

        @NotNull
        public final Heading textFormatToHeading(@NotNull ITextFormat textFormat) {
            Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
            ITextFormat iTextFormat = textFormat;
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1)) {
                return Heading.H1;
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2)) {
                return Heading.H2;
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3)) {
                return Heading.H3;
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4)) {
                return Heading.H4;
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5)) {
                return Heading.H5;
            }
            if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
                return Heading.H6;
            }
            return Heading.H1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

