/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.TextWatcher;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.spans.FullWidthImageProcessingMarker;
import org.wordpress.aztec.spans.IAztecFullWidthImageSpan;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/watchers/FullWidthImageElementWatcher;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "changeCount", "", "changeStart", "deletedNewline", "", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "insertVisualNewline", "position", "normalizeEditingAroundImageSpans", "onTextChanged", "before", "Companion", "aztec_release"})
public final class FullWidthImageElementWatcher
implements TextWatcher {
    private final WeakReference<AztecText> aztecTextRef;
    private boolean deletedNewline;
    private int changeCount;
    private int changeStart;
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.deletedNewline = count > 0 && text.charAt(start + count - 1) == Constants.INSTANCE.getNEWLINE();
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.changeCount = count;
        this.changeStart = start;
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.normalizeEditingAroundImageSpans(this.changeCount, this.changeStart);
    }

    private final void insertVisualNewline(int position) {
        block0: {
            AztecText aztecText = (AztecText)this.aztecTextRef.get();
            if (aztecText == null || (aztecText = aztecText.getText()) == null) break block0;
            aztecText.insert(position, Constants.INSTANCE.getNEWLINE_STRING());
        }
    }

    private final void normalizeEditingAroundImageSpans(int count, int start) {
        Object[] objectArray;
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null && !aztecText.isTextChangedListenerDisabled() && (objectArray = aztecText.getText().getSpans(0, 0, FullWidthImageProcessingMarker.class)).length == 0) {
            int end = start + count;
            IAztecFullWidthImageSpan[] lines = (IAztecFullWidthImageSpan[])aztecText.getText().getSpans(start, start, IAztecFullWidthImageSpan.class);
            Object[] objectArray2 = lines;
            Object[] objectArray3 = aztecText.getText().getSpans(end, end, IAztecFullWidthImageSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"aztecText.text.getSpans(\u2026dthImageSpan::class.java)");
            lines = (IAztecFullWidthImageSpan[])ArraysKt.plus((Object[])objectArray2, (Object[])objectArray3);
            Iterable $receiver$iv = ArraysKt.distinct((Object[])lines);
            for (Object element$iv : $receiver$iv) {
                IAztecFullWidthImageSpan it = (IAztecFullWidthImageSpan)element$iv;
                boolean changedLineBeginning = aztecText.getText().getSpanStart((Object)it) == end && end - 1 >= 0 && aztecText.getText().charAt(end - 1) != Constants.INSTANCE.getNEWLINE();
                boolean changedLineEnd = aztecText.getText().getSpanEnd((Object)it) == start && start < aztecText.length() && aztecText.getText().charAt(start) != Constants.INSTANCE.getNEWLINE();
                FullWidthImageProcessingMarker marker = new FullWidthImageProcessingMarker();
                aztecText.getText().setSpan((Object)marker, 0, 0, 17);
                if (changedLineBeginning) {
                    if (count > 0) {
                        this.insertVisualNewline(end);
                        aztecText.setSelection(end);
                    } else if (this.deletedNewline) {
                        aztecText.getText().delete(end - 1, end);
                        this.insertVisualNewline(end - 1);
                        aztecText.setSelection(end - 1);
                    } else {
                        this.insertVisualNewline(end);
                        aztecText.setSelection(end);
                    }
                } else if (changedLineEnd) {
                    if (count > 0) {
                        this.insertVisualNewline(start);
                    } else {
                        aztecText.getText().delete(aztecText.getText().getSpanStart((Object)it), start);
                    }
                }
                aztecText.getText().removeSpan((Object)marker);
            }
        }
    }

    public FullWidthImageElementWatcher(@NotNull AztecText aztecText) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wordpress/aztec/watchers/FullWidthImageElementWatcher$Companion;", "", "()V", "install", "", "text", "Lorg/wordpress/aztec/AztecText;", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull AztecText text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            text.addTextChangedListener(new FullWidthImageElementWatcher(text));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

