/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJh\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0004R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lorg/wordpress/aztec/spans/AztecUnorderedListSpan;", "Lorg/wordpress/aztec/spans/AztecListSpan;", "attributes", "", "(Ljava/lang/String;)V", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "last", "Lorg/wordpress/aztec/spans/AztecListItemSpan;", "(Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;Ljava/lang/String;Lorg/wordpress/aztec/spans/AztecListItemSpan;)V", "TAG", "getAttributes", "()Ljava/lang/String;", "setAttributes", "bulletColor", "", "bulletMargin", "bulletPadding", "bulletWidth", "lastItem", "getLastItem", "()Lorg/wordpress/aztec/spans/AztecListItemSpan;", "setLastItem", "(Lorg/wordpress/aztec/spans/AztecListItemSpan;)V", "drawLeadingMargin", "", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "x", "dir", "top", "baseline", "bottom", "text", "", "start", "end", "first", "", "l", "Landroid/text/Layout;", "getEndTag", "getLeadingMargin", "getStartTag", "aztec_release"})
public final class AztecUnorderedListSpan
extends AztecListSpan {
    private final String TAG = "ul";
    private int bulletColor;
    private int bulletMargin;
    private int bulletPadding;
    private int bulletWidth;
    @NotNull
    private String attributes;
    @NotNull
    private AztecListItemSpan lastItem;

    @Override
    @NotNull
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.attributes = string;
    }

    @Override
    @NotNull
    public AztecListItemSpan getLastItem() {
        return this.lastItem;
    }

    @Override
    public void setLastItem(@NotNull AztecListItemSpan aztecListItemSpan) {
        Intrinsics.checkParameterIsNotNull((Object)aztecListItemSpan, (String)"<set-?>");
        this.lastItem = aztecListItemSpan;
    }

    @Override
    @NotNull
    public String getStartTag() {
        if (TextUtils.isEmpty((CharSequence)this.getAttributes())) {
            return this.TAG;
        }
        return this.TAG + this.getAttributes();
    }

    @Override
    @NotNull
    public String getEndTag() {
        return this.TAG;
    }

    public int getLeadingMargin(boolean first) {
        return this.bulletMargin + 2 * this.bulletWidth + this.bulletPadding;
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout l) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        if (!first) {
            return;
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        int spanStart = ((Spanned)charSequence).getSpanStart((Object)this);
        int spanEnd = ((Spanned)text).getSpanEnd((Object)this);
        int n = start;
        if (spanStart > n || n > spanEnd || spanStart > (n = end) || n > spanEnd) {
            return;
        }
        Paint.Style style = p.getStyle();
        int oldColor = p.getColor();
        p.setColor(this.bulletColor);
        p.setStyle(Paint.Style.FILL);
        String textToDraw = "\u2022";
        float width = p.measureText(textToDraw);
        c.drawText(textToDraw, ((float)(this.bulletMargin + x + dir) - width) * (float)dir, (float)bottom - p.descent() - width / (float)2 + (float)this.getIndicatorAdjustment(text, end), p);
        p.setColor(oldColor);
        p.setStyle(style);
    }

    public AztecUnorderedListSpan(@NotNull String attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        super(0);
        this.TAG = "ul";
        this.attributes = "";
        this.lastItem = new AztecListItemSpan(null, 1, null);
        this.setAttributes(attributes);
    }

    public AztecUnorderedListSpan(@NotNull BlockFormatter.ListStyle listStyle, @NotNull String attributes, @NotNull AztecListItemSpan last) {
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)last, (String)"last");
        super(listStyle.getVerticalPadding());
        this.TAG = "ul";
        this.attributes = "";
        this.lastItem = new AztecListItemSpan(null, 1, null);
        this.bulletColor = listStyle.getIndicatorColor();
        this.bulletMargin = listStyle.getIndicatorMargin();
        this.bulletWidth = listStyle.getIndicatorWidth();
        this.bulletPadding = listStyle.getIndicatorPadding();
        this.setAttributes(attributes);
        this.setLastItem(last);
    }
}

