/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.TextWatcher;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.spans.AztecFullWidthImageSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/watchers/FullWidthImageElementWatcher;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "getAztecText", "()Lorg/wordpress/aztec/AztecText;", "changeCount", "", "changeStart", "deletedNewline", "", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "insertVisualNewline", "position", "normalizeEditingAroundImageSpans", "onTextChanged", "before", "Companion", "aztec_release"})
public final class FullWidthImageElementWatcher
implements TextWatcher {
    private boolean deletedNewline;
    private int changeCount;
    private int changeStart;
    @NotNull
    private final AztecText aztecText;
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.deletedNewline = count > 0 && text.charAt(start + count - 1) == Constants.INSTANCE.getNEWLINE();
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.changeCount = count;
        this.changeStart = start;
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.normalizeEditingAroundImageSpans(this.changeCount, this.changeStart);
    }

    private final void insertVisualNewline(int position) {
        this.aztecText.getText().insert(position, (CharSequence)Constants.INSTANCE.getNEWLINE_STRING());
    }

    /*
     * WARNING - void declaration
     */
    private final void normalizeEditingAroundImageSpans(int count, int start) {
        if (!this.aztecText.isTextChangedListenerDisabled()) {
            void $receiver$iv;
            int end = start + count;
            AztecFullWidthImageSpan[] lines = (AztecFullWidthImageSpan[])this.aztecText.getText().getSpans(start, start, AztecFullWidthImageSpan.class);
            Object[] objectArray = lines;
            Object[] objectArray2 = this.aztecText.getText().getSpans(end, end, AztecFullWidthImageSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"aztecText.text.getSpans(\u2026dthImageSpan::class.java)");
            lines = (AztecFullWidthImageSpan[])ArraysKt.plus((Object[])objectArray, (Object[])objectArray2);
            Iterable iterable = ArraysKt.distinct((Object[])lines);
            for (Object element$iv : $receiver$iv) {
                AztecFullWidthImageSpan it = (AztecFullWidthImageSpan)element$iv;
                boolean changedLineBeginning = this.aztecText.getText().getSpanStart((Object)it) == end && end - 1 >= 0 && this.aztecText.getText().charAt(end - 1) != Constants.INSTANCE.getNEWLINE();
                boolean changedLineEnd = this.aztecText.getText().getSpanEnd((Object)it) == start && start < this.aztecText.length() && this.aztecText.getText().charAt(start) != Constants.INSTANCE.getNEWLINE();
                this.aztecText.disableTextChangedListener();
                if (changedLineBeginning) {
                    if (count > 0) {
                        this.insertVisualNewline(end);
                        this.aztecText.setSelection(end);
                    } else if (this.deletedNewline) {
                        this.aztecText.getText().delete(end - 1, end);
                        this.insertVisualNewline(end - 1);
                        this.aztecText.setSelection(end - 1);
                    } else {
                        this.insertVisualNewline(end);
                        this.aztecText.setSelection(end);
                    }
                } else if (changedLineEnd) {
                    if (count > 0) {
                        this.insertVisualNewline(start);
                    } else {
                        this.aztecText.getText().delete(this.aztecText.getText().getSpanStart((Object)it), start);
                    }
                }
                this.aztecText.enableTextChangedListener();
            }
        }
    }

    @NotNull
    public final AztecText getAztecText() {
        return this.aztecText;
    }

    public FullWidthImageElementWatcher(@NotNull AztecText aztecText) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.aztecText = aztecText;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wordpress/aztec/watchers/FullWidthImageElementWatcher$Companion;", "", "()V", "install", "", "text", "Lorg/wordpress/aztec/AztecText;", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull AztecText text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            text.addTextChangedListener(new FullWidthImageElementWatcher(text));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

