/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.spans.AztecDynamicImageSpan;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u001aJP\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+H\u0016J\u0006\u0010,\u001a\u00020\u000eJ\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020\u001a2\b\u00102\u001a\u0004\u0018\u00010\u0005J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0018J \u00107\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u00182\b\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0018R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/wordpress/aztec/spans/AztecMediaSpan;", "Lorg/wordpress/aztec/spans/AztecDynamicImageSpan;", "context", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/xml/sax/Attributes;", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "editor", "Lorg/wordpress/aztec/AztecText;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;Lorg/xml/sax/Attributes;Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;Lorg/wordpress/aztec/AztecText;)V", "TAG", "", "getAttributes", "()Lorg/xml/sax/Attributes;", "setAttributes", "(Lorg/xml/sax/Attributes;)V", "getOnMediaTappedListener", "()Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "overlays", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "applyOverlayGravity", "", "overlay", "gravity", "clearOverlays", "draw", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getHtml", "getSource", "onClick", "view", "Landroid/view/View;", "setDrawable", "newDrawable", "setOverayLevel", "", "index", "level", "setOverlay", "aztec_release"})
public final class AztecMediaSpan
extends AztecDynamicImageSpan {
    private final String TAG = "img";
    private final ArrayList<Pair<Drawable, Integer>> overlays;
    @Nullable
    private Attributes attributes;
    @Nullable
    private final AztecText.OnMediaTappedListener onMediaTappedListener;

    public final void setDrawable(@Nullable Drawable newDrawable) {
        this.setImageDrawable(newDrawable);
        Drawable drawable2 = this.getImageDrawable();
        if (drawable2 == null || (drawable2 = drawable2.getBounds()) == null) {
            drawable2 = new Rect(0, 0, 0, 0);
        }
        this.setOriginalBounds(new Rect((Rect)drawable2));
        AztecDynamicImageSpan.Companion.setInitBounds(newDrawable);
        this.computeAspectRatio();
    }

    public final void setOverlay(int index, @Nullable Drawable newDrawable, int gravity) {
        if (CollectionsKt.getLastIndex((List)this.overlays) >= index) {
            this.overlays.remove(index);
        }
        if (newDrawable != null) {
            this.overlays.ensureCapacity(index + 1);
            this.overlays.add(index, (Pair<Drawable, Integer>)new Pair((Object)newDrawable, (Object)gravity));
            AztecDynamicImageSpan.Companion.setInitBounds(newDrawable);
        }
    }

    public final void clearOverlays() {
        this.overlays.clear();
    }

    public final boolean setOverayLevel(int index, int level) {
        Drawable drawable2 = (Drawable)this.overlays.get(index).getFirst();
        return drawable2 != null ? drawable2.setLevel(level) : false;
    }

    private final void applyOverlayGravity(Drawable overlay, int gravity) {
        if (this.getImageDrawable() != null && overlay != null) {
            Drawable drawable2 = this.getImageDrawable();
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            int n = drawable2.getBounds().width();
            Drawable drawable3 = this.getImageDrawable();
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            Rect rect = new Rect(0, 0, n, drawable3.getBounds().height());
            Rect outRect = new Rect();
            Gravity.apply((int)gravity, (int)overlay.getBounds().width(), (int)overlay.getBounds().height(), (Rect)rect, (Rect)outRect);
            overlay.setBounds(outRect.left, outRect.top, outRect.right, outRect.bottom);
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Pair it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.save();
        if (this.getImageDrawable() != null) {
            int transY = top;
            if (this.mVerticalAlignment == 1) {
                transY -= paint.getFontMetricsInt().descent;
            }
            canvas.translate(x, (float)transY);
            Drawable drawable2 = this.getImageDrawable();
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            drawable2.draw(canvas);
        }
        Iterable transY = this.overlays;
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            this.applyOverlayGravity((Drawable)it.getFirst(), ((Number)it.getSecond()).intValue());
        }
        $receiver$iv = this.overlays;
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            Drawable drawable3 = (Drawable)it.getFirst();
            if (drawable3 == null) continue;
            drawable3.draw(canvas);
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.TAG);
        Attributes attributes = this.attributes;
        if (attributes != null) {
            int n;
            Attributes attributes2 = attributes;
            Attributes it = attributes2;
            int n2 = 0;
            Attributes attributes3 = this.attributes;
            if (attributes3 == null) {
                Intrinsics.throwNpe();
            }
            if (n2 <= (n = attributes3.getLength() - 1)) {
                while (true) {
                    void i;
                    sb.append(' ');
                    Attributes attributes4 = this.attributes;
                    if (attributes4 == null) {
                        Intrinsics.throwNpe();
                    }
                    sb.append(attributes4.getLocalName((int)i));
                    sb.append("=\"");
                    Attributes attributes5 = this.attributes;
                    if (attributes5 == null) {
                        Intrinsics.throwNpe();
                    }
                    sb.append(attributes5.getValue((int)i));
                    sb.append("\"");
                    if (i == n) break;
                    ++i;
                }
            }
        }
        sb.append("/>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public final void onClick(@NotNull View view) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            AztecText.OnMediaTappedListener onMediaTappedListener = this.onMediaTappedListener;
            if (onMediaTappedListener == null) break block0;
            onMediaTappedListener.mediaTapped(this.attributes, AztecDynamicImageSpan.Companion.getWidth(this.getImageDrawable()), AztecDynamicImageSpan.Companion.getHeight(this.getImageDrawable()));
        }
    }

    @NotNull
    public final String getSource() {
        Object object = this.attributes;
        if (object == null || (object = object.getValue("src")) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@Nullable Attributes attributes) {
        this.attributes = attributes;
    }

    @Nullable
    public final AztecText.OnMediaTappedListener getOnMediaTappedListener() {
        return this.onMediaTappedListener;
    }

    public AztecMediaSpan(@NotNull Context context, @Nullable Drawable drawable2, @Nullable Attributes attributes, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener, @Nullable AztecText editor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, drawable2);
        this.attributes = attributes;
        this.onMediaTappedListener = onMediaTappedListener;
        this.TAG = "img";
        this.overlays = new ArrayList();
        this.setTextView(editor);
    }

    public /* synthetic */ AztecMediaSpan(Context context, Drawable drawable2, Attributes attributes, AztecText.OnMediaTappedListener onMediaTappedListener, AztecText aztecText, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            aztecText = null;
        }
        this(context, drawable2, attributes, onMediaTappedListener, aztecText);
    }
}

