/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.formatting.BlockFormatter$WhenMappings;
import org.wordpress.aztec.handlers.BlockHandler;
import org.wordpress.aztec.handlers.HeadingHandler;
import org.wordpress.aztec.handlers.ListItemHandler;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecNestable;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.ParagraphSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0018\u0018\u00002\u00020\u0001:\u0003PQRB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0016J\u001a\u0010%\u001a\u00020\"2\b\b\u0002\u0010&\u001a\u00020\u00162\b\b\u0002\u0010'\u001a\u00020\u0016J\"\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u00162\b\b\u0002\u0010'\u001a\u00020\u0016J\"\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u00162\b\b\u0002\u0010'\u001a\u00020\u0016J&\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0016J*\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00162\b\b\u0002\u0010&\u001a\u00020\u00162\b\b\u0002\u0010'\u001a\u00020\u0016J\"\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u00162\b\b\u0002\u0010'\u001a\u00020\u0016J\u0016\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0014002\u0006\u0010#\u001a\u00020\u001aJ\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016J*\u00106\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u00107\u001a\u000208H\u0002J(\u00109\u001a\u00020\u00122\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020 002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J&\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00140;2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00162\b\b\u0002\u00107\u001a\u000208J7\u0010<\u001a\u00020\u0014\"\u0010\b\u0000\u0010=*\n\u0012\u0006\b\u0001\u0012\u00020\u0014002\u0006\u0010>\u001a\u0002H=2\u0006\u0010-\u001a\u00020\u00162\b\b\u0002\u00107\u001a\u000208\u00a2\u0006\u0002\u0010?J \u0010<\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00162\b\b\u0002\u00107\u001a\u000208J6\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u00162\u0014\b\u0002\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0014000;2\b\b\u0002\u0010D\u001a\u00020\"J\u000e\u0010@\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001aJ\u000e\u0010E\u001a\u00020\u00122\u0006\u0010F\u001a\u00020\u0014J\"\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020\u001a2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J\"\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u001a2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J\u000e\u0010K\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010L\u001a\u00020\u0012J\u0006\u0010M\u001a\u00020\u0012J\u0006\u0010N\u001a\u00020\u0012J\u0006\u0010O\u001a\u00020\"R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006S"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "headerStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;)V", "getHeaderStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "applyBlock", "", "blockSpan", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "start", "", "end", "applyBlockStyle", "blockElementType", "Lorg/wordpress/aztec/TextFormat;", "applyHeadingBlock", "headingSpan", "Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "applyListBlock", "listSpan", "Lorg/wordpress/aztec/spans/AztecListSpan;", "containHeadingType", "", "textFormat", "index", "containQuote", "selStart", "selEnd", "containsHeading", "containsHeadingOnly", "containsList", "text", "Landroid/text/Editable;", "nestingLevel", "containsOtherHeadings", "getOuterBlockSpanType", "Ljava/lang/Class;", "getSelectedTextBounds", "Lkotlin/ranges/IntRange;", "editable", "selectionStart", "selectionEnd", "liftBlock", "attrs", "", "liftListBlock", "makeBlock", "", "makeBlockSpan", "T", "type", "(Ljava/lang/Class;ILjava/lang/String;)Lorg/wordpress/aztec/spans/AztecBlockSpan;", "removeBlockStyle", "originalStart", "originalEnd", "spanTypes", "ignoreLineBounds", "setBlockStyle", "blockElement", "switchHeaderType", "headerTypeToSwitchTo", "switchListType", "listTypeToSwitchTo", "toggleHeading", "toggleOrderedList", "toggleQuote", "toggleUnorderedList", "tryRemoveBlockStyleFromFirstLine", "HeaderStyle", "ListStyle", "QuoteStyle", "aztec_release"})
public final class BlockFormatter
extends AztecFormatter {
    @NotNull
    private final ListStyle listStyle;
    @NotNull
    private final QuoteStyle quoteStyle;
    @NotNull
    private final HeaderStyle headerStyle;

    public final void toggleOrderedList() {
        if (!BlockFormatter.containsList$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
            if (BlockFormatter.containsList$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
                BlockFormatter.switchListType$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(TextFormat.FORMAT_ORDERED_LIST);
        }
    }

    public final void toggleUnorderedList() {
        if (!BlockFormatter.containsList$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
            if (BlockFormatter.containsList$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
                BlockFormatter.switchListType$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(TextFormat.FORMAT_UNORDERED_LIST);
        }
    }

    public final void toggleQuote() {
        if (!BlockFormatter.containQuote$default(this, 0, 0, 3, null)) {
            BlockFormatter.applyBlockStyle$default(this, TextFormat.FORMAT_QUOTE, 0, 0, 6, null);
        } else {
            this.removeBlockStyle(TextFormat.FORMAT_QUOTE);
        }
    }

    public final void toggleHeading(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        if (!BlockFormatter.containsHeadingOnly$default(this, textFormat, 0, 0, 6, null)) {
            if (BlockFormatter.containsOtherHeadings$default(this, textFormat, 0, 0, 6, null)) {
                BlockFormatter.switchHeaderType$default(this, textFormat, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, textFormat, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(textFormat);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryRemoveBlockStyleFromFirstLine() {
        void changed;
        int selectionStart = this.getEditor().getSelectionStart();
        if (selectionStart != 0) {
            return false;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Object[] $receiver$iv = this.getEditableText().getSpans(0, 0, AztecBlockSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            int indexOfNewline;
            Object element$iv = $receiver$iv[i];
            AztecBlockSpan it = (AztecBlockSpan)element$iv;
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            int n = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)'\n', (int)0, (boolean)false, (int)6, null);
            int it2 = n;
            int n2 = indexOfNewline = it2 != -1 ? it2 : this.getEditableText().length();
            if (spanEnd <= indexOfNewline + 1) {
                this.getEditableText().removeSpan((Object)it);
                changed.element = true;
                continue;
            }
            this.getEditableText().setSpan((Object)it, indexOfNewline + 1, spanEnd, this.getEditableText().getSpanFlags((Object)it));
            changed.element = true;
        }
        return changed.element;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(@NotNull TextFormat textFormat) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Iterable iterable = BlockFormatter.makeBlock$default(this, textFormat, 0, null, 4, null);
        int n = this.getSelectionEnd();
        int n2 = this.getSelectionStart();
        BlockFormatter blockFormatter = this;
        void var3_6 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            AztecBlockSpan aztecBlockSpan = (AztecBlockSpan)item$iv$iv;
            list = destination$iv$iv;
            Class<?> clazz = it.getClass();
            list.add(clazz);
        }
        list = (List)destination$iv$iv;
        BlockFormatter.removeBlockStyle$default(blockFormatter, n2, n, list, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(int originalStart, int originalEnd, @NotNull List<Class<AztecBlockSpan>> spanTypes, boolean ignoreLineBounds) {
        void $receiver$iv;
        Object spanType;
        Object endOfBounds;
        Object startOfBounds;
        AztecBlockSpan span;
        void $receiver$iv2;
        Object end;
        Object start;
        Intrinsics.checkParameterIsNotNull(spanTypes, (String)"spanTypes");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = originalStart;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = originalEnd;
        IntRange boundsOfSelectedText = ignoreLineBounds ? new IntRange(start.element, end.element) : this.getSelectedTextBounds(this.getEditableText(), start.element, end.element);
        Ref.IntRef intRef3 = new Ref.IntRef();
        intRef3.element = boundsOfSelectedText.getStart();
        Ref.IntRef intRef4 = new Ref.IntRef();
        intRef4.element = boundsOfSelectedText.getEndInclusive();
        if (ignoreLineBounds) {
            boolean hasExtendingBeyondSpans;
            block16: {
                boolean bl;
                void $receiver$iv3;
                boolean hasPrecedingSpans;
                block14: {
                    boolean bl2;
                    void $receiver$iv4;
                    Iterable iterable = spanTypes;
                    for (Object element$iv : $receiver$iv4) {
                        boolean bl3;
                        block13: {
                            Class spanType2 = (Class)element$iv;
                            Object[] objectArray = this.getEditableText().getSpans(start.element, end.element, spanType2);
                            for (int i = 0; i < ((void)$receiver$iv2).length; ++i) {
                                void element$iv2 = $receiver$iv2[i];
                                span = (AztecBlockSpan)element$iv2;
                                if (!(this.getEditableText().getSpanStart((Object)span) < startOfBounds.element)) continue;
                                bl3 = true;
                                break block13;
                            }
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = hasPrecedingSpans = false;
                }
                if (hasPrecedingSpans && this.getEditableText().charAt(startOfBounds.element - 1) != Constants.INSTANCE.getNEWLINE()) {
                    this.getEditableText().insert(startOfBounds.element, (CharSequence)("" + Constants.INSTANCE.getNEWLINE()));
                    int $receiver$iv4 = start.element;
                    start.element = $receiver$iv4 + 1;
                    $receiver$iv4 = end.element;
                    end.element = $receiver$iv4 + 1;
                    $receiver$iv4 = startOfBounds.element;
                    startOfBounds.element = $receiver$iv4 + 1;
                    $receiver$iv4 = endOfBounds.element;
                    endOfBounds.element = $receiver$iv4 + 1;
                }
                Iterable iterable = spanTypes;
                for (Object element$iv : $receiver$iv3) {
                    boolean bl4;
                    block15: {
                        void $receiver$iv5;
                        spanType = (Class)element$iv;
                        Object[] objectArray = this.getEditableText().getSpans(start.element, end.element, (Class)spanType);
                        for (int element$iv2 = 0; element$iv2 < ((void)$receiver$iv5).length; ++element$iv2) {
                            void element$iv3 = $receiver$iv5[element$iv2];
                            AztecBlockSpan span2 = (AztecBlockSpan)element$iv3;
                            if (!(endOfBounds.element < this.getEditableText().getSpanEnd((Object)span2))) continue;
                            bl4 = true;
                            break block15;
                        }
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block16;
                }
                bl = hasExtendingBeyondSpans = false;
            }
            if (hasExtendingBeyondSpans && this.getEditableText().charAt(endOfBounds.element) != Constants.INSTANCE.getNEWLINE()) {
                this.getEditableText().insert(endOfBounds.element, (CharSequence)("" + Constants.INSTANCE.getNEWLINE()));
                int $receiver$iv3 = end.element;
                end.element = $receiver$iv3 + 1;
                $receiver$iv3 = endOfBounds.element;
                endOfBounds.element = $receiver$iv3 + 1;
                if (this.getSelectionEnd() == endOfBounds.element) {
                    this.getEditor().setSelection(this.getSelectionStart() != this.getSelectionEnd() ? this.getSelectionStart() : this.getSelectionEnd() - 1, this.getSelectionEnd() - 1);
                }
            }
        }
        Iterable hasPrecedingSpans = spanTypes;
        for (Object element$iv : $receiver$iv) {
            Class spanType3 = (Class)element$iv;
            AztecBlockSpan[] spans = (AztecBlockSpan[])this.getEditableText().getSpans(start.element, end.element, spanType3);
            spanType = spans;
            for (int i = 0; i < ((void)$receiver$iv2).length; ++i) {
                boolean spanExtendsBeyondLine;
                void element$iv4 = $receiver$iv2[i];
                span = (AztecBlockSpan)element$iv4;
                int spanStart = this.getEditableText().getSpanStart((Object)span);
                int spanEnd = this.getEditableText().getSpanEnd((Object)span);
                boolean spanPrecedesLine = spanStart < startOfBounds.element;
                boolean bl = spanExtendsBeyondLine = endOfBounds.element < spanEnd;
                if (spanPrecedesLine && !spanExtendsBeyondLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    AztecBlockSpan aztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, aztecBlockSpan, spanStart, startOfBounds.element);
                    continue;
                }
                if (spanExtendsBeyondLine && !spanPrecedesLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    AztecBlockSpan aztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, aztecBlockSpan, endOfBounds.element, spanEnd);
                    continue;
                }
                if (spanPrecedesLine && spanExtendsBeyondLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    AztecBlockSpan aztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, aztecBlockSpan, spanStart, startOfBounds.element);
                    BlockHandler.Companion.set((Spannable)this.getEditableText(), this.makeBlockSpan(span.getClass(), span.getNestingLevel(), span.getAttributes()), endOfBounds.element, spanEnd);
                    continue;
                }
                this.getEditableText().removeSpan((Object)span);
            }
        }
        endOfBounds = null;
        startOfBounds = null;
        end = null;
        start = null;
    }

    public static /* bridge */ /* synthetic */ void removeBlockStyle$default(BlockFormatter blockFormatter, int n, int n2, List list, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeBlockStyle");
        }
        if ((n3 & 4) != 0) {
            List<Class> list2 = Arrays.asList(AztecBlockSpan.class);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(AztecBlockSpan::class.java)");
            list = list2;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        blockFormatter.removeBlockStyle(n, n2, (List<Class<AztecBlockSpan>>)list, bl);
    }

    @NotNull
    public final Class<? extends AztecBlockSpan> getOuterBlockSpanType(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        switch (BlockFormatter$WhenMappings.$EnumSwitchMapping$0[textFormat.ordinal()]) {
            case 1: {
                return AztecOrderedListSpan.class;
            }
            case 2: {
                return AztecUnorderedListSpan.class;
            }
            case 3: {
                return AztecQuoteSpan.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return AztecHeadingSpan.class;
            }
        }
        return ParagraphSpan.class;
    }

    @NotNull
    public final List<AztecBlockSpan> makeBlock(@NotNull TextFormat textFormat, int nestingLevel, @NotNull String attrs) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        switch (BlockFormatter$WhenMappings.$EnumSwitchMapping$1[textFormat.ordinal()]) {
            case 1: {
                List<AztecBlockSpan> list = Arrays.asList(new AztecOrderedListSpan(nestingLevel, attrs, this.listStyle), new AztecListItemSpan(nestingLevel + 1, null, 2, null));
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecOrder\u2026emSpan(nestingLevel + 1))");
                return list;
            }
            case 2: {
                List<AztecBlockSpan> list = Arrays.asList(new AztecUnorderedListSpan(nestingLevel, attrs, this.listStyle), new AztecListItemSpan(nestingLevel + 1, null, 2, null));
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecUnord\u2026emSpan(nestingLevel + 1))");
                return list;
            }
            case 3: {
                List<AztecBlockSpan> list = Arrays.asList(new AztecQuoteSpan(nestingLevel, attrs, this.quoteStyle));
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecQuote\u2026evel, attrs, quoteStyle))");
                return list;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                List<AztecBlockSpan> list = Arrays.asList(new AztecHeadingSpan(nestingLevel, textFormat, "", this.headerStyle));
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecHeadi\u2026Format, \"\", headerStyle))");
                return list;
            }
        }
        List<AztecBlockSpan> list = Arrays.asList(new ParagraphSpan(nestingLevel, attrs));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(ParagraphSpan(nestingLevel, attrs))");
        return list;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List makeBlock$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeBlock");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return blockFormatter.makeBlock(textFormat, n, string2);
    }

    @NotNull
    public final AztecBlockSpan makeBlockSpan(@NotNull TextFormat textFormat, int nestingLevel, @NotNull String attrs) {
        AztecBlockSpan aztecBlockSpan;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        switch (BlockFormatter$WhenMappings.$EnumSwitchMapping$2[textFormat.ordinal()]) {
            case 1: {
                aztecBlockSpan = this.makeBlockSpan(AztecOrderedListSpan.class, nestingLevel, attrs);
                break;
            }
            case 2: {
                aztecBlockSpan = this.makeBlockSpan(AztecUnorderedListSpan.class, nestingLevel, attrs);
                break;
            }
            case 3: {
                aztecBlockSpan = this.makeBlockSpan(AztecQuoteSpan.class, nestingLevel, attrs);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return new AztecHeadingSpan(nestingLevel, textFormat, "", this.headerStyle);
            }
            default: {
                aztecBlockSpan = new ParagraphSpan(nestingLevel, attrs);
            }
        }
        return aztecBlockSpan;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeBlockSpan");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return blockFormatter.makeBlockSpan(textFormat, n, string2);
    }

    @NotNull
    public final <T extends Class<? extends AztecBlockSpan>> AztecBlockSpan makeBlockSpan(@NotNull T type, int nestingLevel, @NotNull String attrs) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        T t = type;
        return Intrinsics.areEqual(t, AztecOrderedListSpan.class) ? (AztecBlockSpan)new AztecOrderedListSpan(nestingLevel, attrs, this.listStyle) : (Intrinsics.areEqual(t, AztecUnorderedListSpan.class) ? (AztecBlockSpan)new AztecUnorderedListSpan(nestingLevel, attrs, this.listStyle) : (Intrinsics.areEqual(t, AztecListItemSpan.class) ? (AztecBlockSpan)new AztecListItemSpan(nestingLevel, attrs) : (Intrinsics.areEqual(t, AztecQuoteSpan.class) ? (AztecBlockSpan)new AztecQuoteSpan(nestingLevel, attrs, null, 4, null) : (Intrinsics.areEqual(t, AztecHeadingSpan.class) ? (AztecBlockSpan)new AztecHeadingSpan(nestingLevel, attrs, null, null, 12, null) : (AztecBlockSpan)new ParagraphSpan(nestingLevel, attrs)))));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, Class clazz, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeBlockSpan");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return blockFormatter.makeBlockSpan(clazz, n, string2);
    }

    public final void setBlockStyle(@NotNull AztecBlockSpan blockElement) {
        Intrinsics.checkParameterIsNotNull((Object)blockElement, (String)"blockElement");
        AztecBlockSpan aztecBlockSpan = blockElement;
        if (aztecBlockSpan instanceof AztecOrderedListSpan) {
            ((AztecOrderedListSpan)blockElement).setListStyle(this.listStyle);
        } else if (aztecBlockSpan instanceof AztecUnorderedListSpan) {
            ((AztecUnorderedListSpan)blockElement).setListStyle(this.listStyle);
        } else if (aztecBlockSpan instanceof AztecQuoteSpan) {
            ((AztecQuoteSpan)blockElement).setQuoteStyle(this.quoteStyle);
        } else if (aztecBlockSpan instanceof AztecHeadingSpan) {
            ((AztecHeadingSpan)blockElement).setHeaderStyle(this.headerStyle);
        }
    }

    @NotNull
    public final IntRange getSelectedTextBounds(@NotNull Editable editable, int selectionStart, int selectionEnd) {
        char characterBeforeLastLineBreak;
        Intrinsics.checkParameterIsNotNull((Object)editable, (String)"editable");
        int indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionEnd, (boolean)false, (int)4, null);
        int indexOfFirstLineBreak = indexOfLastLineBreak > 0 ? ((characterBeforeLastLineBreak = editable.charAt(indexOfLastLineBreak - 1)) != '\n' ? StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null)) : (indexOfLastLineBreak == -1 ? StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null) + 1 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null));
        int startOfLine = indexOfFirstLineBreak != -1 ? indexOfFirstLineBreak : 0;
        int endOfLine = indexOfLastLineBreak != -1 ? indexOfLastLineBreak + 1 : editable.length();
        return new IntRange(startOfLine, endOfLine);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyBlockStyle(@NotNull TextFormat blockElementType, int start, int end) {
        block16: {
            int endOfBlock;
            int startOfBlock;
            AztecBlockSpan spanToApply;
            int endOfLine;
            int startOfLine;
            block19: {
                AztecBlockSpan spanOnNextLine;
                block20: {
                    block17: {
                        AztecBlockSpan spansOnPreviousLine;
                        block18: {
                            block15: {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)blockElementType), (String)"blockElementType");
                                if (start == end) break block15;
                                int nestingLevel = AztecNestable.Companion.getNestingLevelAt$default(AztecNestable.Companion, (Spanned)this.getEditableText(), start, 0, 4, null);
                                if (AztecNestable.Companion.getNestingLevelAt$default(AztecNestable.Companion, (Spanned)this.getEditableText(), end, 0, 4, null) != nestingLevel) {
                                    return;
                                }
                                int indexOfFirstLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (String)"\n", (int)end, (boolean)false, (int)4, null);
                                int endOfBlock2 = indexOfFirstLineBreak != -1 ? indexOfFirstLineBreak : this.getEditableText().length();
                                int startOfBlock2 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)this.getEditableText()), (String)"\n", (int)start, (boolean)false, (int)4, null);
                                CharSequence charSequence = StringsKt.subSequence((CharSequence)((CharSequence)this.getEditableText()), (IntRange)new IntRange(startOfBlock2 + 1, endOfBlock2 - 1));
                                if (charSequence == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type android.text.Editable");
                                }
                                Editable selectedLines = (Editable)charSequence;
                                int numberOfLinesWithSpanApplied = 0;
                                int numberOfLines = 0;
                                int n = 0;
                                String[] lines = TextUtils.split((String)selectedLines.toString(), (String)"\n");
                                int n2 = lines.length - 1;
                                if (n <= n2) {
                                    while (true) {
                                        void i;
                                        ++numberOfLines;
                                        if (this.containsList(blockElementType, (int)i, selectedLines, nestingLevel)) {
                                            ++numberOfLinesWithSpanApplied;
                                        }
                                        if (i == n2) break;
                                        ++i;
                                    }
                                }
                                if (numberOfLines == numberOfLinesWithSpanApplied) {
                                    this.removeBlockStyle(blockElementType);
                                } else {
                                    this.applyBlock(BlockFormatter.makeBlockSpan$default(this, blockElementType, nestingLevel, null, 4, null), startOfBlock2 + 1, endOfBlock2 == this.getEditableText().length() ? endOfBlock2 : endOfBlock2 + 1);
                                }
                                break block16;
                            }
                            IntRange boundsOfSelectedText = this.getSelectedTextBounds(this.getEditableText(), start, end);
                            startOfLine = boundsOfSelectedText.getStart();
                            endOfLine = boundsOfSelectedText.getEndInclusive();
                            int nestingLevel = AztecNestable.Companion.getNestingLevelAt$default(AztecNestable.Companion, (Spanned)this.getEditableText(), start, 0, 4, null) + 1;
                            spanToApply = BlockFormatter.makeBlockSpan$default(this, blockElementType, nestingLevel, null, 4, null);
                            startOfBlock = startOfLine;
                            endOfBlock = endOfLine;
                            if (startOfLine == 0 || (spansOnPreviousLine = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(startOfLine - 1, startOfLine - 1, spanToApply.getClass()))) == null) break block17;
                            if (!(spansOnPreviousLine instanceof AztecHeadingSpan)) break block18;
                            AztecBlockSpan aztecBlockSpan = spanToApply;
                            if (aztecBlockSpan == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecHeadingSpan");
                            }
                            if (!Intrinsics.areEqual((Object)((Object)((AztecHeadingSpan)spansOnPreviousLine).getHeading()), (Object)((Object)((AztecHeadingSpan)aztecBlockSpan).getHeading()))) break block17;
                        }
                        startOfBlock = this.getEditableText().getSpanStart((Object)spansOnPreviousLine);
                        BlockFormatter.liftBlock$default(this, blockElementType, startOfBlock, endOfBlock, null, 8, null);
                    }
                    if (endOfLine == this.getEditableText().length() || (spanOnNextLine = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(endOfLine + 1, endOfLine + 1, spanToApply.getClass()))) == null) break block19;
                    if (!(spanOnNextLine instanceof AztecHeadingSpan)) break block20;
                    AztecBlockSpan aztecBlockSpan = spanToApply;
                    if (aztecBlockSpan == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecHeadingSpan");
                    }
                    if (!Intrinsics.areEqual((Object)((Object)((AztecHeadingSpan)spanOnNextLine).getHeading()), (Object)((Object)((AztecHeadingSpan)aztecBlockSpan).getHeading()))) break block19;
                }
                endOfBlock = this.getEditableText().getSpanEnd((Object)spanOnNextLine);
                BlockFormatter.liftBlock$default(this, blockElementType, startOfBlock, endOfBlock, null, 8, null);
            }
            this.applyBlock(spanToApply, startOfBlock, endOfBlock);
            this.getEditor().onSelectionChanged(startOfLine, endOfLine);
        }
    }

    public static /* bridge */ /* synthetic */ void applyBlockStyle$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyBlockStyle");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.applyBlockStyle(textFormat, n, n2);
    }

    private final void applyBlock(AztecBlockSpan blockSpan, int start, int end) {
        AztecBlockSpan aztecBlockSpan = blockSpan;
        if (aztecBlockSpan instanceof AztecOrderedListSpan) {
            this.applyListBlock((AztecListSpan)blockSpan, start, end);
        } else if (aztecBlockSpan instanceof AztecUnorderedListSpan) {
            this.applyListBlock((AztecListSpan)blockSpan, start, end);
        } else if (aztecBlockSpan instanceof AztecQuoteSpan) {
            BlockHandler.Companion.set((Spannable)this.getEditableText(), blockSpan, start, end);
        } else if (aztecBlockSpan instanceof AztecHeadingSpan) {
            this.applyHeadingBlock((AztecHeadingSpan)blockSpan, start, end);
        } else {
            this.getEditableText().setSpan((Object)blockSpan, start, end, 51);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyListBlock(AztecListSpan listSpan, int start, int end) {
        BlockHandler.Companion.set((Spannable)this.getEditableText(), listSpan, start, end);
        CharSequence charSequence = (CharSequence)this.getEditableText();
        String[] lines = TextUtils.split((String)((Object)charSequence.subSequence(start, end)).toString(), (String)"\n");
        int n = 0;
        int n2 = lines.length - 1;
        if (n <= n2) {
            while (true) {
                int lineEnd;
                void $receiver$iv;
                void i;
                int lineLength = lines[i].length();
                Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n3 = element$iv = ((IntIterator)iterator).nextInt();
                    int n4 = sum$iv;
                    int n5 = lines[it].length() + 1;
                    sum$iv = n4 + n5;
                }
                int lineStart = sum$iv;
                int n6 = lineStart + lineLength;
                int it = n6;
                int n7 = lineEnd = start + it != this.getEditableText().length() ? it + 1 : it;
                if (lineLength != 0) {
                    ListItemHandler.Companion.newListItem((Spannable)this.getEditableText(), start + lineStart, start + lineEnd, listSpan.getNestingLevel() + 1);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyHeadingBlock(AztecHeadingSpan headingSpan, int start, int end) {
        CharSequence charSequence = (CharSequence)this.getEditableText();
        int n = 0;
        String[] lines = TextUtils.split((String)((Object)charSequence.subSequence(start, end)).toString(), (String)"\n");
        int n2 = lines.length - 1;
        if (n <= n2) {
            while (true) {
                int n3;
                void $receiver$iv;
                void i;
                int splitLength = lines[i].length();
                Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                int n4 = start;
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n5 = element$iv = ((IntIterator)iterator).nextInt();
                    n3 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n3 + n6;
                }
                n3 = sum$iv;
                int lineStart = n4 + n3;
                int lineEnd = Math.min(lineStart + splitLength + 1, end);
                int lineLength = lineEnd - lineStart;
                if (lineLength != 0) {
                    HeadingHandler.Companion.cloneHeading((Spannable)this.getEditableText(), headingSpan, lineStart, lineEnd);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void liftBlock(TextFormat textFormat, int start, int end, String attrs) {
        switch (BlockFormatter$WhenMappings.$EnumSwitchMapping$3[textFormat.ordinal()]) {
            case 1: {
                this.liftListBlock(AztecOrderedListSpan.class, start, end);
                break;
            }
            case 2: {
                this.liftListBlock(AztecUnorderedListSpan.class, start, end);
                break;
            }
            case 3: {
                void $receiver$iv;
                Object[] objectArray = this.getEditableText().getSpans(start, end, AztecQuoteSpan.class);
                for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                    void element$iv = $receiver$iv[i];
                    AztecQuoteSpan it = (AztecQuoteSpan)element$iv;
                    this.getEditableText().removeSpan((Object)it);
                }
                break;
            }
            default: {
                Object[] $receiver$iv = this.getEditableText().getSpans(start, end, ParagraphSpan.class);
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    ParagraphSpan it = (ParagraphSpan)element$iv;
                    this.getEditableText().removeSpan((Object)it);
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void liftBlock$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, String string2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: liftBlock");
        }
        if ((n3 & 8) != 0) {
            string2 = "";
        }
        blockFormatter.liftBlock(textFormat, n, n2, string2);
    }

    private final void liftListBlock(Class<? extends AztecListSpan> listSpan, int start, int end) {
        AztecBlockSpan it;
        Object element$iv;
        Object[] $receiver$iv;
        int n;
        Object[] objectArray = this.getEditableText().getSpans(start, end, listSpan);
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (AztecListSpan)element$iv;
            this.getEditableText().removeSpan((Object)it);
        }
        $receiver$iv = this.getEditableText().getSpans(start, end, AztecListItemSpan.class);
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (AztecListItemSpan)element$iv;
            this.getEditableText().removeSpan((Object)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsList(@NotNull TextFormat textFormat, int nestingLevel, int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart <= lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containsList(textFormat, it, this.getEditableText(), nestingLevel)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containsList$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containsList");
        }
        if ((n4 & 4) != 0) {
            n2 = blockFormatter.getSelectionStart();
        }
        if ((n4 & 8) != 0) {
            n3 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsList(textFormat, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsList(@NotNull TextFormat textFormat, int index, @NotNull Editable text, int nestingLevel) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String[] lines = TextUtils.split((String)text.toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)objectArray).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start > end) {
            return false;
        }
        AztecBlockSpan[] spans = (AztecBlockSpan[])this.getEditableText().getSpans(start, end, BlockFormatter.makeBlockSpan$default(this, textFormat, nestingLevel, null, 4, null).getClass());
        objectArray = spans;
        Object[] objectArray2 = objectArray;
        return !(objectArray2.length == 0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containQuote(int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containQuote(it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containQuote$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containQuote");
        }
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containQuote(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containQuote(int index) {
        void $receiver$iv;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)objectArray).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        AztecQuoteSpan[] spans = (AztecQuoteSpan[])this.getEditableText().getSpans(start, end, AztecQuoteSpan.class);
        objectArray = spans;
        Object[] objectArray2 = objectArray;
        return !(objectArray2.length == 0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(@NotNull TextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containHeadingType(textFormat, it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containsHeading$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containsHeading");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsHeading(textFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containHeadingType(TextFormat textFormat, int index) {
        void $receiver$iv;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        int n = 0;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        if (n < spans.length) {
            AztecHeadingSpan span = spans[n];
            switch (BlockFormatter$WhenMappings.$EnumSwitchMapping$4[textFormat.ordinal()]) {
                case 1: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H1));
                }
                case 2: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H2));
                }
                case 3: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H3));
                }
                case 4: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H4));
                }
                case 5: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H5));
                }
                case 6: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H6));
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsOtherHeadings(@NotNull TextFormat textFormat, int selStart, int selEnd) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object[] elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        TextFormat[] textFormatArray = new TextFormat[]{TextFormat.FORMAT_HEADING_1, TextFormat.FORMAT_HEADING_2, TextFormat.FORMAT_HEADING_3, TextFormat.FORMAT_HEADING_4, TextFormat.FORMAT_HEADING_5, TextFormat.FORMAT_HEADING_6};
        elements$iv = elements$iv;
        Iterator iterator = $receiver$iv;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            TextFormat it = (TextFormat)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)((Object)it), (Object)((Object)textFormat)) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            TextFormat it = (TextFormat)((Object)element$iv);
            if (!this.containsHeading(it, selStart, selEnd)) continue;
            return true;
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean containsOtherHeadings$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containsOtherHeadings");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsOtherHeadings(textFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsHeadingOnly(@NotNull TextFormat textFormat, int selStart, int selEnd) {
        Object element$iv;
        TextFormat it;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object[] elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        TextFormat[] textFormatArray = new TextFormat[]{TextFormat.FORMAT_HEADING_1, TextFormat.FORMAT_HEADING_2, TextFormat.FORMAT_HEADING_3, TextFormat.FORMAT_HEADING_4, TextFormat.FORMAT_HEADING_5, TextFormat.FORMAT_HEADING_6};
        elements$iv = elements$iv;
        Iterator iterator = $receiver$iv;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            TextFormat it2 = (TextFormat)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)((Object)it2), (Object)((Object)textFormat)) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherHeadings = (List)destination$iv$iv;
        if (!this.containsHeading(textFormat, selStart, selEnd)) return false;
        $receiver$iv = otherHeadings;
        iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (!this.containsHeading(it = (TextFormat)((Object)(element$iv = iterator.next())), selStart, selEnd));
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean containsHeadingOnly$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containsHeadingOnly");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsHeadingOnly(textFormat, n, n2);
    }

    public final void switchListType(@NotNull TextFormat listTypeToSwitchTo, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)listTypeToSwitchTo), (String)"listTypeToSwitchTo");
        AztecListSpan existingListSpan = (AztecListSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(start, end, AztecListSpan.class));
        if (existingListSpan != null) {
            int spanStart = this.getEditableText().getSpanStart((Object)existingListSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingListSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingListSpan);
            this.getEditableText().removeSpan((Object)existingListSpan);
            this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, listTypeToSwitchTo, existingListSpan.getNestingLevel(), null, 4, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchListType$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchListType");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchListType(textFormat, n, n2);
    }

    public final void switchHeaderType(@NotNull TextFormat headerTypeToSwitchTo, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)headerTypeToSwitchTo), (String)"headerTypeToSwitchTo");
        AztecHeadingSpan existingHeaderSpan = (AztecHeadingSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class));
        if (existingHeaderSpan != null) {
            int spanStart = this.getEditableText().getSpanStart((Object)existingHeaderSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingHeaderSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingHeaderSpan);
            existingHeaderSpan.setTextFormat(headerTypeToSwitchTo);
            this.getEditableText().setSpan((Object)existingHeaderSpan, spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchHeaderType$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchHeaderType");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchHeaderType(textFormat, n, n2);
    }

    @NotNull
    public final ListStyle getListStyle() {
        return this.listStyle;
    }

    @NotNull
    public final QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    @NotNull
    public final HeaderStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public BlockFormatter(@NotNull AztecText editor, @NotNull ListStyle listStyle, @NotNull QuoteStyle quoteStyle, @NotNull HeaderStyle headerStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"headerStyle");
        super(editor);
        this.listStyle = listStyle;
        this.quoteStyle = quoteStyle;
        this.headerStyle = headerStyle;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "", "indicatorColor", "", "indicatorMargin", "indicatorPadding", "indicatorWidth", "verticalPadding", "(IIIII)V", "getIndicatorColor", "()I", "getIndicatorMargin", "getIndicatorPadding", "getIndicatorWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "copy", "aztec_release"})
    public static final class ListStyle {
        private final int indicatorColor;
        private final int indicatorMargin;
        private final int indicatorPadding;
        private final int indicatorWidth;
        private final int verticalPadding;

        public final int getIndicatorColor() {
            return this.indicatorColor;
        }

        public final int getIndicatorMargin() {
            return this.indicatorMargin;
        }

        public final int getIndicatorPadding() {
            return this.indicatorPadding;
        }

        public final int getIndicatorWidth() {
            return this.indicatorWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public ListStyle(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            this.indicatorColor = indicatorColor;
            this.indicatorMargin = indicatorMargin;
            this.indicatorPadding = indicatorPadding;
            this.indicatorWidth = indicatorWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.indicatorColor;
        }

        public final int component2() {
            return this.indicatorMargin;
        }

        public final int component3() {
            return this.indicatorPadding;
        }

        public final int component4() {
            return this.indicatorWidth;
        }

        public final int component5() {
            return this.verticalPadding;
        }

        @NotNull
        public final ListStyle copy(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            return new ListStyle(indicatorColor, indicatorMargin, indicatorPadding, indicatorWidth, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ListStyle copy$default(ListStyle listStyle, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n6 & 1) != 0) {
                n = listStyle.indicatorColor;
            }
            if ((n6 & 2) != 0) {
                n2 = listStyle.indicatorMargin;
            }
            if ((n6 & 4) != 0) {
                n3 = listStyle.indicatorPadding;
            }
            if ((n6 & 8) != 0) {
                n4 = listStyle.indicatorWidth;
            }
            if ((n6 & 0x10) != 0) {
                n5 = listStyle.verticalPadding;
            }
            return listStyle.copy(n, n2, n3, n4, n5);
        }

        public String toString() {
            return "ListStyle(indicatorColor=" + this.indicatorColor + ", indicatorMargin=" + this.indicatorMargin + ", indicatorPadding=" + this.indicatorPadding + ", indicatorWidth=" + this.indicatorWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((this.indicatorColor * 31 + this.indicatorMargin) * 31 + this.indicatorPadding) * 31 + this.indicatorWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListStyle)) break block3;
                    ListStyle listStyle = (ListStyle)object;
                    if (!(this.indicatorColor == listStyle.indicatorColor) || !(this.indicatorMargin == listStyle.indicatorMargin) || !(this.indicatorPadding == listStyle.indicatorPadding) || !(this.indicatorWidth == listStyle.indicatorWidth) || !(this.verticalPadding == listStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "", "quoteBackground", "", "quoteColor", "quoteBackgroundAlpha", "", "quoteMargin", "quotePadding", "quoteWidth", "verticalPadding", "(IIFIIII)V", "getQuoteBackground", "()I", "getQuoteBackgroundAlpha", "()F", "getQuoteColor", "getQuoteMargin", "getQuotePadding", "getQuoteWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "aztec_release"})
    public static final class QuoteStyle {
        private final int quoteBackground;
        private final int quoteColor;
        private final float quoteBackgroundAlpha;
        private final int quoteMargin;
        private final int quotePadding;
        private final int quoteWidth;
        private final int verticalPadding;

        public final int getQuoteBackground() {
            return this.quoteBackground;
        }

        public final int getQuoteColor() {
            return this.quoteColor;
        }

        public final float getQuoteBackgroundAlpha() {
            return this.quoteBackgroundAlpha;
        }

        public final int getQuoteMargin() {
            return this.quoteMargin;
        }

        public final int getQuotePadding() {
            return this.quotePadding;
        }

        public final int getQuoteWidth() {
            return this.quoteWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public QuoteStyle(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            this.quoteBackground = quoteBackground;
            this.quoteColor = quoteColor;
            this.quoteBackgroundAlpha = quoteBackgroundAlpha;
            this.quoteMargin = quoteMargin;
            this.quotePadding = quotePadding;
            this.quoteWidth = quoteWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.quoteBackground;
        }

        public final int component2() {
            return this.quoteColor;
        }

        public final float component3() {
            return this.quoteBackgroundAlpha;
        }

        public final int component4() {
            return this.quoteMargin;
        }

        public final int component5() {
            return this.quotePadding;
        }

        public final int component6() {
            return this.quoteWidth;
        }

        public final int component7() {
            return this.verticalPadding;
        }

        @NotNull
        public final QuoteStyle copy(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            return new QuoteStyle(quoteBackground, quoteColor, quoteBackgroundAlpha, quoteMargin, quotePadding, quoteWidth, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QuoteStyle copy$default(QuoteStyle quoteStyle, int n, int n2, float f, int n3, int n4, int n5, int n6, int n7, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n7 & 1) != 0) {
                n = quoteStyle.quoteBackground;
            }
            if ((n7 & 2) != 0) {
                n2 = quoteStyle.quoteColor;
            }
            if ((n7 & 4) != 0) {
                f = quoteStyle.quoteBackgroundAlpha;
            }
            if ((n7 & 8) != 0) {
                n3 = quoteStyle.quoteMargin;
            }
            if ((n7 & 0x10) != 0) {
                n4 = quoteStyle.quotePadding;
            }
            if ((n7 & 0x20) != 0) {
                n5 = quoteStyle.quoteWidth;
            }
            if ((n7 & 0x40) != 0) {
                n6 = quoteStyle.verticalPadding;
            }
            return quoteStyle.copy(n, n2, f, n3, n4, n5, n6);
        }

        public String toString() {
            return "QuoteStyle(quoteBackground=" + this.quoteBackground + ", quoteColor=" + this.quoteColor + ", quoteBackgroundAlpha=" + this.quoteBackgroundAlpha + ", quoteMargin=" + this.quoteMargin + ", quotePadding=" + this.quotePadding + ", quoteWidth=" + this.quoteWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((((this.quoteBackground * 31 + this.quoteColor) * 31 + Float.floatToIntBits(this.quoteBackgroundAlpha)) * 31 + this.quoteMargin) * 31 + this.quotePadding) * 31 + this.quoteWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QuoteStyle)) break block3;
                    QuoteStyle quoteStyle = (QuoteStyle)object;
                    if (!(this.quoteBackground == quoteStyle.quoteBackground) || !(this.quoteColor == quoteStyle.quoteColor) || Float.compare(this.quoteBackgroundAlpha, quoteStyle.quoteBackgroundAlpha) != 0 || !(this.quoteMargin == quoteStyle.quoteMargin) || !(this.quotePadding == quoteStyle.quotePadding) || !(this.quoteWidth == quoteStyle.quoteWidth) || !(this.verticalPadding == quoteStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "", "verticalPadding", "", "(I)V", "getVerticalPadding", "()I", "component1", "copy", "aztec_release"})
    public static final class HeaderStyle {
        private final int verticalPadding;

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public HeaderStyle(int verticalPadding) {
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.verticalPadding;
        }

        @NotNull
        public final HeaderStyle copy(int verticalPadding) {
            return new HeaderStyle(verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ HeaderStyle copy$default(HeaderStyle headerStyle, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                n = headerStyle.verticalPadding;
            }
            return headerStyle.copy(n);
        }

        public String toString() {
            return "HeaderStyle(verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HeaderStyle)) break block3;
                    HeaderStyle headerStyle = (HeaderStyle)object;
                    if (!(this.verticalPadding == headerStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

