/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.widget.TextView;
import java.util.Hashtable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/wordpress/aztec/util/TypefaceCache;", "", "()V", "TYPEFACE_DEJAVU_SANS_MONO", "", "getTYPEFACE_DEJAVU_SANS_MONO", "()Ljava/lang/String;", "TYPEFACE_MERRIWEATHER_REGULAR", "getTYPEFACE_MERRIWEATHER_REGULAR", "mTypefaceCache", "Ljava/util/Hashtable;", "Landroid/graphics/Typeface;", "getTypeface", "context", "Landroid/content/Context;", "typefaceName", "setCustomTypeface", "", "view", "Landroid/widget/TextView;", "aztec_release"})
public final class TypefaceCache {
    @NotNull
    private static final String TYPEFACE_DEJAVU_SANS_MONO = "DejaVuSansMono.ttf";
    @NotNull
    private static final String TYPEFACE_MERRIWEATHER_REGULAR = "Merriweather-Regular.ttf";
    private static final Hashtable<String, Typeface> mTypefaceCache;
    public static final TypefaceCache INSTANCE;

    @NotNull
    public final String getTYPEFACE_DEJAVU_SANS_MONO() {
        return TYPEFACE_DEJAVU_SANS_MONO;
    }

    @NotNull
    public final String getTYPEFACE_MERRIWEATHER_REGULAR() {
        return TYPEFACE_MERRIWEATHER_REGULAR;
    }

    @Nullable
    public final Typeface getTypeface(@NotNull Context context, @NotNull String typefaceName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)typefaceName, (String)"typefaceName");
        if (!mTypefaceCache.containsKey(typefaceName)) {
            Typeface typeface = null;
            try {
                typeface = Typeface.createFromAsset((AssetManager)context.getApplicationContext().getAssets(), (String)("fonts/" + typefaceName));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (typeface != null) {
                mTypefaceCache.put(typefaceName, typeface);
            }
        }
        return mTypefaceCache.get(typefaceName);
    }

    public final void setCustomTypeface(@NotNull Context context, @NotNull TextView view, @NotNull String typefaceName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)typefaceName, (String)"typefaceName");
        if (view.isInEditMode()) {
            return;
        }
        Typeface typeface = this.getTypeface(context, typefaceName);
        if (typeface != null) {
            view.setTypeface(typeface);
        }
    }

    private TypefaceCache() {
        INSTANCE = this;
        TYPEFACE_DEJAVU_SANS_MONO = TYPEFACE_DEJAVU_SANS_MONO;
        TYPEFACE_MERRIWEATHER_REGULAR = TYPEFACE_MERRIWEATHER_REGULAR;
        mTypefaceCache = new Hashtable();
    }

    static {
        new TypefaceCache();
    }
}

