/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.formatting.InlineFormatter;
import org.wordpress.aztec.spans.AztecContentSpan;
import org.wordpress.aztec.spans.AztecInlineSpan;
import org.wordpress.aztec.spans.AztecSpanIds;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u0012\u0010 \u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010!\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0013H\u0016R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0007R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/wordpress/aztec/spans/AztecCodeSpan;", "Landroid/text/style/MetricAffectingSpan;", "Landroid/text/ParcelableSpan;", "Lorg/wordpress/aztec/spans/AztecContentSpan;", "Lorg/wordpress/aztec/spans/AztecInlineSpan;", "attributes", "", "(Ljava/lang/String;)V", "codeStyle", "Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "(Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;Ljava/lang/String;)V", "src", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "TAG", "getAttributes", "()Ljava/lang/String;", "setAttributes", "codeBackground", "", "codeBackgroundAlpha", "", "codeColor", "configureTextPaint", "", "tp", "Landroid/text/TextPaint;", "describeContents", "getEndTag", "getSpanTypeId", "getSpanTypeIdInternal", "getStartTag", "updateDrawState", "updateMeasureState", "writeToParcel", "dest", "flags", "aztec_release"})
public final class AztecCodeSpan
extends MetricAffectingSpan
implements ParcelableSpan,
AztecContentSpan,
AztecInlineSpan {
    private final String TAG = "code";
    private int codeBackground;
    private float codeBackgroundAlpha;
    private int codeColor;
    @NotNull
    private String attributes;

    @Override
    @NotNull
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.attributes = string;
    }

    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    public final int getSpanTypeIdInternal() {
        return AztecSpanIds.CODE_SPAN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        dest.writeInt(this.codeBackground);
        dest.writeInt(this.codeColor);
    }

    @Override
    @NotNull
    public String getStartTag() {
        if (TextUtils.isEmpty((CharSequence)this.getAttributes())) {
            return this.TAG;
        }
        return this.TAG + this.getAttributes();
    }

    @Override
    @NotNull
    public String getEndTag() {
        return this.TAG;
    }

    public void updateDrawState(@Nullable TextPaint tp) {
        this.configureTextPaint(tp);
    }

    public void updateMeasureState(@Nullable TextPaint tp) {
        this.configureTextPaint(tp);
    }

    private final void configureTextPaint(TextPaint tp) {
        block2: {
            int alpha = (int)(this.codeBackgroundAlpha * (float)255);
            TextPaint textPaint = tp;
            if (textPaint != null) {
                textPaint.setTypeface(Typeface.MONOSPACE);
            }
            if (tp != null) {
                tp.bgColor = Color.argb((int)alpha, (int)Color.red((int)this.codeBackground), (int)Color.green((int)this.codeBackground), (int)Color.blue((int)this.codeBackground));
            }
            TextPaint textPaint2 = tp;
            if (textPaint2 == null) break block2;
            textPaint2.setColor(this.codeColor);
        }
    }

    public AztecCodeSpan(@NotNull String attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this.TAG = "code";
        this.attributes = "";
        this.setAttributes(attributes);
    }

    public /* synthetic */ AztecCodeSpan(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    public AztecCodeSpan(@NotNull InlineFormatter.CodeStyle codeStyle, @NotNull String attributes) {
        Intrinsics.checkParameterIsNotNull((Object)codeStyle, (String)"codeStyle");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this(attributes);
        this.codeBackground = codeStyle.getCodeBackground();
        this.codeBackgroundAlpha = codeStyle.getCodeBackgroundAlpha();
        this.codeColor = codeStyle.getCodeColor();
    }

    public /* synthetic */ AztecCodeSpan(InlineFormatter.CodeStyle codeStyle, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(codeStyle, string);
    }

    public AztecCodeSpan(@NotNull Parcel src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        this.TAG = "code";
        this.attributes = "";
        this.codeBackground = src.readInt();
        this.codeBackgroundAlpha = src.readFloat();
        this.codeColor = src.readInt();
    }
}

