/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.text.Spanned;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/wordpress/aztec/SpanLogger;", "", "()V", "logSpans", "", "text", "Landroid/text/Spanned;", "spaces", "count", "", "aztec_release"})
public final class SpanLogger {
    public static final SpanLogger INSTANCE;

    private final String spaces(int count) {
        String string = TextUtils.join((CharSequence)"", (Iterable)Collections.nCopies(count, " "));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TextUtils.join(\"\", Colle\u2026ions.nCopies(count, \" \"))");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String logSpans(@NotNull Spanned text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Object[] spans = text.getSpans(0, 9999999, Object.class);
        List<Object> spansList = Arrays.asList(Arrays.copyOf(spans, spans.length));
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(StringsKt.replace$default((String)text.toString(), (char)'\n', (char)' ', (boolean)false, (int)4, null));
        for (Object span : spansList) {
            int start = text.getSpanStart(span);
            int end = text.getSpanEnd(span);
            int gap = text.length() + 5;
            sb.append('\n');
            if (start > 0) {
                sb.append(INSTANCE.spaces(start));
                gap -= start;
            }
            sb.append('|');
            --gap;
            if (end - start - 1 > 0) {
                sb.append(INSTANCE.spaces(end - start - 1));
                gap -= end - start - 1;
            }
            if (end - start > 0) {
                sb.append('|');
                --gap;
            }
            sb.append(INSTANCE.spaces(gap));
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%03d";
            Object[] objectArray = new Object[]{start};
            StringBuilder stringBuilder = sb.append("   ");
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "%03d";
            objectArray = new Object[]{end};
            stringBuilder = stringBuilder.append(string3).append(" -> ");
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string3 = string4;
            stringBuilder.append(string3).append(" : ").append(span.getClass().getSimpleName());
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private SpanLogger() {
        INSTANCE = this;
    }

    static {
        new SpanLogger();
    }
}

