/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/wordpress/aztec/source/Format;", "", "()V", "block", "", "addFormatting", "content", "clearFormatting", "html", "replaceAll", "pattern", "replacement", "aztec_release"})
public final class Format {
    private static final String block = "div|span|br|blockquote|ul|ol|li|p|h1|h2|h3|h4|h5|h6";
    public static final Format INSTANCE;

    @NotNull
    public final String addFormatting(@NotNull String content) {
        String fixBrNewlines;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Document doc = Jsoup.parseBodyFragment((String)content);
        String string = doc.body().html();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"doc.body().html()");
        String newlineToTheLeft = this.replaceAll(string, "(?<!</?(" + block + ")>)" + "\n" + "\\" + "s*?<((?!/?(" + block + ")).*?)>", "<$2>");
        String newlineToTheRight = this.replaceAll(newlineToTheLeft, "<(/?(?!" + block + ").)>" + "\n" + "(?!</?(" + block + ")>)", "<$1>");
        String string2 = fixBrNewlines = this.replaceAll(newlineToTheRight, "(<br>)(?!\n)", "$1\n");
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public final String clearFormatting(@NotNull String html) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        return this.replaceAll(html, "\\" + "s*<(/?(" + block + ")(.*?))>" + "\\" + "s*", "<$1>");
    }

    private final String replaceAll(String content, String pattern, String replacement) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        String string = m.replaceAll(replacement);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.replaceAll(replacement)");
        return string;
    }

    private Format() {
        INSTANCE = this;
        block = block;
    }

    static {
        new Format();
    }
}

