/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.Editable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.TextChangedEvent;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.formatting.BlockFormatter$WhenMappings;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecLineBlockSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.ParagraphSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002ABB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012J&\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012J\u001a\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u0012J\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00102\b\b\u0002\u0010\u001d\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u0012J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&J\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u0012J\u0016\u0010-\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&J(\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/012\b\b\u0002\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u000205J\u0018\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u00020\u00102\b\b\u0002\u00102\u001a\u000203J\u001e\u00106\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u001bJ4\u00109\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020/012\b\b\u0002\u0010:\u001a\u00020\u001bJ\u000e\u00109\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0010J\"\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012J\u0006\u0010=\u001a\u00020\u000eJ\u0006\u0010>\u001a\u00020\u000eJ\u0006\u0010?\u001a\u00020\u000eJ\u0006\u0010@\u001a\u00020\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006C"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;)V", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "applyBlockStyle", "", "blockElementType", "Lorg/wordpress/aztec/TextFormat;", "start", "", "end", "carryOverDeletedListItemAttributes", "count", "changedText", "", "text", "Landroid/text/Editable;", "containQuote", "", "index", "selStart", "selEnd", "containsList", "textFormat", "getBlockSpanToOpen", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/spans/AztecLineBlockSpan;", "editableText", "textChangedEvent", "Lorg/wordpress/aztec/TextChangedEvent;", "getBlockSpansToClose", "getSelectedTextBounds", "Lkotlin/ranges/IntRange;", "editable", "selectionStart", "selectionEnd", "handleBlockStyling", "makeBlockSpan", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "spanType", "Ljava/lang/Class;", "attrs", "", "lastItem", "Lorg/wordpress/aztec/spans/AztecListItemSpan;", "realignAttributesWhenAddingItem", "textChangedEventDetails", "newline", "removeBlockStyle", "ignoreLineBounds", "switchListType", "listTypeToSwitchTo", "toggleOrderedList", "toggleQuote", "toggleUnorderedList", "tryRemoveBlockStyleFromFirstLine", "ListStyle", "QuoteStyle", "aztec_release"})
public final class BlockFormatter
extends AztecFormatter {
    @NotNull
    private final ListStyle listStyle;
    @NotNull
    private final QuoteStyle quoteStyle;

    @NotNull
    public final ListStyle getListStyle() {
        return this.listStyle;
    }

    @NotNull
    public final QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public final void toggleOrderedList() {
        if (!BlockFormatter.containsList$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null)) {
            if (BlockFormatter.containsList$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null)) {
                BlockFormatter.switchListType$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(TextFormat.FORMAT_ORDERED_LIST);
        }
    }

    public final void toggleUnorderedList() {
        if (!BlockFormatter.containsList$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null)) {
            if (BlockFormatter.containsList$default(this, TextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null)) {
                BlockFormatter.switchListType$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, TextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            }
        } else {
            this.removeBlockStyle(TextFormat.FORMAT_UNORDERED_LIST);
        }
    }

    public final void toggleQuote() {
        if (!BlockFormatter.containQuote$default(this, 0, 0, 3, null)) {
            BlockFormatter.applyBlockStyle$default(this, TextFormat.FORMAT_QUOTE, 0, 0, 6, null);
        } else {
            this.removeBlockStyle(TextFormat.FORMAT_QUOTE);
        }
    }

    public final boolean tryRemoveBlockStyleFromFirstLine() {
        int selectionStart = this.getEditor().getSelectionStart();
        Object[] $receiver$iv = this.getEditableText().getSpans(selectionStart, selectionStart, AztecBlockSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            AztecBlockSpan it = (AztecBlockSpan)element$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)it);
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            if (spanStart != selectionStart) continue;
            int indexOfNewline = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)'\n', (int)spanStart, (boolean)false, (int)4, null);
            if (spanStart != 0 && spanEnd == indexOfNewline + 1) {
                --spanEnd;
            }
            if (spanEnd == indexOfNewline || indexOfNewline == -1) {
                this.getEditableText().removeSpan((Object)it);
                this.getEditor().onSelectionChanged(this.getEditor().getSelectionStart(), this.getEditor().getSelectionEnd());
            } else {
                this.getEditableText().setSpan((Object)it, indexOfNewline + 1, spanEnd, 33);
                this.getEditor().onSelectionChanged(this.getEditor().getSelectionStart(), this.getEditor().getSelectionEnd());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void handleBlockStyling(@NotNull Editable text, @NotNull TextChangedEvent textChangedEvent) {
        Object blockSpan;
        void $receiver$iv;
        int spanStart;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
        int inputStart = textChangedEvent.getInputStart();
        int inputEnd = textChangedEvent.getInputEnd();
        ArrayList<AztecLineBlockSpan> spanToClose = this.getBlockSpansToClose(text, textChangedEvent);
        Iterable iterable = spanToClose;
        for (Object element$iv : $receiver$iv2) {
            AztecLineBlockSpan it = (AztecLineBlockSpan)element$iv;
            int spanEnd = text.getSpanEnd((Object)it);
            if (spanEnd == (spanStart = text.getSpanStart((Object)it)) || spanEnd > text.length()) continue;
            if (inputStart == 0 && spanStart > 0 && text.charAt(spanStart) == '\n' && !textChangedEvent.isAddingCharacters()) {
                ++spanEnd;
                this.getEditor().disableTextChangedListener();
                text.insert(spanStart, (CharSequence)Constants.INSTANCE.getZWJ_STRING());
            }
            this.getEditableText().setSpan((Object)it, spanStart, spanEnd, 33);
        }
        ArrayList<AztecLineBlockSpan> spanToOpen = this.getBlockSpanToOpen(text, textChangedEvent);
        Iterable iterable2 = spanToOpen;
        for (Object element$iv : $receiver$iv) {
            boolean spanEndsWithNewline;
            AztecLineBlockSpan it = (AztecLineBlockSpan)element$iv;
            int textLength = text.length();
            int spanEnd = text.getSpanEnd((Object)it);
            int spanStart2 = text.getSpanStart((Object)it);
            if (inputStart < spanStart2) {
                this.getEditableText().setSpan((Object)it, inputStart, spanEnd, 33);
                continue;
            }
            if (!textChangedEvent.isAddingCharacters() || (spanEndsWithNewline = StringsKt.indexOf((CharSequence)((CharSequence)this.getEditableText()), (char)'\n', (int)textChangedEvent.getInputStart(), (boolean)true) == spanEnd - textChangedEvent.getNumberOfAddedCharacters())) continue;
            int indexOfLineEnd = StringsKt.indexOf((CharSequence)((CharSequence)text), (char)'\n', (int)(spanEnd - 1), (boolean)true);
            spanEnd = indexOfLineEnd == spanEnd ? (spanEnd += textChangedEvent.getCount()) : (indexOfLineEnd == -1 ? text.length() : indexOfLineEnd + (textChangedEvent.isAfterZeroWidthJoiner() ? 1 : 0));
            if (spanEnd > textLength) continue;
            this.getEditableText().setSpan((Object)it, text.getSpanStart((Object)it), spanEnd, 34);
        }
        if (textChangedEvent.isAfterZeroWidthJoiner() && !textChangedEvent.isNewLineButNotAtTheBeginning()) {
            this.getEditor().disableTextChangedListener();
            int before = Math.min(inputStart, inputEnd);
            text.delete(before - 1, before);
            if (!textChangedEvent.isAddingCharacters() && (blockSpan = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(before - 1, before - 1, AztecBlockSpan.class))) != null) {
                int newline = StringsKt.indexOf$default((CharSequence)((CharSequence)text), (char)'\n', (int)(before - 1), (boolean)false, (int)4, null);
                int end = newline != -1 ? Math.min(text.length(), newline) : text.length();
                text.setSpan(blockSpan, text.getSpanStart(blockSpan), end, 33);
            }
        } else if (textChangedEvent.isAfterZeroWidthJoiner() && textChangedEvent.isNewLineButNotAtTheBeginning()) {
            BlockFormatter.removeBlockStyle$default(this, 0, 0, null, false, 15, null);
            this.getEditor().disableTextChangedListener();
            if (inputStart == 1) {
                text.delete(inputStart - 1, inputStart + 1);
            } else {
                text.delete(inputStart - 2, inputStart);
                Object[] before = text.getSpans(inputStart - 2, inputStart - 2, AztecListSpan.class);
                blockSpan = before;
                if (!(((Object[])blockSpan).length == 0)) {
                    this.getEditor().disableTextChangedListener();
                    text.insert(inputStart - 2, (CharSequence)"\n");
                }
            }
        } else if (!textChangedEvent.isAfterZeroWidthJoiner() && textChangedEvent.isNewLineButNotAtTheBeginning()) {
            AztecBlockSpan blockSpan2 = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(inputStart, inputStart, AztecBlockSpan.class));
            if (blockSpan2 != null && text.getSpanEnd((Object)blockSpan2) == inputStart + 1 || text.getSpanEnd((Object)blockSpan2) == inputStart + 2 && text.charAt(inputStart + 1) == '\n') {
                if (inputEnd == text.length() || text.charAt(inputEnd) == '\n') {
                    this.getEditor().disableTextChangedListener();
                    text.insert(inputStart + 1, (CharSequence)Constants.INSTANCE.getZWJ_STRING());
                    text.setSpan((Object)blockSpan2, text.getSpanStart((Object)blockSpan2), inputEnd + 1, 33);
                } else {
                    text.setSpan((Object)blockSpan2, text.getSpanStart((Object)blockSpan2), inputEnd + 1, 33);
                }
            }
        } else if (textChangedEvent.getDeletedFromBlockEnd()) {
            Object v0;
            block34: {
                void $receiver$iv3;
                blockSpan = text.getSpans(textChangedEvent.getBlockSpanStart(), textChangedEvent.getBlockSpanStart(), AztecBlockSpan.class);
                for (int newline = 0; newline < ((void)$receiver$iv3).length; ++newline) {
                    void element$iv = $receiver$iv3[newline];
                    AztecBlockSpan it = (AztecBlockSpan)element$iv;
                    if (!(text.getSpanStart((Object)it) == textChangedEvent.getBlockSpanStart())) continue;
                    v0 = element$iv;
                    break block34;
                }
                v0 = null;
            }
            AztecBlockSpan list = v0;
            if (list != null) {
                int spanStart3 = textChangedEvent.getBlockSpanStart();
                int spanEnd = text.getSpanEnd((Object)list);
                if (textChangedEvent.getTextBefore().charAt(inputEnd) != Constants.INSTANCE.getZWJ_CHAR()) {
                    this.getEditor().disableTextChangedListener();
                    text.insert(inputEnd, (CharSequence)Constants.INSTANCE.getZWJ_STRING());
                    int newSpanEnd = inputEnd > spanEnd ? spanEnd + 2 : spanEnd + 1;
                    text.setSpan((Object)list, spanStart3, newSpanEnd, 33);
                } else if (inputEnd - 2 >= spanStart3 && text.charAt(inputEnd - 2) == '\n' || inputEnd - 1 == spanStart3) {
                    this.getEditor().disableTextChangedListener();
                    text.insert(inputEnd - 1, (CharSequence)Constants.INSTANCE.getZWJ_STRING());
                    if (inputEnd - 1 < spanStart3 + 1) {
                        text.setSpan((Object)list, inputEnd - 1, spanEnd, 33);
                    }
                    this.getEditor().disableTextChangedListener();
                    text.delete(inputEnd, inputEnd + 1);
                } else if (spanEnd > 0 && spanStart3 != spanEnd) {
                    this.getEditor().disableTextChangedListener();
                    text.delete(spanEnd - 1, spanEnd);
                } else {
                    text.removeSpan((Object)list);
                }
            }
        } else if (!textChangedEvent.isAddingCharacters() && !textChangedEvent.isNewLineButNotAtTheBeginning()) {
            boolean deletedCharacterIsNewline;
            boolean bl = deletedCharacterIsNewline = textChangedEvent.getTextBefore().charAt(textChangedEvent.getInputEnd()) == '\n';
            if (!deletedCharacterIsNewline) {
                return;
            }
            blockSpan = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(inputEnd, inputEnd, AztecBlockSpan.class));
            int before = Math.min(inputStart, inputEnd);
            int spanEnd = text.getSpanEnd(blockSpan);
            spanStart = text.getSpanStart(blockSpan);
            if (spanEnd - 1 > 0 && spanStart < spanEnd && spanEnd > 0 && text.charAt(spanEnd - 1) == '\n') {
                text.setSpan(blockSpan, spanStart, spanEnd - 1, 33);
            }
            if (blockSpan != null && before - 1 > 0 && text.getSpanEnd(blockSpan) == before) {
                int newline;
                if (textChangedEvent.getTextBefore().charAt(before) == Constants.INSTANCE.getZWJ_CHAR()) {
                    this.getEditor().disableTextChangedListener();
                    text.delete(before - 1, before);
                }
                int end = (newline = StringsKt.indexOf$default((CharSequence)((CharSequence)text), (char)'\n', (int)before, (boolean)false, (int)4, null)) != -1 ? Math.min(text.length(), StringsKt.indexOf$default((CharSequence)((CharSequence)text), (char)'\n', (int)before, (boolean)false, (int)4, null)) : text.length();
                text.setSpan(blockSpan, text.getSpanStart(blockSpan), end, 33);
            }
        }
        int indexOfZWJ = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)Constants.INSTANCE.getZWJ_CHAR(), (int)0, (boolean)false, (int)6, null);
        while (indexOfZWJ >= 0) {
            this.getEditor().removeInlineStylesFromRange(indexOfZWJ, indexOfZWJ + 1);
            indexOfZWJ = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)Constants.INSTANCE.getZWJ_CHAR(), (int)(indexOfZWJ + 1), (boolean)false, (int)4, null);
        }
    }

    public final void removeBlockStyle(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        BlockFormatter.removeBlockStyle$default(this, this.getSelectionStart(), this.getSelectionEnd(), BlockFormatter.makeBlockSpan$default(this, textFormat, null, 2, null).getClass(), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(int start, int end, @NotNull Class<AztecBlockSpan> spanType, boolean ignoreLineBounds) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(spanType, (String)"spanType");
        AztecBlockSpan[] spans = (AztecBlockSpan[])this.getEditableText().getSpans(start, end, spanType);
        Object[] objectArray = spans;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void element$iv = $receiver$iv[i];
            AztecBlockSpan it = (AztecBlockSpan)element$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)it);
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            IntRange boundsOfSelectedText = ignoreLineBounds ? new IntRange(start, end) : this.getSelectedTextBounds(this.getEditableText(), start, end);
            int startOfLine = boundsOfSelectedText.getStart();
            int endOfLine = boundsOfSelectedText.getEndInclusive();
            boolean spanPrecedesLine = spanStart < startOfLine;
            boolean spanExtendsBeyondLine = endOfLine < spanEnd;
            this.getEditableText().removeSpan((Object)it);
            if (spanPrecedesLine) {
                this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, it.getClass(), null, null, 6, null), spanStart, startOfLine - 1, 33);
            }
            if (!spanExtendsBeyondLine) continue;
            if (this.getEditableText().charAt(endOfLine) == '\n' && !ignoreLineBounds) {
                this.getEditor().disableTextChangedListener();
                this.getEditableText().delete(endOfLine, endOfLine + 1);
                --spanEnd;
            }
            this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, it.getClass(), null, null, 6, null), endOfLine, spanEnd, 33);
        }
    }

    public static /* bridge */ /* synthetic */ void removeBlockStyle$default(BlockFormatter blockFormatter, int n, int n2, Class clazz, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeBlockStyle");
        }
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        if ((n3 & 4) != 0) {
            clazz = AztecBlockSpan.class;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        blockFormatter.removeBlockStyle(n, n2, clazz, bl);
    }

    @NotNull
    public final AztecBlockSpan makeBlockSpan(@NotNull TextFormat textFormat, @NotNull String attrs) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        switch (BlockFormatter$WhenMappings.$EnumSwitchMapping$0[textFormat.ordinal()]) {
            case 1: {
                return new AztecOrderedListSpan(this.listStyle, attrs, new AztecListItemSpan(null, 1, null));
            }
            case 2: {
                return new AztecUnorderedListSpan(this.listStyle, attrs, new AztecListItemSpan(null, 1, null));
            }
            case 3: {
                return new AztecQuoteSpan(this.quoteStyle, attrs);
            }
        }
        return new ParagraphSpan(attrs);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, TextFormat textFormat, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeBlockSpan");
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        return blockFormatter.makeBlockSpan(textFormat, string2);
    }

    @NotNull
    public final AztecBlockSpan makeBlockSpan(@NotNull Class<AztecBlockSpan> spanType, @NotNull String attrs, @NotNull AztecListItemSpan lastItem) {
        Intrinsics.checkParameterIsNotNull(spanType, (String)"spanType");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Intrinsics.checkParameterIsNotNull((Object)lastItem, (String)"lastItem");
        Class<AztecBlockSpan> clazz = spanType;
        if (Intrinsics.areEqual(clazz, AztecOrderedListSpan.class)) {
            return new AztecOrderedListSpan(this.listStyle, attrs, lastItem);
        }
        if (Intrinsics.areEqual(clazz, AztecUnorderedListSpan.class)) {
            return new AztecUnorderedListSpan(this.listStyle, attrs, lastItem);
        }
        if (Intrinsics.areEqual(clazz, AztecQuoteSpan.class)) {
            return new AztecQuoteSpan(this.quoteStyle, attrs);
        }
        return new ParagraphSpan(attrs);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, Class clazz, String string2, AztecListItemSpan aztecListItemSpan, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeBlockSpan");
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            aztecListItemSpan = new AztecListItemSpan(null, 1, null);
        }
        return blockFormatter.makeBlockSpan(clazz, string2, aztecListItemSpan);
    }

    @NotNull
    public final IntRange getSelectedTextBounds(@NotNull Editable editable, int selectionStart, int selectionEnd) {
        char characterBeforeLastLineBreak;
        Intrinsics.checkParameterIsNotNull((Object)editable, (String)"editable");
        int indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionEnd, (boolean)false, (int)4, null);
        int indexOfFirstLineBreak = indexOfLastLineBreak > 0 ? ((characterBeforeLastLineBreak = editable.charAt(indexOfLastLineBreak - 1)) != '\n' ? StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null)) : (indexOfLastLineBreak == -1 ? StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null) + 1 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null));
        int startOfLine = indexOfFirstLineBreak != -1 ? indexOfFirstLineBreak : 0;
        int endOfLine = indexOfLastLineBreak != -1 ? indexOfLastLineBreak : editable.length();
        return new IntRange(startOfLine, endOfLine);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyBlockStyle(@NotNull TextFormat blockElementType, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blockElementType), (String)"blockElementType");
        if (start != end) {
            String selectedText = StringsKt.substring((CharSequence)((CharSequence)this.getEditableText()), (IntRange)new IntRange(start + 1, end - 1));
            if (StringsKt.indexOf$default((CharSequence)selectedText, (String)"\n", (int)0, (boolean)false, (int)6, null) != -1) {
                int indexOfFirstLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (String)"\n", (int)end, (boolean)false, (int)4, null);
                int endOfBlock = indexOfFirstLineBreak != -1 ? indexOfFirstLineBreak : this.getEditableText().length();
                int startOfBlock = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)this.getEditableText()), (String)"\n", (int)start, (boolean)false, (int)4, null);
                CharSequence charSequence = StringsKt.subSequence((CharSequence)((CharSequence)this.getEditableText()), (IntRange)new IntRange(startOfBlock + 1, endOfBlock - 1));
                if (charSequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.Editable");
                }
                Editable selectedLines = (Editable)charSequence;
                int numberOfLinesWithSpanApplied = 0;
                int numberOfLines = 0;
                int n = 0;
                String[] lines = TextUtils.split((String)selectedLines.toString(), (String)"\n");
                int n2 = lines.length - 1;
                if (n <= n2) {
                    while (true) {
                        void i;
                        ++numberOfLines;
                        if (this.containsList(blockElementType, (int)i, selectedLines)) {
                            ++numberOfLinesWithSpanApplied;
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                if (numberOfLines == numberOfLinesWithSpanApplied) {
                    this.removeBlockStyle(blockElementType);
                } else {
                    this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, blockElementType, null, 2, null), startOfBlock + 1, endOfBlock, 34);
                }
            }
        } else {
            AztecBlockSpan spanOnNextLine;
            AztecBlockSpan spansOnPreviousLine;
            int endOfLine;
            boolean isEmptyLine;
            IntRange boundsOfSelectedText = this.getSelectedTextBounds(this.getEditableText(), start, end);
            int startOfLine = boundsOfSelectedText.getStart();
            boolean bl = isEmptyLine = startOfLine == (endOfLine = ((Number)boundsOfSelectedText.getEndInclusive()).intValue());
            if (isEmptyLine) {
                this.getEditor().disableTextChangedListener();
                this.getEditableText().insert(startOfLine, (CharSequence)Constants.INSTANCE.getZWJ_STRING());
                ++endOfLine;
            }
            AztecBlockSpan spanToApply = BlockFormatter.makeBlockSpan$default(this, blockElementType, null, 2, null);
            int startOfBlock = startOfLine;
            int endOfBlock = endOfLine;
            if (startOfLine != 0 && (spansOnPreviousLine = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(startOfLine - 1, startOfLine - 1, spanToApply.getClass()))) != null) {
                startOfBlock = this.getEditableText().getSpanStart((Object)spansOnPreviousLine);
                this.getEditableText().removeSpan((Object)spansOnPreviousLine);
            }
            if (endOfLine != this.getEditableText().length() && (spanOnNextLine = (AztecBlockSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(endOfLine + 1, endOfLine + 1, spanToApply.getClass()))) != null) {
                endOfBlock = this.getEditableText().getSpanEnd((Object)spanOnNextLine);
                this.getEditableText().removeSpan((Object)spanOnNextLine);
            }
            this.getEditableText().setSpan((Object)spanToApply, startOfBlock, endOfBlock, 34);
            if (isEmptyLine) {
                this.getEditor().onSelectionChanged(startOfLine, endOfLine);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void applyBlockStyle$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyBlockStyle");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.applyBlockStyle(textFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsList(@NotNull TextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart <= lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containsList(textFormat, it, this.getEditableText())) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containsList$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containsList");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsList(textFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsList(@NotNull TextFormat textFormat, int index, @NotNull Editable text) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String[] lines = TextUtils.split((String)text.toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)objectArray).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start > end) {
            return false;
        }
        AztecBlockSpan[] spans = (AztecBlockSpan[])this.getEditableText().getSpans(start, end, BlockFormatter.makeBlockSpan$default(this, textFormat, null, 2, null).getClass());
        objectArray = spans;
        Object[] objectArray2 = objectArray;
        return !(objectArray2.length == 0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containQuote(int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containQuote(it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean containQuote$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containQuote");
        }
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containQuote(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containQuote(int index) {
        void $receiver$iv;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)objectArray).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        AztecQuoteSpan[] spans = (AztecQuoteSpan[])this.getEditableText().getSpans(start, end, AztecQuoteSpan.class);
        objectArray = spans;
        Object[] objectArray2 = objectArray;
        return !(objectArray2.length == 0);
    }

    public final void switchListType(@NotNull TextFormat listTypeToSwitchTo, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)listTypeToSwitchTo), (String)"listTypeToSwitchTo");
        AztecListSpan existingListSpan = (AztecListSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(start, end, AztecListSpan.class));
        if (existingListSpan != null) {
            int spanStart = this.getEditableText().getSpanStart((Object)existingListSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingListSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingListSpan);
            this.getEditableText().removeSpan((Object)existingListSpan);
            this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, listTypeToSwitchTo, null, 2, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* bridge */ /* synthetic */ void switchListType$default(BlockFormatter blockFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchListType");
        }
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchListType(textFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<AztecLineBlockSpan> getBlockSpanToOpen(@NotNull Editable editableText, @NotNull TextChangedEvent textChangedEvent) {
        Intrinsics.checkParameterIsNotNull((Object)editableText, (String)"editableText");
        Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
        ArrayList<AztecLineBlockSpan> spansToClose = new ArrayList<AztecLineBlockSpan>();
        if (textChangedEvent.getCount() >= 0 && editableText.length() > textChangedEvent.getInputStart()) {
            int flags;
            Object[] $receiver$iv;
            AztecLineBlockSpan[] spans = (AztecLineBlockSpan[])editableText.getSpans(textChangedEvent.getInputStart(), textChangedEvent.getInputStart(), AztecLineBlockSpan.class);
            Object[] objectArray = spans;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                char lastCharacter;
                boolean deletingLastCharacter;
                void element$iv = $receiver$iv[i];
                AztecLineBlockSpan it = (AztecLineBlockSpan)element$iv;
                if (textChangedEvent.getInputStart() > 0) {
                    char previousCharacter;
                    char c = previousCharacter = textChangedEvent.isAddingCharacters() ? editableText.charAt(textChangedEvent.getInputStart() - 1) : editableText.charAt(textChangedEvent.getInputEnd());
                    if (previousCharacter == '\n') continue;
                }
                boolean bl = deletingLastCharacter = !textChangedEvent.isAddingCharacters() && editableText.length() == textChangedEvent.getInputEnd();
                if (deletingLastCharacter || !textChangedEvent.isAddingCharacters() && editableText.length() > textChangedEvent.getInputEnd() && (lastCharacter = editableText.charAt(textChangedEvent.getInputEnd())) == '\n' || ((flags = editableText.getSpanFlags((Object)spans[0])) & 0x21) != 33) continue;
                spansToClose.add(it);
            }
            $receiver$iv = spans;
            if ($receiver$iv.length == 0) {
                void $receiver$iv2;
                AztecLineBlockSpan[] spansAfterInput = (AztecLineBlockSpan[])editableText.getSpans(textChangedEvent.getInputEnd(), textChangedEvent.getInputEnd(), AztecLineBlockSpan.class);
                Object[] objectArray2 = spansAfterInput;
                for (int i = 0; i < ((void)$receiver$iv2).length; ++i) {
                    void element$iv = $receiver$iv2[i];
                    AztecLineBlockSpan it = (AztecLineBlockSpan)element$iv;
                    flags = editableText.getSpanFlags((Object)spansAfterInput[0]);
                    if ((flags & 0x21) != 33 && (flags & 0x22) != 34) continue;
                    spansToClose.add(it);
                }
            }
        }
        return spansToClose;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<AztecLineBlockSpan> getBlockSpansToClose(@NotNull Editable editableText, @NotNull TextChangedEvent textChangedEvent) {
        ArrayList<AztecLineBlockSpan> spansToClose;
        block6: {
            int startIndex;
            block5: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)editableText, (String)"editableText");
                Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
                spansToClose = new ArrayList<AztecLineBlockSpan>();
                int n = startIndex = textChangedEvent.isAddingCharacters() ? textChangedEvent.getInputStart() : textChangedEvent.getInputEnd();
                if (startIndex <= 0 || textChangedEvent.getCount() != 1) break block5;
                if (editableText.charAt(startIndex - 1) != '\n') {
                    return spansToClose;
                }
                AztecLineBlockSpan[] spans = (AztecLineBlockSpan[])editableText.getSpans(startIndex, startIndex, AztecLineBlockSpan.class);
                Object[] objectArray = spans;
                for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                    int flags;
                    void element$iv = $receiver$iv[i];
                    AztecLineBlockSpan it = (AztecLineBlockSpan)element$iv;
                    int spanStart = editableText.getSpanStart((Object)spans[0]);
                    int spanEnd = editableText.getSpanEnd((Object)spans[0]);
                    if (startIndex == spanStart) {
                        spansToClose.add(it);
                        continue;
                    }
                    if (startIndex != spanEnd || ((flags = editableText.getSpanFlags((Object)spans[0])) & 0x22) != 34) continue;
                    spansToClose.add(it);
                }
                break block6;
            }
            if (startIndex != 0 || textChangedEvent.getCount() != 1) break block6;
            CharSequence spans = (CharSequence)editableText;
            if (spans.length() > 0) {
                AztecBlockSpan[] spansAfterInput = (AztecBlockSpan[])editableText.getSpans(startIndex + 1, startIndex + 1, AztecBlockSpan.class);
                Object[] $receiver$iv = spansAfterInput;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    AztecBlockSpan it = (AztecBlockSpan)element$iv;
                    spansToClose.add(it);
                }
            }
        }
        return spansToClose;
    }

    /*
     * WARNING - void declaration
     */
    public final void realignAttributesWhenAddingItem(@NotNull Editable text, @NotNull TextChangedEvent textChangedEventDetails, boolean newline) {
        AztecListSpan list;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)textChangedEventDetails, (String)"textChangedEventDetails");
        if (newline && (list = (AztecListSpan)ArraysKt.firstOrNull((Object[])text.getSpans(textChangedEventDetails.getInputStart(), textChangedEventDetails.getInputStart(), AztecListSpan.class))) != null) {
            int listEnd = text.getSpanEnd((Object)list);
            if (textChangedEventDetails.getInputEnd() < text.length() && text.charAt(textChangedEventDetails.getInputEnd()) == '\n') {
                void $receiver$iv;
                AztecListItemSpan[] spans = (AztecListItemSpan[])text.getSpans(textChangedEventDetails.getInputEnd(), textChangedEventDetails.getInputEnd() + 1, AztecListItemSpan.class);
                Object[] objectArray = spans;
                for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                    void element$iv = $receiver$iv[i];
                    AztecListItemSpan it = (AztecListItemSpan)element$iv;
                    if (text.getSpanStart((Object)it) != textChangedEventDetails.getInputEnd() || text.getSpanEnd((Object)it) != textChangedEventDetails.getInputEnd() + 1) continue;
                    int spanStart = textChangedEventDetails.getInputStart();
                    if (text.charAt(textChangedEventDetails.getInputStart()) == Constants.INSTANCE.getZWJ_CHAR()) {
                        --spanStart;
                    }
                    text.setSpan((Object)it, spanStart, spanStart + 1, 33);
                }
            }
            if (textChangedEventDetails.getInputEnd() == listEnd) {
                int prevNewline = textChangedEventDetails.getInputStart();
                if (text.charAt(prevNewline) == Constants.INSTANCE.getZWJ_CHAR()) {
                    --prevNewline;
                }
                text.setSpan((Object)list.getLastItem(), prevNewline, prevNewline + 1, 33);
                list.setLastItem(new AztecListItemSpan(null, 1, null));
            }
        }
    }

    public final void carryOverDeletedListItemAttributes(int count, int start, @NotNull CharSequence changedText, @NotNull Editable text) {
        AztecListSpan list;
        AztecListItemSpan item;
        Intrinsics.checkParameterIsNotNull((Object)changedText, (String)"changedText");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (count != 0 && changedText.charAt(start) == '\n' && (item = (AztecListItemSpan)ArraysKt.firstOrNull((Object[])text.getSpans(start, start + count, AztecListItemSpan.class))) != null && (list = (AztecListSpan)ArraysKt.firstOrNull((Object[])text.getSpans(start, start + count, AztecListSpan.class))) != null) {
            int listEnd = text.getSpanEnd((Object)list);
            int next = StringsKt.indexOf$default((CharSequence)changedText, (char)'\n', (int)(start + count), (boolean)false, (int)4, null);
            if (next != -1 && next < listEnd) {
                AztecListItemSpan oldSpan = (AztecListItemSpan)ArraysKt.firstOrNull((Object[])text.getSpans(next, next + 1, AztecListItemSpan.class));
                if (oldSpan != null) {
                    text.removeSpan((Object)oldSpan);
                }
                text.setSpan((Object)item, next, next + 1, 33);
            } else {
                list.setLastItem(item);
            }
        }
    }

    public BlockFormatter(@NotNull AztecText editor, @NotNull ListStyle listStyle, @NotNull QuoteStyle quoteStyle) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)editor), (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        super(editor);
        this.listStyle = listStyle;
        this.quoteStyle = quoteStyle;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "", "indicatorColor", "", "indicatorMargin", "indicatorPadding", "indicatorWidth", "verticalPadding", "(IIIII)V", "getIndicatorColor", "()I", "getIndicatorMargin", "getIndicatorPadding", "getIndicatorWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "copy", "aztec_release"})
    public static final class ListStyle {
        private final int indicatorColor;
        private final int indicatorMargin;
        private final int indicatorPadding;
        private final int indicatorWidth;
        private final int verticalPadding;

        public final int getIndicatorColor() {
            return this.indicatorColor;
        }

        public final int getIndicatorMargin() {
            return this.indicatorMargin;
        }

        public final int getIndicatorPadding() {
            return this.indicatorPadding;
        }

        public final int getIndicatorWidth() {
            return this.indicatorWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public ListStyle(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            this.indicatorColor = indicatorColor;
            this.indicatorMargin = indicatorMargin;
            this.indicatorPadding = indicatorPadding;
            this.indicatorWidth = indicatorWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.indicatorColor;
        }

        public final int component2() {
            return this.indicatorMargin;
        }

        public final int component3() {
            return this.indicatorPadding;
        }

        public final int component4() {
            return this.indicatorWidth;
        }

        public final int component5() {
            return this.verticalPadding;
        }

        @NotNull
        public final ListStyle copy(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            return new ListStyle(indicatorColor, indicatorMargin, indicatorPadding, indicatorWidth, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ListStyle copy$default(ListStyle listStyle, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n6 & 1) != 0) {
                n = listStyle.indicatorColor;
            }
            if ((n6 & 2) != 0) {
                n2 = listStyle.indicatorMargin;
            }
            if ((n6 & 4) != 0) {
                n3 = listStyle.indicatorPadding;
            }
            if ((n6 & 8) != 0) {
                n4 = listStyle.indicatorWidth;
            }
            if ((n6 & 0x10) != 0) {
                n5 = listStyle.verticalPadding;
            }
            return listStyle.copy(n, n2, n3, n4, n5);
        }

        public String toString() {
            return "ListStyle(indicatorColor=" + this.indicatorColor + ", indicatorMargin=" + this.indicatorMargin + ", indicatorPadding=" + this.indicatorPadding + ", indicatorWidth=" + this.indicatorWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((this.indicatorColor * 31 + this.indicatorMargin) * 31 + this.indicatorPadding) * 31 + this.indicatorWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListStyle)) break block3;
                    ListStyle listStyle = (ListStyle)object;
                    if (!(this.indicatorColor == listStyle.indicatorColor) || !(this.indicatorMargin == listStyle.indicatorMargin) || !(this.indicatorPadding == listStyle.indicatorPadding) || !(this.indicatorWidth == listStyle.indicatorWidth) || !(this.verticalPadding == listStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "", "quoteBackground", "", "quoteColor", "quoteBackgroundAlpha", "", "quoteMargin", "quotePadding", "quoteWidth", "verticalPadding", "(IIFIIII)V", "getQuoteBackground", "()I", "getQuoteBackgroundAlpha", "()F", "getQuoteColor", "getQuoteMargin", "getQuotePadding", "getQuoteWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "aztec_release"})
    public static final class QuoteStyle {
        private final int quoteBackground;
        private final int quoteColor;
        private final float quoteBackgroundAlpha;
        private final int quoteMargin;
        private final int quotePadding;
        private final int quoteWidth;
        private final int verticalPadding;

        public final int getQuoteBackground() {
            return this.quoteBackground;
        }

        public final int getQuoteColor() {
            return this.quoteColor;
        }

        public final float getQuoteBackgroundAlpha() {
            return this.quoteBackgroundAlpha;
        }

        public final int getQuoteMargin() {
            return this.quoteMargin;
        }

        public final int getQuotePadding() {
            return this.quotePadding;
        }

        public final int getQuoteWidth() {
            return this.quoteWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public QuoteStyle(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            this.quoteBackground = quoteBackground;
            this.quoteColor = quoteColor;
            this.quoteBackgroundAlpha = quoteBackgroundAlpha;
            this.quoteMargin = quoteMargin;
            this.quotePadding = quotePadding;
            this.quoteWidth = quoteWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.quoteBackground;
        }

        public final int component2() {
            return this.quoteColor;
        }

        public final float component3() {
            return this.quoteBackgroundAlpha;
        }

        public final int component4() {
            return this.quoteMargin;
        }

        public final int component5() {
            return this.quotePadding;
        }

        public final int component6() {
            return this.quoteWidth;
        }

        public final int component7() {
            return this.verticalPadding;
        }

        @NotNull
        public final QuoteStyle copy(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            return new QuoteStyle(quoteBackground, quoteColor, quoteBackgroundAlpha, quoteMargin, quotePadding, quoteWidth, verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QuoteStyle copy$default(QuoteStyle quoteStyle, int n, int n2, float f, int n3, int n4, int n5, int n6, int n7, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n7 & 1) != 0) {
                n = quoteStyle.quoteBackground;
            }
            if ((n7 & 2) != 0) {
                n2 = quoteStyle.quoteColor;
            }
            if ((n7 & 4) != 0) {
                f = quoteStyle.quoteBackgroundAlpha;
            }
            if ((n7 & 8) != 0) {
                n3 = quoteStyle.quoteMargin;
            }
            if ((n7 & 0x10) != 0) {
                n4 = quoteStyle.quotePadding;
            }
            if ((n7 & 0x20) != 0) {
                n5 = quoteStyle.quoteWidth;
            }
            if ((n7 & 0x40) != 0) {
                n6 = quoteStyle.verticalPadding;
            }
            return quoteStyle.copy(n, n2, f, n3, n4, n5, n6);
        }

        public String toString() {
            return "QuoteStyle(quoteBackground=" + this.quoteBackground + ", quoteColor=" + this.quoteColor + ", quoteBackgroundAlpha=" + this.quoteBackgroundAlpha + ", quoteMargin=" + this.quoteMargin + ", quotePadding=" + this.quotePadding + ", quoteWidth=" + this.quoteWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((((this.quoteBackground * 31 + this.quoteColor) * 31 + Float.floatToIntBits(this.quoteBackgroundAlpha)) * 31 + this.quoteMargin) * 31 + this.quotePadding) * 31 + this.quoteWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QuoteStyle)) break block3;
                    QuoteStyle quoteStyle = (QuoteStyle)object;
                    if (!(this.quoteBackground == quoteStyle.quoteBackground) || !(this.quoteColor == quoteStyle.quoteColor) || Float.compare(this.quoteBackgroundAlpha, quoteStyle.quoteBackgroundAlpha) != 0 || !(this.quoteMargin == quoteStyle.quoteMargin) || !(this.quotePadding == quoteStyle.quotePadding) || !(this.quoteWidth == quoteStyle.quoteWidth) || !(this.verticalPadding == quoteStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

