/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.text.TextUtilsCompat;
import android.support.v4.util.ArrayMap;
import android.text.Editable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineHeightSpan;
import android.text.style.QuoteSpan;
import android.text.style.UpdateLayout;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ8\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u000208H\u0016J`\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0007H\u0016Jh\u0010D\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00072\u0006\u0010G\u001a\u00020HH\u0016J \u0010L\u001a\u00020H2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0002J \u0010M\u001a\u00020H2\u0006\u0010N\u001a\u00020O2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0002R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001d\"\u0004\b.\u0010\u001f\u00a8\u0006P"}, d2={"Lorg/wordpress/aztec/spans/AztecQuoteSpan;", "Landroid/text/style/QuoteSpan;", "Landroid/text/style/LineBackgroundSpan;", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "nestingLevel", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "align", "Landroid/text/Layout$Alignment;", "(ILorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;Landroid/text/Layout$Alignment;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAlign", "()Landroid/text/Layout$Alignment;", "setAlign", "(Landroid/text/Layout$Alignment;)V", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "offset", "quoteStart", "Landroid/support/v4/util/ArrayMap;", "", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "setQuoteStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;)V", "rect", "Landroid/graphics/Rect;", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "drawBackground", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "left", "right", "top", "baseline", "bottom", "lnum", "drawLeadingMargin", "x", "dir", "first", "", "layout", "Landroid/text/Layout;", "getLeadingMargin", "isRtlQuote", "isWithinListItem", "editable", "Landroid/text/Editable;", "aztec_release"})
public final class AztecQuoteSpan
extends QuoteSpan
implements LineBackgroundSpan,
IAztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    private int endBeforeBleed;
    private int startBeforeCollapse;
    private final Rect rect;
    private int offset;
    private final ArrayMap<Integer, Float> quoteStart;
    @NotNull
    private final String TAG = "blockquote";
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.QuoteStyle quoteStyle;
    @Nullable
    private Layout.Alignment align;

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.quoteStyle.getVerticalPadding();
            fm.top -= this.quoteStyle.getVerticalPadding();
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.quoteStyle.getVerticalPadding();
            fm.bottom += this.quoteStyle.getVerticalPadding();
        }
    }

    public int getLeadingMargin(boolean first) {
        return this.quoteStyle.getQuoteMargin() + this.quoteStyle.getQuoteWidth() + this.quoteStyle.getQuotePadding() - this.offset;
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout2) {
        float marginEnd;
        float marginStart;
        int margin;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        Paint.Style style2 = p.getStyle();
        int color2 = p.getColor();
        p.setStyle(Paint.Style.FILL);
        p.setColor(this.quoteStyle.getQuoteColor());
        Editable editable = (Editable)text;
        boolean isWithinListItem = this.isWithinListItem(editable, start, end);
        boolean isRtl = this.isRtlQuote(text, start, end);
        if (isWithinListItem) {
            margin = x;
            this.offset = this.quoteStyle.getQuoteMargin();
        } else {
            margin = isRtl ? x - this.quoteStyle.getQuoteMargin() : x + this.quoteStyle.getQuoteMargin();
            this.offset = 0;
        }
        if (isRtl) {
            marginStart = margin + dir * this.quoteStyle.getQuoteWidth();
            marginEnd = margin;
            Map map = (Map)this.quoteStart;
            Integer n = start;
            Float f = Float.valueOf(marginStart);
            map.put(n, f);
        } else {
            marginStart = margin;
            marginEnd = margin + dir * this.quoteStyle.getQuoteWidth();
            Map map = (Map)this.quoteStart;
            Integer n = start;
            Float f = Float.valueOf(marginEnd);
            map.put(n, f);
        }
        c.drawRect(marginStart, (float)top, marginEnd, (float)bottom, p);
        p.setStyle(style2);
        p.setColor(color2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isWithinListItem(Editable editable, int start, int end) {
        boolean bl;
        block1: {
            void $receiver$iv;
            Object[] objectArray = editable.getSpans(start, end, AztecListItemSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editable.getSpans(start,\u2026ListItemSpan::class.java)");
            Object[] objectArray2 = objectArray;
            for (void element$iv : $receiver$iv) {
                AztecListItemSpan it = (AztecListItemSpan)element$iv;
                if (!(it.getNestingLevel() == this.getNestingLevel() - 1)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public void drawBackground(@NotNull Canvas c, @NotNull Paint p, int left, int right, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, int lnum) {
        int quoteBackgroundEnd;
        int quoteBackgroundStart;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int alpha = (int)(this.quoteStyle.getQuoteBackgroundAlpha() * (float)255);
        int paintColor = p.getColor();
        p.setColor(Color.argb((int)alpha, (int)Color.red((int)this.quoteStyle.getQuoteBackground()), (int)Color.green((int)this.quoteStyle.getQuoteBackground()), (int)Color.blue((int)this.quoteStyle.getQuoteBackground())));
        boolean isRtl = this.isRtlQuote(text, start, end);
        if (isRtl) {
            quoteBackgroundStart = left;
            Float f = (Float)this.quoteStart.get((Object)start);
            quoteBackgroundEnd = f != null ? (int)f.floatValue() : 0;
        } else {
            Float f = (Float)this.quoteStart.get((Object)start);
            quoteBackgroundStart = f != null ? (int)f.floatValue() : 0;
            quoteBackgroundEnd = right;
        }
        this.rect.set(quoteBackgroundStart, top, quoteBackgroundEnd, bottom);
        c.drawRect(this.rect, p);
        p.setColor(paintColor);
    }

    private final boolean isRtlQuote(CharSequence text, int start, int end) {
        TextDirectionHeuristicCompat textDirectionHeuristicCompat;
        if (TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1) {
            TextDirectionHeuristicCompat textDirectionHeuristicCompat2 = TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL;
            textDirectionHeuristicCompat = textDirectionHeuristicCompat2;
            Intrinsics.checkExpressionValueIsNotNull((Object)textDirectionHeuristicCompat2, (String)"TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL");
        } else {
            TextDirectionHeuristicCompat textDirectionHeuristicCompat3 = TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
            textDirectionHeuristicCompat = textDirectionHeuristicCompat3;
            Intrinsics.checkExpressionValueIsNotNull((Object)textDirectionHeuristicCompat3, (String)"TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR");
        }
        TextDirectionHeuristicCompat textDirectionHeuristic = textDirectionHeuristicCompat;
        return textDirectionHeuristic.isRtl(text, start, end - start);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public final void setQuoteStyle(@NotNull BlockFormatter.QuoteStyle quoteStyle) {
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"<set-?>");
        this.quoteStyle = quoteStyle;
    }

    @Override
    @Nullable
    public Layout.Alignment getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(@Nullable Layout.Alignment alignment) {
        this.align = alignment;
    }

    public AztecQuoteSpan(int nestingLevel, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.QuoteStyle quoteStyle, @Nullable Layout.Alignment align) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.quoteStyle = quoteStyle;
        this.align = align;
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
        this.rect = new Rect();
        this.quoteStart = new ArrayMap();
        this.TAG = "blockquote";
    }

    public /* synthetic */ AztecQuoteSpan(int n, AztecAttributes aztecAttributes, BlockFormatter.QuoteStyle quoteStyle, Layout.Alignment alignment, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 4) != 0) {
            quoteStyle = new BlockFormatter.QuoteStyle(0, 0, 0.0f, 0, 0, 0, 0);
        }
        if ((n2 & 8) != 0) {
            alignment = null;
        }
        this(n, aztecAttributes, quoteStyle, alignment);
    }

    @Override
    @NotNull
    public Layout.Alignment getAlignment() {
        return IAztecBlockSpan.DefaultImpls.getAlignment(this);
    }

    @Override
    public boolean shouldParseAlignmentToHtml() {
        return IAztecBlockSpan.DefaultImpls.shouldParseAlignmentToHtml(this);
    }

    @Override
    @NotNull
    public String getStartTag() {
        return IAztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return IAztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void applyInlineStyleAttributes(@NotNull Editable output, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        IAztecBlockSpan.DefaultImpls.applyInlineStyleAttributes(this, output, start, end);
    }

    @Override
    public void clearStartBeforeCollapse() {
        IAztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return IAztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        IAztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return IAztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

