/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import androidx.core.text.TextDirectionHeuristicCompat;
import androidx.core.text.TextDirectionHeuristicsCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.handlers.BlockHandler;
import org.wordpress.aztec.handlers.HeadingHandler;
import org.wordpress.aztec.handlers.ListItemHandler;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecPreformatSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.IAztecAlignmentSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecCompositeBlockSpan;
import org.wordpress.aztec.spans.IAztecLineBlockSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.wordpress.aztec.spans.ParagraphSpanKt;
import org.wordpress.aztec.util.SpanWrapper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\u0018\u00002\u00020\u0001:\u0004z{|}B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\"\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J \u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J \u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J \u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\"\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u001a\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002JT\u0010.\u001a\u00020\u001a2\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a00j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a`12\u0006\u00102\u001a\u00020\u001a2\u0016\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u001a04j\b\u0012\u0004\u0012\u00020\u001a`52\u0006\u00106\u001a\u00020\u001aH\u0002J\u0018\u00107\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u001aH\u0002J\"\u0010:\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ&\u0010=\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001aJ\"\u0010A\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ\"\u0010B\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ*\u0010C\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001a2\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ\"\u0010D\u001a\u0002082\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ\u000e\u0010E\u001a\u0002082\u0006\u00109\u001a\u00020\u001aJ\u001a\u0010E\u001a\u0002082\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ\u001a\u0010F\u001a\u0002082\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aJ,\u0010G\u001a\b\u0012\u0004\u0012\u00020-0H2\b\u0010*\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aH\u0002J\u001a\u0010I\u001a\u0004\u0018\u00010J2\b\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010>\u001a\u00020KJ\u001e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020?2\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u001aJ\u001c\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001a0H2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ \u0010R\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J(\u0010S\u001a\u00020\u00162\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0T2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J&\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00180H2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001a2\b\b\u0002\u0010V\u001a\u00020WJ?\u0010X\u001a\u00020\u0018\"\u0010\b\u0000\u0010Y*\n\u0012\u0006\b\u0001\u0012\u00020\u00180T2\u0006\u0010Z\u001a\u0002HY2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001a2\b\b\u0002\u0010V\u001a\u00020W\u00a2\u0006\u0002\u0010[J \u0010X\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001a2\b\b\u0002\u0010V\u001a\u00020WJ8\u0010\\\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020\u001a2\u0006\u0010^\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020\u00182\u0006\u0010@\u001a\u00020\u001a2\u0006\u0010`\u001a\u0002082\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J8\u0010a\u001a\u00020\u001a2\u0006\u0010^\u001a\u00020\u001a2\u0006\u0010b\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020\u00182\u0006\u0010@\u001a\u00020\u001a2\u0006\u0010`\u001a\u0002082\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010d\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001eJ>\u0010d\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010e\u001a\u00020\u001a2\u0006\u0010f\u001a\u00020\u001a2\u0014\b\u0002\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180T0H2\b\b\u0002\u0010h\u001a\u000208J\u001e\u0010i\u001a\u00020\u0016\"\b\b\u0000\u0010Y*\u00020\u00182\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002HY0TJ\u000e\u0010j\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001eJ\u000e\u0010k\u001a\u00020\u00162\u0006\u0010l\u001a\u00020\u0018J\"\u0010m\u001a\u00020\u00162\u0006\u0010n\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u001a\u0010o\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\"\u0010p\u001a\u00020\u00162\u0006\u0010q\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\"\u0010r\u001a\u00020\u00162\u0006\u0010s\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010t\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001eJ\u0006\u0010u\u001a\u00020\u0016J\u0006\u0010v\u001a\u00020\u0016J\u000e\u0010w\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001eJ\u0006\u0010x\u001a\u00020\u0016J\u0006\u0010y\u001a\u000208R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006~"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "headerStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "preformatStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;)V", "getHeaderStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "getPreformatStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "applyBlock", "", "blockSpan", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "start", "", "end", "applyBlockStyle", "blockElementType", "Lorg/wordpress/aztec/ITextFormat;", "applyHeadingBlock", "headingSpan", "Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "applyLineBlock", "format", "applyListBlock", "listSpan", "Lorg/wordpress/aztec/spans/AztecListSpan;", "applyQuote", "Lorg/wordpress/aztec/spans/AztecQuoteSpan;", "applyTextAlignment", "textFormat", "changeAlignment", "it", "Lorg/wordpress/aztec/spans/IAztecAlignmentSpan;", "checkBound", "bounds", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "key", "delimiters", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lastIndex", "containHeadingType", "", "index", "containsAlignment", "selStart", "selEnd", "containsBlockElement", "text", "Landroid/text/Editable;", "nestingLevel", "containsHeading", "containsHeadingOnly", "containsList", "containsOtherHeadings", "containsPreformat", "containsQuote", "getAlignedSpans", "", "getAlignment", "Landroid/text/Layout$Alignment;", "", "getBoundsOfText", "Lkotlin/ranges/IntRange;", "editable", "selectionStart", "selectionEnd", "getTopBlockDelimiters", "liftBlock", "liftListBlock", "Ljava/lang/Class;", "makeBlock", "attrs", "Lorg/wordpress/aztec/AztecAttributes;", "makeBlockSpan", "T", "type", "(Ljava/lang/Class;Lorg/wordpress/aztec/ITextFormat;ILorg/wordpress/aztec/AztecAttributes;)Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "mergeWithBlockAbove", "startOfLine", "endOfLine", "spanToApply", "isWithinList", "mergeWithBlockBelow", "startOfBlock", "pushNewBlock", "removeBlockStyle", "originalStart", "originalEnd", "spanTypes", "ignoreLineBounds", "removeEntireBlock", "removeTextAlignment", "setBlockStyle", "blockElement", "switchHeaderType", "headerTypeToSwitchTo", "switchHeadingToPreformat", "switchListType", "listTypeToSwitchTo", "switchPreformatToHeading", "headingTextFormat", "toggleHeading", "toggleOrderedList", "toggleQuote", "toggleTextAlignment", "toggleUnorderedList", "tryRemoveBlockStyleFromFirstLine", "HeaderStyle", "ListStyle", "PreformatStyle", "QuoteStyle", "aztec_release"})
public final class BlockFormatter
extends AztecFormatter {
    @NotNull
    private final ListStyle listStyle;
    @NotNull
    private final QuoteStyle quoteStyle;
    @NotNull
    private final HeaderStyle headerStyle;
    @NotNull
    private final PreformatStyle preformatStyle;

    public final void toggleOrderedList() {
        if (!BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
            if (BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
                BlockFormatter.switchListType$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
            }
        } else if (BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
            BlockFormatter.switchListType$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 6, null);
        } else {
            this.removeBlockStyle(AztecTextFormat.FORMAT_ORDERED_LIST);
        }
    }

    public final void toggleUnorderedList() {
        if (!BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 0, 12, null)) {
            if (BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
                BlockFormatter.switchListType$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
            }
        } else if (BlockFormatter.containsList$default(this, AztecTextFormat.FORMAT_ORDERED_LIST, 0, 0, 0, 12, null)) {
            BlockFormatter.switchListType$default(this, AztecTextFormat.FORMAT_UNORDERED_LIST, 0, 0, 6, null);
        } else {
            this.removeBlockStyle(AztecTextFormat.FORMAT_UNORDERED_LIST);
        }
    }

    public final void toggleQuote() {
        if (!BlockFormatter.containsQuote$default(this, 0, 0, 3, null)) {
            BlockFormatter.applyBlockStyle$default(this, AztecTextFormat.FORMAT_QUOTE, 0, 0, 6, null);
        } else {
            this.removeEntireBlock(AztecQuoteSpan.class);
        }
    }

    public final void toggleHeading(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        ITextFormat iTextFormat = textFormat;
        if (iTextFormat == AztecTextFormat.FORMAT_HEADING_1 || iTextFormat == AztecTextFormat.FORMAT_HEADING_2 || iTextFormat == AztecTextFormat.FORMAT_HEADING_3 || iTextFormat == AztecTextFormat.FORMAT_HEADING_4 || iTextFormat == AztecTextFormat.FORMAT_HEADING_5 || iTextFormat == AztecTextFormat.FORMAT_HEADING_6) {
            if (!BlockFormatter.containsHeadingOnly$default(this, textFormat, 0, 0, 6, null)) {
                if (BlockFormatter.containsPreformat$default(this, 0, 0, 3, null)) {
                    BlockFormatter.switchPreformatToHeading$default(this, textFormat, 0, 0, 6, null);
                } else if (BlockFormatter.containsOtherHeadings$default(this, textFormat, 0, 0, 6, null)) {
                    BlockFormatter.switchHeaderType$default(this, textFormat, 0, 0, 6, null);
                } else {
                    BlockFormatter.applyBlockStyle$default(this, textFormat, 0, 0, 6, null);
                }
            }
        } else if (iTextFormat == AztecTextFormat.FORMAT_PARAGRAPH) {
            Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecHeadingSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(se\u2026cHeadingSpan::class.java)");
            AztecHeadingSpan span = (AztecHeadingSpan)ArraysKt.firstOrNull((Object[])objectArray);
            if (span != null) {
                this.removeBlockStyle(span.getTextFormat());
            }
            this.removeBlockStyle(AztecTextFormat.FORMAT_PREFORMAT);
        } else if (iTextFormat == AztecTextFormat.FORMAT_PREFORMAT && !BlockFormatter.containsPreformat$default(this, 0, 0, 3, null)) {
            if (BlockFormatter.containsOtherHeadings$default(this, AztecTextFormat.FORMAT_PREFORMAT, 0, 0, 6, null)) {
                BlockFormatter.switchHeadingToPreformat$default(this, 0, 0, 3, null);
            } else {
                BlockFormatter.applyBlockStyle$default(this, textFormat, 0, 0, 6, null);
            }
        }
    }

    public final void toggleTextAlignment(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        ITextFormat iTextFormat = textFormat;
        if (iTextFormat == AztecTextFormat.FORMAT_ALIGN_LEFT || iTextFormat == AztecTextFormat.FORMAT_ALIGN_CENTER || iTextFormat == AztecTextFormat.FORMAT_ALIGN_RIGHT) {
            if (BlockFormatter.containsAlignment$default(this, textFormat, 0, 0, 6, null)) {
                this.removeTextAlignment(textFormat);
            } else {
                BlockFormatter.applyTextAlignment$default(this, textFormat, 0, 0, 6, null);
            }
        }
    }

    public final void removeTextAlignment(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Iterable $receiver$iv = BlockFormatter.getAlignedSpans$default(this, textFormat, 0, 0, 6, null);
        for (Object element$iv : $receiver$iv) {
            IAztecAlignmentSpan it = (IAztecAlignmentSpan)element$iv;
            this.changeAlignment(it, null);
        }
    }

    public final boolean tryRemoveBlockStyleFromFirstLine() {
        Object[] $receiver$iv;
        int selectionStart = this.getEditor().getSelectionStart();
        if (selectionStart != 0) {
            return false;
        }
        boolean changed = false;
        Object[] objectArray = this.getEditableText().getSpans(0, 0, IAztecBlockSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(0,\u2026tecBlockSpan::class.java)");
        for (Object element$iv : $receiver$iv = objectArray) {
            int indexOfNewline;
            IAztecBlockSpan it = (IAztecBlockSpan)element$iv;
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            int n = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)'\n', (int)0, (boolean)false, (int)6, null);
            int it2 = n;
            int n2 = indexOfNewline = it2 != -1 ? it2 : this.getEditableText().length();
            if (spanEnd <= indexOfNewline + 1) {
                this.getEditableText().removeSpan((Object)it);
                changed = true;
                continue;
            }
            this.getEditableText().setSpan((Object)it, indexOfNewline + 1, spanEnd, this.getEditableText().getSpanFlags((Object)it));
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(@NotNull ITextFormat textFormat) {
        Collection<Class<?>> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Iterable iterable = BlockFormatter.makeBlock$default(this, textFormat, 0, null, 4, null);
        int n = this.getSelectionEnd();
        int n2 = this.getSelectionStart();
        ITextFormat iTextFormat = textFormat;
        BlockFormatter blockFormatter = this;
        void var3_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IAztecBlockSpan iAztecBlockSpan = (IAztecBlockSpan)item$iv$iv;
            collection = destination$iv$iv;
            Class<?> clazz = it.getClass();
            collection.add(clazz);
        }
        collection = (List)destination$iv$iv;
        BlockFormatter.removeBlockStyle$default(blockFormatter, iTextFormat, n2, n, (List)collection, false, 16, null);
    }

    public final <T extends IAztecBlockSpan> void removeEntireBlock(@NotNull Class<T> type) {
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), type);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(se\u2026tart, selectionEnd, type)");
        for (Object element$iv : $receiver$iv = objectArray) {
            IAztecBlockSpan it = (IAztecBlockSpan)element$iv;
            IAztecNestable.Companion.pullUp$default(IAztecNestable.Companion, (Spannable)this.getEditableText(), this.getSelectionStart(), this.getSelectionEnd(), it.getNestingLevel(), 0, 16, null);
            this.getEditableText().removeSpan((Object)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBlockStyle(@NotNull ITextFormat textFormat, int originalStart, int originalEnd, @NotNull List<Class<IAztecBlockSpan>> spanTypes, boolean ignoreLineBounds) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull(spanTypes, (String)"spanTypes");
        int start = originalStart;
        int end = originalEnd;
        IntRange boundsOfSelectedText = ignoreLineBounds ? new IntRange(start, end) : this.getBoundsOfText(this.getEditableText(), start, end);
        int startOfBounds = boundsOfSelectedText.getStart();
        int endOfBounds = boundsOfSelectedText.getEndInclusive();
        if (ignoreLineBounds) {
            boolean hasExtendingBeyondSpans;
            block20: {
                boolean bl;
                Iterable $receiver$iv;
                boolean hasPrecedingSpans;
                block18: {
                    boolean bl2;
                    Iterable $receiver$iv2 = spanTypes;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            boolean bl3;
                            block17: {
                                void $receiver$iv3;
                                Class spanType = (Class)element$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.getEditableText().getSpans(start, end, spanType), (String)"editableText.getSpans(start, end, spanType)");
                                for (void element$iv2 : $receiver$iv3) {
                                    IAztecBlockSpan span = (IAztecBlockSpan)element$iv2;
                                    if (!(this.getEditableText().getSpanStart((Object)span) < startOfBounds)) continue;
                                    bl3 = true;
                                    break block17;
                                }
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block18;
                        }
                        bl2 = hasPrecedingSpans = false;
                    }
                }
                if (hasPrecedingSpans && this.getEditableText().charAt(startOfBounds - 1) != Constants.INSTANCE.getNEWLINE()) {
                    this.getEditableText().insert(startOfBounds, (CharSequence)("" + Constants.INSTANCE.getNEWLINE()));
                    int $receiver$iv2 = start;
                    start = $receiver$iv2 + 1;
                    $receiver$iv2 = end;
                    end = $receiver$iv2 + 1;
                    $receiver$iv2 = startOfBounds;
                    startOfBounds = $receiver$iv2 + 1;
                    $receiver$iv2 = endOfBounds;
                    endOfBounds = $receiver$iv2 + 1;
                }
                if (($receiver$iv = (Iterable)spanTypes) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        boolean bl4;
                        block19: {
                            void $receiver$iv4;
                            Class spanType = (Class)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)this.getEditableText().getSpans(start, end, spanType), (String)"editableText.getSpans(start, end, spanType)");
                            for (void element$iv3 : $receiver$iv4) {
                                IAztecBlockSpan span = (IAztecBlockSpan)element$iv3;
                                if (!(endOfBounds < this.getEditableText().getSpanEnd((Object)span))) continue;
                                bl4 = true;
                                break block19;
                            }
                            bl4 = false;
                        }
                        if (!bl4) continue;
                        bl = true;
                        break block20;
                    }
                    bl = hasExtendingBeyondSpans = false;
                }
            }
            if (hasExtendingBeyondSpans && this.getEditableText().charAt(endOfBounds) != Constants.INSTANCE.getNEWLINE()) {
                this.getEditableText().insert(endOfBounds, (CharSequence)("" + Constants.INSTANCE.getNEWLINE()));
                int $receiver$iv = end;
                end = $receiver$iv + 1;
                $receiver$iv = endOfBounds;
                endOfBounds = $receiver$iv + 1;
                if (this.getSelectionEnd() == endOfBounds) {
                    this.getEditor().setSelection(this.getSelectionStart() != this.getSelectionEnd() ? this.getSelectionStart() : this.getSelectionEnd() - 1, this.getSelectionEnd() - 1);
                }
            }
        }
        Iterable $receiver$iv = spanTypes;
        for (Object element$iv : $receiver$iv) {
            IAztecBlockSpan[] $receiver$iv5;
            Class spanType = (Class)element$iv;
            boolean hasLingeringEmptyListItem = spanType.isAssignableFrom(AztecListItemSpan.class) && this.getEditableText().length() > end && (this.getEditableText().charAt(end) == '\n' || this.getEditableText().charAt(end) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER());
            int endModifier = hasLingeringEmptyListItem ? 1 : 0;
            IAztecBlockSpan[] spans = (IAztecBlockSpan[])this.getEditableText().getSpans(start, end + endModifier, spanType);
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            IAztecBlockSpan[] iAztecBlockSpanArray = $receiver$iv5 = spans;
            int n = iAztecBlockSpanArray.length;
            for (int i = 0; i < n; ++i) {
                boolean spanExtendsBeyondLine;
                IAztecBlockSpan element$iv4;
                IAztecBlockSpan span = element$iv4 = iAztecBlockSpanArray[i];
                int spanStart = this.getEditableText().getSpanStart((Object)span);
                int spanEnd = this.getEditableText().getSpanEnd((Object)span);
                boolean spanPrecedesLine = spanStart < startOfBounds;
                boolean bl = spanExtendsBeyondLine = endOfBounds < spanEnd;
                if (spanPrecedesLine && !spanExtendsBeyondLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    IAztecBlockSpan iAztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, iAztecBlockSpan, spanStart, startOfBounds);
                    continue;
                }
                if (spanExtendsBeyondLine && !spanPrecedesLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    IAztecBlockSpan iAztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, iAztecBlockSpan, endOfBounds, spanEnd);
                    continue;
                }
                if (spanPrecedesLine && spanExtendsBeyondLine) {
                    Spannable spannable = (Spannable)this.getEditableText();
                    IAztecBlockSpan iAztecBlockSpan = span;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecBlockSpan, (String)"span");
                    BlockHandler.Companion.set(spannable, iAztecBlockSpan, spanStart, startOfBounds);
                    BlockHandler.Companion.set((Spannable)this.getEditableText(), this.makeBlockSpan(span.getClass(), textFormat, span.getNestingLevel(), span.getAttributes()), endOfBounds, spanEnd);
                    continue;
                }
                IAztecNestable.Companion.pullUp$default(IAztecNestable.Companion, (Spannable)this.getEditableText(), this.getEditableText().getSpanStart((Object)span), this.getEditableText().getSpanEnd((Object)span), span.getNestingLevel(), 0, 16, null);
                this.getEditableText().removeSpan((Object)span);
            }
        }
    }

    public static /* synthetic */ void removeBlockStyle$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, List list, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            List<Class<IAztecBlockSpan>> list2 = Arrays.asList(IAztecBlockSpan.class);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(IAztecBlockSpan::class.java)");
            list = list2;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        blockFormatter.removeBlockStyle(iTextFormat, n, n2, list, bl);
    }

    @NotNull
    public final List<IAztecBlockSpan> makeBlock(@NotNull ITextFormat textFormat, int nestingLevel, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        ITextFormat iTextFormat = textFormat;
        if (iTextFormat == AztecTextFormat.FORMAT_ORDERED_LIST) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecOrderedListSpan(nestingLevel, attrs, this.listStyle), new AztecListItemSpan(nestingLevel + 1, null, null, 6, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecOrder\u2026emSpan(nestingLevel + 1))");
            return list;
        }
        if (iTextFormat == AztecTextFormat.FORMAT_UNORDERED_LIST) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecUnorderedListSpan(nestingLevel, attrs, this.listStyle), new AztecListItemSpan(nestingLevel + 1, null, null, 6, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecUnord\u2026emSpan(nestingLevel + 1))");
            return list;
        }
        if (iTextFormat == AztecTextFormat.FORMAT_QUOTE) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecQuoteSpan(nestingLevel, attrs, this.quoteStyle, null, 8, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecQuote\u2026evel, attrs, quoteStyle))");
            return list;
        }
        if (iTextFormat == AztecTextFormat.FORMAT_HEADING_1 || iTextFormat == AztecTextFormat.FORMAT_HEADING_2 || iTextFormat == AztecTextFormat.FORMAT_HEADING_3 || iTextFormat == AztecTextFormat.FORMAT_HEADING_4 || iTextFormat == AztecTextFormat.FORMAT_HEADING_5 || iTextFormat == AztecTextFormat.FORMAT_HEADING_6) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecHeadingSpan(nestingLevel, textFormat, attrs, this.headerStyle, null, 16, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecHeadi\u2026mat, attrs, headerStyle))");
            return list;
        }
        if (iTextFormat == AztecTextFormat.FORMAT_PREFORMAT) {
            List<IAztecBlockSpan> list = Arrays.asList(new AztecPreformatSpan(nestingLevel, attrs, this.preformatStyle, null, 8, null));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AztecPrefo\u2026, attrs, preformatStyle))");
            return list;
        }
        List<IAztecBlockSpan> list = Arrays.asList(ParagraphSpanKt.createParagraphSpan$default(nestingLevel, attrs, null, 4, null));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(createPara\u2026pan(nestingLevel, attrs))");
        return list;
    }

    @NotNull
    public static /* synthetic */ List makeBlock$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, AztecAttributes aztecAttributes, int n2, Object object) {
        if ((n2 & 4) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return blockFormatter.makeBlock(iTextFormat, n, aztecAttributes);
    }

    @Nullable
    public final Layout.Alignment getAlignment(@Nullable ITextFormat textFormat, @NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        TextDirectionHeuristicCompat direction = TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        boolean isRtl = direction.isRtl(text, 0, text.length());
        ITextFormat iTextFormat = textFormat;
        return iTextFormat == AztecTextFormat.FORMAT_ALIGN_LEFT ? (!isRtl ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE) : (iTextFormat == AztecTextFormat.FORMAT_ALIGN_CENTER ? Layout.Alignment.ALIGN_CENTER : (iTextFormat == AztecTextFormat.FORMAT_ALIGN_RIGHT ? (isRtl ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE) : null));
    }

    @NotNull
    public final IAztecBlockSpan makeBlockSpan(@NotNull ITextFormat textFormat, int nestingLevel, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        ITextFormat iTextFormat = textFormat;
        return iTextFormat == AztecTextFormat.FORMAT_ORDERED_LIST ? this.makeBlockSpan(AztecOrderedListSpan.class, textFormat, nestingLevel, attrs) : (iTextFormat == AztecTextFormat.FORMAT_UNORDERED_LIST ? this.makeBlockSpan(AztecUnorderedListSpan.class, textFormat, nestingLevel, attrs) : (iTextFormat == AztecTextFormat.FORMAT_QUOTE ? this.makeBlockSpan(AztecQuoteSpan.class, textFormat, nestingLevel, attrs) : (iTextFormat == AztecTextFormat.FORMAT_HEADING_1 || iTextFormat == AztecTextFormat.FORMAT_HEADING_2 || iTextFormat == AztecTextFormat.FORMAT_HEADING_3 || iTextFormat == AztecTextFormat.FORMAT_HEADING_4 || iTextFormat == AztecTextFormat.FORMAT_HEADING_5 || iTextFormat == AztecTextFormat.FORMAT_HEADING_6 ? this.makeBlockSpan(AztecHeadingSpan.class, textFormat, nestingLevel, attrs) : (iTextFormat == AztecTextFormat.FORMAT_PREFORMAT ? this.makeBlockSpan(AztecPreformatSpan.class, textFormat, nestingLevel, attrs) : ParagraphSpanKt.createParagraphSpan$default(nestingLevel, attrs, null, 4, null)))));
    }

    @NotNull
    public static /* synthetic */ IAztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, AztecAttributes aztecAttributes, int n2, Object object) {
        if ((n2 & 4) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return blockFormatter.makeBlockSpan(iTextFormat, n, aztecAttributes);
    }

    @NotNull
    public final <T extends Class<? extends IAztecBlockSpan>> IAztecBlockSpan makeBlockSpan(@NotNull T type, @NotNull ITextFormat textFormat, int nestingLevel, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        T t = type;
        return Intrinsics.areEqual(t, AztecOrderedListSpan.class) ? (IAztecBlockSpan)new AztecOrderedListSpan(nestingLevel, attrs, this.listStyle) : (Intrinsics.areEqual(t, AztecUnorderedListSpan.class) ? (IAztecBlockSpan)new AztecUnorderedListSpan(nestingLevel, attrs, this.listStyle) : (Intrinsics.areEqual(t, AztecListItemSpan.class) ? (IAztecBlockSpan)new AztecListItemSpan(nestingLevel, attrs, null, 4, null) : (Intrinsics.areEqual(t, AztecQuoteSpan.class) ? (IAztecBlockSpan)new AztecQuoteSpan(nestingLevel, attrs, this.quoteStyle, null, 8, null) : (Intrinsics.areEqual(t, AztecHeadingSpan.class) ? (IAztecBlockSpan)new AztecHeadingSpan(nestingLevel, textFormat, attrs, this.headerStyle, null, 16, null) : (Intrinsics.areEqual(t, AztecPreformatSpan.class) ? (IAztecBlockSpan)new AztecPreformatSpan(nestingLevel, attrs, this.preformatStyle, null, 8, null) : ParagraphSpanKt.createParagraphSpan$default(nestingLevel, attrs, null, 4, null))))));
    }

    @NotNull
    public static /* synthetic */ IAztecBlockSpan makeBlockSpan$default(BlockFormatter blockFormatter, Class clazz, ITextFormat iTextFormat, int n, AztecAttributes aztecAttributes, int n2, Object object) {
        if ((n2 & 8) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return blockFormatter.makeBlockSpan(clazz, iTextFormat, n, aztecAttributes);
    }

    public final void setBlockStyle(@NotNull IAztecBlockSpan blockElement) {
        Intrinsics.checkParameterIsNotNull((Object)blockElement, (String)"blockElement");
        IAztecBlockSpan iAztecBlockSpan = blockElement;
        if (iAztecBlockSpan instanceof AztecOrderedListSpan) {
            ((AztecOrderedListSpan)blockElement).setListStyle(this.listStyle);
        } else if (iAztecBlockSpan instanceof AztecUnorderedListSpan) {
            ((AztecUnorderedListSpan)blockElement).setListStyle(this.listStyle);
        } else if (iAztecBlockSpan instanceof AztecQuoteSpan) {
            ((AztecQuoteSpan)blockElement).setQuoteStyle(this.quoteStyle);
        } else if (iAztecBlockSpan instanceof AztecPreformatSpan) {
            ((AztecPreformatSpan)blockElement).setPreformatStyle(this.preformatStyle);
        } else if (iAztecBlockSpan instanceof AztecHeadingSpan) {
            ((AztecHeadingSpan)blockElement).setHeaderStyle(this.headerStyle);
        }
    }

    @NotNull
    public final List<Integer> getTopBlockDelimiters(int start, int end) {
        Object it;
        Object $receiver$iv$iv;
        Object $receiver$iv;
        ArrayList delimiters = CollectionsKt.arrayListOf((Object[])new Integer[]{start, end});
        HashMap<Integer, Integer> bounds = new HashMap<Integer, Integer>();
        int startNesting = IAztecNestable.Companion.getMinNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), start, 0, 4, null);
        Map map = bounds;
        Object object = start;
        Object[] objectArray = Integer.valueOf(startNesting);
        map.put(object, objectArray);
        int endNesting = IAztecNestable.Companion.getMinNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), end, 0, 4, null);
        object = bounds;
        objectArray = end;
        Integer n = endNesting;
        object.put(objectArray, n);
        Object[] objectArray2 = this.getEditableText().getSpans(start, end, IAztecBlockSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"editableText.getSpans(st\u2026tecBlockSpan::class.java)");
        objectArray = objectArray2;
        n = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (Map element$iv$iv : $receiver$iv$iv) {
            it = (IAztecBlockSpan)((Object)element$iv$iv);
            if (!(this.getEditableText().getSpanStart(it) >= start && this.getEditableText().getSpanEnd(it) <= end)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new Comparator<T>(this){
            final /* synthetic */ BlockFormatter this$0;
            {
                this.this$0 = blockFormatter;
            }

            public final int compare(T a, T b) {
                IAztecBlockSpan it = (IAztecBlockSpan)a;
                Comparable comparable = Integer.valueOf(this.this$0.getEditableText().getSpanStart((Object)it));
                it = (IAztecBlockSpan)b;
                Comparable comparable2 = comparable;
                Integer n = this.this$0.getEditableText().getSpanStart((Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List blockSpans = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv);
        $receiver$iv = blockSpans;
        $receiver$iv$iv = $receiver$iv.iterator();
        while ($receiver$iv$iv.hasNext()) {
            SpanWrapper<? extends IAztecNestable> parent;
            Map element$iv$iv;
            Object element$iv = $receiver$iv$iv.next();
            IAztecBlockSpan it2 = (IAztecBlockSpan)element$iv;
            int spanIndex = this.getEditableText().getSpanStart((Object)it2);
            int nesting = IAztecNestable.Companion.getMinNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), spanIndex, 0, 4, null);
            element$iv$iv = bounds;
            it = spanIndex;
            Object object2 = nesting;
            element$iv$iv.put(it, object2);
            spanIndex = this.getEditableText().getSpanEnd((Object)it2);
            nesting = IAztecNestable.Companion.getMinNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), spanIndex, 0, 4, null);
            element$iv$iv = bounds;
            it = spanIndex;
            object2 = nesting;
            element$iv$iv.put(it, object2);
            if (!(it2 instanceof IAztecCompositeBlockSpan)) continue;
            SpanWrapper<IAztecBlockSpan> wrapper = new SpanWrapper<IAztecBlockSpan>((Spannable)this.getEditableText(), it2);
            SpanWrapper<? extends IAztecNestable> spanWrapper = parent = IAztecNestable.Companion.getParent((Spannable)this.getEditableText(), wrapper);
            if (spanWrapper == null) continue;
            Object it3 = object2 = spanWrapper;
            if (parent.getStart() >= start && parent.getEnd() <= end) continue;
            delimiters.add(wrapper.getStart());
            delimiters.add(wrapper.getEnd());
        }
        $receiver$iv = bounds;
        if (!$receiver$iv.isEmpty()) {
            int last;
            Set set = bounds.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"bounds.keys");
            Object object3 = CollectionsKt.first((Iterable)set);
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"bounds.keys.first()");
            int lastIndex = ((Number)object3).intValue();
            Set set2 = bounds.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"bounds.keys");
            Iterable $receiver$iv2 = set2;
            for (Object element$iv : $receiver$iv2) {
                Integer key;
                Integer n2 = key = (Integer)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"key");
                last = this.checkBound(bounds, n2, delimiters, lastIndex);
                if (last <= -1) continue;
                lastIndex = last;
            }
            Set set3 = bounds.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set3, (String)"bounds.keys");
            Object object4 = CollectionsKt.last((Iterable)set3);
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"bounds.keys.last()");
            lastIndex = ((Number)object4).intValue();
            Set<Integer> set4 = bounds.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set4, (String)"bounds.keys");
            $receiver$iv2 = CollectionsKt.reversed((Iterable)set4);
            for (Object element$iv : $receiver$iv2) {
                Integer key;
                Integer n3 = key = (Integer)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"key");
                last = this.checkBound(bounds, n3, delimiters, lastIndex);
                if (last <= -1) continue;
                lastIndex = last;
            }
        }
        return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)delimiters));
    }

    private final int checkBound(HashMap<Integer, Integer> bounds, int key, ArrayList<Integer> delimiters, int lastIndex) {
        Integer n = bounds.get(key);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        Integer n2 = bounds.get(lastIndex);
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)n, (Object)n2) ^ true) {
            Integer n3 = bounds.get(key);
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            int n4 = ((Number)n3).intValue();
            Integer n5 = bounds.get(lastIndex);
            if (n5 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"bounds[lastIndex]!!");
            if (Intrinsics.compare((int)n4, (int)((Number)n5).intValue()) < 0) {
                delimiters.add(key);
                return key;
            }
        }
        return -1;
    }

    @NotNull
    public final IntRange getBoundsOfText(@NotNull Editable editable, int selectionStart, int selectionEnd) {
        int indexOfFirstLineBreak;
        Intrinsics.checkParameterIsNotNull((Object)editable, (String)"editable");
        boolean selectionStartIsOnTheNewLine = selectionStart != selectionEnd && selectionStart > 0 && selectionStart < this.getEditableText().length() && editable.charAt(selectionStart) == '\n';
        boolean selectionStartIsBetweenNewlines = selectionStartIsOnTheNewLine && selectionStart > 0 && selectionStart < this.getEditableText().length() && editable.charAt(selectionStart - 1) == '\n';
        boolean isTrailingNewlineAtTheEndOfSelection = selectionStart != selectionEnd && selectionEnd > 0 && this.getEditableText().length() > selectionEnd && this.getEditableText().charAt(selectionEnd) != Constants.INSTANCE.getEND_OF_BUFFER_MARKER() && this.getEditableText().charAt(selectionEnd) != '\n' && this.getEditableText().charAt(selectionEnd - 1) == '\n';
        int indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionEnd, (boolean)false, (int)4, null);
        if (selectionStartIsBetweenNewlines) {
            indexOfFirstLineBreak = selectionStart;
        } else if (selectionStartIsOnTheNewLine) {
            boolean isSingleCharacterLine = selectionStart > 1 && this.getEditableText().charAt(selectionStart - 1) != '\n' && this.getEditableText().charAt(selectionStart - 2) == '\n' || selectionStart == 1;
            indexOfFirstLineBreak = isSingleCharacterLine ? selectionStart - 1 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1;
            if (isTrailingNewlineAtTheEndOfSelection) {
                indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionEnd - 1), (boolean)false, (int)4, null);
            }
        } else if (isTrailingNewlineAtTheEndOfSelection) {
            indexOfFirstLineBreak = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1;
            indexOfLastLineBreak = StringsKt.indexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionEnd - 1), (boolean)false, (int)4, null);
        } else {
            indexOfFirstLineBreak = indexOfLastLineBreak > 0 ? StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)(selectionStart - 1), (boolean)false, (int)4, null) + 1 : (indexOfLastLineBreak == -1 ? (selectionStart == 0 ? 0 : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null) + 1) : StringsKt.lastIndexOf$default((CharSequence)((CharSequence)editable), (String)"\n", (int)selectionStart, (boolean)false, (int)4, null));
        }
        int startOfBlock = indexOfFirstLineBreak != -1 ? indexOfFirstLineBreak : 0;
        int endOfBlock = indexOfLastLineBreak != -1 ? indexOfLastLineBreak + 1 : editable.length();
        return new IntRange(startOfBlock, endOfBlock);
    }

    public final void applyTextAlignment(@NotNull ITextFormat textFormat, int start, int end) {
        IAztecAlignmentSpan it;
        Object element$iv$iv;
        Iterator iterator;
        Object $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        CharSequence charSequence = (CharSequence)this.getEditableText();
        if (charSequence.length() == 0) {
            this.getEditableText().append((CharSequence)("" + Constants.INSTANCE.getEND_OF_BUFFER_MARKER()));
        }
        IntRange boundsOfSelectedText = this.getBoundsOfText(this.getEditableText(), start, end);
        List spans = this.getAlignedSpans(null, boundsOfSelectedText.getStart(), boundsOfSelectedText.getEndInclusive());
        if (start == end) {
            if (start == boundsOfSelectedText.getStart() && spans.size() > 1) {
                $receiver$iv = spans;
                Iterable iterable = $receiver$iv;
                destination$iv$iv = new ArrayList();
                iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    it = (IAztecAlignmentSpan)element$iv$iv;
                    if (!(this.getEditableText().getSpanEnd((Object)it) != start)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                spans = (List)destination$iv$iv;
            } else if (start == boundsOfSelectedText.getEndInclusive() && spans.size() > 1) {
                $receiver$iv = spans;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    it = (IAztecAlignmentSpan)element$iv$iv;
                    if (!(this.getEditableText().getSpanStart((Object)it) != start)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                spans = (List)destination$iv$iv;
            }
        }
        if (!($receiver$iv = (Collection)spans).isEmpty()) {
            $receiver$iv = spans;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (IAztecAlignmentSpan)element$iv$iv;
                if (!(!(it instanceof AztecListSpan))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                IAztecAlignmentSpan it2 = (IAztecAlignmentSpan)element$iv;
                this.changeAlignment(it2, textFormat);
            }
        } else {
            int nestingLevel = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), boundsOfSelectedText.getStart(), 0, 4, null);
            Layout.Alignment alignment = this.getAlignment(textFormat, StringsKt.subSequence((CharSequence)((CharSequence)this.getEditableText()), (IntRange)RangesKt.until((int)boundsOfSelectedText.getStart(), (int)boundsOfSelectedText.getEndInclusive())));
            this.getEditableText().setSpan((Object)ParagraphSpanKt.createParagraphSpan(nestingLevel, new AztecAttributes(null, 1, null), alignment), boundsOfSelectedText.getStart().intValue(), boundsOfSelectedText.getEndInclusive().intValue(), 51);
        }
    }

    public static /* synthetic */ void applyTextAlignment$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.applyTextAlignment(iTextFormat, n, n2);
    }

    private final void changeAlignment(IAztecAlignmentSpan it, ITextFormat blockElementType) {
        SpanWrapper<IAztecAlignmentSpan> wrapper = new SpanWrapper<IAztecAlignmentSpan>((Spannable)this.getEditableText(), it);
        it.setAlign(this.getAlignment(blockElementType, StringsKt.substring((CharSequence)((CharSequence)this.getEditableText()), (IntRange)RangesKt.until((int)wrapper.getStart(), (int)wrapper.getEnd()))));
        this.getEditableText().setSpan((Object)it, wrapper.getStart(), wrapper.getEnd(), wrapper.getFlags());
    }

    /*
     * WARNING - void declaration
     */
    public final void applyBlockStyle(@NotNull ITextFormat blockElementType, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)blockElementType, (String)"blockElementType");
        CharSequence charSequence = (CharSequence)this.getEditableText();
        if (charSequence.length() == 0) {
            this.getEditableText().append((CharSequence)("" + Constants.INSTANCE.getEND_OF_BUFFER_MARKER()));
        }
        IntRange boundsOfSelectedText = this.getBoundsOfText(this.getEditableText(), start, end);
        int nestingLevel = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), start, 0, 4, null) + 1;
        IAztecBlockSpan spanToApply = BlockFormatter.makeBlockSpan$default(this, blockElementType, nestingLevel, null, 4, null);
        if (start != end) {
            if (spanToApply instanceof IAztecLineBlockSpan) {
                this.applyLineBlock(blockElementType, boundsOfSelectedText.getStart(), boundsOfSelectedText.getEndInclusive());
            } else {
                List<Integer> delimiters = this.getTopBlockDelimiters(boundsOfSelectedText.getStart(), boundsOfSelectedText.getEndInclusive());
                int n = 0;
                int n2 = delimiters.size() - 1;
                while (n < n2) {
                    void i;
                    this.pushNewBlock(((Number)delimiters.get((int)i)).intValue(), ((Number)delimiters.get((int)(i + true))).intValue(), blockElementType);
                    ++i;
                }
            }
            this.getEditor().setSelection(this.getEditor().getSelectionStart());
        } else {
            boolean bl;
            int endOfLine;
            int startOfLine;
            block9: {
                void $receiver$iv;
                startOfLine = boundsOfSelectedText.getStart();
                endOfLine = boundsOfSelectedText.getEndInclusive();
                Object[] objectArray = this.getEditableText().getSpans(boundsOfSelectedText.getStart().intValue(), boundsOfSelectedText.getEndInclusive().intValue(), IAztecCompositeBlockSpan.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(bo\u2026iteBlockSpan::class.java)");
                Object[] objectArray2 = objectArray;
                for (void element$iv : $receiver$iv) {
                    IAztecCompositeBlockSpan it = (IAztecCompositeBlockSpan)element$iv;
                    if (!(it.getNestingLevel() == nestingLevel - 1)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            boolean isWithinPartialBlock = bl;
            int startOfBlock = this.mergeWithBlockAbove(startOfLine, endOfLine, spanToApply, nestingLevel, isWithinPartialBlock, blockElementType);
            int endOfBlock = this.mergeWithBlockBelow(endOfLine, startOfBlock, spanToApply, nestingLevel, isWithinPartialBlock, blockElementType);
            if (spanToApply instanceof IAztecLineBlockSpan) {
                this.applyBlock(spanToApply, startOfBlock, endOfBlock);
            } else {
                this.pushNewBlock(startOfBlock, endOfBlock, blockElementType);
            }
        }
        this.getEditor().setSelection(this.getEditor().getSelectionStart(), this.getEditor().getSelectionEnd());
    }

    public static /* synthetic */ void applyBlockStyle$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.applyBlockStyle(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final void pushNewBlock(int start, int end, ITextFormat blockElementType) {
        SpanWrapper it;
        IAztecBlockSpan newBlock;
        boolean isListItem;
        int nesting;
        block4: {
            boolean bl;
            void $receiver$iv;
            nesting = IAztecNestable.Companion.getMinNestingLevelAt((Spanned)this.getEditableText(), start, end) + 1;
            Object[] objectArray = this.getEditableText().getSpans(start, end, IAztecCompositeBlockSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026iteBlockSpan::class.java)");
            Object[] objectArray2 = objectArray;
            for (void element$iv : $receiver$iv) {
                IAztecCompositeBlockSpan it2 = (IAztecCompositeBlockSpan)element$iv;
                if (!(it2.getNestingLevel() == nesting)) continue;
                bl = true;
                break block4;
            }
            bl = isListItem = false;
        }
        if (isListItem) {
            int $receiver$iv = nesting;
            nesting = $receiver$iv + 1;
        }
        int pushBy = (newBlock = BlockFormatter.makeBlockSpan$default(this, blockElementType, nesting, null, 4, null)) instanceof AztecListSpan ? 2 : 1;
        List<SpanWrapper<IAztecNestable>> spans = IAztecNestable.Companion.pushDeeper((Spannable)this.getEditableText(), start, end, nesting, pushBy);
        Iterable $receiver$iv = spans;
        for (Object element$iv : $receiver$iv) {
            it = (SpanWrapper)element$iv;
            it.remove();
        }
        this.applyBlock(newBlock, start, end);
        $receiver$iv = spans;
        for (Object element$iv : $receiver$iv) {
            it = (SpanWrapper)element$iv;
            it.reapply();
        }
    }

    private final int mergeWithBlockAbove(int startOfLine, int endOfLine, IAztecBlockSpan spanToApply, int nestingLevel, boolean isWithinList, ITextFormat blockElementType) {
        int startOfBlock;
        block5: {
            IAztecBlockSpan spansOnPreviousLine;
            block6: {
                startOfBlock = startOfLine;
                if (startOfLine == 0) break block5;
                Object[] objectArray = this.getEditableText().getSpans(startOfLine - 1, startOfLine - 1, spanToApply.getClass());
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u20261, spanToApply.javaClass)");
                spansOnPreviousLine = (IAztecBlockSpan)ArraysKt.firstOrNull((Object[])objectArray);
                if (spansOnPreviousLine == null || spansOnPreviousLine.getNestingLevel() != nestingLevel) break block5;
                if (!(spansOnPreviousLine instanceof AztecHeadingSpan)) break block6;
                IAztecBlockSpan iAztecBlockSpan = spanToApply;
                if (iAztecBlockSpan == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecHeadingSpan");
                }
                if (((AztecHeadingSpan)spansOnPreviousLine).getHeading() != ((AztecHeadingSpan)iAztecBlockSpan).getHeading()) break block5;
            }
            if (!isWithinList) {
                startOfBlock = this.getEditableText().getSpanStart((Object)spansOnPreviousLine);
                this.liftBlock(blockElementType, startOfBlock, endOfLine);
            }
        }
        return startOfBlock;
    }

    private final int mergeWithBlockBelow(int endOfLine, int startOfBlock, IAztecBlockSpan spanToApply, int nestingLevel, boolean isWithinList, ITextFormat blockElementType) {
        int endOfBlock;
        block5: {
            IAztecBlockSpan spanOnNextLine;
            block6: {
                endOfBlock = endOfLine;
                if (endOfLine == this.getEditableText().length()) break block5;
                Object[] objectArray = this.getEditableText().getSpans(endOfLine + 1, endOfLine + 1, spanToApply.getClass());
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(en\u20261, spanToApply.javaClass)");
                spanOnNextLine = (IAztecBlockSpan)ArraysKt.firstOrNull((Object[])objectArray);
                if (spanOnNextLine == null || spanOnNextLine.getNestingLevel() != nestingLevel) break block5;
                if (!(spanOnNextLine instanceof AztecHeadingSpan)) break block6;
                IAztecBlockSpan iAztecBlockSpan = spanToApply;
                if (iAztecBlockSpan == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecHeadingSpan");
                }
                if (((AztecHeadingSpan)spanOnNextLine).getHeading() != ((AztecHeadingSpan)iAztecBlockSpan).getHeading()) break block5;
            }
            if (!isWithinList) {
                endOfBlock = this.getEditableText().getSpanEnd((Object)spanOnNextLine);
                this.liftBlock(blockElementType, startOfBlock, endOfBlock);
            }
        }
        return endOfBlock;
    }

    private final void applyBlock(IAztecBlockSpan blockSpan, int start, int end) {
        IAztecBlockSpan iAztecBlockSpan = blockSpan;
        if (iAztecBlockSpan instanceof AztecOrderedListSpan) {
            this.applyListBlock((AztecListSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecUnorderedListSpan) {
            this.applyListBlock((AztecListSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecQuoteSpan) {
            this.applyQuote((AztecQuoteSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecHeadingSpan) {
            this.applyHeadingBlock((AztecHeadingSpan)blockSpan, start, end);
        } else if (iAztecBlockSpan instanceof AztecPreformatSpan) {
            BlockHandler.Companion.set((Spannable)this.getEditableText(), blockSpan, start, end);
        } else {
            this.getEditableText().setSpan((Object)blockSpan, start, end, 51);
        }
    }

    private final void applyQuote(AztecQuoteSpan blockSpan, int start, int end) {
        BlockHandler.Companion.set((Spannable)this.getEditableText(), blockSpan, start, end);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyListBlock(AztecListSpan listSpan, int start, int end) {
        BlockHandler.Companion.set((Spannable)this.getEditableText(), listSpan, start, end);
        if (end - start == 1 && (this.getEditableText().charAt(end - 1) == '\n' || this.getEditableText().charAt(end - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER())) {
            ListItemHandler.Companion.newListItem((Spannable)this.getEditableText(), start, end, listSpan.getNestingLevel() + 1);
        } else {
            int listEnd = end == this.getEditableText().length() ? end : end - 1;
            CharSequence charSequence = (CharSequence)this.getEditableText();
            String listContent = ((Object)charSequence.subSequence(start, listEnd)).toString();
            String[] lines = TextUtils.split((String)listContent, (String)"\n");
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int lineLength = lines[i].length();
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int n7 = lineStart + lineLength;
                int it = n7;
                int lineEnd = start + it != this.getEditableText().length() ? it + 1 : it;
                ListItemHandler.Companion.newListItem((Spannable)this.getEditableText(), start + lineStart, start + lineEnd, listSpan.getNestingLevel() + 1);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyLineBlock(ITextFormat format, int start, int end) {
        CharSequence charSequence = (CharSequence)this.getEditableText();
        String[] lines = TextUtils.split((String)((Object)charSequence.subSequence(start, end)).toString(), (String)"\n");
        int n = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
        int n2 = lines.length;
        while (n < n2) {
            int n3;
            void $receiver$iv;
            void i;
            int splitLength = lines[i].length();
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)i);
            int n4 = start;
            int sum$iv = 0;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int element$iv;
                int n5 = element$iv = ((IntIterator)iterator).nextInt();
                n3 = sum$iv;
                int n6 = lines[it].length() + 1;
                sum$iv = n3 + n6;
            }
            n3 = sum$iv;
            int lineStart = n4 + n3;
            int lineEnd = Math.min(lineStart + splitLength + 1, end);
            int lineLength = lineEnd - lineStart;
            if (lineLength != 0) {
                int nesting = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), lineStart, 0, 4, null) + 1;
                IAztecBlockSpan block = BlockFormatter.makeBlockSpan$default(this, format, nesting, null, 4, null);
                this.applyBlock(block, lineStart, lineEnd);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyHeadingBlock(AztecHeadingSpan headingSpan, int start, int end) {
        CharSequence charSequence = (CharSequence)this.getEditableText();
        String[] lines = TextUtils.split((String)((Object)charSequence.subSequence(start, end)).toString(), (String)"\n");
        int n = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
        int n2 = lines.length;
        while (n < n2) {
            int n3;
            void $receiver$iv;
            void i;
            int splitLength = lines[i].length();
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)i);
            int n4 = start;
            int sum$iv = 0;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int element$iv;
                int n5 = element$iv = ((IntIterator)iterator).nextInt();
                n3 = sum$iv;
                int n6 = lines[it].length() + 1;
                sum$iv = n3 + n6;
            }
            n3 = sum$iv;
            int lineStart = n4 + n3;
            int lineEnd = Math.min(lineStart + splitLength + 1, end);
            int lineLength = lineEnd - lineStart;
            if (lineLength != 0) {
                HeadingHandler.Companion.cloneHeading((Spannable)this.getEditableText(), headingSpan, lineStart, lineEnd);
            }
            ++i;
        }
    }

    private final void liftBlock(ITextFormat textFormat, int start, int end) {
        ITextFormat iTextFormat = textFormat;
        if (iTextFormat == AztecTextFormat.FORMAT_ORDERED_LIST) {
            this.liftListBlock(AztecOrderedListSpan.class, start, end);
        } else if (iTextFormat == AztecTextFormat.FORMAT_UNORDERED_LIST) {
            this.liftListBlock(AztecUnorderedListSpan.class, start, end);
        } else if (iTextFormat == AztecTextFormat.FORMAT_QUOTE) {
            Object[] $receiver$iv;
            Object[] objectArray = this.getEditableText().getSpans(start, end, AztecQuoteSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026tecQuoteSpan::class.java)");
            for (Object element$iv : $receiver$iv = objectArray) {
                AztecQuoteSpan it = (AztecQuoteSpan)element$iv;
                IAztecNestable.Companion.pullUp$default(IAztecNestable.Companion, (Spannable)this.getEditableText(), start, end, it.getNestingLevel(), 0, 16, null);
                this.getEditableText().removeSpan((Object)it);
            }
        } else {
            Object[] $receiver$iv;
            Object[] objectArray = this.getEditableText().getSpans(start, end, ParagraphSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026aragraphSpan::class.java)");
            for (Object element$iv : $receiver$iv = objectArray) {
                ParagraphSpan it = (ParagraphSpan)element$iv;
                IAztecNestable.Companion.pullUp$default(IAztecNestable.Companion, (Spannable)this.getEditableText(), start, end, it.getNestingLevel(), 0, 16, null);
                this.getEditableText().removeSpan((Object)it);
            }
        }
    }

    private final void liftListBlock(Class<? extends AztecListSpan> listSpan, int start, int end) {
        Object[] $receiver$iv;
        Object[] objectArray = this.getEditableText().getSpans(start, end, listSpan);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(start, end, listSpan)");
        for (Object element$iv : $receiver$iv = objectArray) {
            Object[] $receiver$iv2;
            AztecListSpan it = (AztecListSpan)element$iv;
            SpanWrapper<AztecListSpan> wrapper = new SpanWrapper<AztecListSpan>((Spannable)this.getEditableText(), it);
            Intrinsics.checkExpressionValueIsNotNull((Object)this.getEditableText().getSpans(wrapper.getStart(), wrapper.getEnd(), AztecListItemSpan.class), (String)"editableText.getSpans(wr\u2026ListItemSpan::class.java)");
            for (Object element$iv2 : $receiver$iv2) {
                AztecListItemSpan it2 = (AztecListItemSpan)element$iv2;
                this.getEditableText().removeSpan((Object)it2);
            }
            IAztecNestable.Companion.pullUp$default(IAztecNestable.Companion, (Spannable)this.getEditableText(), start, end, wrapper.getSpan().getNestingLevel(), 0, 16, null);
            wrapper.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsList(@NotNull ITextFormat textFormat, int nestingLevel, int selStart, int selEnd) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart <= lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containsBlockElement(textFormat, it, this.getEditableText(), nestingLevel)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean containsList$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = blockFormatter.getSelectionStart();
        }
        if ((n4 & 8) != 0) {
            n3 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsList(iTextFormat, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsBlockElement(@NotNull ITextFormat textFormat, int index, @NotNull Editable text, int nestingLevel) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String[] lines = TextUtils.split((String)text.toString(), (String)"\n");
        if (index < 0 || index >= lines.length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        IAztecBlockSpan[] iAztecBlockSpanArray = $receiver$iv.iterator();
        while (iAztecBlockSpanArray.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)iAztecBlockSpanArray).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start > end) {
            return false;
        }
        IAztecBlockSpan[] spans = (IAztecBlockSpan[])this.getEditableText().getSpans(start, end, BlockFormatter.makeBlockSpan$default(this, textFormat, nestingLevel, null, 4, null).getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        IAztecBlockSpan[] iAztecBlockSpanArray2 = iAztecBlockSpanArray = spans;
        return !(iAztecBlockSpanArray2.length == 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsQuote(int selStart, int selEnd) {
        if (selStart < 0) return false;
        if (selEnd < 0) {
            return false;
        }
        Object[] objectArray = this.getEditableText().getSpans(selStart, selEnd, AztecQuoteSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(se\u2026tecQuoteSpan::class.java)");
        Object[] $receiver$iv = objectArray;
        Object[] objectArray2 = $receiver$iv;
        int n = objectArray2.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            int n3;
            Object element$iv = objectArray2[n2];
            AztecQuoteSpan it = (AztecQuoteSpan)element$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)it);
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            if (selStart == selEnd) {
                if (this.getEditableText().length() == selStart) {
                    n3 = selStart;
                    if (spanStart <= n3 && spanEnd >= n3) {
                        return true;
                    }
                    bl = false;
                } else {
                    if (spanEnd != selStart && spanStart <= (n3 = selStart) && spanEnd >= n3) {
                        return true;
                    }
                    bl = false;
                }
            } else {
                n3 = selStart;
                if (spanStart <= n3) {
                    if (spanEnd >= n3) return true;
                }
                n3 = selEnd;
                if (spanStart <= n3) {
                    if (spanEnd >= n3) return true;
                }
                n3 = spanStart;
                if (selStart <= n3) {
                    if (selEnd >= n3) return true;
                }
                if (spanStart <= n3 && (n3 = spanEnd) >= n3) {
                    return true;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static /* synthetic */ boolean containsQuote$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsQuote(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containHeadingType(textFormat, it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean containsHeading$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsHeading(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containHeadingType(ITextFormat textFormat, int index) {
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= lines.length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)iterator).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        int n5 = 0;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        AztecHeadingSpan[] aztecHeadingSpanArray = spans;
        int n6 = aztecHeadingSpanArray.length;
        if (n5 < n6) {
            AztecHeadingSpan span = aztecHeadingSpanArray[n5];
            ITextFormat iTextFormat = textFormat;
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_1) {
                return span.getHeading() == AztecHeadingSpan.Heading.H1;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_2) {
                return span.getHeading() == AztecHeadingSpan.Heading.H2;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_3) {
                return span.getHeading() == AztecHeadingSpan.Heading.H3;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_4) {
                return span.getHeading() == AztecHeadingSpan.Heading.H4;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_5) {
                return span.getHeading() == AztecHeadingSpan.Heading.H5;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_6) {
                return span.getHeading() == AztecHeadingSpan.Heading.H6;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsOtherHeadings(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        AztecTextFormat[] aztecTextFormatArray = new AztecTextFormat[]{AztecTextFormat.FORMAT_HEADING_1, AztecTextFormat.FORMAT_HEADING_2, AztecTextFormat.FORMAT_HEADING_3, AztecTextFormat.FORMAT_HEADING_4, AztecTextFormat.FORMAT_HEADING_5, AztecTextFormat.FORMAT_HEADING_6, AztecTextFormat.FORMAT_PREFORMAT};
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void it = element$iv$iv;
            if (!(it != textFormat)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            AztecTextFormat it = (AztecTextFormat)element$iv;
            if (!this.containsHeading(it, selStart, selEnd)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean containsOtherHeadings$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsOtherHeadings(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsHeadingOnly(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        Object element$iv;
        AztecTextFormat it;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        AztecTextFormat[] aztecTextFormatArray = new AztecTextFormat[]{AztecTextFormat.FORMAT_HEADING_1, AztecTextFormat.FORMAT_HEADING_2, AztecTextFormat.FORMAT_HEADING_3, AztecTextFormat.FORMAT_HEADING_4, AztecTextFormat.FORMAT_HEADING_5, AztecTextFormat.FORMAT_HEADING_6, AztecTextFormat.FORMAT_PREFORMAT};
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void it2 = element$iv$iv;
            if (!(it2 != textFormat)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherHeadings = (List)destination$iv$iv;
        if (!this.containsHeading(textFormat, selStart, selEnd)) return false;
        $receiver$iv = otherHeadings;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (!this.containsHeading(it = (AztecTextFormat)(element$iv = iterator.next()), selStart, selEnd));
        return false;
    }

    public static /* synthetic */ boolean containsHeadingOnly$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsHeadingOnly(iTextFormat, n, n2);
    }

    public final boolean containsAlignment(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Collection collection = this.getAlignedSpans(textFormat, selStart, selEnd);
        return !collection.isEmpty();
    }

    public static /* synthetic */ boolean containsAlignment$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsAlignment(iTextFormat, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<IAztecAlignmentSpan> getAlignedSpans(ITextFormat textFormat, int selStart, int selEnd) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        if (selStart < 0 || selEnd < 0) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = this.getEditableText().getSpans(selStart, selEnd, IAztecAlignmentSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(se\u2026lignmentSpan::class.java)");
        Object[] objectArray2 = objectArray;
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            IAztecAlignmentSpan it = (IAztecAlignmentSpan)element$iv$iv;
            if (!(textFormat == null || it.getAlign() == this.getAlignment(textFormat, StringsKt.substring((CharSequence)((CharSequence)this.getEditableText()), (IntRange)RangesKt.until((int)this.getEditableText().getSpanStart((Object)it), (int)this.getEditableText().getSpanEnd((Object)it)))))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            int n;
            Object element$iv$iv = iterator.next();
            IAztecAlignmentSpan it = (IAztecAlignmentSpan)element$iv$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)it);
            int spanEnd = this.getEditableText().getSpanEnd((Object)it);
            boolean bl = selStart == selEnd ? (this.getEditableText().length() == selStart ? spanStart <= (n = selStart) && spanEnd >= n : spanEnd != selStart && spanStart <= (n = selStart) && spanEnd >= n) : spanStart <= (n = selStart) && spanEnd >= n || spanStart <= (n = selEnd) && spanEnd >= n || selStart <= (n = spanStart) && selEnd >= n || selStart <= (n = spanEnd) && selEnd >= n;
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getAlignedSpans$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.getAlignedSpans(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsPreformat(int selStart, int selEnd) {
        boolean bl;
        block7: {
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                int n3 = 0;
                Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n4 = element$iv = ((IntIterator)iterator).nextInt();
                    int n5 = sum$iv;
                    int n6 = lines[it].length() + 1;
                    sum$iv = n5 + n6;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containsPreformat(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean containsPreformat$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        return blockFormatter.containsPreformat(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsPreformat(int index) {
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= lines.length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        AztecPreformatSpan[] aztecPreformatSpanArray = $receiver$iv.iterator();
        while (aztecPreformatSpanArray.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)aztecPreformatSpanArray).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        AztecPreformatSpan[] spans = (AztecPreformatSpan[])this.getEditableText().getSpans(start, end, AztecPreformatSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        AztecPreformatSpan[] aztecPreformatSpanArray2 = aztecPreformatSpanArray = spans;
        return !(aztecPreformatSpanArray2.length == 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void switchListType(@NotNull ITextFormat listTypeToSwitchTo, int start, int end) {
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)listTypeToSwitchTo, (String)"listTypeToSwitchTo");
        AztecListSpan[] spans = (AztecListSpan[])this.getEditableText().getSpans(start, end, AztecListSpan.class);
        if (start == end && spans.length > 1) {
            void $receiver$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            $receiver$iv = spans;
            AztecListSpan[] aztecListSpanArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var8_9 = $receiver$iv$iv;
            int n = ((void)var8_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var8_9[i];
                if (!(this.getEditableText().getSpanStart((Object)it) == start)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            AztecListSpan[] aztecListSpanArray2 = thisCollection$iv.toArray(new AztecListSpan[0]);
            if (aztecListSpanArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            spans = aztecListSpanArray2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        $receiver$iv = spans;
        for (AztecListSpan element$iv : $receiver$iv) {
            AztecListSpan existingListSpan = element$iv;
            if (existingListSpan == null) continue;
            int spanStart = this.getEditableText().getSpanStart((Object)existingListSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingListSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingListSpan);
            this.getEditableText().removeSpan((Object)existingListSpan);
            this.getEditableText().setSpan((Object)BlockFormatter.makeBlockSpan$default(this, listTypeToSwitchTo, existingListSpan.getNestingLevel(), null, 4, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* synthetic */ void switchListType$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchListType(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void switchHeaderType(@NotNull ITextFormat headerTypeToSwitchTo, int start, int end) {
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)headerTypeToSwitchTo, (String)"headerTypeToSwitchTo");
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        if (start == end && spans.length > 1) {
            void $receiver$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            $receiver$iv = spans;
            AztecHeadingSpan[] aztecHeadingSpanArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var8_9 = $receiver$iv$iv;
            int n = ((void)var8_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var8_9[i];
                if (!(this.getEditableText().getSpanStart((Object)it) == start)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            AztecHeadingSpan[] aztecHeadingSpanArray2 = thisCollection$iv.toArray(new AztecHeadingSpan[0]);
            if (aztecHeadingSpanArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            spans = aztecHeadingSpanArray2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        $receiver$iv = spans;
        for (AztecHeadingSpan element$iv : $receiver$iv) {
            AztecHeadingSpan existingHeaderSpan = element$iv;
            if (existingHeaderSpan == null) continue;
            int spanStart = this.getEditableText().getSpanStart((Object)existingHeaderSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)existingHeaderSpan);
            int spanFlags = this.getEditableText().getSpanFlags((Object)existingHeaderSpan);
            existingHeaderSpan.setTextFormat(headerTypeToSwitchTo);
            this.getEditableText().setSpan((Object)existingHeaderSpan, spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* synthetic */ void switchHeaderType$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchHeaderType(iTextFormat, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void switchHeadingToPreformat(int start, int end) {
        Object $receiver$iv;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        if (start == end && spans.length > 1) {
            void $receiver$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            $receiver$iv = spans;
            AztecHeadingSpan[] aztecHeadingSpanArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var7_8 = $receiver$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var7_8[i];
                if (!(this.getEditableText().getSpanStart((Object)it) == start)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            AztecHeadingSpan[] aztecHeadingSpanArray2 = thisCollection$iv.toArray(new AztecHeadingSpan[0]);
            if (aztecHeadingSpanArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            spans = aztecHeadingSpanArray2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        $receiver$iv = spans;
        for (AztecHeadingSpan element$iv : $receiver$iv) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            AztecHeadingSpan heading = element$iv;
            if (heading == null) continue;
            int spanStart = this.getEditableText().getSpanStart((Object)heading);
            int spanEnd = this.getEditableText().getSpanEnd((Object)heading);
            int spanFlags = this.getEditableText().getSpanFlags((Object)heading);
            Iterable $i$f$filter = $receiver$iv2 = (Iterable)BlockFormatter.makeBlock$default(this, heading.getTextFormat(), 0, null, 4, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IAztecBlockSpan iAztecBlockSpan = (IAztecBlockSpan)item$iv$iv;
                Collection collection = destination$iv$iv;
                Class<?> clazz = it.getClass();
                collection.add(clazz);
            }
            List spanType = (List)destination$iv$iv;
            BlockFormatter.removeBlockStyle$default(this, heading.getTextFormat(), spanStart, spanEnd, spanType, false, 16, null);
            this.getEditableText().setSpan((Object)new AztecPreformatSpan(heading.getNestingLevel(), heading.getAttributes(), this.preformatStyle, null, 8, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* synthetic */ void switchHeadingToPreformat$default(BlockFormatter blockFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchHeadingToPreformat(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void switchPreformatToHeading(@NotNull ITextFormat headingTextFormat, int start, int end) {
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)headingTextFormat, (String)"headingTextFormat");
        AztecPreformatSpan[] spans = (AztecPreformatSpan[])this.getEditableText().getSpans(start, end, AztecPreformatSpan.class);
        if (start == end && spans.length > 1) {
            void $receiver$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            $receiver$iv = spans;
            AztecPreformatSpan[] aztecPreformatSpanArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var8_9 = $receiver$iv$iv;
            int n = ((void)var8_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var8_9[i];
                if (!(this.getEditableText().getSpanStart((Object)it) == start)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            AztecPreformatSpan[] aztecPreformatSpanArray2 = thisCollection$iv.toArray(new AztecPreformatSpan[0]);
            if (aztecPreformatSpanArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            spans = aztecPreformatSpanArray2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        $receiver$iv = spans;
        for (AztecPreformatSpan element$iv : $receiver$iv) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            AztecPreformatSpan preformat = element$iv;
            if (preformat == null) continue;
            int spanStart = this.getEditableText().getSpanStart((Object)preformat);
            int spanEnd = this.getEditableText().getSpanEnd((Object)preformat);
            int spanFlags = this.getEditableText().getSpanFlags((Object)preformat);
            Iterable $i$f$filter = $receiver$iv2 = (Iterable)BlockFormatter.makeBlock$default(this, AztecTextFormat.FORMAT_PREFORMAT, 0, null, 4, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IAztecBlockSpan iAztecBlockSpan = (IAztecBlockSpan)item$iv$iv;
                Collection collection = destination$iv$iv;
                Class<?> clazz = it.getClass();
                collection.add(clazz);
            }
            List spanType = (List)destination$iv$iv;
            BlockFormatter.removeBlockStyle$default(this, AztecTextFormat.FORMAT_PREFORMAT, spanStart, spanEnd, spanType, false, 16, null);
            this.getEditableText().setSpan((Object)new AztecHeadingSpan(preformat.getNestingLevel(), headingTextFormat, preformat.getAttributes(), null, null, 24, null), spanStart, spanEnd, spanFlags);
            this.getEditor().onSelectionChanged(start, end);
        }
    }

    public static /* synthetic */ void switchPreformatToHeading$default(BlockFormatter blockFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blockFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = blockFormatter.getSelectionEnd();
        }
        blockFormatter.switchPreformatToHeading(iTextFormat, n, n2);
    }

    @NotNull
    public final ListStyle getListStyle() {
        return this.listStyle;
    }

    @NotNull
    public final QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    @NotNull
    public final HeaderStyle getHeaderStyle() {
        return this.headerStyle;
    }

    @NotNull
    public final PreformatStyle getPreformatStyle() {
        return this.preformatStyle;
    }

    public BlockFormatter(@NotNull AztecText editor, @NotNull ListStyle listStyle, @NotNull QuoteStyle quoteStyle, @NotNull HeaderStyle headerStyle, @NotNull PreformatStyle preformatStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"headerStyle");
        Intrinsics.checkParameterIsNotNull((Object)preformatStyle, (String)"preformatStyle");
        super(editor);
        this.listStyle = listStyle;
        this.quoteStyle = quoteStyle;
        this.headerStyle = headerStyle;
        this.preformatStyle = preformatStyle;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "", "indicatorColor", "", "indicatorMargin", "indicatorPadding", "indicatorWidth", "verticalPadding", "(IIIII)V", "getIndicatorColor", "()I", "getIndicatorMargin", "getIndicatorPadding", "getIndicatorWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class ListStyle {
        private final int indicatorColor;
        private final int indicatorMargin;
        private final int indicatorPadding;
        private final int indicatorWidth;
        private final int verticalPadding;

        public final int getIndicatorColor() {
            return this.indicatorColor;
        }

        public final int getIndicatorMargin() {
            return this.indicatorMargin;
        }

        public final int getIndicatorPadding() {
            return this.indicatorPadding;
        }

        public final int getIndicatorWidth() {
            return this.indicatorWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public ListStyle(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            this.indicatorColor = indicatorColor;
            this.indicatorMargin = indicatorMargin;
            this.indicatorPadding = indicatorPadding;
            this.indicatorWidth = indicatorWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.indicatorColor;
        }

        public final int component2() {
            return this.indicatorMargin;
        }

        public final int component3() {
            return this.indicatorPadding;
        }

        public final int component4() {
            return this.indicatorWidth;
        }

        public final int component5() {
            return this.verticalPadding;
        }

        @NotNull
        public final ListStyle copy(int indicatorColor, int indicatorMargin, int indicatorPadding, int indicatorWidth, int verticalPadding) {
            return new ListStyle(indicatorColor, indicatorMargin, indicatorPadding, indicatorWidth, verticalPadding);
        }

        @NotNull
        public static /* synthetic */ ListStyle copy$default(ListStyle listStyle, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = listStyle.indicatorColor;
            }
            if ((n6 & 2) != 0) {
                n2 = listStyle.indicatorMargin;
            }
            if ((n6 & 4) != 0) {
                n3 = listStyle.indicatorPadding;
            }
            if ((n6 & 8) != 0) {
                n4 = listStyle.indicatorWidth;
            }
            if ((n6 & 0x10) != 0) {
                n5 = listStyle.verticalPadding;
            }
            return listStyle.copy(n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "ListStyle(indicatorColor=" + this.indicatorColor + ", indicatorMargin=" + this.indicatorMargin + ", indicatorPadding=" + this.indicatorPadding + ", indicatorWidth=" + this.indicatorWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((this.indicatorColor * 31 + this.indicatorMargin) * 31 + this.indicatorPadding) * 31 + this.indicatorWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListStyle)) break block3;
                    ListStyle listStyle = (ListStyle)object;
                    if (!(this.indicatorColor == listStyle.indicatorColor) || !(this.indicatorMargin == listStyle.indicatorMargin) || !(this.indicatorPadding == listStyle.indicatorPadding) || !(this.indicatorWidth == listStyle.indicatorWidth) || !(this.verticalPadding == listStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006#"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "", "quoteBackground", "", "quoteColor", "quoteBackgroundAlpha", "", "quoteMargin", "quotePadding", "quoteWidth", "verticalPadding", "(IIFIIII)V", "getQuoteBackground", "()I", "getQuoteBackgroundAlpha", "()F", "getQuoteColor", "getQuoteMargin", "getQuotePadding", "getQuoteWidth", "getVerticalPadding", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class QuoteStyle {
        private final int quoteBackground;
        private final int quoteColor;
        private final float quoteBackgroundAlpha;
        private final int quoteMargin;
        private final int quotePadding;
        private final int quoteWidth;
        private final int verticalPadding;

        public final int getQuoteBackground() {
            return this.quoteBackground;
        }

        public final int getQuoteColor() {
            return this.quoteColor;
        }

        public final float getQuoteBackgroundAlpha() {
            return this.quoteBackgroundAlpha;
        }

        public final int getQuoteMargin() {
            return this.quoteMargin;
        }

        public final int getQuotePadding() {
            return this.quotePadding;
        }

        public final int getQuoteWidth() {
            return this.quoteWidth;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public QuoteStyle(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            this.quoteBackground = quoteBackground;
            this.quoteColor = quoteColor;
            this.quoteBackgroundAlpha = quoteBackgroundAlpha;
            this.quoteMargin = quoteMargin;
            this.quotePadding = quotePadding;
            this.quoteWidth = quoteWidth;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.quoteBackground;
        }

        public final int component2() {
            return this.quoteColor;
        }

        public final float component3() {
            return this.quoteBackgroundAlpha;
        }

        public final int component4() {
            return this.quoteMargin;
        }

        public final int component5() {
            return this.quotePadding;
        }

        public final int component6() {
            return this.quoteWidth;
        }

        public final int component7() {
            return this.verticalPadding;
        }

        @NotNull
        public final QuoteStyle copy(int quoteBackground, int quoteColor, float quoteBackgroundAlpha, int quoteMargin, int quotePadding, int quoteWidth, int verticalPadding) {
            return new QuoteStyle(quoteBackground, quoteColor, quoteBackgroundAlpha, quoteMargin, quotePadding, quoteWidth, verticalPadding);
        }

        @NotNull
        public static /* synthetic */ QuoteStyle copy$default(QuoteStyle quoteStyle, int n, int n2, float f, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = quoteStyle.quoteBackground;
            }
            if ((n7 & 2) != 0) {
                n2 = quoteStyle.quoteColor;
            }
            if ((n7 & 4) != 0) {
                f = quoteStyle.quoteBackgroundAlpha;
            }
            if ((n7 & 8) != 0) {
                n3 = quoteStyle.quoteMargin;
            }
            if ((n7 & 0x10) != 0) {
                n4 = quoteStyle.quotePadding;
            }
            if ((n7 & 0x20) != 0) {
                n5 = quoteStyle.quoteWidth;
            }
            if ((n7 & 0x40) != 0) {
                n6 = quoteStyle.verticalPadding;
            }
            return quoteStyle.copy(n, n2, f, n3, n4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "QuoteStyle(quoteBackground=" + this.quoteBackground + ", quoteColor=" + this.quoteColor + ", quoteBackgroundAlpha=" + this.quoteBackgroundAlpha + ", quoteMargin=" + this.quoteMargin + ", quotePadding=" + this.quotePadding + ", quoteWidth=" + this.quoteWidth + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return (((((this.quoteBackground * 31 + this.quoteColor) * 31 + Float.floatToIntBits(this.quoteBackgroundAlpha)) * 31 + this.quoteMargin) * 31 + this.quotePadding) * 31 + this.quoteWidth) * 31 + this.verticalPadding;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QuoteStyle)) break block3;
                    QuoteStyle quoteStyle = (QuoteStyle)object;
                    if (!(this.quoteBackground == quoteStyle.quoteBackground) || !(this.quoteColor == quoteStyle.quoteColor) || Float.compare(this.quoteBackgroundAlpha, quoteStyle.quoteBackgroundAlpha) != 0 || !(this.quoteMargin == quoteStyle.quoteMargin) || !(this.quotePadding == quoteStyle.quotePadding) || !(this.quoteWidth == quoteStyle.quoteWidth) || !(this.verticalPadding == quoteStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "", "preformatBackground", "", "preformatBackgroundAlpha", "", "preformatColor", "verticalPadding", "(IFII)V", "getPreformatBackground", "()I", "getPreformatBackgroundAlpha", "()F", "getPreformatColor", "getVerticalPadding", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class PreformatStyle {
        private final int preformatBackground;
        private final float preformatBackgroundAlpha;
        private final int preformatColor;
        private final int verticalPadding;

        public final int getPreformatBackground() {
            return this.preformatBackground;
        }

        public final float getPreformatBackgroundAlpha() {
            return this.preformatBackgroundAlpha;
        }

        public final int getPreformatColor() {
            return this.preformatColor;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public PreformatStyle(int preformatBackground, float preformatBackgroundAlpha, int preformatColor, int verticalPadding) {
            this.preformatBackground = preformatBackground;
            this.preformatBackgroundAlpha = preformatBackgroundAlpha;
            this.preformatColor = preformatColor;
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.preformatBackground;
        }

        public final float component2() {
            return this.preformatBackgroundAlpha;
        }

        public final int component3() {
            return this.preformatColor;
        }

        public final int component4() {
            return this.verticalPadding;
        }

        @NotNull
        public final PreformatStyle copy(int preformatBackground, float preformatBackgroundAlpha, int preformatColor, int verticalPadding) {
            return new PreformatStyle(preformatBackground, preformatBackgroundAlpha, preformatColor, verticalPadding);
        }

        @NotNull
        public static /* synthetic */ PreformatStyle copy$default(PreformatStyle preformatStyle, int n, float f, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = preformatStyle.preformatBackground;
            }
            if ((n4 & 2) != 0) {
                f = preformatStyle.preformatBackgroundAlpha;
            }
            if ((n4 & 4) != 0) {
                n2 = preformatStyle.preformatColor;
            }
            if ((n4 & 8) != 0) {
                n3 = preformatStyle.verticalPadding;
            }
            return preformatStyle.copy(n, f, n2, n3);
        }

        @NotNull
        public String toString() {
            return "PreformatStyle(preformatBackground=" + this.preformatBackground + ", preformatBackgroundAlpha=" + this.preformatBackgroundAlpha + ", preformatColor=" + this.preformatColor + ", verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return ((this.preformatBackground * 31 + Float.floatToIntBits(this.preformatBackgroundAlpha)) * 31 + this.preformatColor) * 31 + this.verticalPadding;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PreformatStyle)) break block3;
                    PreformatStyle preformatStyle = (PreformatStyle)object;
                    if (!(this.preformatBackground == preformatStyle.preformatBackground) || Float.compare(this.preformatBackgroundAlpha, preformatStyle.preformatBackgroundAlpha) != 0 || !(this.preformatColor == preformatStyle.preformatColor) || !(this.verticalPadding == preformatStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/wordpress/aztec/formatting/BlockFormatter$HeaderStyle;", "", "verticalPadding", "", "(I)V", "getVerticalPadding", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class HeaderStyle {
        private final int verticalPadding;

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public HeaderStyle(int verticalPadding) {
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.verticalPadding;
        }

        @NotNull
        public final HeaderStyle copy(int verticalPadding) {
            return new HeaderStyle(verticalPadding);
        }

        @NotNull
        public static /* synthetic */ HeaderStyle copy$default(HeaderStyle headerStyle, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = headerStyle.verticalPadding;
            }
            return headerStyle.copy(n);
        }

        @NotNull
        public String toString() {
            return "HeaderStyle(verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return this.verticalPadding;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HeaderStyle)) break block3;
                    HeaderStyle headerStyle = (HeaderStyle)object;
                    if (!(this.verticalPadding == headerStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

