/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JsonArrayCore;
import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonPrinter;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.JsonValueBase;
import com.github.wnameless.json.base.JsonValueCore;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.JsonifyLinkedHashMap;
import com.github.wnameless.json.flattener.KeyTransformer;
import com.github.wnameless.json.flattener.PrintMode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public final class JsonUnflattener {
    public static final String ROOT = "root";
    private final JsonCore<?> jsonCore;
    private final JsonValueCore<?> root;
    private FlattenMode flattenMode = FlattenMode.NORMAL;
    private Character separator = Character.valueOf('.');
    private Character leftBracket = Character.valueOf('[');
    private Character rightBracket = Character.valueOf(']');
    private PrintMode printMode = PrintMode.MINIMAL;
    private KeyTransformer keyTrans = null;

    public static String unflatten(String json) {
        return new JsonUnflattener(json).unflatten();
    }

    public static String unflatten(Map<String, ?> flattenedMap) {
        return new JsonUnflattener(flattenedMap).unflatten();
    }

    public static Map<String, Object> unflattenAsMap(String json) {
        return new JsonUnflattener(json).unflattenAsMap();
    }

    public static Map<String, Object> unflattenAsMap(Map<String, ?> flattenedMap) {
        return new JsonUnflattener(flattenedMap).unflattenAsMap();
    }

    private JsonUnflattener newJsonUnflattener(JsonValueCore<?> jsonValue) {
        JsonUnflattener ju = new JsonUnflattener(jsonValue);
        ju.withFlattenMode(this.flattenMode);
        ju.withSeparator(this.separator.charValue());
        ju.withLeftAndRightBrackets(this.leftBracket.charValue(), this.rightBracket.charValue());
        ju.withPrintMode(this.printMode);
        ju.withKeyTransformer(this.keyTrans);
        return ju;
    }

    private JsonUnflattener(JsonValueCore<?> root) {
        this.jsonCore = new JacksonJsonCore();
        this.root = root;
    }

    private JsonValueCore<?> parseJson(String json) {
        return this.jsonCore.parse(json);
    }

    public JsonUnflattener(String json) {
        this.jsonCore = new JacksonJsonCore();
        this.root = this.parseJson(json);
    }

    public JsonUnflattener(JsonCore<?> jsonCore, String json) {
        this.jsonCore = (JsonCore)Validate.notNull(jsonCore);
        this.root = this.parseJson(json);
    }

    public JsonUnflattener(Reader jsonReader) throws IOException {
        this.jsonCore = new JacksonJsonCore();
        this.root = this.jsonCore.parse(jsonReader);
    }

    public JsonUnflattener(JsonCore<?> jsonCore, Reader jsonReader) throws IOException {
        this.jsonCore = (JsonCore)Validate.notNull(jsonCore);
        this.root = jsonCore.parse(jsonReader);
    }

    public JsonUnflattener(Map<String, ?> flattenedMap) {
        this.jsonCore = new JacksonJsonCore();
        this.root = this.jsonCore.parse(new JsonifyLinkedHashMap(flattenedMap).toString());
    }

    public JsonUnflattener(JsonCore<?> jsonCore, Map<String, ?> flattenedMap) {
        this.jsonCore = (JsonCore)Validate.notNull(jsonCore);
        this.root = jsonCore.parse(new JsonifyLinkedHashMap(flattenedMap).toString());
    }

    private String arrayIndex() {
        return Pattern.quote(this.leftBracket.toString()) + "\\s*\\d+\\s*" + Pattern.quote(this.rightBracket.toString());
    }

    private String objectComplexKey() {
        return Pattern.quote(this.leftBracket.toString()) + "\\s*\".+?\"\\s*" + Pattern.quote(this.rightBracket.toString());
    }

    private String objectKey() {
        return "[^" + Pattern.quote(this.separator.toString()) + Pattern.quote(this.leftBracket.toString()) + Pattern.quote(this.rightBracket.toString()) + "]+";
    }

    private Pattern keyPartPattern() {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB)) {
            return Pattern.compile("[^" + Pattern.quote(this.separator.toString()) + "]+");
        }
        return Pattern.compile(this.arrayIndex() + "|" + this.objectComplexKey() + "|" + this.objectKey());
    }

    public JsonUnflattener withFlattenMode(FlattenMode flattenMode) {
        this.flattenMode = (FlattenMode)((Object)Validate.notNull((Object)((Object)flattenMode)));
        return this;
    }

    public JsonUnflattener withSeparator(char separator) {
        String separatorStr = String.valueOf(separator);
        Validate.isTrue((!separatorStr.matches("[\"\\s]") ? 1 : 0) != 0, (String)"Separator contains illegal character(%s)", (Object[])new Object[]{separatorStr});
        Validate.isTrue((!this.leftBracket.equals(Character.valueOf(separator)) && !this.rightBracket.equals(Character.valueOf(separator)) ? 1 : 0) != 0, (String)"Separator(%s) is already used in brackets", (Object[])new Object[]{separatorStr});
        this.separator = Character.valueOf(separator);
        return this;
    }

    private String illegalBracketsRegex() {
        return "[\"\\s" + Pattern.quote(this.separator.toString()) + "]";
    }

    public JsonUnflattener withLeftAndRightBrackets(char leftBracket, char rightBracket) {
        Validate.isTrue((leftBracket != rightBracket ? 1 : 0) != 0, (String)"Both brackets cannot be the same", (Object[])new Object[0]);
        String leftBracketStr = String.valueOf(leftBracket);
        String rightBracketStr = String.valueOf(rightBracket);
        Validate.isTrue((!leftBracketStr.matches(this.illegalBracketsRegex()) ? 1 : 0) != 0, (String)"Left bracket contains illegal character(%s)", (Object[])new Object[]{leftBracketStr});
        Validate.isTrue((!rightBracketStr.matches(this.illegalBracketsRegex()) ? 1 : 0) != 0, (String)"Right bracket contains illegal character(%s)", (Object[])new Object[]{rightBracketStr});
        this.leftBracket = Character.valueOf(leftBracket);
        this.rightBracket = Character.valueOf(rightBracket);
        return this;
    }

    public JsonUnflattener withPrintMode(PrintMode printMode) {
        this.printMode = (PrintMode)((Object)Validate.notNull((Object)((Object)printMode)));
        return this;
    }

    public JsonUnflattener withKeyTransformer(KeyTransformer keyTrans) {
        this.keyTrans = keyTrans;
        return this;
    }

    private String writeByConfig(JsonValueBase<?> jsonValue) {
        switch (this.printMode) {
            case PRETTY: {
                return JsonPrinter.prettyPrint((String)jsonValue.toJson());
            }
        }
        return jsonValue.toJson();
    }

    public String unflatten() {
        StringWriter sw = new StringWriter();
        if (this.root.isArray()) {
            JsonArrayCore<?> unflattenedArray = this.unflattenArray(this.root.asArray());
            sw.append(this.writeByConfig((JsonValueBase<?>)unflattenedArray.asValue()));
            return sw.toString();
        }
        if (!this.root.isObject()) {
            return this.root.toString();
        }
        JsonObjectCore flattened = this.root.asObject();
        JsonValueCore unflattened = flattened.isEmpty() ? this.jsonCore.parse("{}").asValue() : null;
        Iterator names = flattened.names();
        while (names.hasNext()) {
            String key = (String)names.next();
            JsonValueCore currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = this.keyPartPattern().matcher(key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                if (objKey != null ^ aryIdx != null) {
                    if (this.isJsonArray(keyPart)) {
                        currentVal = this.findOrCreateJsonArray(currentVal, objKey, aryIdx).asValue();
                        objKey = null;
                        aryIdx = this.extractIndex(keyPart);
                    } else {
                        if (((JsonValueCore)flattened.get(key)).isArray()) {
                            flattened.set(key, this.unflattenArray(((JsonValueCore)flattened.get(key)).asArray()));
                        }
                        currentVal = this.findOrCreateJsonObject(currentVal, objKey, aryIdx).asValue();
                        objKey = this.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey == null && aryIdx == null) {
                    if (this.isJsonArray(keyPart)) {
                        aryIdx = this.extractIndex(keyPart);
                        if (currentVal == null) {
                            currentVal = this.jsonCore.parse("[]").asValue();
                        }
                    } else {
                        objKey = this.extractKey(keyPart);
                        if (currentVal == null) {
                            currentVal = this.jsonCore.parse("{}").asValue();
                        }
                    }
                }
                if (unflattened != null) continue;
                unflattened = currentVal;
            }
            this.setUnflattenedValue(flattened, key, currentVal, objKey, aryIdx);
        }
        sw.append(this.writeByConfig((JsonValueBase<?>)unflattened));
        return sw.toString();
    }

    public Map<String, Object> unflattenAsMap() {
        JsonValueCore flattenedValue = this.jsonCore.parse(this.unflatten());
        if (flattenedValue.isArray() || !flattenedValue.isObject()) {
            JsonObjectCore jsonObj = this.jsonCore.parse("{}").asObject();
            jsonObj.set(ROOT, (JsonSource)flattenedValue);
            return jsonObj.toMap();
        }
        return flattenedValue.asObject().toMap();
    }

    private JsonArrayCore<?> unflattenArray(JsonArrayCore<?> array) {
        JsonArrayCore unflattenArray = this.jsonCore.parse("[]").asArray();
        for (JsonValueCore value : array) {
            if (value.isArray()) {
                unflattenArray.add(this.unflattenArray(value.asArray()));
                continue;
            }
            if (value.isObject()) {
                JsonValueCore obj = this.jsonCore.parse(this.newJsonUnflattener(value).unflatten());
                unflattenArray.add((JsonSource)obj);
                continue;
            }
            unflattenArray.add((JsonSource)value);
        }
        return unflattenArray;
    }

    private String extractKey(String keyPart) {
        if (keyPart.matches(this.objectComplexKey())) {
            keyPart = keyPart.replaceAll("^" + Pattern.quote(this.leftBracket.toString()) + "\\s*\"", "");
            keyPart = keyPart.replaceAll("\"\\s*" + Pattern.quote(this.rightBracket.toString()) + "$", "");
        }
        return this.keyTrans != null ? this.keyTrans.transform(keyPart) : keyPart;
    }

    private Integer extractIndex(String keyPart) {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB)) {
            return Integer.valueOf(keyPart);
        }
        return Integer.valueOf(keyPart.replaceAll("[" + Pattern.quote(this.leftBracket.toString()) + Pattern.quote(this.rightBracket.toString()) + "\\s]", ""));
    }

    private boolean isJsonArray(String keyPart) {
        return keyPart.matches(this.arrayIndex()) || this.flattenMode.equals((Object)FlattenMode.MONGODB) && keyPart.matches("\\d+");
    }

    private JsonArrayCore<?> findOrCreateJsonArray(JsonValueCore<?> currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObjectCore jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonArrayCore ary = this.jsonCore.parse("[]").asArray();
                jsonObj.set(objKey, (JsonSource)ary);
                return ary;
            }
            return ((JsonValueCore)jsonObj.get(objKey)).asArray();
        }
        JsonArrayCore jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || ((JsonValueCore)jsonAry.get(aryIdx.intValue())).isNull()) {
            JsonArrayCore ary = this.jsonCore.parse("[]").asArray();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonSource)ary);
            return ary;
        }
        return ((JsonValueCore)jsonAry.get(aryIdx.intValue())).asArray();
    }

    private JsonObjectCore<?> findOrCreateJsonObject(JsonValueCore<?> currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObjectCore jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonObjectCore obj = this.jsonCore.parse("{}").asObject();
                jsonObj.set(objKey, (JsonSource)obj);
                return obj;
            }
            return ((JsonValueCore)jsonObj.get(objKey)).asObject();
        }
        JsonArrayCore jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || ((JsonValueCore)jsonAry.get(aryIdx.intValue())).isNull()) {
            JsonObjectCore obj = this.jsonCore.parse("{}").asObject();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonSource)obj);
            return obj;
        }
        return ((JsonValueCore)jsonAry.get(aryIdx.intValue())).asObject();
    }

    private void setUnflattenedValue(JsonObjectCore<?> flattened, String key, JsonValueCore<?> currentVal, String objKey, Integer aryIdx) {
        JsonValueCore val = (JsonValueCore)flattened.get(key);
        if (objKey != null) {
            if (val.isArray()) {
                JsonArrayCore jsonArray = this.jsonCore.parse("[]").asArray();
                for (JsonValueCore arrayVal : val.asArray()) {
                    jsonArray.add(this.parseJson(this.newJsonUnflattener(arrayVal).unflatten()));
                }
                currentVal.asObject().set(objKey, (JsonSource)jsonArray);
            } else {
                currentVal.asObject().set(objKey, (JsonSource)val);
            }
        } else {
            this.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), (JsonSource)val);
        }
    }

    private void assureJsonArraySize(JsonArrayCore<?> jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add((JsonSource)this.jsonCore.parse("null"));
        }
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonUnflattener)) {
            return false;
        }
        return this.root.equals(((JsonUnflattener)o).root);
    }

    public String toString() {
        return "JsonUnflattener{root=" + this.root + "}";
    }
}

