/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JsonArrayBase;
import com.github.wnameless.json.base.JsonObjectBase;
import com.github.wnameless.json.base.JsonValueUtils;
import com.github.wnameless.json.base.Jsonable;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface JsonValueBase<JVB extends JsonValueBase<JVB>>
extends Jsonable {
    public boolean isObject();

    public boolean isArray();

    public boolean isString();

    public boolean isBoolean();

    public boolean isNumber();

    public boolean isNull();

    public String asString();

    public boolean asBoolean();

    public int asInt();

    public long asLong();

    public BigInteger asBigInteger();

    public double asDouble();

    public BigDecimal asBigDecimal();

    default public Number asNumber() {
        return JsonValueUtils.toJavaNumber(this.asBigDecimal());
    }

    default public Object asNull() {
        return null;
    }

    public JsonObjectBase<JVB> asObject();

    public JsonArrayBase<JVB> asArray();

    public JsonValueBase<JVB> asValue();
}

