/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.app.Activity;
import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.ColorInt;
import androidx.annotation.MenuRes;
import androidx.appcompat.widget.PopupMenu;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigation;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationItem;
import java.util.ArrayList;
import java.util.List;

public class AHBottomNavigationAdapter {
    private Menu mMenu;
    private List<AHBottomNavigationItem> navigationItems;

    public AHBottomNavigationAdapter(Activity activity, @MenuRes int menuRes) {
        PopupMenu popupMenu = new PopupMenu((Context)activity, null);
        this.mMenu = popupMenu.getMenu();
        activity.getMenuInflater().inflate(menuRes, this.mMenu);
    }

    public void setupWithBottomNavigation(AHBottomNavigation ahBottomNavigation) {
        this.setupWithBottomNavigation(ahBottomNavigation, null);
    }

    public void setupWithBottomNavigation(AHBottomNavigation ahBottomNavigation, @ColorInt int[] colors) {
        if (this.navigationItems == null) {
            this.navigationItems = new ArrayList<AHBottomNavigationItem>();
        } else {
            this.navigationItems.clear();
        }
        if (this.mMenu != null) {
            for (int i = 0; i < this.mMenu.size(); ++i) {
                AHBottomNavigationItem navigationItem;
                MenuItem item = this.mMenu.getItem(i);
                if (colors != null && colors.length >= this.mMenu.size() && colors[i] != 0) {
                    navigationItem = new AHBottomNavigationItem(String.valueOf(item.getTitle()), item.getIcon(), colors[i]);
                    this.navigationItems.add(navigationItem);
                    continue;
                }
                navigationItem = new AHBottomNavigationItem(String.valueOf(item.getTitle()), item.getIcon());
                this.navigationItems.add(navigationItem);
            }
            ahBottomNavigation.removeAllItems();
            ahBottomNavigation.addItems(this.navigationItems);
        }
    }

    public MenuItem getMenuItem(int index) {
        return this.mMenu.getItem(index);
    }

    public AHBottomNavigationItem getNavigationItem(int index) {
        return this.navigationItems.get(index);
    }

    public Integer getPositionByMenuId(int menuId) {
        for (int i = 0; i < this.mMenu.size(); ++i) {
            if (this.mMenu.getItem(i).getItemId() != menuId) continue;
            return i;
        }
        return null;
    }
}

