/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.aurelhubert.ahbottomnavigation.AHTextView;
import java.util.ArrayList;

public class AHHelper {
    public static Drawable getTintDrawable(Drawable drawable2, @Nullable Integer color2, boolean forceTint) {
        if (color2 == null) {
            Drawable wrapDrawable = DrawableCompat.wrap((Drawable)drawable2).mutate();
            if (Build.VERSION.SDK_INT >= 21) {
                wrapDrawable.setTintList(null);
            }
            return wrapDrawable;
        }
        if (forceTint) {
            drawable2.clearColorFilter();
            drawable2.setColorFilter(color2.intValue(), PorterDuff.Mode.SRC_IN);
            drawable2.invalidateSelf();
            return drawable2;
        }
        Drawable wrapDrawable = DrawableCompat.wrap((Drawable)drawable2).mutate();
        DrawableCompat.setTint((Drawable)wrapDrawable, (int)color2);
        return wrapDrawable;
    }

    public static void updateTopMargin(View view, int fromMargin, int toMargin) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromMargin, toMargin});
        animator.setDuration(150L);
        animator.addUpdateListener(valueAnimator -> {
            float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                p.setMargins(p.leftMargin, (int)animatedValue, p.rightMargin, p.bottomMargin);
                view.requestLayout();
            }
        });
        animator.start();
    }

    public static void updateBottomMargin(View view, int fromMargin, int toMargin, int duration) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromMargin, toMargin});
        animator.setDuration((long)duration);
        animator.addUpdateListener(valueAnimator -> {
            float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)animatedValue);
                view.requestLayout();
            }
        });
        animator.start();
    }

    public static void updateLeftMargin(View view, int fromMargin, int toMargin) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromMargin, toMargin});
        animator.setDuration(150L);
        animator.addUpdateListener(valueAnimator -> {
            float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                p.setMargins((int)animatedValue, p.topMargin, p.rightMargin, p.bottomMargin);
                view.requestLayout();
            }
        });
        animator.start();
    }

    public static void updateTextSize(TextView textView, float fromSize, float toSize) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromSize, toSize});
        animator.setDuration(150L);
        animator.addUpdateListener(valueAnimator -> {
            float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            textView.setTextSize(0, animatedValue);
        });
        animator.start();
    }

    public static void updateAlpha(View view, float fromValue, float toValue) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromValue, toValue});
        animator.setDuration(150L);
        animator.addUpdateListener(valueAnimator -> {
            float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            view.setAlpha(animatedValue);
        });
        animator.start();
    }

    public static void updateTextColor(AHTextView textView, @Nullable Integer fromColor, @Nullable Integer toColor) {
        if (fromColor != null && toColor != null) {
            ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{fromColor, toColor});
            colorAnimation.setDuration(150L);
            colorAnimation.addUpdateListener(animator -> textView.setTextColor((Integer)animator.getAnimatedValue()));
            colorAnimation.start();
        } else {
            textView.setTextColor(toColor);
        }
    }

    public static void updateViewBackgroundColor(View view, @ColorInt int fromColor, @ColorInt int toColor) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{fromColor, toColor});
        colorAnimation.setDuration(150L);
        colorAnimation.addUpdateListener(animator -> view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue()));
        colorAnimation.start();
    }

    public static void updateDrawableColor(Drawable drawable2, ImageView imageView, @Nullable Integer fromColor, @Nullable Integer toColor, boolean forceTint) {
        if (fromColor != null && toColor != null) {
            ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{fromColor, toColor});
            colorAnimation.setDuration(150L);
            colorAnimation.addUpdateListener(animator -> {
                imageView.setImageDrawable(AHHelper.getTintDrawable(drawable2, (Integer)animator.getAnimatedValue(), forceTint));
                imageView.requestLayout();
            });
            colorAnimation.start();
        } else {
            imageView.setImageDrawable(AHHelper.getTintDrawable(drawable2, toColor, forceTint));
            imageView.requestLayout();
        }
    }

    public static void updateWidth(View view, float fromWidth, float toWidth) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromWidth, toWidth});
        animator.setDuration(150L);
        animator.addUpdateListener(animator1 -> {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            params.width = Math.round(((Float)animator1.getAnimatedValue()).floatValue());
            view.setLayoutParams(params);
        });
        animator.start();
    }

    public static boolean isTranslucentStatusBar(Context context) {
        Window w = AHHelper.unwrap(context).getWindow();
        WindowManager.LayoutParams lp = w.getAttributes();
        int flags = lp.flags;
        return (flags & 0x8000000) == 0x8000000;
    }

    public static int getSoftButtonsBarSizePort(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            Window window = AHHelper.unwrap(context).getWindow();
            window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            int usableHeight = metrics.heightPixels;
            window.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
            int realHeight = metrics.heightPixels;
            if (realHeight > usableHeight) {
                return realHeight - usableHeight;
            }
            return 0;
        }
        return 0;
    }

    public static Activity unwrap(Context context) {
        while (!(context instanceof Activity)) {
            ContextWrapper wrapper = (ContextWrapper)context;
            context = wrapper.getBaseContext();
        }
        return (Activity)context;
    }

    public static <T> void map(ArrayList<T> al, Mapper<T> mapper) {
        if (al == null) {
            return;
        }
        for (int i = 0; i < al.size(); ++i) {
            al.set(i, mapper.map(al.get(i)));
        }
    }

    public static <T> void fill(ArrayList<T> al, int count, T value) {
        for (int i = 0; i < count; ++i) {
            al.add(value);
        }
    }

    public static boolean equals(@Nullable Integer o1, @Nullable Integer o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }

    public static interface Mapper<T> {
        public T map(T var1);
    }
}

