/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation.notification;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class AHNotification
implements Parcelable {
    public static final int NOTIFICATION_SIZE_DEFAULT = -1;
    @Nullable
    private String text;
    @ColorInt
    private int textColor;
    @ColorInt
    private int backgroundColor;
    @Px
    private int size = -1;
    public static final Parcelable.Creator<AHNotification> CREATOR = new Parcelable.Creator<AHNotification>(){

        public AHNotification createFromParcel(Parcel in) {
            return new AHNotification(in);
        }

        public AHNotification[] newArray(int size) {
            return new AHNotification[size];
        }
    };

    public AHNotification() {
    }

    private AHNotification(Parcel in) {
        this.text = in.readString();
        this.textColor = in.readInt();
        this.backgroundColor = in.readInt();
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.text) && this.size < 0;
    }

    public boolean isPimple() {
        return TextUtils.isEmpty((CharSequence)this.text) && this.size >= 0;
    }

    @NonNull
    public String getReadableText() {
        return this.text == null ? "" : this.text;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(@Px int size) {
        this.size = size;
    }

    public static AHNotification justText(String text) {
        return new Builder().setText(text).build();
    }

    public static List<AHNotification> generateEmptyList(int size) {
        ArrayList<AHNotification> notificationList = new ArrayList<AHNotification>();
        for (int i = 0; i < size; ++i) {
            notificationList.add(new AHNotification());
        }
        return notificationList;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.text);
        dest.writeInt(this.textColor);
        dest.writeInt(this.backgroundColor);
        dest.writeInt(this.size);
    }

    public boolean hasText() {
        return !TextUtils.isEmpty((CharSequence)this.text);
    }

    public static class Builder {
        @Nullable
        private String text;
        @ColorInt
        private int textColor;
        @ColorInt
        private int backgroundColor;
        @Px
        private int size = -1;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setTextColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder setSize(@Px int size) {
            this.size = size;
            return this;
        }

        public AHNotification build() {
            AHNotification notification = new AHNotification();
            notification.text = this.text;
            notification.textColor = this.textColor;
            notification.backgroundColor = this.backgroundColor;
            notification.size = this.size;
            return notification;
        }
    }
}

