/*
 * Decompiled with CFR 0.152.
 */
package com.wildma.idcardcamera.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.wildma.idcardcamera.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageUtils {
    public static boolean save(Bitmap src, String filePath, Bitmap.CompressFormat format) {
        return ImageUtils.save(src, FileUtils.getFileByPath(filePath), format, false);
    }

    public static boolean save(Bitmap src, File file, Bitmap.CompressFormat format) {
        return ImageUtils.save(src, file, format, false);
    }

    public static boolean save(Bitmap src, String filePath, Bitmap.CompressFormat format, boolean recycle) {
        return ImageUtils.save(src, FileUtils.getFileByPath(filePath), format, recycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Bitmap src, File file, Bitmap.CompressFormat format, boolean recycle) {
        boolean ret;
        BufferedOutputStream os;
        block5: {
            if (ImageUtils.isEmptyBitmap(src) || !FileUtils.createOrExistsFile(file)) {
                return false;
            }
            System.out.println(src.getWidth() + ", " + src.getHeight());
            os = null;
            ret = false;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                ret = src.compress(format, 100, (OutputStream)os);
                if (!recycle || src.isRecycled()) break block5;
                src.recycle();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtils.closeIO(os);
                    throw throwable;
                }
                FileUtils.closeIO(os);
            }
        }
        FileUtils.closeIO(os);
        return ret;
    }

    private static boolean isEmptyBitmap(Bitmap src) {
        return src == null || src.getWidth() == 0 || src.getHeight() == 0;
    }

    public static Bitmap getBitmapFromByte(byte[] bytes, int width, int height) {
        YuvImage image = new YuvImage(bytes, 17, width, height, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream(bytes.length);
        if (!image.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)os)) {
            return null;
        }
        byte[] tmp = os.toByteArray();
        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])tmp, (int)0, (int)tmp.length);
        return bmp;
    }
}

