/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.cache;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.cache.CacheDatabase;
import tech.linjiang.pandora.util.Utils;

@CacheDatabase.Table(value="log_crash")
public class Crash
implements Serializable {
    @CacheDatabase.Column(value="_id", primaryKey=true)
    public int id;
    @CacheDatabase.Column(value="createTime")
    public long createTime;
    @CacheDatabase.Column(value="startTime")
    public long startTime;
    @CacheDatabase.Column(value="type")
    public String type;
    @CacheDatabase.Column(value="cause")
    public String cause;
    @CacheDatabase.Column(value="stack")
    public String stack;
    @CacheDatabase.Column(value="versionCode")
    public int versionCode;
    @CacheDatabase.Column(value="versionName")
    public String versionName;
    @CacheDatabase.Column(value="sys_sdk")
    public String systemSDK;
    @CacheDatabase.Column(value="sys_version")
    public String systemVersion;
    @CacheDatabase.Column(value="rom")
    public String rom;
    @CacheDatabase.Column(value="cpu")
    public String cpuABI;
    @CacheDatabase.Column(value="phone")
    public String phoneName;
    @CacheDatabase.Column(value="locale")
    public String locale;

    public static void clear() {
        CacheDatabase.delete(Crash.class);
    }

    public static List<Crash> query() {
        List<Crash> result = CacheDatabase.queryList(Crash.class, null, "order by createTime DESC");
        return result;
    }

    public static void insert(Throwable t, long launchTime) {
        Crash crash = new Crash();
        crash.startTime = launchTime;
        crash.createTime = System.currentTimeMillis();
        crash.type = t.getClass().getSimpleName();
        crash.cause = t.getMessage();
        crash.stack = Utils.collectThrow(t);
        crash.versionCode = Crash.packageCode(Utils.getContext());
        crash.versionName = Crash.packageName(Utils.getContext());
        crash.systemVersion = Build.VERSION.RELEASE;
        crash.systemSDK = "Android " + Build.VERSION.SDK_INT;
        crash.rom = Build.MANUFACTURER;
        crash.cpuABI = Build.CPU_ABI;
        crash.phoneName = Build.MODEL;
        crash.locale = Locale.getDefault().getLanguage();
        CacheDatabase.insert(crash);
    }

    private static int packageCode(Context context) {
        PackageManager manager = context.getPackageManager();
        int code = 0;
        try {
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            code = info.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return code;
    }

    private static String packageName(Context context) {
        PackageManager manager = context.getPackageManager();
        String name = null;
        try {
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            name = info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return name;
    }
}

