/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.View;
import android.view.WindowManager;
import android.widget.Toast;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.util.Config;

public class Utils {
    public static final DateFormat DEFAULT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS", Locale.ENGLISH);
    public static final DateFormat NO_MILLIS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    public static final DateFormat HHMMSS = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
    private static Context CONTEXT;
    private static Handler mainHandler;
    private static long lastCheckTime;
    private static float[] lastXyz;

    private Utils() {
    }

    public static void init(Context context) {
        CONTEXT = context.getApplicationContext();
        mainHandler = new Handler(Looper.getMainLooper());
    }

    @SuppressLint(value={"PrivateApi"})
    @NonNull
    public static Context getContext() {
        return CONTEXT;
    }

    public static <V> boolean isNotEmpty(List<V> sourceList) {
        return sourceList != null && sourceList.size() != 0;
    }

    public static <V> int getCount(V[] sourceList) {
        return sourceList != null && sourceList.length != 0 ? sourceList.length : 0;
    }

    public static <T> T[] newArray(T ... value) {
        return value;
    }

    public static String millis2String(long millis) {
        return Utils.millis2String(millis, DEFAULT);
    }

    public static String millis2String(long millis, DateFormat format) {
        return format.format(new Date(millis));
    }

    public static void toast(@StringRes int resId) {
        Toast.makeText((Context)CONTEXT, (int)resId, (int)0).show();
    }

    public static void toast(String msg) {
        Toast.makeText((Context)CONTEXT, (CharSequence)msg, (int)0).show();
    }

    public static void copy2ClipBoard(String msg) {
        ClipboardManager cm = (ClipboardManager)CONTEXT.getSystemService("clipboard");
        try {
            ClipData mClipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)msg);
            cm.setPrimaryClip(mClipData);
            Utils.toast(R.string.pd_copy_2_clipboard);
        }
        catch (Throwable t) {
            Utils.toast(t.getMessage());
        }
    }

    public static void post(Runnable runnable) {
        mainHandler.post(runnable);
    }

    public static void postDelayed(Runnable runnable, long delayMillis) {
        mainHandler.postDelayed(runnable, delayMillis);
    }

    public static void cancelTask(Runnable runnable) {
        mainHandler.removeCallbacks(runnable);
    }

    public static String formatSize(long origin) {
        BigDecimal size = new BigDecimal(Long.toString(origin));
        String value = size.compareTo(new BigDecimal("1024")) < 0 ? size + "B" : ((size = size.divide(new BigDecimal("1024"))).compareTo(new BigDecimal("1024")) > 0 ? size.divide(new BigDecimal("1024"), 2, 1) + "MB" : size.setScale(2, 1) + "KB");
        return value;
    }

    public static void shareText(String content) {
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.TEXT", content);
        shareIntent.setType("text/plain");
        try {
            CONTEXT.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)"share to"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Utils.toast(t.getMessage());
        }
    }

    public static void removeViewFromWindow(View v) {
        try {
            WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
            windowManager.removeView(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean checkPermission() {
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)CONTEXT)) {
            Toast.makeText((Context)CONTEXT, (int)R.string.pd_please_allow_permission, (int)1).show();
            try {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                intent.setData(Uri.parse((String)("package:" + CONTEXT.getPackageName())));
                intent.setFlags(0x10000000);
                CONTEXT.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void registerSensor(SensorEventListener listener) {
        try {
            SensorManager manager = (SensorManager)CONTEXT.getSystemService("sensor");
            Sensor sensor = manager.getDefaultSensor(1);
            manager.registerListener(listener, sensor, 3);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Utils.toast(t.getMessage());
        }
    }

    public static void unRegisterSensor(SensorEventListener listener) {
        try {
            SensorManager manager = (SensorManager)CONTEXT.getSystemService("sensor");
            Sensor sensor = manager.getDefaultSensor(1);
            manager.unregisterListener(listener, sensor);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Utils.toast(t.getMessage());
        }
    }

    public static boolean checkIfShake(float x, float y, float z) {
        long currentTime = System.currentTimeMillis();
        long diffTime = currentTime - lastCheckTime;
        if (diffTime < 100L) {
            return false;
        }
        lastCheckTime = currentTime;
        float deltaX = x - lastXyz[0];
        float deltaY = y - lastXyz[1];
        float deltaZ = z - lastXyz[2];
        Utils.lastXyz[0] = x;
        Utils.lastXyz[1] = y;
        Utils.lastXyz[2] = z;
        int delta = (int)(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) / (double)diffTime * 10000.0);
        return delta > Config.getSHAKE_THRESHOLD();
    }

    static {
        lastXyz = new float[3];
    }
}

