/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import java.io.Serializable;
import java.util.ArrayList;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.connector.EditCallback;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.EditFragment;
import tech.linjiang.pandora.ui.item.CheckBoxItem;
import tech.linjiang.pandora.ui.item.NameArrowItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class ConfigFragment
extends BaseListFragment {
    private int editingType;
    private EditCallback callback = new EditCallback(){

        @Override
        public void onValueChanged(String value) {
            try {
                switch (ConfigFragment.this.editingType) {
                    case 32: {
                        long req = Long.parseLong(value);
                        Config.setNETWORK_DELAY_REQ(req);
                        break;
                    }
                    case 33: {
                        long res = Long.parseLong(value);
                        Config.setNETWORK_DELAY_RES(res);
                        break;
                    }
                    case 34: {
                        int size = Integer.parseInt(value);
                        if (size < 1) {
                            Utils.toast("invalid. At least 1");
                            return;
                        }
                        Config.setNETWORK_PAGE_SIZE(size);
                        break;
                    }
                    case 2: {
                        int threshold = Integer.parseInt(value);
                        if (threshold < 600) {
                            Utils.toast("invalid. At least 600");
                            return;
                        }
                        Config.setSHAKE_THRESHOLD(threshold);
                        break;
                    }
                    case 64: {
                        String gravity = String.valueOf(value);
                        int result = ViewKnife.formatGravity(gravity);
                        if (result != 0) {
                            Config.setUI_ACTIVITY_GRAVITY(result);
                            break;
                        }
                        Utils.toast("invalid");
                        break;
                    }
                    case 65: {
                        int interval = Integer.parseInt(value);
                        if (interval < 1) {
                            Utils.toast("invalid. At least 1");
                            return;
                        }
                        Config.setUI_GRID_INTERVAL(interval);
                    }
                }
                ConfigFragment.this.refreshData();
                Utils.toast(R.string.pd_success);
            }
            catch (Throwable t) {
                t.printStackTrace();
                Utils.toast(t.getMessage());
            }
        }
    };

    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Setting");
        this.getToolbar().getMenu().findItem(R.id.menu_reset).setVisible(true);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                Config.reset();
                ConfigFragment.this.refreshData();
                Utils.toast(R.string.pd_success);
                return false;
            }
        });
        this.refreshData();
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (!(item instanceof TitleItem)) {
                    int type = (Integer)item.getTag();
                    Log.d((String)ConfigFragment.this.TAG, (String)("onItemClick: " + type));
                    switch (type) {
                        case 17: {
                            Config.setCOMMON_NETWORK_SWITCH(!Config.getCOMMON_NETWORK_SWITCH());
                            break;
                        }
                        case 18: {
                            Config.setCOMMON_SANDBOX_SWITCH(!Config.getCOMMON_SANDBOX_SWITCH());
                            break;
                        }
                        case 19: {
                            Config.setCOMMON_UI_SWITCH(!Config.getCOMMON_UI_SWITCH());
                            break;
                        }
                        case 2: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 64: 
                        case 65: {
                            ConfigFragment.this.editingType = type;
                            Bundle bundle = new Bundle();
                            bundle.putSerializable("param2", (Serializable)ConfigFragment.this.callback);
                            if (type == 2) {
                                bundle.putStringArray("param3", Utils.newArray("800", "1000", "1200", "1400", "1600"));
                            } else if (type == 64) {
                                bundle.putStringArray("param3", Utils.newArray("start|top", "end|top", "start|bottom", "end|bottom"));
                                bundle.putBoolean("param4", true);
                            }
                            ConfigFragment.this.launch(EditFragment.class, bundle);
                            break;
                        }
                        case 48: {
                            Config.setSANDBOX_DPM(!Config.getSANDBOX_DPM());
                            break;
                        }
                        case 1: {
                            Config.setSHAKE_SWITCH(!Config.getSHAKE_SWITCH());
                            break;
                        }
                        case 66: {
                            Config.setUI_IGNORE_SYS_LAYER(!Config.getUI_IGNORE_SYS_LAYER());
                        }
                    }
                }
            }
        });
    }

    private void refreshData() {
        ArrayList<BaseItem> data = new ArrayList<BaseItem>();
        data.add(new TitleItem("NETWORK"));
        data.add(new NameArrowItem("delay for each request(ms)", "" + Config.getNETWORK_DELAY_REQ()).setTag(32));
        data.add(new NameArrowItem("delay for each response(ms)", "" + Config.getNETWORK_DELAY_RES()).setTag(33));
        data.add(new NameArrowItem("the maximum number of first loads", "" + Config.getNETWORK_PAGE_SIZE()).setTag(34));
        data.add(new TitleItem("SANDBOX"));
        data.add(new CheckBoxItem("show device-protect-mode file\n(only for api>=24)", Config.getSANDBOX_DPM()).setTag(48));
        data.add(new TitleItem("UI"));
        data.add(new NameArrowItem("the gravity of activity info", "" + ViewKnife.parseGravity(Config.getUI_ACTIVITY_GRAVITY())).setTag(64));
        data.add(new NameArrowItem("the interval of grid line(dp)", "" + Config.getUI_GRID_INTERVAL()).setTag(65));
        data.add(new CheckBoxItem("ignore system layers in hierarchy", Config.getUI_IGNORE_SYS_LAYER()).setTag(66));
        data.add(new TitleItem("SHAKE"));
        data.add(new CheckBoxItem("turn on", Config.getSHAKE_SWITCH()).setTag(1));
        data.add(new NameArrowItem("threshold", "" + Config.getSHAKE_THRESHOLD()).setTag(2));
        data.add(new TitleItem("COMMON"));
        data.add(new CheckBoxItem("enable network module", Config.getCOMMON_NETWORK_SWITCH()).setTag(17));
        data.add(new CheckBoxItem("enable sandbox module", Config.getCOMMON_SANDBOX_SWITCH()).setTag(18));
        this.getAdapter().setItems(data);
    }
}

