/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.canvas;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import tech.linjiang.pandora.inspector.model.Element;
import tech.linjiang.pandora.util.ViewKnife;

public class ClickInfoCanvas {
    private View container;
    private final int cornerRadius = ViewKnife.dip2px(1.5f);
    private final int textBgFillingSpace = ViewKnife.dip2px(3.0f);
    private final int textLineDistance = ViewKnife.dip2px(6.0f);
    private Paint textPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setTextSize(ViewKnife.dip2px(10.0f));
            this.setColor(-65536);
            this.setStyle(Paint.Style.FILL);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
            this.setFlags(32);
        }
    };
    private Paint cornerPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
            this.setColor(-1);
            this.setStyle(Paint.Style.FILL);
        }
    };
    private RectF tmpRectF = new RectF();
    private Element infoElement;
    private ValueAnimator infoAnimator;
    private boolean showInfoAlways = false;

    public ClickInfoCanvas(View container) {
        this.container = container;
    }

    public ClickInfoCanvas(View container, boolean showInfoAlways) {
        this.container = container;
        this.showInfoAlways = showInfoAlways;
    }

    public void setInfoElement(Element infoElement) {
        this.infoElement = infoElement;
        if (!this.showInfoAlways) {
            this.animInfo();
        }
    }

    private void animInfo() {
        if (this.infoAnimator != null) {
            this.infoAnimator.removeAllUpdateListeners();
            this.infoAnimator.cancel();
        }
        this.infoAnimator = ObjectAnimator.ofInt((int[])new int[]{255, 0}).setDuration(1400L);
        this.infoAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ClickInfoCanvas.this.container.invalidate();
            }
        });
        this.infoAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ClickInfoCanvas.this.infoElement = null;
                ClickInfoCanvas.this.container.invalidate();
            }
        });
        this.infoAnimator.start();
    }

    public void draw(Canvas canvas) {
        if (this.infoElement == null) {
            return;
        }
        boolean show = this.showInfoAlways;
        if (!show) {
            boolean bl = show = this.infoAnimator != null && this.infoAnimator.isRunning();
        }
        if (show) {
            int alpha = this.showInfoAlways ? 255 : (Integer)this.infoAnimator.getAnimatedValue();
            this.cornerPaint.setAlpha(alpha);
            this.textPaint.setAlpha(alpha);
            Rect rect = this.infoElement.getRect();
            String widthText = ViewKnife.px2dipStr(rect.width());
            this.drawText(canvas, widthText, (float)rect.centerX() - ViewKnife.getTextWidth(this.textPaint, widthText) / 2.0f, rect.top - this.textLineDistance);
            String heightText = ViewKnife.px2dipStr(rect.height());
            this.drawText(canvas, heightText, rect.right + this.textLineDistance, rect.centerY());
        }
    }

    private void drawText(Canvas canvas, String text, float x, float y) {
        float diff;
        float left = x - (float)this.textBgFillingSpace;
        float top = y - ViewKnife.getTextHeight(this.textPaint, text);
        float right = x + ViewKnife.getTextWidth(this.textPaint, text) + (float)this.textBgFillingSpace;
        float bottom = y + (float)this.textBgFillingSpace;
        if (left < 0.0f) {
            right -= left;
            left = 0.0f;
        }
        if (top < 0.0f) {
            bottom -= top;
            top = 0.0f;
        }
        if (bottom > (float)canvas.getHeight()) {
            diff = top - bottom;
            bottom = canvas.getHeight();
            top = bottom + diff;
        }
        if (right > (float)canvas.getWidth()) {
            diff = left - right;
            right = canvas.getWidth();
            left = right + diff;
        }
        this.tmpRectF.set(left, top, right, bottom);
        canvas.drawRoundRect(this.tmpRectF, (float)this.cornerRadius, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawText(text, left + (float)this.textBgFillingSpace, bottom - (float)this.textBgFillingSpace, this.textPaint);
    }
}

