/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.attribute.parser;

import android.os.Build;
import android.widget.EditText;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.inspector.attribute.IParser;
import tech.linjiang.pandora.inspector.model.Attribute;
import tech.linjiang.pandora.util.ViewKnife;

public class TextViewParser
implements IParser<TextView> {
    @Override
    public List<Attribute> getAttrs(TextView view) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute textAttribute = new Attribute("text", view.getText().toString(), 18);
        attributes.add(textAttribute);
        Attribute textColorAttribute = new Attribute("textColor", "#" + TextViewParser.intToHex(view.getCurrentTextColor()), 17);
        attributes.add(textColorAttribute);
        Attribute textHintColorAttribute = new Attribute("textHintColor", "#" + TextViewParser.intToHex(view.getCurrentHintTextColor()));
        attributes.add(textHintColorAttribute);
        Attribute textSizeAttribute = new Attribute("textSize", ViewKnife.px2dipStr(view.getTextSize()), 16);
        attributes.add(textSizeAttribute);
        Attribute gravityAttribute = new Attribute("gravity", TextViewParser.gravityToStr(view.getGravity()));
        attributes.add(gravityAttribute);
        Attribute lineCountAttribute = new Attribute("lineCount", String.valueOf(view.getLineCount()));
        attributes.add(lineCountAttribute);
        Attribute lineHeightAttribute = new Attribute("lineHeight", ViewKnife.px2dipStr(view.getLineHeight()));
        attributes.add(lineHeightAttribute);
        if (Build.VERSION.SDK_INT >= 16) {
            Attribute lineSpacingExtraAttribute = new Attribute("lineSpacingExtra", String.valueOf(view.getLineSpacingExtra()));
            attributes.add(lineSpacingExtraAttribute);
            Attribute lineSpacingMultiplierAttribute = new Attribute("lineSpacingMultiplier", String.valueOf(view.getLineSpacingMultiplier()));
            attributes.add(lineSpacingMultiplierAttribute);
            if (view instanceof EditText) {
                Attribute maxLinesAttribute = new Attribute("maxLines", String.valueOf(view.getMaxLines()));
                attributes.add(maxLinesAttribute);
                Attribute minLinesAttribute = new Attribute("minLines", String.valueOf(view.getMinLines()));
                attributes.add(minLinesAttribute);
                Attribute maxEmsAttribute = new Attribute("maxEms", String.valueOf(view.getMaxEms()));
                attributes.add(maxEmsAttribute);
                Attribute minEmsAttribute = new Attribute("minEms", String.valueOf(view.getMinEms()));
                attributes.add(minEmsAttribute);
                Attribute maxWidthAttribute = new Attribute("maxWidth", ViewKnife.px2dipStr(view.getMaxWidth()));
                attributes.add(maxWidthAttribute);
                Attribute minWidthAttribute = new Attribute("minWidth", ViewKnife.px2dipStr(view.getMinWidth()));
                attributes.add(minWidthAttribute);
                Attribute maxHeightAttribute = new Attribute("maxHeight", ViewKnife.px2dipStr(view.getMaxHeight()));
                attributes.add(maxHeightAttribute);
                Attribute minHeightAttribute = new Attribute("minHeight", ViewKnife.px2dipStr(view.getMinHeight()));
                attributes.add(minHeightAttribute);
            }
        }
        return attributes;
    }

    private static String intToHex(int value) {
        return Integer.toHexString(value).toUpperCase();
    }

    private static String gravityToStr(int gravity) {
        switch (gravity) {
            case 0: {
                return "NO_GRAVITY";
            }
            case 3: {
                return "LEFT";
            }
            case 48: {
                return "TOP";
            }
            case 5: {
                return "RIGHT";
            }
            case 80: {
                return "BOTTOM";
            }
            case 17: {
                return "CENTER";
            }
            case 1: {
                return "CENTER_HORIZONTAL";
            }
            case 16: {
                return "CENTER_VERTICAL";
            }
            case 0x800003: {
                return "START";
            }
            case 0x800005: {
                return "END";
            }
            case 8: {
                return "CLIP_HORIZONTAL";
            }
            case 128: {
                return "CLIP_VERTICAL";
            }
            case 119: {
                return "FILL";
            }
            case 7: {
                return "FILL_HORIZONTAL";
            }
            case 112: {
                return "FILL_VERTICAL";
            }
        }
        return "OTHER";
    }
}

