/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.util.ViewKnife;

public class BaseLineView
extends View {
    private int touchSlop;
    private float downX;
    private float downY;
    private float lastX;
    private float lastY;
    private float initX;
    private float initY;
    private float oldX;
    private float oldY;
    private float moveStartX;
    private float moveStartY;
    private int heightDP;
    private int widthDP;
    private int SCALE_LENGTH = ViewKnife.dip2px(4.0f);
    private int SCALE_GAP = 5;
    private int direction;
    private Paint paint = new Paint(1){
        {
            this.setColor(ViewKnife.getColor(R.color.pd_red));
            this.setStyle(Paint.Style.FILL);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
        }
    };
    private Paint oldPaint = new Paint(1){
        {
            this.setColor(ViewKnife.getColor(R.color.pd_red));
            this.setStyle(Paint.Style.STROKE);
            this.setStrokeWidth(ViewKnife.dip2px(0.5f));
            this.setPathEffect((PathEffect)new DashPathEffect(new float[]{ViewKnife.dip2px(3.0f), ViewKnife.dip2px(3.0f)}, 0.0f));
        }
    };
    private Paint mutablePaint = new Paint(1){
        {
            this.setColor(ViewKnife.getColor(R.color.pd_blue));
            this.setStyle(Paint.Style.FILL);
            this.setStrokeWidth(ViewKnife.dip2px(2.0f));
            this.setTextSize(ViewKnife.dip2px(12.0f));
            this.setFlags(32);
        }
    };
    private final Paint defPaint = new Paint(1){
        {
            this.setColor(-256);
            this.setStrokeWidth(ViewKnife.dip2px(2.0f));
            this.setStyle(Paint.Style.STROKE);
        }
    };

    public BaseLineView(Context context) {
        super(context);
        this.setLayerType(1, null);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.heightDP = ViewKnife.px2dip(this.getMeasuredHeight());
        this.widthDP = ViewKnife.px2dip(this.getMeasuredWidth());
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.downX = this.lastX = event.getX();
                this.downY = this.lastY = event.getY();
                super.onTouchEvent(event);
                return true;
            }
            case 2: {
                this.lastX = event.getX();
                this.lastY = event.getY();
                float dx = this.lastX - this.downX;
                float dy = this.lastY - this.downY;
                if (this.direction == 0) {
                    if (Math.abs(dx) > (float)this.touchSlop) {
                        this.direction = 1;
                        this.moveStartX = this.lastX;
                        this.oldX = this.initX;
                        if (this.initY <= 0.0f) {
                            this.initY = this.lastY;
                        }
                    } else if (Math.abs(dy) > (float)this.touchSlop) {
                        this.direction = 2;
                        this.moveStartY = this.lastY;
                        this.oldY = this.initY;
                        if (this.initX <= 0.0f) {
                            this.initX = this.lastX;
                        }
                    }
                }
                if (this.direction == 0) break;
                this.invalidate();
                break;
            }
            case 1: {
                if (this.direction == 0) {
                    this.oldY = 0.0f;
                    this.oldX = 0.0f;
                    this.initX = event.getX();
                    this.initY = event.getY();
                } else {
                    if (this.direction == 1) {
                        this.oldX = this.initX;
                        this.initX += event.getX() - this.moveStartX;
                    } else if (this.direction == 2) {
                        this.oldY = this.initY;
                        this.initY += event.getY() - this.moveStartY;
                    }
                    this.direction = 0;
                }
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), this.defPaint);
        if (this.initY > 0.0f) {
            canvas.drawLine(0.0f, this.initY, (float)this.getMeasuredWidth(), this.initY, this.paint);
        }
        if (this.initX > 0.0f) {
            canvas.drawLine(this.initX, 0.0f, this.initX, (float)this.getMeasuredHeight(), this.paint);
        }
        for (i = 0; i < this.heightDP; i += this.SCALE_GAP) {
            canvas.drawLine(this.initX, (float)ViewKnife.dip2px(i), this.initX + (float)this.SCALE_LENGTH, (float)ViewKnife.dip2px(i), this.paint);
        }
        for (i = 0; i < this.widthDP; i += this.SCALE_GAP) {
            canvas.drawLine((float)ViewKnife.dip2px(i), this.initY, (float)ViewKnife.dip2px(i), this.initY + (float)this.SCALE_LENGTH, this.paint);
        }
        if (this.direction == 1) {
            canvas.drawLine(this.initX + this.lastX - this.moveStartX, 0.0f, this.initX + this.lastX - this.moveStartX, (float)this.getMeasuredHeight(), this.paint);
            float dis = this.lastX - this.moveStartX;
            canvas.drawLine(this.initX, this.initY, this.initX + dis, this.initY, this.mutablePaint);
            this.mutablePaint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(ViewKnife.px2dip(dis) + "dp", this.initX + dis / 2.0f, this.initY - (float)ViewKnife.dip2px(12.0f), this.mutablePaint);
        } else if (this.direction == 2) {
            canvas.drawLine(0.0f, this.initY + this.lastY - this.moveStartY, (float)this.getMeasuredWidth(), this.initY + this.lastY - this.moveStartY, this.paint);
            float dis = this.lastY - this.moveStartY;
            canvas.drawLine(this.initX, this.initY, this.initX, this.initY + dis, this.mutablePaint);
            this.mutablePaint.setTextAlign(Paint.Align.LEFT);
            canvas.drawText(ViewKnife.px2dip(dis) + "dp", this.initX + (float)ViewKnife.dip2px(12.0f), this.initY + dis / 2.0f, this.mutablePaint);
        }
        if (this.oldX > 0.0f) {
            canvas.drawLine(this.oldX, 0.0f, this.oldX, (float)this.getMeasuredHeight(), this.oldPaint);
        }
        if (this.oldY > 0.0f) {
            canvas.drawLine(0.0f, this.oldY, (float)this.getMeasuredWidth(), this.oldY, this.oldPaint);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
        public static final int NONE = 0;
        public static final int HORIZONTAL = 1;
        public static final int VERTICAL = 2;
    }
}

