/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SwitchCompat;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.ViewAttrFragment;
import tech.linjiang.pandora.ui.item.HierarchyItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class HierarchyFragment
extends BaseListFragment
implements CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    private boolean isExpand = true;
    private View targetView;
    private int sysLayerCount;
    private View rootView;

    @Override
    protected boolean needDefaultDivider() {
        return false;
    }

    @Override
    protected boolean enableSwipeBack() {
        return this.targetView != null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            return;
        }
        this.rootView = ViewKnife.tryGetTheFrontView(Pandora.get().getTopActivity());
        if (!Config.getUI_IGNORE_SYS_LAYER()) {
            this.sysLayerCount = this.countSysLayers();
        } else {
            if (this.rootView != null) {
                this.rootView = this.rootView.findViewById(0x1020002);
            }
            this.sysLayerCount = 0;
        }
        this.targetView = this.findViewByDefaultTag();
        if (this.targetView != null) {
            this.targetView.setTag(R.id.pd_view_tag_for_unique, null);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.rootView = null;
        this.targetView = null;
    }

    @Override
    protected RecyclerView.LayoutManager onCreateLayoutManager() {
        return new LinearLayoutManager(Utils.getContext()){

            public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
                LinearSmoothScroller smoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

                    protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                        return 120.0f / (float)displayMetrics.densityDpi;
                    }

                    protected int getVerticalSnapPreference() {
                        return -1;
                    }
                };
                smoothScroller.setTargetPosition(position);
                this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
            }
        };
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            return;
        }
        this.getToolbar().setTitle(R.string.pd_name_layer);
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_1, 0, (CharSequence)"").setActionView((View)new SwitchCompat(this.getContext())).setShowAsAction(2);
        SwitchCompat switchCompat = (SwitchCompat)this.getToolbar().getMenu().findItem(R.id.pd_menu_id_1).getActionView();
        switchCompat.setChecked(this.isExpand);
        switchCompat.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.getRecyclerView().setBackgroundColor(-1);
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                HierarchyItem hierarchyItem = (HierarchyItem)item;
                if (hierarchyItem.isGroup() && hierarchyItem.getChildCount() > 0) {
                    if (!hierarchyItem.isExpand) {
                        List<HierarchyItem> expands = hierarchyItem.assembleChildren();
                        HierarchyFragment.this.insertItems(expands, position + 1);
                    } else {
                        List expands = HierarchyFragment.this.getAllExpandItems(hierarchyItem, position + 1);
                        HierarchyFragment.this.removeItems(expands);
                    }
                    hierarchyItem.toggleIcon();
                }
            }
        });
        this.expandAllViews();
    }

    @Override
    protected void onViewEnterAnimEnd(View container) {
        super.onViewEnterAnimEnd(container);
        if (this.targetView != null) {
            int scrollTargetIndex = -1;
            for (int i = 0; i < this.getAdapter().getItems().size(); ++i) {
                HierarchyItem hierarchyItem = (HierarchyItem)this.getAdapter().getItem(i);
                if (hierarchyItem.data != this.targetView) continue;
                scrollTargetIndex = i;
                break;
            }
            if (scrollTargetIndex != -1) {
                this.getRecyclerView().smoothScrollToPosition(scrollTargetIndex);
            }
        }
    }

    private List<HierarchyItem> getAllExpandItems(HierarchyItem hierarchyItem, int pos) {
        ArrayList<HierarchyItem> result = new ArrayList<HierarchyItem>();
        if (hierarchyItem.isExpand && hierarchyItem.getChildCount() > 0) {
            for (int i = pos; i < this.getAdapter().getItemCount(); ++i) {
                HierarchyItem curItem = (HierarchyItem)this.getAdapter().getItem(i);
                if (hierarchyItem.layerCount >= curItem.layerCount) break;
                result.add(curItem);
                if (!curItem.isGroup()) continue;
                List<HierarchyItem> subChildren = this.getAllExpandItems(curItem, i + 1);
                result.addAll(subChildren);
                i += subChildren.size();
            }
        }
        return result;
    }

    private void removeItems(List<HierarchyItem> data) {
        final ArrayList tmpData = new ArrayList();
        for (int i = 0; i < this.getAdapter().getItemCount(); ++i) {
            tmpData.add(this.getAdapter().getItem(i));
        }
        this.getAdapter().getItems().removeAll(data);
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

            public int getNewListSize() {
                return HierarchyFragment.this.getAdapter().getItemCount();
            }

            public int getOldListSize() {
                return tmpData.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                HierarchyItem newHierarchyItem = (HierarchyItem)HierarchyFragment.this.getAdapter().getItem(newItemPosition);
                HierarchyItem oldHierarchyItem = (HierarchyItem)tmpData.get(oldItemPosition);
                return oldHierarchyItem.data == newHierarchyItem.data;
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return oldItemPosition == newItemPosition;
            }
        });
        result.dispatchUpdatesTo((RecyclerView.Adapter)this.getAdapter());
    }

    private void insertItems(List<HierarchyItem> data, int pos) {
        final ArrayList tmpData = new ArrayList();
        for (int i = 0; i < this.getAdapter().getItemCount(); ++i) {
            tmpData.add(this.getAdapter().getItem(i));
        }
        this.getAdapter().getItems().addAll(pos, data);
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

            public int getNewListSize() {
                return HierarchyFragment.this.getAdapter().getItemCount();
            }

            public int getOldListSize() {
                return tmpData.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                HierarchyItem newHierarchyItem = (HierarchyItem)HierarchyFragment.this.getAdapter().getItem(newItemPosition);
                HierarchyItem oldHierarchyItem = (HierarchyItem)tmpData.get(oldItemPosition);
                return oldHierarchyItem.data == newHierarchyItem.data;
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return oldItemPosition == newItemPosition;
            }
        });
        result.dispatchUpdatesTo((RecyclerView.Adapter)this.getAdapter());
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (this.isExpand) {
            this.getAdapter().performClick(0);
        } else {
            this.expandAllViews();
        }
        this.isExpand = !this.isExpand;
    }

    private void expandAllViews() {
        ArrayList<BaseItem> data = new ArrayList<BaseItem>();
        HierarchyItem rootItem = HierarchyItem.createRoot(this.rootView, this);
        rootItem.sysLayerCount = this.sysLayerCount;
        data.add(rootItem);
        this.assembleItems(data, rootItem);
        this.getAdapter().setItems(data);
    }

    private void assembleItems(List<BaseItem> container, HierarchyItem hierarchyItem) {
        if (hierarchyItem.data == this.targetView) {
            hierarchyItem.isTarget = true;
        }
        if (hierarchyItem.isGroup() && hierarchyItem.getChildCount() > 0) {
            hierarchyItem.isExpand = true;
            List<HierarchyItem> expands = hierarchyItem.assembleChildren();
            for (int i = 0; i < expands.size(); ++i) {
                HierarchyItem childItem = expands.get(i);
                container.add(childItem);
                this.assembleItems(container, childItem);
            }
        }
    }

    private View findViewByDefaultTag() {
        return this.findViewByDefaultTag(this.rootView);
    }

    private View findViewByDefaultTag(View root) {
        if (root.getTag(R.id.pd_view_tag_for_unique) != null) {
            return root;
        }
        if (root instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)root;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                View view = this.findViewByDefaultTag(parent.getChildAt(i));
                if (view == null) continue;
                return view;
            }
        }
        return null;
    }

    private int countSysLayers() {
        View content = this.rootView.findViewById(0x1020002);
        int layer = 0;
        if (content != null) {
            View current = content;
            while (current.getParent() != null) {
                ++layer;
                if (!(current.getParent() instanceof View)) break;
                current = (View)current.getParent();
            }
        }
        return layer;
    }

    public void onClick(View v) {
        int position = (Integer)v.getTag();
        ((View)((HierarchyItem)this.getAdapter().getItem((int)position)).data).setTag(R.id.pd_view_tag_for_unique, new Object());
        this.launch(ViewAttrFragment.class, null);
    }
}

