/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.canvas;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.view.View;
import tech.linjiang.pandora.inspector.model.Element;
import tech.linjiang.pandora.util.ViewKnife;

public class SelectCanvas {
    private View container;
    private final int cornerRadius = ViewKnife.dip2px(1.5f);
    private Paint cornerPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
        }
    };
    private Paint areaPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-65536);
            this.setStyle(Paint.Style.STROKE);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
        }
    };
    private Paint dashLinePaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-1426128896);
            this.setStyle(Paint.Style.STROKE);
            this.setPathEffect((PathEffect)new DashPathEffect(new float[]{ViewKnife.dip2px(3.0f), ViewKnife.dip2px(3.0f)}, 0.0f));
        }
    };

    public SelectCanvas(View container) {
        container.setLayerType(1, null);
        this.container = container;
    }

    private int getMeasuredWidth() {
        return this.container.getMeasuredWidth();
    }

    private int getMeasuredHeight() {
        return this.container.getMeasuredHeight();
    }

    public void draw(Canvas canvas, Element ... elements) {
        canvas.save();
        for (Element element : elements) {
            if (element == null) continue;
            this.drawSelected(canvas, element);
        }
        canvas.restore();
    }

    private void drawSelected(Canvas canvas, Element element) {
        Rect rect = element.getRect();
        canvas.drawLine(0.0f, (float)rect.top, (float)this.getMeasuredWidth(), (float)rect.top, this.dashLinePaint);
        canvas.drawLine(0.0f, (float)rect.bottom, (float)this.getMeasuredWidth(), (float)rect.bottom, this.dashLinePaint);
        canvas.drawLine((float)rect.left, 0.0f, (float)rect.left, (float)this.getMeasuredHeight(), this.dashLinePaint);
        canvas.drawLine((float)rect.right, 0.0f, (float)rect.right, (float)this.getMeasuredHeight(), this.dashLinePaint);
        canvas.drawRect(rect, this.areaPaint);
        this.cornerPaint.setColor(-1);
        this.cornerPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)rect.left, (float)rect.top, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawCircle((float)rect.right, (float)rect.top, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawCircle((float)rect.left, (float)rect.bottom, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawCircle((float)rect.right, (float)rect.bottom, (float)this.cornerRadius, this.cornerPaint);
        this.cornerPaint.setColor(-65536);
        this.cornerPaint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle((float)rect.left, (float)rect.top, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawCircle((float)rect.right, (float)rect.top, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawCircle((float)rect.left, (float)rect.bottom, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawCircle((float)rect.right, (float)rect.bottom, (float)this.cornerRadius, this.cornerPaint);
    }
}

