/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.attribute;

import android.view.View;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.inspector.attribute.IParser;
import tech.linjiang.pandora.inspector.attribute.parser.ImageViewParser;
import tech.linjiang.pandora.inspector.attribute.parser.TextViewParser;
import tech.linjiang.pandora.inspector.attribute.parser.ViewGroupParser;
import tech.linjiang.pandora.inspector.attribute.parser.ViewParser;
import tech.linjiang.pandora.inspector.model.Attribute;

public final class AttrFactory {
    private List<IParser> parsers = new ArrayList<IParser>(){
        {
            this.add(new ImageViewParser());
            this.add(new TextViewParser());
            this.add(new ViewGroupParser());
            this.add(new ViewParser());
        }
    };

    public void addParser(IParser parser) {
        this.parsers.add(0, parser);
    }

    public List<Attribute> parse(View v) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (IParser parser : this.parsers) {
            if (parser == null) continue;
            try {
                List<Attribute> result;
                ParameterizedType parameterizedType = (ParameterizedType)parser.getClass().getGenericInterfaces()[0];
                Type actualTypeArguments = parameterizedType.getActualTypeArguments()[0];
                if (!this.findUpUntilEqual(v.getClass(), actualTypeArguments) || (result = parser.getAttrs(v)) == null || result.isEmpty()) continue;
                for (int i = 0; i < result.size(); ++i) {
                    result.get((int)i).category = actualTypeArguments.toString();
                }
                attributes.addAll(result);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return attributes;
    }

    private boolean findUpUntilEqual(Class clazz, Type type) {
        do {
            if (type != clazz) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return false;
    }
}

