/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.attribute.parser;

import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.inspector.attribute.IParser;
import tech.linjiang.pandora.inspector.model.Attribute;
import tech.linjiang.pandora.util.ViewKnife;

public class ViewParser
implements IParser<View> {
    @Override
    public List<Attribute> getAttrs(View view) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute classAttribute = new Attribute("class", String.valueOf(view.getClass().getName()));
        attributes.add(classAttribute);
        ViewGroup.LayoutParams params = view.getLayoutParams();
        Attribute paramsAttribute = new Attribute("LayoutParams", params.getClass().getName());
        attributes.add(paramsAttribute);
        Attribute widthAttribute = new Attribute("layout_width", ViewParser.formatLayoutParam(params.width, view.getWidth()), 1);
        attributes.add(widthAttribute);
        Attribute heightAttribute = new Attribute("layout_height", ViewParser.formatLayoutParam(params.height, view.getHeight()), 2);
        attributes.add(heightAttribute);
        Attribute visibilityAttribute = new Attribute("visibility", ViewParser.formatVisibility(view.getVisibility()), 3);
        attributes.add(visibilityAttribute);
        Attribute paddingLeftAttribute = new Attribute("paddingLeft", ViewKnife.px2dipStr(view.getPaddingLeft()), 4);
        attributes.add(paddingLeftAttribute);
        Attribute paddingTopAttribute = new Attribute("paddingTop", ViewKnife.px2dipStr(view.getPaddingTop()), 6);
        attributes.add(paddingTopAttribute);
        Attribute paddingRightAttribute = new Attribute("paddingRight", ViewKnife.px2dipStr(view.getPaddingRight()), 5);
        attributes.add(paddingRightAttribute);
        Attribute paddingBottomAttribute = new Attribute("paddingBottom", ViewKnife.px2dipStr(view.getPaddingBottom()), 7);
        attributes.add(paddingBottomAttribute);
        if (view.getLayoutParams() != null && view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            Attribute marginLeftAttribute = new Attribute("marginLeft", ViewKnife.px2dipStr(marginLayoutParams.leftMargin), 20);
            attributes.add(marginLeftAttribute);
            Attribute marginTopAttribute = new Attribute("marginTop", ViewKnife.px2dipStr(marginLayoutParams.topMargin), 22);
            attributes.add(marginTopAttribute);
            Attribute marginRightAttribute = new Attribute("marginRight", ViewKnife.px2dipStr(marginLayoutParams.rightMargin), 21);
            attributes.add(marginRightAttribute);
            Attribute marginBottomAttribute = new Attribute("marginBottom", ViewKnife.px2dipStr(marginLayoutParams.bottomMargin), 23);
            attributes.add(marginBottomAttribute);
        }
        Attribute translationXAttribute = new Attribute("translationX", ViewKnife.px2dipStr(view.getTranslationX()));
        attributes.add(translationXAttribute);
        Attribute translationYAttribute = new Attribute("translationY", ViewKnife.px2dipStr(view.getTranslationY()));
        attributes.add(translationYAttribute);
        Attribute backgroundAttribute = new Attribute("background", String.valueOf(view.getBackground()));
        attributes.add(backgroundAttribute);
        Attribute alphaAttribute = new Attribute("alpha", String.valueOf(view.getAlpha()), 8);
        attributes.add(alphaAttribute);
        Attribute tagAttribute = new Attribute("tag", String.valueOf(view.getTag()));
        attributes.add(tagAttribute);
        Attribute enableAttribute = new Attribute("enable", String.valueOf(view.isEnabled()));
        attributes.add(enableAttribute);
        Attribute clickAttribute = new Attribute("clickable", String.valueOf(view.isClickable()));
        attributes.add(clickAttribute);
        Attribute longClickableAttribute = new Attribute("longClickable", String.valueOf(view.isLongClickable()));
        attributes.add(longClickableAttribute);
        Attribute focusAttribute = new Attribute("focusable", String.valueOf(view.isFocusable()));
        attributes.add(focusAttribute);
        Attribute contentDescriptionAttribute = new Attribute("contentDescription", String.valueOf(view.getContentDescription()));
        attributes.add(contentDescriptionAttribute);
        return attributes;
    }

    private static String formatLayoutParam(int layoutParam, int size) {
        String dp = ViewKnife.px2dipStr(size);
        if (layoutParam == -2) {
            return String.format("wrap_content (%s)", dp);
        }
        if (layoutParam == -1) {
            return String.format("match_parent (%s)", dp);
        }
        return dp;
    }

    private static String formatVisibility(int value) {
        if (value == 0) {
            return "VISIBLE";
        }
        if (value == 4) {
            return "INVISIBLE";
        }
        if (value == 8) {
            return "GONE";
        }
        return "OTHER";
    }
}

