/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.canvas;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import tech.linjiang.pandora.inspector.model.Element;
import tech.linjiang.pandora.util.ViewKnife;

public class RelativeCanvas {
    private View container;
    private final int cornerRadius = ViewKnife.dip2px(1.5f);
    private final int endPointSpace = ViewKnife.dip2px(2.0f);
    private final int textBgFillingSpace = ViewKnife.dip2px(3.0f);
    private final int textLineDistance = ViewKnife.dip2px(6.0f);
    private Paint areaPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-65536);
            this.setStyle(Paint.Style.STROKE);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
        }
    };
    private Paint textPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setTextSize(ViewKnife.dip2px(10.0f));
            this.setColor(-65536);
            this.setStyle(Paint.Style.FILL);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
            this.setFlags(32);
        }
    };
    private Paint cornerPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
        }
    };
    private RectF tmpRectF = new RectF();

    public RelativeCanvas(View container) {
        this.container = container;
    }

    private int getMeasuredWidth() {
        return this.container.getMeasuredWidth();
    }

    private int getMeasuredHeight() {
        return this.container.getMeasuredHeight();
    }

    public void draw(Canvas canvas, Element element1, Element element2) {
        if (element1 != null && element2 != null) {
            int y;
            int x;
            canvas.save();
            Rect firstRect = element1.getRect();
            Rect secondRect = element2.getRect();
            if (secondRect.top > firstRect.bottom) {
                x = secondRect.left + secondRect.width() / 2;
                this.drawLineWithText(canvas, x, firstRect.bottom, x, secondRect.top);
            }
            if (firstRect.top > secondRect.bottom) {
                x = secondRect.left + secondRect.width() / 2;
                this.drawLineWithText(canvas, x, secondRect.bottom, x, firstRect.top);
            }
            if (secondRect.left > firstRect.right) {
                y = secondRect.top + secondRect.height() / 2;
                this.drawLineWithText(canvas, secondRect.left, y, firstRect.right, y);
            }
            if (firstRect.left > secondRect.right) {
                y = secondRect.top + secondRect.height() / 2;
                this.drawLineWithText(canvas, secondRect.right, y, firstRect.left, y);
            }
            this.drawNestedAreaLine(canvas, firstRect, secondRect);
            this.drawNestedAreaLine(canvas, secondRect, firstRect);
            canvas.restore();
        }
    }

    private void drawLineWithText(Canvas canvas, int startX, int startY, int endX, int endY) {
        if (startX == endX && startY == endY) {
            return;
        }
        if (startX > endX) {
            int tempX = startX;
            startX = endX;
            endX = tempX;
        }
        if (startY > endY) {
            int tempY = startY;
            startY = endY;
            endY = tempY;
        }
        if (startX == endX) {
            this.drawLineWithEndPoint(canvas, startX, startY + this.endPointSpace, endX, endY - this.endPointSpace);
            String text = ViewKnife.px2dip(endY - startY) + "dp";
            this.drawText(canvas, text, startX + this.textLineDistance, (float)(startY + (endY - startY) / 2) + ViewKnife.getTextHeight(this.textPaint, text) / 2.0f);
        } else if (startY == endY) {
            this.drawLineWithEndPoint(canvas, startX + this.endPointSpace, startY, endX - this.endPointSpace, endY);
            String text = ViewKnife.px2dip(endX - startX) + "dp";
            this.drawText(canvas, text, (float)(startX + (endX - startX) / 2) - ViewKnife.getTextWidth(this.textPaint, text) / 2.0f, startY - this.textLineDistance);
        }
    }

    private void drawLineWithEndPoint(Canvas canvas, int startX, int startY, int endX, int endY) {
        canvas.drawLine((float)startX, (float)startY, (float)endX, (float)endY, this.areaPaint);
        if (startX == endX) {
            canvas.drawLine((float)(startX - this.endPointSpace), (float)startY, (float)(endX + this.endPointSpace), (float)startY, this.areaPaint);
            canvas.drawLine((float)(startX - this.endPointSpace), (float)endY, (float)(endX + this.endPointSpace), (float)endY, this.areaPaint);
        } else if (startY == endY) {
            canvas.drawLine((float)startX, (float)(startY - this.endPointSpace), (float)startX, (float)(endY + this.endPointSpace), this.areaPaint);
            canvas.drawLine((float)endX, (float)(startY - this.endPointSpace), (float)endX, (float)(endY + this.endPointSpace), this.areaPaint);
        }
    }

    private void drawText(Canvas canvas, String text, float x, float y) {
        float diff;
        float left = x - (float)this.textBgFillingSpace;
        float top = y - ViewKnife.getTextHeight(this.textPaint, text);
        float right = x + ViewKnife.getTextWidth(this.textPaint, text) + (float)this.textBgFillingSpace;
        float bottom = y + (float)this.textBgFillingSpace;
        if (left < 0.0f) {
            right -= left;
            left = 0.0f;
        }
        if (top < 0.0f) {
            bottom -= top;
            top = 0.0f;
        }
        if (bottom > (float)this.getMeasuredHeight()) {
            diff = top - bottom;
            bottom = this.getMeasuredHeight();
            top = bottom + diff;
        }
        if (right > (float)this.getMeasuredWidth()) {
            diff = left - right;
            right = this.getMeasuredWidth();
            left = right + diff;
        }
        this.cornerPaint.setColor(-1);
        this.cornerPaint.setStyle(Paint.Style.FILL);
        this.tmpRectF.set(left, top, right, bottom);
        canvas.drawRoundRect(this.tmpRectF, (float)this.cornerRadius, (float)this.cornerRadius, this.cornerPaint);
        canvas.drawText(text, left + (float)this.textBgFillingSpace, bottom - (float)this.textBgFillingSpace, this.textPaint);
    }

    private void drawNestedAreaLine(Canvas canvas, Rect firstRect, Rect secondRect) {
        if (secondRect.left >= firstRect.left && secondRect.right <= firstRect.right && secondRect.top >= firstRect.top && secondRect.bottom <= firstRect.bottom) {
            this.drawLineWithText(canvas, secondRect.left, secondRect.top + secondRect.height() / 2, firstRect.left, secondRect.top + secondRect.height() / 2);
            this.drawLineWithText(canvas, secondRect.right, secondRect.top + secondRect.height() / 2, firstRect.right, secondRect.top + secondRect.height() / 2);
            this.drawLineWithText(canvas, secondRect.left + secondRect.width() / 2, secondRect.top, secondRect.left + secondRect.width() / 2, firstRect.top);
            this.drawLineWithText(canvas, secondRect.left + secondRect.width() / 2, secondRect.bottom, secondRect.left + secondRect.width() / 2, firstRect.bottom);
        }
    }
}

