/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.Arrays;
import org.jtransforms.dht.FloatDHT_1D;
import org.jtransforms.dht.FloatDHT_2D;
import org.jtransforms.dht.FloatDHT_3D;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.IOUtils;
import org.visnow.jlargearrays.ConcurrencyUtils;
import org.visnow.jlargearrays.FloatLargeArray;

public class BenchmarkFloatDHT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static long[] sizes1D = new long[]{262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 10368L, 27000L, 75600L, 165375L, 362880L, 1562500L, 0x310000L, 6250000L};
    private static long[] sizes2D = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 260L, 520L, 1050L, 1458L, 1960L, 2916L, 4116L, 5832L};
    private static long[] sizes3D = new long[]{16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 5L, 17L, 30L, 95L, 180L, 270L, 324L, 420L};
    private static boolean doScaling = false;

    private BenchmarkFloatDHT() {
    }

    public static void parseArguments(String[] args) {
        if (args.length > 0) {
            int i;
            nthread = Integer.parseInt(args[0]);
            threadsBegin2D = Integer.parseInt(args[1]);
            threadsBegin3D = Integer.parseInt(args[2]);
            niter = Integer.parseInt(args[3]);
            doWarmup = Boolean.parseBoolean(args[4]);
            doScaling = Boolean.parseBoolean(args[5]);
            nsize = Integer.parseInt(args[6]);
            sizes1D = new long[nsize];
            sizes2D = new long[nsize];
            sizes3D = new long[nsize];
            for (i = 0; i < nsize; ++i) {
                BenchmarkFloatDHT.sizes1D[i] = Integer.parseInt(args[7 + i]);
            }
            for (i = 0; i < nsize; ++i) {
                BenchmarkFloatDHT.sizes2D[i] = Integer.parseInt(args[7 + nsize + i]);
            }
            for (i = 0; i < nsize; ++i) {
                BenchmarkFloatDHT.sizes3D[i] = Integer.parseInt(args[7 + nsize + nsize + i]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads((int)nthread);
        CommonUtils.setThreadsBeginN_2D(threadsBegin2D);
        CommonUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[] x;
            System.out.println("Forward DHT 1D of size " + sizes1D[i]);
            if (doWarmup) {
                FloatDHT_1D dht = new FloatDHT_1D(sizes1D[i]);
                x = new float[(int)sizes1D[i]];
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                dht.forward(x);
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                dht.forward(x);
            }
            long elapsedTime = System.nanoTime();
            FloatDHT_1D dht = new FloatDHT_1D(sizes1D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new float[(int)sizes1D[i]];
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                elapsedTime = System.nanoTime();
                dht.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dht = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray x;
            System.out.println("Forward DHT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatDHT_2D dht2 = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
                x = new FloatLargeArray(sizes2D[i] * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
            }
            long elapsedTime = System.nanoTime();
            FloatDHT_2D dht2 = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new FloatLargeArray(sizes2D[i] * sizes2D[i], false);
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                elapsedTime = System.nanoTime();
                dht2.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dht2 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][] x;
            System.out.println("Forward DHT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatDHT_2D dht2 = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
                x = new float[(int)sizes2D[i]][(int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
            }
            long elapsedTime = System.nanoTime();
            FloatDHT_2D dht2 = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new float[(int)sizes2D[i]][(int)sizes2D[i]];
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                elapsedTime = System.nanoTime();
                dht2.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dht2 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray x;
            System.out.println("Forward DHT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatDHT_3D dht3 = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                x = new FloatLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
            }
            long elapsedTime = System.nanoTime();
            FloatDHT_3D dht3 = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new FloatLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                elapsedTime = System.nanoTime();
                dht3.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dht3 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][][] x;
            System.out.println("Forward DHT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatDHT_3D dht3 = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                x = new float[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
            }
            long elapsedTime = System.nanoTime();
            FloatDHT_3D dht3 = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new float[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                elapsedTime = System.nanoTime();
                dht3.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dht3 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times_without_constructor, times_with_constructor);
    }

    public static void main(String[] args) {
        BenchmarkFloatDHT.parseArguments(args);
        BenchmarkFloatDHT.benchmarkForward_1D();
        BenchmarkFloatDHT.benchmarkForward_2D_input_1D();
        BenchmarkFloatDHT.benchmarkForward_2D_input_2D();
        BenchmarkFloatDHT.benchmarkForward_3D_input_1D();
        BenchmarkFloatDHT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

