/*
 * Decompiled with CFR 0.152.
 */
package testapp;

import com.welie.blessed.BluetoothBytesParser;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import testapp.TemperatureType;
import testapp.TemperatureUnit;

public class TemperatureMeasurement
implements Serializable {
    public final TemperatureUnit unit;
    public float temperatureValue;
    public final Date timestamp;
    public TemperatureType type;

    public TemperatureMeasurement(byte[] byteArray) {
        BluetoothBytesParser parser = new BluetoothBytesParser(byteArray);
        int flags = parser.getIntValue(17);
        this.unit = (flags & 1) > 0 ? TemperatureUnit.Fahrenheit : TemperatureUnit.Celsius;
        boolean timestampPresent = (flags & 2) > 0;
        boolean typePresent = (flags & 4) > 0;
        this.temperatureValue = parser.getFloatValue(52).floatValue();
        this.timestamp = timestampPresent ? parser.getDateTime() : Calendar.getInstance().getTime();
        if (typePresent) {
            int typeValue = parser.getIntValue(17);
            this.type = TemperatureType.fromValue(typeValue);
        }
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", Locale.ENGLISH);
        String formattedTimestamp = this.timestamp != null ? df.format(this.timestamp) : "null";
        return String.format(Locale.ENGLISH, "%.1f %s (%s), at (%s)", new Object[]{Float.valueOf(this.temperatureValue), this.unit == TemperatureUnit.Celsius ? "celcius" : "fahrenheit", this.type, formattedTimestamp});
    }
}

