/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.util.ArrayList;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;
import jnr.posix.BaseIovec;
import jnr.posix.BaseMsgHdr;
import jnr.posix.CmsgHdr;
import jnr.posix.LinuxCmsgHdr;
import jnr.posix.LinuxSocketMacros;
import jnr.posix.NativePOSIX;

class LinuxMsgHdr
extends BaseMsgHdr {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    protected LinuxMsgHdr(NativePOSIX posix) {
        super(posix, layout);
        this.setName(null);
    }

    @Override
    CmsgHdr allocateCmsgHdrInternal(NativePOSIX posix, Pointer pointer, int len) {
        if (len > 0) {
            return new LinuxCmsgHdr(posix, pointer, len);
        }
        return new LinuxCmsgHdr(posix, pointer);
    }

    @Override
    void setControlPointer(Pointer control) {
        LinuxMsgHdr.layout.msg_control.set(this.memory, control);
    }

    @Override
    void setControlLen(int len) {
        LinuxMsgHdr.layout.msg_controllen.set(this.memory, len);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("msghdr {\n");
        buf.append("  msg_name=").append(this.getName()).append(",\n");
        buf.append("  msg_namelen=").append(this.getNameLen()).append(",\n");
        buf.append("  msg_iov=[\n");
        Pointer iovp = LinuxMsgHdr.layout.msg_iov.get(this.memory);
        int numIov = this.getIovLen();
        for (int i = 0; i < numIov; ++i) {
            Pointer eachp = iovp.slice(i * BaseIovec.layout.size());
            buf.append(new BaseIovec(this.posix, eachp).toString("    "));
            if (i < numIov - 1) {
                buf.append(",\n");
                continue;
            }
            buf.append("\n");
        }
        buf.append("  ],\n");
        buf.append("  msg_control=[\n");
        CmsgHdr[] controls = this.getControls();
        for (int i = 0; i < controls.length; ++i) {
            buf.append(((LinuxCmsgHdr)controls[i]).toString("    "));
            if (i < controls.length - 1) {
                buf.append(",\n");
                continue;
            }
            buf.append("\n");
        }
        buf.append("  ],\n");
        buf.append("  msg_controllen=").append(LinuxMsgHdr.layout.msg_controllen.get(this.memory)).append("\n");
        buf.append("  msg_iovlen=").append(this.getIovLen()).append(",\n");
        buf.append("  msg_flags=").append(this.getFlags()).append(",\n");
        buf.append("}");
        return buf.toString();
    }

    @Override
    void setNamePointer(Pointer name) {
        LinuxMsgHdr.layout.msg_name.set(this.memory, name);
    }

    @Override
    Pointer getNamePointer() {
        return LinuxMsgHdr.layout.msg_name.get(this.memory);
    }

    @Override
    void setNameLen(int len) {
        LinuxMsgHdr.layout.msg_namelen.set(this.memory, len);
    }

    @Override
    int getNameLen() {
        return (int)LinuxMsgHdr.layout.msg_namelen.get(this.memory);
    }

    @Override
    void setIovPointer(Pointer iov) {
        LinuxMsgHdr.layout.msg_iov.set(this.memory, iov);
    }

    @Override
    Pointer getIovPointer() {
        return LinuxMsgHdr.layout.msg_iov.get(this.memory);
    }

    @Override
    void setIovLen(int len) {
        LinuxMsgHdr.layout.msg_iovlen.set(this.memory, len);
    }

    @Override
    int getIovLen() {
        return (int)LinuxMsgHdr.layout.msg_iovlen.get(this.memory);
    }

    @Override
    Pointer getControlPointer() {
        return LinuxMsgHdr.layout.msg_control.get(this.memory);
    }

    @Override
    public int getControlLen() {
        return (int)LinuxMsgHdr.layout.msg_controllen.get(this.memory);
    }

    @Override
    public void setFlags(int flags) {
        LinuxMsgHdr.layout.msg_flags.set(this.memory, flags);
    }

    @Override
    public int getFlags() {
        return LinuxMsgHdr.layout.msg_flags.get(this.memory);
    }

    @Override
    public CmsgHdr[] getControls() {
        CmsgHdr each;
        int len = this.getControlLen();
        if (len == 0) {
            return new CmsgHdr[0];
        }
        ArrayList<CmsgHdr> control = new ArrayList<CmsgHdr>();
        Pointer controlPtr = this.getControlPointer();
        for (int offset = 0; offset < len; offset += LinuxSocketMacros.INSTANCE.CMSG_ALIGN(each.getLen())) {
            each = this.allocateCmsgHdrInternal(this.posix, controlPtr.slice(offset), -1);
            control.add(each);
        }
        return control.toArray(new CmsgHdr[control.size()]);
    }

    public static class Layout
    extends StructLayout {
        public final StructLayout.Pointer msg_name = new StructLayout.Pointer(this);
        public final StructLayout.socklen_t msg_namelen = new StructLayout.socklen_t(this);
        public final StructLayout.Pointer msg_iov = new StructLayout.Pointer(this);
        public final StructLayout.size_t msg_iovlen = new StructLayout.size_t(this);
        public final StructLayout.Pointer msg_control = new StructLayout.Pointer(this);
        public final StructLayout.size_t msg_controllen = new StructLayout.size_t(this);
        public final StructLayout.Signed32 msg_flags = new StructLayout.Signed32(this);

        protected Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

