/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezAdapter;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.BluezGattService;
import com.welie.blessed.bluez.DbusHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bluez.Device1;
import org.bluez.GattService1;
import org.bluez.exceptions.BluezAlreadyConnectedException;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezAuthenticationCanceledException;
import org.bluez.exceptions.BluezAuthenticationFailedException;
import org.bluez.exceptions.BluezAuthenticationRejectedException;
import org.bluez.exceptions.BluezAuthenticationTimeoutException;
import org.bluez.exceptions.BluezConnectionAttemptFailedException;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.bluez.exceptions.BluezNotAvailableException;
import org.bluez.exceptions.BluezNotConnectedException;
import org.bluez.exceptions.BluezNotReadyException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.jetbrains.annotations.NotNull;

public class BluezDevice
extends AbstractBluetoothObject {
    private final Device1 rawdevice;
    private final BluezAdapter adapter;
    private final Map<UUID, BluezGattService> servicesByUuid = new LinkedHashMap<UUID, BluezGattService>();

    public BluezDevice(Device1 _device, BluezAdapter _adapter, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluezDeviceType.DEVICE, _dbusConnection, _dbusPath);
        this.rawdevice = _device;
        this.adapter = _adapter;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return Device1.class;
    }

    public List<BluezGattService> getGattServices() {
        if (this.servicesByUuid.isEmpty()) {
            this.refreshGattServices();
        }
        return new ArrayList<BluezGattService>(this.servicesByUuid.values());
    }

    public void refreshGattServices() {
        this.servicesByUuid.clear();
        Set<String> findNodes = DbusHelper.findNodes(this.getDbusConnection(), this.getDbusPath());
        Map<String, GattService1> remoteObjects = this.getRemoteObjects(findNodes, this.getDbusPath(), GattService1.class);
        for (Map.Entry<String, GattService1> entry : remoteObjects.entrySet()) {
            BluezGattService bluetoothGattService = new BluezGattService(entry.getValue(), this, entry.getKey(), this.getDbusConnection());
            this.servicesByUuid.put(bluetoothGattService.getUuid(), bluetoothGattService);
        }
    }

    public BluezGattService getGattServiceByUuid(UUID uuid) {
        if (this.servicesByUuid.isEmpty()) {
            this.refreshGattServices();
        }
        return this.servicesByUuid.get(uuid);
    }

    public BluezAdapter getAdapter() {
        return this.adapter;
    }

    public Device1 getRawDevice() {
        return this.rawdevice;
    }

    public Boolean isBlocked() {
        return this.getTyped("Blocked", Boolean.class);
    }

    public void setBlocked(Boolean _blocked) {
        this.setTyped("Blocked", _blocked);
    }

    public Boolean isTrusted() {
        return this.getTyped("Trusted", Boolean.class);
    }

    public void setTrusted(boolean _trusted) {
        this.setTyped("Trusted", _trusted);
    }

    public String getAlias() {
        return this.getTyped("Alias", String.class);
    }

    public void setAlias(String _alias) {
        this.setTyped("Alias", _alias);
    }

    public byte[] getAdvertisingFlags() {
        List typed = this.getTyped("AdvertisingFlags", ArrayList.class);
        if (typed != null) {
            return this.byteListToByteArray(typed);
        }
        return null;
    }

    @NotNull
    public @NotNull List<@NotNull UUID> getUuids() {
        ArrayList<@NotNull UUID> result = new ArrayList<UUID>();
        try {
            List typed = this.getTyped("UUIDs", ArrayList.class);
            if (typed != null) {
                typed.stream().map(UUID::fromString).forEach(result::add);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Boolean isConnected() {
        return this.getTyped("Connected", Boolean.class);
    }

    public Boolean isLegacyPairing() {
        return this.getTyped("LegacyPairing", Boolean.class);
    }

    public Boolean isPaired() {
        return this.getTyped("Paired", Boolean.class);
    }

    public Boolean isServicesResolved() {
        return this.getTyped("ServicesResolved", Boolean.class);
    }

    @NotNull
    public @NotNull Map<@NotNull String, byte[]> getServiceData() {
        HashMap<@NotNull String, byte[]> result = new HashMap<String, byte[]>();
        try {
            return this.getTyped("ServiceData", DBusMap.class);
        }
        catch (Exception e) {
            return result;
        }
    }

    public Map<String, byte[]> getAdvertisementData() {
        return this.getTyped("AdvertisingData", DBusMap.class);
    }

    @NotNull
    public Map<Integer, byte[]> getManufacturerData() {
        HashMap<Integer, byte[]> result = new HashMap<Integer, byte[]>();
        try {
            Map deviceManufacturerData = this.getTyped("ManufacturerData", DBusMap.class);
            if (deviceManufacturerData != null) {
                deviceManufacturerData.forEach((key, value) -> result.put(key.intValue(), (byte[])value));
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public Short getRssi() {
        Short rssi = null;
        try {
            rssi = this.getTyped("RSSI", Short.class);
        }
        catch (DBusExecutionException dBusExecutionException) {
            // empty catch block
        }
        return rssi;
    }

    public Short getTxPower() {
        return this.getTyped("TxPower", Short.class);
    }

    public String getAddress() {
        String address = null;
        try {
            address = this.getTyped("Address", String.class);
        }
        catch (DBusExecutionException dBusExecutionException) {
            // empty catch block
        }
        return address;
    }

    public String getIcon() {
        return this.getTyped("Icon", String.class);
    }

    public String getModAlias() {
        return this.getTyped("Modalias", String.class);
    }

    public String getName() {
        String name = null;
        try {
            name = this.getTyped("Name", String.class);
        }
        catch (DBusExecutionException dBusExecutionException) {
            // empty catch block
        }
        return name;
    }

    public Integer getAppearance() {
        UInt16 typed = this.getTyped("Appearance", UInt16.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public Integer getBluetoothClass() {
        UInt32 typed = this.getTyped("Class", UInt32.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public void connect() throws BluezFailedException, BluezAlreadyConnectedException, BluezNotReadyException, BluezInProgressException {
        this.rawdevice.Connect();
    }

    public boolean disconnect() {
        try {
            this.rawdevice.Disconnect();
            return true;
        }
        catch (BluezNotConnectedException bluezNotConnectedException) {
            return this.isConnected() == false;
        }
    }

    public boolean connectProfile(UUID _uuid) {
        try {
            this.rawdevice.ConnectProfile(_uuid.toString());
            return true;
        }
        catch (BluezFailedException | BluezInProgressException | BluezInvalidArgumentsException | BluezNotAvailableException | BluezNotReadyException _ex) {
            return false;
        }
    }

    public boolean disconnectProfile(UUID _uuid) {
        try {
            this.rawdevice.DisconnectProfile(_uuid.toString());
        }
        catch (BluezFailedException | BluezInProgressException | BluezInvalidArgumentsException | BluezNotSupportedException _ex) {
            return false;
        }
        return true;
    }

    public void pair() throws BluezInProgressException, BluezInvalidArgumentsException, BluezFailedException, BluezAuthenticationFailedException, BluezAlreadyExistsException, BluezAuthenticationCanceledException, BluezAuthenticationRejectedException, BluezAuthenticationTimeoutException, BluezConnectionAttemptFailedException {
        this.rawdevice.Pair();
    }

    public boolean cancelPairing() {
        try {
            this.rawdevice.CancelPairing();
            return true;
        }
        catch (BluezDoesNotExistException | BluezFailedException _ex) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [device=" + this.rawdevice + ", adapter=" + this.adapter.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

