/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.handlers.AbstractInterfacesAddedHandler;
import org.freedesktop.dbus.handlers.AbstractPropertiesChangedHandler;
import org.freedesktop.dbus.interfaces.ObjectManager;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BluezSignalHandler {
    private static final String TAG = BluezSignalHandler.class.getSimpleName();
    private static final Logger logger = LoggerFactory.getLogger(TAG);
    private static BluezSignalHandler instance = null;
    private DBusConnection dbusConnection;
    private final Map<String, BluetoothPeripheral> peripheralsMap = new ConcurrentHashMap<String, BluetoothPeripheral>();
    private final List<BluetoothCentralManager> centralList = new ArrayList<BluetoothCentralManager>();
    protected final AbstractPropertiesChangedHandler signalHandler = new AbstractPropertiesChangedHandler(){

        @Override
        public void handle(Properties.PropertiesChanged propertiesChanged) {
            if (propertiesChanged.getPropertiesChanged().isEmpty()) {
                return;
            }
            String interfaceName = propertiesChanged.getInterfaceName();
            if (interfaceName.equals("org.bluez.Device1") || interfaceName.equals("org.bluez.Adapter1")) {
                for (BluetoothCentralManager central : BluezSignalHandler.this.centralList) {
                    central.handleSignal(propertiesChanged);
                }
            }
            if (BluezSignalHandler.this.peripheralsMap.isEmpty()) {
                return;
            }
            if (interfaceName.equals("org.bluez.Device1") || interfaceName.equals("org.bluez.GattCharacteristic1")) {
                String path = propertiesChanged.getPath();
                Set peripherals = BluezSignalHandler.this.peripheralsMap.keySet();
                for (String peripheralAddress : peripherals) {
                    if (!path.contains(peripheralAddress)) continue;
                    ((BluetoothPeripheral)BluezSignalHandler.this.peripheralsMap.get(peripheralAddress)).handleSignal(propertiesChanged);
                }
            }
        }
    };
    protected final AbstractInterfacesAddedHandler interfacesAddedHandler = new AbstractInterfacesAddedHandler(){

        @Override
        public void handle(ObjectManager.InterfacesAdded interfacesAdded) {
            String path = interfacesAdded.getPath();
            interfacesAdded.getInterfaces().forEach((key, value) -> {
                if (key.equalsIgnoreCase("org.bluez.Device1")) {
                    for (BluetoothCentralManager central : BluezSignalHandler.this.centralList) {
                        central.handleInterfaceAddedForDevice(path, (Map<String, Variant<?>>)value);
                    }
                }
            });
        }
    };

    static synchronized BluezSignalHandler createInstance(@NotNull DBusConnection dbusConnection) {
        Objects.requireNonNull(dbusConnection, "no valid dbusconnection provided");
        if (instance == null) {
            instance = new BluezSignalHandler(dbusConnection);
        }
        return instance;
    }

    public static synchronized BluezSignalHandler getInstance() {
        if (instance == null) {
            logger.error("Using getInstance when no BluezSignalHandler has been created");
        }
        return instance;
    }

    private BluezSignalHandler(@NotNull DBusConnection dBusConnection) {
        Objects.requireNonNull(dBusConnection, "no valid dbusconnection provided");
        try {
            this.dbusConnection = dBusConnection;
            this.registerPropertiesChangedHandler(this.signalHandler);
            this.registerInterfacesAddedHandler(this.interfacesAddedHandler);
        }
        catch (DBusException e) {
            logger.error("Error registering scan property handler");
            logger.error(e.toString());
        }
    }

    private void registerPropertiesChangedHandler(@NotNull AbstractPropertiesChangedHandler handler) throws DBusException {
        this.dbusConnection.addSigHandler(handler.getImplementationClass(), handler);
    }

    private void registerInterfacesAddedHandler(@NotNull AbstractInterfacesAddedHandler handler) throws DBusException {
        this.dbusConnection.addSigHandler(handler.getImplementationClass(), handler);
    }

    void addPeripheral(@NotNull String peripheralAddress, @NotNull BluetoothPeripheral peripheral) {
        Objects.requireNonNull(peripheralAddress, "no valid address provided");
        Objects.requireNonNull(peripheral, "no valid peripheral provided");
        String deviceAddressString = peripheralAddress.replace(":", "_");
        this.peripheralsMap.put(deviceAddressString, peripheral);
    }

    void removePeripheral(@NotNull String peripheralAddress) {
        Objects.requireNonNull(peripheralAddress, "no valid address provided");
        String deviceAddressString = peripheralAddress.replace(":", "_");
        this.peripheralsMap.remove(deviceAddressString);
    }

    void addCentral(@NotNull BluetoothCentralManager central) {
        Objects.requireNonNull(central, "no valid central provided");
        this.centralList.add(central);
    }
}

