/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothGattCharacteristic;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothGattDescriptor {
    protected static final byte[] ENABLE_NOTIFICATION_VALUE = new byte[]{1, 0};
    protected static final byte[] ENABLE_INDICATION_VALUE = new byte[]{2, 0};
    protected static final byte[] DISABLE_NOTIFICATION_VALUE = new byte[]{0, 0};
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    @NotNull
    protected final UUID uuid;
    protected final int permissions;
    @Nullable
    protected BluetoothGattCharacteristic characteristic;

    public BluetoothGattDescriptor(@NotNull UUID uuid, int permissions) {
        this.uuid = Objects.requireNonNull(uuid, "no valid UUID supplied");
        this.permissions = permissions;
    }

    @Nullable
    public BluetoothGattCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    void setCharacteristic(@NotNull BluetoothGattCharacteristic characteristic) {
        this.characteristic = Objects.requireNonNull(characteristic, "no valid characteristic supplied");
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public int getPermissions() {
        return this.permissions;
    }
}

