/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.common.SearchOrder;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileIoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIoUtil.class);

    private FileIoUtil() {
    }

    public static Properties readProperties(File _file) {
        if (_file.exists()) {
            try {
                return FileIoUtil.readProperties(new FileInputStream(_file));
            }
            catch (FileNotFoundException _ex) {
                LOGGER.info("Could not load properties file: " + _file, _ex);
            }
        }
        return null;
    }

    public static Properties readProperties(InputStream _stream) {
        Properties props = new Properties();
        if (_stream == null) {
            return null;
        }
        try {
            props.load(_stream);
            return props;
        }
        catch (IOException | NumberFormatException _ex) {
            LOGGER.warn("Could not properties: ", _ex);
            return null;
        }
    }

    public static Properties readPropertiesFromFile(String _fileName, Properties _props) {
        Properties props = _props == null ? new Properties() : _props;
        LOGGER.debug("Trying to read properties from file: " + _fileName);
        Properties newProperties = FileIoUtil.readProperties(new File(_fileName));
        if (newProperties != null) {
            LOGGER.debug("Successfully read properties from file: " + _fileName);
            props.putAll((Map<?, ?>)newProperties);
        }
        return props;
    }

    public static boolean writeProperties(File _file, Properties _props) {
        LOGGER.debug("Trying to write Properties to file: " + _file);
        try (FileOutputStream out = new FileOutputStream(_file);){
            _props.store(out, _file.getName());
            LOGGER.debug("Successfully wrote properties to file: " + _file);
        }
        catch (IOException _ex) {
            LOGGER.warn("Could not save File: " + _file, _ex);
            return false;
        }
        return true;
    }

    public static boolean writeProperties(String _propertiesFile, Properties _props) {
        return FileIoUtil.writeProperties(new File(_propertiesFile), _props);
    }

    public static boolean readPropertiesBoolean(Properties _props, String _property) {
        return _props.containsKey(_property) && _props.getProperty(_property).matches("(?i)(1|yes|true|enabled|on|y)");
    }

    public static List<String> getTextfileFromUrl(String _url) {
        return FileIoUtil.getTextfileFromUrl(_url, Charset.defaultCharset());
    }

    public static List<String> getTextfileFromUrl(String _url, Charset _charset) {
        return FileIoUtil.getTextfileFromUrl(_url, _charset, false);
    }

    public static List<String> getTextfileFromUrl(String _url, Charset _charset, boolean _silent) {
        if (_url == null) {
            return null;
        }
        String fileUrl = _url;
        if (!fileUrl.contains("://")) {
            fileUrl = "file://" + fileUrl;
        }
        try {
            URL dlUrl = fileUrl.startsWith("file:/") ? new URL("file", "", fileUrl.replaceFirst("file:\\/{1,2}", "")) : new URL(fileUrl);
            URLConnection urlConn = dlUrl.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            return FileIoUtil.readTextFileFromStream(urlConn.getInputStream(), _charset, _silent);
        }
        catch (IOException _ex) {
            if (!_silent) {
                LOGGER.warn("Error while reading file:", _ex);
            }
            return null;
        }
    }

    public static List<String> readTextFileFromStream(InputStream _input, Charset _charset, boolean _silent) {
        if (_input == null) {
            return null;
        }
        try {
            ArrayList<String> fileContent;
            try (BufferedReader dis = new BufferedReader(new InputStreamReader(_input, _charset));){
                String s2;
                fileContent = new ArrayList<String>();
                while ((s2 = dis.readLine()) != null) {
                    fileContent.add(s2);
                }
            }
            return fileContent.size() > 0 ? fileContent : null;
        }
        catch (IOException _ex) {
            if (!_silent) {
                LOGGER.warn("Error while reading file:", _ex);
            }
            return null;
        }
    }

    public static String readFileToString(String _file) {
        List<String> localText = FileIoUtil.getTextfileFromUrl(_file);
        if (localText == null) {
            return null;
        }
        return StringUtil.join(FileIoUtil.guessLineTerminatorOfFile(_file), localText);
    }

    public static List<String> readFileToList(File _file) {
        return FileIoUtil.readFileToList(_file.getAbsolutePath());
    }

    public static List<String> readFileToList(String _fileName) {
        List<String> localText = FileIoUtil.getTextfileFromUrl(_fileName);
        return localText;
    }

    public static String readFileToString(File _file) {
        return FileIoUtil.readFileToString(_file.getAbsolutePath());
    }

    public static String readStringFromResources(InputStream _stream, String _charset) {
        if (_stream == null) {
            LOGGER.error("Error: null-Stream received!");
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(_stream, _charset));
            int c = br.read();
            while (c != -1) {
                sb.append((char)c);
                c = br.read();
            }
        }
        catch (IOException _ex) {
            LOGGER.error("Error while reading resource to string: ", _ex);
        }
        return sb.toString();
    }

    public static Properties loadPropertiesFromClasspath(String _propertiesFile) throws IOException {
        InputStream is = FileIoUtil.class.getClassLoader().getResourceAsStream(_propertiesFile);
        if (is == null) {
            throw new IOException("Resource [" + _propertiesFile + "] not found in classpath.");
        }
        Properties props = FileIoUtil.readProperties(is);
        return props;
    }

    public static boolean loadPropertiesFromClasspath(String _propertiesFile, Properties _properties) {
        if (_properties == null) {
            throw new IllegalArgumentException("Properties object required");
        }
        try {
            Properties loaded = FileIoUtil.loadPropertiesFromClasspath(_propertiesFile);
            if (loaded != null) {
                _properties.putAll((Map<?, ?>)loaded);
            }
        }
        catch (IOException _ex) {
            return false;
        }
        return true;
    }

    public static String readFileFromClassPath(String _fileName) {
        StringBuilder sb = new StringBuilder();
        for (String string : FileIoUtil.readFileFromClassPathAsList(_fileName)) {
            sb.append(string).append("\n");
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static List<String> readFileFromClassPathAsList(String _fileName) {
        ArrayList result = FileIoUtil.readFileFromClassPathAsList(_fileName, Charset.defaultCharset(), false);
        return result == null ? new ArrayList() : result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFileFromClassPathAsList(String _fileName, Charset _charset, boolean _silent) {
        ArrayList<String> contents = new ArrayList<String>();
        if (StringUtil.isBlank(_fileName)) {
            return contents;
        }
        InputStream inputStream = FileIoUtil.class.getClassLoader().getResourceAsStream(_fileName);
        if (inputStream == null) {
            if (!_silent) return contents;
            return null;
        }
        try (BufferedReader dis = new BufferedReader(new InputStreamReader(inputStream, _charset));){
            String s2;
            while ((s2 = dis.readLine()) != null) {
                contents.add(s2);
            }
            ArrayList<String> arrayList = contents;
            return arrayList;
        }
        catch (IOException _ex) {
            if (_silent) return null;
            LOGGER.error("Error while reading resource to string: ", _ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTextFile(String _fileName, String _fileContent, Charset _charset, boolean _append) {
        File file;
        if (StringUtil.isBlank(_fileName)) {
            return false;
        }
        String allText = "";
        if (_append && (file = new File(_fileName)).exists()) {
            allText = FileIoUtil.readFileToString(file) + FileIoUtil.guessLineTerminatorOfFile(_fileName);
        }
        allText = allText + _fileContent;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(_fileName), _charset);
            writer.write(allText);
        }
        catch (IOException _ex) {
            LOGGER.error("Could not write file to '" + _fileName + "'", _ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException _ex) {
                LOGGER.error("Error while closing file '" + _fileName + "'", _ex);
                return false;
            }
        }
        return true;
    }

    public static boolean writeTextFile(String _fileName, String _fileContent, boolean _append) {
        return FileIoUtil.writeTextFile(_fileName, _fileContent, Charset.defaultCharset(), _append);
    }

    public static List<String> readFileFrom(String _fileName, Charset _charset, SearchOrder ... _searchOrder) {
        InputStream stream = FileIoUtil.openInputStreamForFile(_fileName, _searchOrder);
        if (stream != null) {
            return FileIoUtil.readTextFileFromStream(stream, _charset, true);
        }
        return null;
    }

    public static InputStream openInputStreamForFile(String _fileNameWithPath, SearchOrder ... _searchOrder) {
        if (_searchOrder == null) {
            return null;
        }
        try {
            block6: for (SearchOrder searchOrder : _searchOrder) {
                switch (searchOrder) {
                    case CLASS_PATH: {
                        InputStream inputStream = FileIoUtil.class.getClassLoader().getResourceAsStream(_fileNameWithPath);
                        if (inputStream == null) continue block6;
                        return inputStream;
                    }
                    case SYSTEM_PATH: {
                        String[] searchPathes;
                        String pathes = System.getenv("PATH");
                        String os = System.getProperty("os.name");
                        String delimiter = ":";
                        if (os != null && os.equalsIgnoreCase("windows")) {
                            delimiter = ";";
                        }
                        if (pathes == null) continue block6;
                        for (String path : searchPathes = pathes.split(delimiter)) {
                            File file = new File(path, _fileNameWithPath);
                            if (!file.exists() || !file.canRead()) continue;
                            return new FileInputStream(file);
                        }
                        continue block6;
                    }
                    default: {
                        File file = new File(_fileNameWithPath);
                        if (!file.exists() || !file.canRead()) continue block6;
                        return new FileInputStream(file);
                    }
                }
            }
        }
        catch (FileNotFoundException _ex) {
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String guessLineTerminatorOfFile(String _file) {
        if (StringUtil.isEmpty(_file)) {
            return SystemUtil.LINE_SEPARATOR;
        }
        File file = new File(_file);
        if (!file.exists()) return SystemUtil.LINE_SEPARATOR;
        if (!file.canRead()) {
            return SystemUtil.LINE_SEPARATOR;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            block32: {
                boolean carriageReturn = false;
                boolean lineFeed = false;
                boolean nextIteration = false;
                char[] buf = new char[1];
                while (reader.read(buf) != -1) {
                    if (buf[0] == '\r') {
                        carriageReturn = true;
                    } else if (buf[0] == '\n') {
                        lineFeed = true;
                    }
                    if (carriageReturn && lineFeed) {
                        String string = "\r\n";
                        return string;
                    }
                    if (carriageReturn && !nextIteration) {
                        nextIteration = true;
                        continue;
                    }
                    if (lineFeed) {
                        String string = "\n";
                        return string;
                    }
                    if (!carriageReturn) {
                        continue;
                    }
                    break block32;
                }
                return SystemUtil.LINE_SEPARATOR;
            }
            String string = "\r";
            return string;
        }
        catch (IOException _ex) {
            return SystemUtil.LINE_SEPARATOR;
        }
    }
}

